<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Admin extends CI_Controller 
{	
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
		
	}

	# Admin Login
	public function adminLogin()
	{
		if(!empty($this->user_id)){
			redirect(base_url() . 'admin/dashboard', 'refresh');
		}
		
		$page_data['page_title'] = SITE_NAME.' | Admin Login'; #Page Title
		
		if($_POST)
		{
			$email = $this->input->post('email');
			$password = $this->input->post('password');
			
			$status = $this->admin_model->adminLogin($email,$password);
			
			if($status == 10)
			{
				$this->session->set_flashdata('success_message' , 'Successfully logged!');
				redirect(base_url() . 'orders/ManageOrders', 'refresh');
			}
			else if($status == 9)
			{
				$this->session->set_flashdata('error_message' , 'Your account has been Blocked!');
				redirect(base_url() . 'admin/adminLogin', 'refresh');
			}
			else if($status == 8)
			{
				$this->session->set_flashdata('error_message' , 'Email does not exist!');
				redirect(base_url() . 'admin/adminLogin', 'refresh');
			}
			else if($status == 0)
			{
				$this->session->set_flashdata('error_message' , 'Email or Password does not match!');
				redirect(base_url() . 'admin/adminLogin', 'refresh');
			}
			else
			{
				$this->session->set_flashdata('error_message' , "Can't login this time!");
				redirect(base_url(), 'refresh');
			}
		}
		$this->load->view('backend/admin/login');
	}
	
	public function dashboard()
	{
		if(empty($this->user_id)){
			 redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
		$page_data['dashboard'] = 1;
		
		$page_data['page_name']  = "admin/dashboard"; #View Page
		$page_data['page_title'] = SITE_NAME.' | Dashboard'; #Page Title

		$page_data['dashbord_filter'] = $this->Reports_model->dashboardAllReports();
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	public function forgot_password()
	{
		$page_data['page_title'] = 'Forgot Password'; #Page Title
		
		if($_POST)
		{
			$email = $this->input->post('email');
			
			if($email !="")
			{
				$checkEmail = $this->db->query("select 
				user_id, 
				first_name,
				email,
				random_user_id, 
				user_name, 
				original_password 
				
				from users WHERE email='".$email."' or user_name ='".$email."'")->result_array();
				#print_r($checkEmail);exit;
				
				if(count($checkEmail) > 0)
				{
					#Email sent start here
					$page_data['forgot_password'] =1;
					$user_id = $checkEmail[0]['user_id'];
					
					if($user_id == 1) #Admin Forgot Password
					{
						$page_data['password'] = $checkEmail[0]['original_password'];
						$page_data['EmployeeName'] = $checkEmail[0]['first_name'];
						$page_data['email'] = $checkEmail[0]['email'];
						
						$to = CONTACT_EMAIL;
						$from = $page_data['email'];
						$fromName = $page_data['EmployeeName'];
						$subject = "Forgot Password";	
						
						$message = $this->load->view('mail_template/admin_mail_template', $page_data, true);
						
						if(EMAIL_TYPE == 2) #SMTP
						{
							$sendMail = Send_SMTP($from,$to,$subject,$message,$fromName);
						}
						else  #Send Grid 
						{
							$sendMail = Send_Grid($from,$to,$subject,$message,$fromName);
						}
						#Email sent end here
					}
					else #Employee Forgot Password
					{
						$page_data['password'] = $checkEmail[0]['original_password'];
						$page_data['EmployeeName'] = $checkEmail[0]['first_name'];
						$page_data['EmployeeNumber'] = $checkEmail[0]['random_user_id'];
						$page_data['email'] = $checkEmail[0]['email'];
						$page_data['user_name'] = $checkEmail[0]['user_name'];
						
						$to = CONTACT_EMAIL;
						$from = $page_data['email'];
						$fromName = $page_data['EmployeeName'];
						$subject = "Forgot Password";	
						
						$message = $this->load->view('mail_template/admin_mail_template', $page_data, true);
						
						if(EMAIL_TYPE == 2) #SMTP
						{
							$sendMail = Send_SMTP($from,$to,$subject,$message,$fromName);
						}
						else  #Send Grid 
						{
							$sendMail = Send_Grid($from,$to,$subject,$message,$fromName);
						}
						#Email sent end here
					}
					
					$this->session->set_flashdata('success_message' , 'Your Password sent to admin E-Mail.Please contact to admin.');
					redirect(base_url().'admin/forgot_password', 'refresh');
				}
				else
				{
					$this->session->set_flashdata('error_message' , 'Invalid Email!');
					redirect(base_url().'admin/forgot_password', 'refresh');
				}
			}
		}
		$this->load->view('backend/admin/forgot_password');
	}
	
	# Product Expiry
    function product_expiry()
    {
		$page_data['page_title'] = SITE_NAME.' | Product Expiry'; #Page Title
		
		if ($_POST) 
		{
			$data['description'] = strtotime($_POST['product_start_date']);
			$this->db->where('type' , 'product_start_date');
			$this->db->update('settings' , $data);
			
			$data['description'] = strtotime($_POST['product_end_date']);
			$this->db->where('type' , 'product_end_date');
			$this->db->update('settings' , $data);
			
			$data['description'] = $_POST['before_expire_days'];
			$this->db->where('type' , 'before_expire_days');
			$this->db->update('settings' , $data);
			
			
			$this->session->set_flashdata('flash_message' , 'Product expiry date updated successfully!');
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		$this->load->view('backend/admin/product_expiry');
    }
	
	
	# General Settings
    function system_settings($type = '', $id = '', $status = '')
    {
		if(!$this->user_id)
		{
			redirect(base_url().'admin/adminLogin', 'refresh');
		}
		
		$page_data['manage_settings'] = $page_data['ApplicationSetups'] = 1;
		
		$page_data['page_name']  = 'admin/general_settings';
        $page_data['page_title'] = SITE_NAME.' | General Settings';
        $page_data['settings']   = $this->db->get('settings')->result_array();
        $page_data['type']   = $type;
		
		switch($type)
		{
			case 'general-settings':
				if($_POST)
				{
					$data['description'] = $this->input->post('system_name');
					$this->db->where('type' , 'system_name');
					$this->db->update('settings' , $data);

					$data['description'] = $this->input->post('system_title');
					$this->db->where('type' , 'system_title');
					$this->db->update('settings' , $data);
					
					$data['description'] = $this->input->post('company_name');
					$this->db->where('type' , 'company_name');
					$this->db->update('settings' , $data);
					
					$data['description'] = $this->input->post('welcome_content');
					$this->db->where('type' , 'welcome_content');
					$this->db->update('settings' , $data);
					
					$data['description'] = $this->input->post('company_youtube_url');
					$this->db->where('type' , 'company_youtube_url');
					$this->db->update('settings' , $data);
					
					$data['description'] = strtoupper($_POST['backup_morning']);
					$this->db->where('type' , 'backup_morning');
					$this->db->update('settings' , $data);
					
					$data['description'] = strtoupper($_POST['backup_evening']);
					$this->db->where('type' , 'backup_evening');
					$this->db->update('settings' , $data);
					
					$data['description'] = $_POST['gst_number'];
					$this->db->where('type' , 'gst_number');
					$this->db->update('settings' , $data);
					
					$data['description'] = $_POST['pan_number'];
					$this->db->where('type' , 'pan_number');
					$this->db->update('settings' , $data);
					
					$data['description'] = $_POST['company_account'];
					$this->db->where('type' , 'company_account');
					$this->db->update('settings' , $data);
					
					$data['description'] = $_POST['birthday_message'];
					$this->db->where('type' , 'birthday_message');
					$this->db->update('settings' , $data);
					
					$data['description'] = $_POST['gst_state_number'];
					$this->db->where('type' , 'gst_state_number');
					$this->db->update('settings' , $data);
					
					$this->session->set_flashdata('flash_message' , 'General settings updated successfully!');
					redirect(base_url() . 'admin/system_settings/general-settings', 'refresh');
				}
			break;	
			
			case 'email-contact-settings':
				if($_POST)
				{
					$data['description'] = $this->input->post('contact_email');
					$this->db->where('type' , 'contact_email');
					$this->db->update('settings' , $data);
					
					$data['description'] = $this->input->post('webmaster_email');
					$this->db->where('type' , 'webmaster_email');
					$this->db->update('settings' , $data);
					
					$data['description'] = $this->input->post('no_reply_email');
					$this->db->where('type' , 'no_reply_email');
					$this->db->update('settings' , $data);
					
					$data['description'] = $this->input->post('address');
					$this->db->where('type' , 'address');
					$this->db->update('settings' , $data);
					
					$data['description'] = $this->input->post('address2');
					$this->db->where('type' , 'address2');
					$this->db->update('settings' , $data);
					
					$data['description'] = $this->input->post('address3');
					$this->db->where('type' , 'address3');
					$this->db->update('settings' , $data);
					
					$data['description'] = $this->input->post('address4');
					$this->db->where('type' , 'address4');
					$this->db->update('settings' , $data);

					$data['description'] = $this->input->post('phone');
					$this->db->where('type' , 'phone');
					$this->db->update('settings' , $data);
					
					$data['description'] = $this->input->post('phone2');
					$this->db->where('type' , 'phone2');
					$this->db->update('settings' , $data);
					
					$this->session->set_flashdata('flash_message' , 'E-Mail & Contact settings updated successfully!');
					redirect(base_url() . 'admin/system_settings/email-contact-settings', 'refresh');
				}
			break;
			
			case 'image-settings':
				if( $_POST || $_FILES )
				{
					if( !empty($_FILES['userfile']['name']) )
					{  
						move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/logo.png');
						#compressImage($_FILES['userfile']['tmp_name'],'uploads/logo.png',60);
					}
					
					if( !empty($_FILES['userfile1']['name']) )
					{  
						move_uploaded_file($_FILES['userfile1']['tmp_name'], 'uploads/logo1.png');
						#compressImage($_FILES['userfile']['tmp_name'],'uploads/logo.png',60);
					}
					
					if( !empty($_FILES['favicon']['name']) )
					{  
						move_uploaded_file($_FILES['favicon']['tmp_name'], 'uploads/favicon.png');
						#compressImage($_FILES['favicon']['tmp_name'],'uploads/favicon.png',60);
					}
					
					if( !empty($_FILES['noimage']['name']) )
					{  
						move_uploaded_file($_FILES['noimage']['tmp_name'], 'uploads/no-image.png');
						#compressImage($_FILES['noimage']['tmp_name'],'uploads/no-image.png',60);
					}
					
					if( !empty($_FILES['backround_image']['name']) )
					{  
						move_uploaded_file($_FILES['backround_image']['tmp_name'], 'uploads/backround_image.png');
						#compressImage($_FILES['backround_image']['tmp_name'],'uploads/backround_image.png',60);
					}
					
					$this->session->set_flashdata('flash_message' , 'Image settings updated successfully!');
					redirect(base_url() . 'admin/system_settings/image-settings', 'refresh');
				}
			break;
			
			case 'currency-settings':
				$page_data['currency_data'] = $this->db->query('select * from system_settings where system_setting_id=1')->result_array();
				if($_POST)
				{
					$data['country_id'] = $this->input->post('country_id');
					$data['country_code'] = $this->input->post('country_code');
					$data['currency_symbol'] = $this->input->post('currency_symbol');
					$data['currency_code'] = $this->input->post('currency_code');
					
					$this->db->where('system_setting_id' , 1);
					$this->db->update('system_settings' , $data);
					
					#Currency updated 
					$country_data['default_country'] = 0;
					$result = $this->db->update('country', $country_data);
					
					if($result)
					{
						$country_id = $data['country_id'];
						$data_1['default_country'] = 1;
						$this->db->where('country_id', $country_id);
						$result1 = $this->db->update('country', $data_1);
					}
					#Currency updated 
					
					$this->session->set_flashdata('flash_message' , 'Currency setting updated successfully!');
					redirect(base_url() . 'admin/system_settings/currency-settings', 'refresh');
				}
			break;
			
			case 'system-settings':
				$page_data['currency_data'] = $this->db->query('select decimal_digit_value,fixed_invoice_amount,km_distance from system_settings where system_setting_id=1')->result_array();
				if($_POST)
				{
					$data['decimal_digit_value'] 			= $this->input->post('decimal_digit_value');
					$data['fixed_invoice_amount'] 			= $this->input->post('fixed_invoice_amount');
					$data['km_distance'] 					= $this->input->post('km_distance');
					$data['auto_refresh_seconds'] 			= $this->input->post('auto_refresh_seconds');
					
					$this->db->where('system_setting_id' , 1);
					$this->db->update('system_settings' , $data);
					
					$this->session->set_flashdata('flash_message' , 'System setting updated successfully!');
					redirect(base_url() . 'admin/system_settings/system-settings', 'refresh');
				}
			break;

			case 'socialmedia-api':
				$page_data['scocialmeida_api'] = $this->db->query('select * from system_settings where system_setting_id=1')->result_array();
				if($_POST)
				{
					$data['fb_api_id'] 				= $this->input->post('fb_api_id');
					$data['fb_api_secret'] 			= $this->input->post('fb_api_secret');
					$data['fb_api_token'] 			= $this->input->post('fb_api_token');
					$data['google_secret_key'] 		= $this->input->post('google_secret_key');
					$data['google_client_id'] 		= $this->input->post('google_client_id');
					$data['google_map_api_key'] 	= $this->input->post('google_map_api_key');
					$data['sms_api_key'] 			= $this->input->post('sms_api_key');
					$data['sms_api_secret'] 		= $this->input->post('sms_api_secret');
					$data['n_genius_payment_outlet'] 		= $this->input->post('n_genius_payment_outlet');
					$data['n_genius_payment_api'] 		= $this->input->post('n_genius_payment_api');

					$this->db->where('system_setting_id' , 1);
					$this->db->update('system_settings' , $data);
					
					$this->session->set_flashdata('flash_message' , 'System setting updated successfully!');
					redirect(base_url() . 'admin/system_settings/socialmedia-api', 'refresh');
				}
			break;
			
			case 'theme':
				
				$page_data['manage_settings'] = 1;
				$page_data['page_title'] = SITE_NAME.' | Theme Selection';
				$page_data['breadcrumb'] = 'Theme Selection';
				if($_POST)
				{
					$data['description'] = $this->input->post('thems');
					$this->db->where('type' , 'thems');
					$this->db->update('settings' , $data);
					
					$this->session->set_flashdata('flash_message' , 'Theme Selection updated successfully!');
					redirect(base_url() . 'admin/system_settings/theme', 'refresh');
				}
			break;
				
			default:
			
			break;
			
		}
		$this->load->view($this->adminTemplate, $page_data);
    }

	#Social Media Settings
	function social_media_settings($param1 = '', $param2 = '', $param3 = '') 
	{
		if(!$this->user_id)
		{
			redirect(base_url().'admin/adminLogin', 'refresh');
		}
			
		if($_POST)
		{
			$this->frontend_model->updateSocialMediaSettings();
			$this->session->set_flashdata('flash_message' , 'Social Media Settings');
			redirect(base_url() . 'admin/social_media_settings', 'refresh');
		}
		
		$page_data['manage_settings'] = $page_data['ApplicationSetups'] = 1;
		
		$page_data['page_name'] = 'admin/social_media_settings';
		$page_data['page_title']  = SITE_NAME.' | Social Media Settings';
		$this->load->view($this->adminTemplate, $page_data);
    }
	
	function mailer_settings()
    {
		if(!$this->user_id)
		{
			redirect(base_url().'admin/adminLogin', 'refresh');
		}
		
		$page_data['manage_settings'] = $page_data['ApplicationSetups'] = 1;
		
		$page_data['page_name']  = 'admin/mailer_settings';
		$page_data['page_title'] = SITE_NAME.' | Mailer Settings';
		
		$page_data['edit_data'] = $this->db->get_where('email_settings', array('settings_id' => 1))
							->result_array();
		
		if($_POST)
		{
			$data['email_type'] = $_POST['email_type'];
			
			if($_POST['email_type'] == 1)
			{
				$data['sendgrid_host'] = $this->input->post('sendgrid_host');
				$data['sendgrid_port'] = $this->input->post('sendgrid_port');
				$data['sendgrid_username'] = $this->input->post('sendgrid_username');
				$data['sendgrid_password'] = $this->input->post('sendgrid_password');
			}
			else if($_POST['email_type'] == 2)
			{
				$data['smtp_host'] = $this->input->post('smtp_host');
				$data['smtp_port'] = $this->input->post('smtp_port');
				$data['smtp_username'] = $this->input->post('smtp_username');
				$data['smtp_password'] = $this->input->post('smtp_password');
			}
			
			$this->db->where('settings_id', 1);
			$result = $this->db->update('email_settings', $data);
			if($result > 0)
			{
				$this->session->set_flashdata('flash_message' , get_phrase('mailer_settings_updated_successfully'));
				redirect(base_url() . 'admin/mailer_settings/', 'refresh');
			}
		}
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	function manage_profile($param1 = '', $param2 = '', $param3 = '')
    {
        if(!$this->user_id)
		{
			redirect(base_url().'admin/adminLogin', 'refresh');
		}
		
		$page_data['type'] = $param1;
	
        if ($param1 == 'update_profile_info') 
		{
            $data['first_name']  = $this->input->post('first_name');
            $data['last_name']  = $this->input->post('last_name');
            $data['phone_number']  = $this->input->post('phone_number');
            $data['address1'] = $this->input->post('address1');
            $data['address2'] = $this->input->post('address2');
            $data['country'] = $this->input->post('country');
            $data['city'] = $this->input->post('city');
            $data['email'] = $this->input->post('email');

            $admin_id = $param2;

            #$validation = email_validation_for_edit($data['email'], $admin_id, 'user');
			
			$this->db->where('user_id', $this->user_id);
			$this->db->update('users', $data);
			
			if(!empty($_FILES['userfile']['name']))
			{
				move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/admin_image/' . $this->user_id . '.png');
			}
			
			if(!empty($_FILES['coverfile']['name']))
			{
				move_uploaded_file($_FILES['coverfile']['tmp_name'], 'uploads/cover_image/' . $this->user_id . '.png');
			}
			
			$this->session->set_flashdata('flash_message', 'Profile updated successfully!');
			redirect(base_url() . 'admin/manage_profile/', 'refresh');
        }
		
		if ($param1 == 'change_password')
		{
            $data['password']             = md5($this->input->post('password'));
            $data['new_password']         = md5($this->input->post('new_password'));
            $data['confirm_new_password'] = md5($this->input->post('confirm_new_password'));

            $current_password = $this->db->get_where('users', array('user_id' => $this->user_id))->row()->password;
			
            if ($current_password == $data['password'] && $data['new_password'] == $data['confirm_new_password']) 
			{
                $this->db->where('user_id', $this->user_id);
                $this->db->update('users', array('password' => $data['new_password']));
                $this->session->set_flashdata('flash_message', get_phrase('password_changed_successfully'));
            } 
			else 
			{
                $this->session->set_flashdata('error_message', get_phrase('password_mismatch'));
            }
            redirect(base_url() . 'admin/manage_profile/', 'refresh');
        }
		
		
        $page_data['page_name']  = 'admin/manage_profile';
        $page_data['page_title'] = get_phrase('manage_profile');
        $page_data['edit_data']  = $this->db->get_where('users', array( 'user_id' => $this->user_id))->result_array();
        $this->load->view($this->adminTemplate, $page_data);
    }
	
	function change_password($param1 = '', $param2 = '', $param3 = '')
    {
        if(!$this->user_id)
		{
			redirect(base_url().'admin/adminLogin', 'refresh');
		}
			
        if ($param1 == 'change_password')
		{
            $data['password']             = md5($this->input->post('password'));
            $data['new_password']         = md5($this->input->post('new_password'));
            $data['confirm_new_password'] = md5($this->input->post('confirm_new_password'));

            $current_password = $this->db->get_where('users', array('user_id' => $this->user_id))->row()->password;
			
            if ($current_password == $data['password'] && $data['new_password'] == $data['confirm_new_password']) 
			{
                $this->db->where('user_id', $this->user_id);
                $this->db->update('users', array('password' => $data['new_password'],'original_password' => $_POST['new_password'] ));
                $this->session->set_flashdata('flash_message', get_phrase('password_changed_successfully'));
            } 
			else 
			{
                $this->session->set_flashdata('error_message', get_phrase('password_mismatch'));
            }
            redirect(base_url() . 'admin/change_password/', 'refresh');
        }
        $page_data['page_name']  = 'admin/change_password';
        $page_data['page_title'] = SITE_NAME.' | '.get_phrase('change_password');
      
        $this->load->view($this->adminTemplate, $page_data);
    }
	
	public function logout() 
	{
        $this->session->sess_destroy();
        redirect(base_url().'login.html', 'refresh');
    }
	
	public function sort_itemper_page($id="")
	{
		$page_number = $id;
		$redirecturl = isset($_GET['redirect'])?$_GET['redirect']:"";
		$_SESSION['PAGE']=$page_number;
		
		redirect($_SERVER['HTTP_REFERER'], 'refresh');
	}
	
	#Manage Category
    function manage_category($type = '', $id = '', $status = '', $status1 = '')
    {
		if (isset($this->user_id) && $this->user_id == '')
            redirect(base_url() . 'admin/adminLogin', 'refresh');
		
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageCategory'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'admin/manage_category';
		$page_data['page_title'] = SITE_NAME.' | Manage Category';
		
		switch($type)
		{
			case "add": #Add
				if($_POST)
				{
					$data['category_name'] = $this->input->post('category_name');
					$data['category_url'] = url($data['category_name']);
					$data['order_number'] = $this->input->post('order_number');
					$data['description'] = $this->input->post('description');
					$data['caytegory_layer'] = 1; #Main Category
					$data['category_status'] = 1;
					
					# Category exist start here
					$chkExistCategory = $this->db->query("select category_id from category
						where 
							category_name='".$data['category_name']."' 
							")->result_array();
							
					if(count($chkExistCategory) > 0)
					{
						$this->session->set_flashdata('error_message' , " Category Name already exist!");
						redirect(base_url() . 'admin/manage_category/add', 'refresh');
					}
					# Category exist end here
					
					$this->db->insert('category', $data);
					$id = $this->db->insert_id();
					if($id !="")
					{
						if( isset($_FILES['category_images']['name']) && $_FILES['category_images']['name'] !="" )
						{
							move_uploaded_file($_FILES['category_images']['tmp_name'], 'uploads/category_image/' . $id . '.png');
						}
						
						if( isset($_FILES['category_banner']['name']) && $_FILES['category_banner']['name'] !="" )
						{
							move_uploaded_file($_FILES['category_banner']['tmp_name'], 'uploads/category_banner/' . $id . '.png');
						}
						
						$this->session->set_flashdata('flash_message' , get_phrase('category_added_successfully'));
						redirect(base_url() . 'admin/manage_category', 'refresh');
					}
				}
			break;
			
			case "edit": #Edit
				$page_data['edit_data'] = $this->db->get_where('category', array('category_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['category_name'] = $this->input->post('category_name');
					$data['category_url'] = url($data['category_name']);
					$data['description'] = $this->input->post('description');
					
					$data['order_number'] = $this->input->post('order_number');
					
					# Category exist start here
						$chkExistCategory = $this->db->query("select category_id from category
							where 
									category_id !='".$id."' and
								(category_name='".$data['category_name']."')
								")->result_array();
								
						if(count($chkExistCategory) > 0)
						{
							$this->session->set_flashdata('error_message' , " Category Name already exist!");
							redirect(base_url() . 'admin/manage_category/edit', 'refresh');
						}
					# Category exist end here
					
					$this->db->where('category_id', $id);
					$result = $this->db->update('category', $data);
					if($result > 0)
					{
						if( isset($_FILES['category_images']['name']) && $_FILES['category_images']['name'] !="" )
						{
							move_uploaded_file($_FILES['category_images']['tmp_name'], 'uploads/category_image/' . $id . '.png');
						}
						
						if( isset($_FILES['category_banner']['name']) && $_FILES['category_banner']['name'] !="" )
						{
							move_uploaded_file($_FILES['category_banner']['tmp_name'], 'uploads/category_banner/' . $id . '.png');
						}
						
						$this->session->set_flashdata('flash_message' , get_phrase('category_updated_successfully'));
						redirect(base_url() . 'admin/manage_category', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('category_id', $id);
				$this->db->delete('category');
				$this->session->set_flashdata('flash_message' , get_phrase('category_deleted_successfully!'));
				redirect(base_url() . 'admin/manage_category/', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['category_status'] = 1;
					$succ_msg = 'category_unblocked_successfully!';
				}else{
					$data['category_status'] = 0;
					$succ_msg = 'category_blocked_successfully!';
				}
				$this->db->where('category_id', $id);
				$this->db->update('category', $data);
				$this->session->set_flashdata('flash_message' , get_phrase($succ_msg));
				redirect(base_url() . 'admin/manage_category/', 'refresh');
			break;
			
			#Sub category start
			case "add_subcategory": #Add Subcategory
				if($_POST)
				{
					$data['main_category_id'] = $id;
					$data['category_name'] = $this->input->post('sub_category_name');
					$data['category_url'] = url($data['category_name']);
					$data['description'] = $this->input->post('description');
					
					$data['order_number'] = $this->input->post('order_number');
					$data['caytegory_layer'] = 2; #2nd Sub Category
					$data['category_status'] = 1;
					
					$this->db->insert('category', $data);
					$id = $this->db->insert_id();
					if($id !="")
					{
						if( isset($_FILES['category_images']['name']) && $_FILES['category_images']['name'] !="" )
						{
							move_uploaded_file($_FILES['category_images']['tmp_name'], 'uploads/category_image/' . $id . '.png');
						}
						$this->session->set_flashdata('flash_message' , get_phrase('category_added_successfully'));
						redirect(base_url() . 'admin/manage_category/manage_subcategory/'.$status, 'refresh');
					}
				}
			break;
			
			case "edit_subcategory": #Edit
				$page_data['edit_data'] = $this->db->get_where('category', array('category_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['category_name'] = $this->input->post('sub_category_name');
					$data['category_url'] = url($data['category_name']);
					$data['description'] = $this->input->post('description');
					
					$data['order_number'] = $this->input->post('order_number');
					
					$this->db->where('category_id', $id);
					$result = $this->db->update('category', $data);
					if($result > 0)
					{
						if( isset($_FILES['category_images']['name']) && $_FILES['category_images']['name'] !="" )
						{
							move_uploaded_file($_FILES['category_images']['tmp_name'], 'uploads/category_image/' . $id . '.png');
						}
						
						$this->session->set_flashdata('flash_message' , get_phrase('sub_category_updated_successfully'));
						redirect(base_url() . 'admin/manage_category/manage_subcategory/'.$status, 'refresh');
					}
				}
			break;
			
			case "delete_subcategory": #Delete
				$this->db->where('category_id', $id);
				$this->db->delete('category');
				$this->session->set_flashdata('flash_message' , get_phrase('sub_category_deleted_successfully!'));
				redirect(base_url() . 'admin/manage_category/manage_subcategory/'.$status, 'refresh');
			break;
			
			case "status_subcategory": #Block & Unblock
				if($status == 1){
					$data['category_status'] = 1;
					$succ_msg = 'sub_category_unblocked_successfully!';
				}else{
					$data['category_status'] = 0;
					$succ_msg = 'sub_category_blocked_successfully!';
				}
				$this->db->where('category_id', $id);
				$this->db->update('category', $data);
				$this->session->set_flashdata('flash_message' , get_phrase($succ_msg));
				redirect(base_url() . 'admin/manage_category/manage_subcategory/'.$status1, 'refresh');
			break;
			
			case "manage_subcategory": #Manage Subcategory
				$page_data['subCategory'] = $result = $this->db->query("select * from category where main_category_id ='".$id."'")->result_array();
			break;
			#Sub category end
			
			#Sec Sub category start
			
			case "add_secsubcategory": #Add Subcategory
				if($_POST)
				{
					$data['main_category_id'] = $id;
					$data['category_name'] = $this->input->post('sec_sub_category_name');
					$data['category_url'] = url($data['category_name']);
					$data['description'] = $this->input->post('description');
					
					/* $data['order_number'] = $this->input->post('order_number'); */
					$data['caytegory_layer'] = 3; #3rd Category
					$data['category_status'] = 1;
					
					$this->db->insert('category', $data);
					$id = $this->db->insert_id();
					if($id !="")
					{
						if( isset($_FILES['category_images']['name']) && $_FILES['category_images']['name'] !="" )
						{
							move_uploaded_file($_FILES['category_images']['tmp_name'], 'uploads/category_image/' . $id . '.png');
						}
						$this->session->set_flashdata('flash_message' , get_phrase('category_added_successfully'));
						redirect(base_url() . 'admin/manage_category/manage_subcategory/'.$status, 'refresh');
					}
				}
			break;
			case "edit_secsubcategory": #edit Sec Sub category
				$page_data['edit_data'] = $this->db->get_where('category', array('category_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['category_name'] = $this->input->post('sec_sub_category_name');
					$data['category_url'] = url($data['category_name']);
					$data['order_number'] = $this->input->post('order_number');
					$data['description'] = $this->input->post('description');
					
					$this->db->where('category_id', $id);
					$result = $this->db->update('category', $data);
					
					if($id !="")
					{
						if( isset($_FILES['category_images']['name']) && $_FILES['category_images']['name'] !="" )
						{
							move_uploaded_file($_FILES['category_images']['tmp_name'], 'uploads/category_image/' . $id . '.png');
						}
						$this->session->set_flashdata('flash_message' , get_phrase('sub_category_Updated_successfully'));
						redirect(base_url() . 'admin/manage_category/manage_secsubcategory/'.$status, 'refresh');
					}
				}
			break;
			
			case "delete_secsubcategory": #Delete
				$this->db->where('category_id', $id);
				$this->db->delete('category');
				$this->session->set_flashdata('flash_message' , get_phrase('sec_sub_category_deleted_successfully!'));
				redirect(base_url() . 'admin/manage_category/manage_secsubcategory/'.$status, 'refresh');
			break;
			
			case "status_secsubcategory": #Block & Unblock
				if($status == 1){
					$data['category_status'] = 1;
					$succ_msg = 'sec_sub_category_unblocked_successfully!';
				}else{
					$data['category_status'] = 0;
					$succ_msg = 'sec_sub_category_blocked_successfully!';
				}
				$this->db->where('category_id', $id);
				$this->db->update('category', $data);
				$this->session->set_flashdata('flash_message' , get_phrase($succ_msg));
				redirect(base_url() . 'admin/manage_category/manage_secsubcategory/'.$status1, 'refresh');
			break;
			
			case "manage_secsubcategory": #Manage Subcategory
				$page_data['secsubCategory'] = $result = $this->db->query("select * from category where main_category_id ='".$id."'")->result_array();
			break;
			#Sub category end
			
			
			default : #Manage
				//$page_data['category'] = $result = $this->db->query("select * from category where main_category_id =0")->result_array();
				$page_data["totalRows"] = $totalRows = $this->admin_model->getManageCategoryCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('admin/manage_category?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('admin/manage_category?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result = $this->admin_model->getManageCategory($limit, $offset);
			
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
			
			
		}
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	function ManageBackupDatabases($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['manage_settings'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'admin/ManageBackupDatabases';
		$page_data['page_title'] = 'Manage Backup Databases';
		
		switch($type)
		{
			case "delete": #Delete
				$getDatabaseDetails = $this->db->query("select database_name from backup_databases where backup_id='".$id."'")->result_array();
				$database_name = $getDatabaseDetails[0]["database_name"];
				
				if( file_exists($database_name) && !empty($database_name) )
				{
					unlink($database_name);
				}
				
				$this->db->where('backup_id', $id);
				$this->db->delete('backup_databases');
				
				$this->session->set_flashdata('flash_message' , "Backup database deleted successfully!");
				redirect(base_url() . 'admin/ManageBackupDatabases', 'refresh');
			break;
			
			case "export":
				date_default_timezone_set('GMT');
				#Load the file helper in codeigniter
				$this->load->helper('file');
				
				$con = mysqli_connect(HOST_NAME,USER_NAME,DB_PASSWORD,DATABASE_NAME);

				$tables = array();
				$query = mysqli_query($con, 'SHOW TABLES');
				while($row = mysqli_fetch_row($query))
				{
					 $tables[] = $row[0];
				}

				$result = 'SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";';
				$result .= 'SET AUTOCOMMIT = 0;';
				$result .= 'START TRANSACTION;';
				$result .= 'SET time_zone = "+00:00";';
					
				foreach($tables as $table)
				{
					$query = mysqli_query($con, 'SELECT * FROM `'.$table.'`');
					$num_fields = mysqli_num_fields($query);

					#$result .= 'DROP TABLE IF EXISTS '.$table.';';
					$row2 = mysqli_fetch_row(mysqli_query($con, 'SHOW CREATE TABLE `'.$table.'`'));
					$result .= "\n\n".$row2[1].";\n\n";
					
					for ($i = 0; $i < $num_fields; $i++) 
					{
						while($row = mysqli_fetch_row($query))
						{
						    $result .= 'INSERT INTO `'.$table.'` VALUES(';
							for($j=0; $j<$num_fields; $j++)
							{
							    $row[$j] = addslashes($row[$j]);
							    $row[$j] = str_replace("\n","\\n",$row[$j]);
								if(isset($row[$j]))
								{
								   $result .= '"'.$row[$j].'"' ; 
								}
								else
								{ 
								   $result .= '""';
								}
								if($j<($num_fields-1))
								{ 
								   $result .= ',';
								}
							}
							$result .= ");\n";
						}
					}
					$result .="\n\n";
				}

				#Create Folder
				$folder = 'database/';
				if (!is_dir($folder))
				mkdir($folder, 0777, true);
				chmod($folder, 0777);

				$date = "db_filename_".date('m-d-Y')."_".rand(); 
				$filename = $folder.$date; 
				$databaseName = $folder.$date.'.sql'; 

				$handle = fopen($filename.'.sql','w+');
				fwrite($handle,$result);
				fclose($handle);
				
				$data['database_name'] = $databaseName;
				$data['backup_date'] = strtotime(date('d-m-Y h:i:s a'));
				
				$this->db->insert('backup_databases', $data);
				$id = $this->db->insert_id();
				$this->session->set_flashdata('flash_message' , "Database backuped successfully!");
				redirect(base_url() . 'admin/ManageBackupDatabases', 'refresh');  
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->admin_model->getManageExpensePaymentTypeCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('admin/ManageBackupDatabases?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('admin/ManageBackupDatabases?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->admin_model->getManagePaymentType($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	public function ajaxSubCategory() 
	{
        $id = $_POST["id"];		
		if($id)
		{			
			$data =  $this->db->query("select category_id, category_name from category
					where main_category_id='".$id."' order by category_name asc
					")->result_array();
		
			if( count($data) > 0)
			{
				#echo '<option value="">Select State</option>';
				foreach($data as $val)
				{
					echo '<option value="'.$val['category_id'].'">'.ucfirst($val['category_name']).'</option>';
				}
			}
			else
			{
				echo '<option value="">No sub category under this soft skills!</option>';
			}
		}
		die;
    }
	
	# Ajax  Change
	public function ajaxCountystate() 
	{
        $id = $_POST["id"];		
		if($id)
		{			
			$data =  $this->db->query("select state.state_id,state.state_name from state
					left join country on country.country_id = state.state_id
					where state.country_id='".$id."' order by state.state_name asc
					")->result_array();

			if( count($data) > 0)
			{
				echo '<option value="">- Select State -</option>';
				foreach($data as $val)
				{
					echo '<option value="'.$val['state_id'].'">'.ucfirst($val['state_name']).'</option>';
				}
			}
			else
			{
				echo '<option value="">No State under this Country!</option>';
			}
		}
		die;
    }
		
	
	# Ajax  Change
	public function ajaxselectState() 
	{
        $id = $_POST["id"];		
		if($id)
		{			
			$data =  $this->db->query("select state.* from state
					left join country on country.country_id = state.state_id
					where state.country_id='".$id."' order by state.state_name asc
					")->result_array();
		
			if( count($data) > 0)
			{
				echo '<option value="">- Select State -</option>';
				foreach($data as $val)
				{
					echo '<option value="'.$val['state_id'].'">'.ucfirst($val['state_name']).'</option>';
				}
			}
			else
			{
				echo '<option value="">No states under this country!</option>';
			}
		}
		die;
    }
	
	# Ajax  Change
	public function ajaxSelectDistrict() 
	{
        $id = $_POST["id"];		
		if($id)
		{	
			#left join country on country.country_id = state.state_id
			$data =  $this->db->query("select district.* from district
					where district.state_id='".$id."' order by district.district_name asc
					")->result_array();
		
			if( count($data) > 0)
			{
				echo '<option value="">- Select District -</option>';
				foreach($data as $val)
				{
					echo '<option value="'.$val['district_id'].'">'.ucfirst($val['district_name']).'</option>';
				}
			}
			else
			{
				echo '<option value="">No districts under this state!</option>';
			}
		}
		die;
    }
	
	# Ajax Select cities under State
	public function ajaxSelectCity() 
	{
        $id = $_POST["id"];		
		if($id)
		{			
			$data =  $this->db->query("select city.city_id,city.city_name from city
					left join state on state.state_id = city.city_id
					where city.state_id='".$id."' order by city.city_name asc
					")->result_array();
		
			if( count($data) > 0)
			{
				echo '<option value="">- Select City -</option>';
				foreach($data as $val)
				{
					echo '<option value="'.$val['city_id'].'">'.ucfirst($val['city_name']).'</option>';
				}
			}
			else
			{
				echo '<option value="">No cities under this state!</option>';
			}
		}
		die;
    }
	
	function ManageBankDetails($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['manage_settings'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'admin/ManageBankDetails';
		$page_data['page_title'] = 'Manage Bank Details';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['micr_code'] = $this->input->post('micr_code');
					$existBankCode = $this->db->query("select bank_id from org_bank_details where micr_code='".$data['micr_code']."' ")->result_array();
					if(count($existBankCode) >0 )
					{
						$this->session->set_flashdata('error_message' , "Sorry! Already exist MICR code!");
						redirect(base_url() . 'admin/ManageBankDetails', 'refresh');
					}
					
					$data['bank_name'] = $this->input->post('bank_name');
					$data['branch_id'] = $this->input->post('branch_id');
					$data['bank_status'] = 1;
					
					$this->db->insert('org_bank_details', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						if( !empty($_FILES['bank_logo']['name']) )
						{  
							move_uploaded_file($_FILES['bank_logo']['tmp_name'], 'uploads/bank_logo/'.$id.'.png');
						}
						
						$this->session->set_flashdata('flash_message' , "Bank details added Successfully!");
						redirect(base_url() . 'admin/ManageBankDetails', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('org_bank_details', array('bank_id' => $id))
										->result_array();
										
				if($_POST)
				{
					$data['micr_code'] = $this->input->post('micr_code');
					$existBranchCode = $this->db->query("select bank_id from org_bank_details where micr_code='".$data['micr_code']."' and bank_id !='".$id."'")->result_array();
					if(count($existBranchCode) >0 )
					{
						$this->session->set_flashdata('error_message' , "Sorry! Already exist MICR code!");
						redirect(base_url() . 'admin/ManageBankDetails/edit/'.$id, 'refresh');
					}
				
					$data['bank_name'] = $this->input->post('bank_name');
					$data['branch_id'] = $this->input->post('branch_id');
					
					$this->db->where('bank_id', $id);
					$result = $this->db->update('org_bank_details', $data);
					
					if($result)
					{
						if( !empty($_FILES['bank_logo']['name']) )
						{  
							move_uploaded_file($_FILES['bank_logo']['tmp_name'], 'uploads/bank_logo/'.$id.'.png');
						}
						
						$this->session->set_flashdata('flash_message' , "Bank details updated Successfully!");
						redirect(base_url() . 'admin/ManageBankDetails', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('bank_id', $id);
				$this->db->delete('org_bank_details');
				
				$this->session->set_flashdata('flash_message' , "Bank details deleted successfully!");
				redirect(base_url() . 'admin/ManageBankDetails', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['bank_status'] = 1;
					$succ_msg = 'Bank details unblocked successfully!';
				}else{
					$data['bank_status'] = 0;
					$succ_msg = 'Bank details blocked successfully!';
				}
				$this->db->where('bank_id', $id);
				$this->db->update('org_bank_details', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'admin/ManageBankDetails', 'refresh');
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->admin_model->getManageBankDetailsCount();
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('admin/ManageBankDetails?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('admin/ManageBankDetails?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->admin_model->getManageBankDetails($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	public function EmailExist()
	{
		if ( isset($_POST['email_check']) && $_POST['email_check'] == 1) 
		{
			$email = $_POST['email'];
			#$register_type = $_POST['register_type'];
			
			$results = $this->db->query("select user_id from users WHERE email='".$email."' and user_type !=1 ")->result_array(); #and register_type='".$register_type."'
			if ( count($results) > 0 ) {
				echo "taken";	
			}else{
				echo 'not_taken';
			}
			exit();
		}
	}
	
	function ManagePaymentType($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['manage_settings'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'admin/ManagePaymentType';
		$page_data['page_title'] = 'Manage Payment Mode';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['payment_type'] = $this->input->post('payment_type');
					$data['payment_type_status'] = 1;
					
					$this->db->insert('expense_payment_type', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{	
						$this->session->set_flashdata('flash_message' , "Payment Type added Successfully!");
						redirect(base_url() . 'admin/ManagePaymentType', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('expense_payment_type', array('payment_type_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['payment_type'] = $this->input->post('payment_type');
					
					$this->db->where('payment_type_id', $id);
					$result = $this->db->update('expense_payment_type', $data);
					
					if($result)
					{
						$this->session->set_flashdata('flash_message' , "Payment Type updated Successfully!");
						redirect(base_url() . 'admin/ManagePaymentType', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('payment_type_id', $id);
				$this->db->delete('expense_payment_type');
				
				$this->session->set_flashdata('flash_message' , "Payment Type deleted successfully!");
				redirect(base_url() . 'admin/ManagePaymentType', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['payment_type_status'] = 1;
					$succ_msg = 'Payment Type unblocked successfully!';
				}else{
					$data['payment_type_status'] = 0;
					$succ_msg = 'Payment Type blocked successfully!';
				}
				$this->db->where('payment_type_id', $id);
				$this->db->update('expense_payment_type', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'admin/ManagePaymentType', 'refresh');
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->admin_model->getManageExpensePaymentTypeCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('admin/ManagePaymentType?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('admin/ManagePaymentType?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->admin_model->getManagePaymentType($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	public function MobileNumberExist()
	{
		if ( isset($_POST['mobile_number_check']) && $_POST['mobile_number_check'] == 1) 
		{
			$mobile_number = $_POST['mobile_number'];
			#$register_type = $_POST['register_type'];
			
			$results = $this->db->query("select user_id from users WHERE mobile_number='".$mobile_number."' and (register_type =1 || register_type =2) ")->result_array(); #and register_type='".$register_type."'
			if ( count($results) > 0 ) {
				echo "taken";	
			}else{
				echo 'not_taken';
			}
			exit();
		}
	}
	public function getCountryDetails()
	{
		$id = $_POST["id"];		
		if($id)
		{			
			$data =  $this->db->query("select * from country
					where country_id='".$id."' and country_status=1
					")->result();
			echo json_encode($data);
		}
		die;
	}

	public function ordersFilter($val)
	{
		$_SESSION['orders_filter'] = $val;
		redirect(base_url() . 'admin/dashboard', 'refresh');
	}
	
	#Manage Banner
    function manage_banner($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
		
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['manage_settings'] = $page_data['Setups'] = 1;
		
		
		$page_data['page_name']  = 'admin/manage_banner';
		$page_data['page_title'] = 'Manage Banner';
		
		switch($type)
		{
			case "add": #Add
				if($_POST)
				{
					$user_type = $this->input->post('user_type');
					
					$getBanner = $this->db->query('select banner_id from banner where user_type="'.$user_type.'"')->result_array(); 
					
					/* if( count($getBanner) == 0 )
					{ */
						
						$data['banner_title'] = $this->input->post('banner_title');
						$data['banner_url'] = $this->input->post('banner_url');
						$data['banner_link_name'] = $this->input->post('banner_link_name');
						$data['banner_description'] = $this->input->post('banner_description');
						$data['category_id'] = $this->input->post('category_id');
						
						$data['banner_status'] = 1;
						
						$this->db->insert('banner', $data);
						$id = $this->db->insert_id();
						if($id !="")
						{
							if(!empty($_FILES['banner_image']['name']))
							{
								#compressImage($_FILES['banner_image']['tmp_name'],'uploads/banner/' . $id . '.png',60);
								move_uploaded_file($_FILES['banner_image']['tmp_name'], 'uploads/banner/'.$id.'.png');
						
							}
							$this->session->set_flashdata('flash_message' , get_phrase('banner_added_successfully'));
							redirect(base_url() . 'admin/manage_banner', 'refresh');
						}
					/* }
					else
					{
						$this->session->set_flashdata('error_message' , 'Already exist this user type banner!');
						redirect(base_url() . 'admin/manage_banner', 'refresh');
					} */
				}
			break;
			
			case "edit": #Edit
				$page_data['edit_data'] = $this->db->get_where('banner', array('banner_id' => $id))->result_array();
				if($_POST)
				{
					$data['banner_title'] = $this->input->post('banner_title');
					
					$data['banner_url'] = $this->input->post('banner_url');
					$data['banner_link_name'] = $this->input->post('banner_link_name');
					$data['banner_description'] = $this->input->post('banner_description');
					$data['category_id'] = $this->input->post('category_id');

					$this->db->where('banner_id', $id);
					$result = $this->db->update('banner', $data);
					
					if($result > 0)
					{
						if(!empty($_FILES['banner_image']['name']))
						{
							#compressImage($_FILES['banner_image']['tmp_name'],'uploads/banner/' . $id . '.png',60);
							move_uploaded_file($_FILES['banner_image']['tmp_name'], 'uploads/banner/'.$id.'.png');
						}
						
						$this->session->set_flashdata('flash_message' , get_phrase('banner_updated_successfully'));
						redirect(base_url() . 'admin/manage_banner', 'refresh');
					}
					
				}
			break;
			
			case "delete": #Delete
				$this->db->where('banner_id', $id);
				$this->db->delete('banner');
				$this->session->set_flashdata('flash_message' , get_phrase('banner_deleted_successfully!'));
				redirect(base_url() . 'admin/manage_banner/', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['banner_status'] = 1;
					$succ_msg = 'banner_unblocked_successfully!';
				}else{
					$data['banner_status'] = 0;
					$succ_msg = 'banner_blocked_successfully!';
				}
				$this->db->where('banner_id', $id);
				$this->db->update('banner', $data);
				$this->session->set_flashdata('flash_message' , get_phrase($succ_msg));
				redirect(base_url() . 'admin/manage_banner/', 'refresh');
			break;
			
			default : #Manage
			
				if($_POST)
				{
					# Set Default banner
					$default_banner = $_POST["default_banner"];
					
					if($default_banner){
						$banner_update = $this->db->update("banner", array("default_banner" => 0), array("banner_id >" => 0));
					}
					$result = $this->db->update("banner", array("default_banner" => 1), array("banner_id" => $default_banner));
					
					$this->session->set_flashdata('flash_message' ,'Default banner updated successfully!');
					redirect(base_url() . 'admin/manage_banner/', 'refresh');
				}
				
				$page_data["totalRows"] = $totalRows = $this->admin_model->getBannerCount(); #
				
				if(!empty($_SESSION['PAGE'])){
					$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('admin/manage_banner?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('admin/manage_banner?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['banner']  = $result= $this->admin_model->getBanner($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}
		$this->load->view($this->adminTemplate, $page_data);
	}

	function ManageFeedback()
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
		
		# Multi delete start here
		if( isset($_POST['delete']) && $_POST['delete'] != "")
		{
			if( isset($_POST["checkbox"]) )
			{
				$count = count($_POST["checkbox"]);
				for($i=0;$i<$count;$i++)
				{
					$checkbox = $_POST["checkbox"];
					$conatct_id = $id = $checkbox[$i];
					
					$this->db->where('feedback_id', $conatct_id);
					$this->db->delete('feedback');
				}
				$this->session->set_flashdata('flash_message' , 'Contact data deleted successfully!');
				redirect($_SERVER['HTTP_REFERER'], 'refresh');
			}
		}
		# Multi delete end here
		
		$page_data['ManageFeedback'] = 1;
		$page_data['page_name']  = 'admin/ManageFeedback';
		$page_data['page_title'] = 'Manage Feedback';
		
		$page_data["totalRows"] = $totalRows = $this->admin_model->getManageFeedbackCount();#
		
		if(!empty($_SESSION['PAGE']))
		{$limit = $_SESSION['PAGE'];
		}else{$limit = 10;}
		
		if (!empty($_GET['keywords'])) {
			$base_url = base_url('admin/ManageFeedback?keywords='.$_GET['keywords']);
		} else {
			$base_url = base_url('admin/ManageFeedback?keywords=');
		}
		
		$config = PaginationConfig($base_url,$totalRows,$limit);
		$this->pagination->initialize($config);
		$str_links = $this->pagination->create_links();
		$page_data['pagination'] = explode('&nbsp;', $str_links);
		$offset = 0;
		if (!empty($_GET['per_page'])) {
			$pageNo = $_GET['per_page'];
			$offset = ($pageNo - 1) * $limit;
		}
		
		if($offset == 1 || $offset== "" || $offset== 0){
			$page_data["first_item"] = 1;
		}else{
			$page_data["first_item"] = $offset + 1;
		}
		
		$page_data['resultData']  = $result= $this->admin_model->getManageFeedback($limit, $offset);
		
		#show start and ending Count
		$total_counts = $total_count= 0;
		$pages=$page_data["starting"] = $page_data["ending"]="";
		$pageno = isset($pageNo) ? $pageNo :"";
		
		if( $totalRows == 0 ){
			$page_data["starting"] = 0;
		}else if( $pageno==1 || $pageno=="" ){
			$page_data["starting"] = 1;
		}else{
			$pages = $pageno-1;
			$total_count = $pages * $config["per_page"];
			$page_data["starting"] = ( $config["per_page"] * $pages )+1;
		}
		
		$total_counts = $total_count + count($result);
		$page_data["ending"]  = $total_counts;
		#show start and ending Count end
		
		
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	# Manage CMS
    function manage_cms($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/login', 'refresh');
		}
		
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['manage_settings'] = $page_data['ApplicationSetups'] = 1;
		
		$page_data['page_name']  = 'admin/manage_cms';
		$page_data['page_title'] = get_phrase('manage_cms');
		
		switch($type)
		{
			case "add": #Add
				if($_POST)
				{
					$cms_title = $this->input->post('cms_title');
					$cms_name = $this->cms_page[$cms_title];

					$chk_query = "select cms_page_id from cms where cms_page_id = $cms_title";
					$chk_exist = $this->db->query($chk_query)->result_array();

					if (count($chk_exist) == 0) 
					{
						$data['cms_title'] 		= $cms_name;
						$data['cms_url'] 		= url($cms_name);
						$data['cms_desc'] 		= $this->input->post('cms_desc');
						$data['cms_page_id'] 	= $cms_title;
						
						$this->db->insert('cms', $data);
						$id = $this->db->insert_id();

						if($id !="")
						{
							$this->session->set_flashdata('flash_message' , get_phrase('property_added_successfully'));
							redirect(base_url() . 'admin/manage_cms/', 'refresh');
						}
					}
					else 
					{
						$this->session->set_flashdata('error_message' , get_phrase('property_already_existed'));
						redirect(base_url() . 'admin/manage_cms/', 'refresh');
					}
				
				}
			break;
			
			case "edit": #Edit
				$page_data['edit_data'] = $this->db->get_where('cms', array('cms_id' => $id))
										->result_array();
				if($_POST)
				{
					$cms_title = $this->input->post('cms_title');
					$cms_name = $this->cms_page[$cms_title];

					$data['cms_title'] 		= $cms_name;
					$data['cms_url'] 		= url($cms_name);
					$data['cms_desc'] 		= $this->input->post('cms_desc');
					$data['cms_page_id'] 	= $cms_title;

					$this->db->where('cms_id', $id);
					$result = $this->db->update('cms', $data);
					if($result > 0)
					{
						$this->session->set_flashdata('flash_message' , get_phrase('cms_updated_successfully'));
						redirect(base_url() . 'admin/manage_cms/', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('cms_id', $id);
				$this->db->delete('cms');
				$this->session->set_flashdata('flash_message' , get_phrase('cms_deleted_successfully!'));
				redirect(base_url() . 'admin/manage_cms/', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['cms_status'] = 1;
					$succ_msg = 'cms_unblocked_successfully!';
				}else{
					$data['cms_status'] = 0;
					$succ_msg = 'cms_blocked_successfully!';
				}
				$this->db->where('cms_id', $id);
				$this->db->update('cms', $data);
				$this->session->set_flashdata('flash_message' , get_phrase($succ_msg));
				redirect(base_url() . 'admin/manage_cms/', 'refresh');
			break;
			
			default : #Manage
				$page_data['cms'] = $this->admin_model->getCMS();
			break;
		}
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	
}
?>
