<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*------------------------------
#   Author  :   Sharanji P        
#   Date    :   08 - July - 2021
#   Jesperapps Software Services
--------------------------------*/
class Api extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function send_otp()
    {
		$json = @file_get_contents('php://input');
		$jsondata = @json_decode($json);
		
		$mobile_number = $jsondata->mobile_number;
		$country_id = $jsondata->country_id;

		if (isset($jsondata->user_id) && isset($jsondata->user_id))
		{
			$this->updateMobileNumber($jsondata->user_id, $mobile_number,$country_id);exit;
		}

		if( empty($mobile_number) )
		{
			header("Content-Type: application/json");
			$response = array(
							"httpCode" => 404 ,
							"message" => "Mobile number is required!" 
						);
			echo json_encode($response);
			exit;
		}
		
	
		$chkAlreayExist = $this->db->query("select user_id,country_code from users 
											left join country on country.country_id = users.country_id
											where  mobile_number='".$mobile_number."' ")->result_array();
		
		if (count($chkAlreayExist) > 0) {
			// $data->country_id 	= $country_id;
			$this->db->where('mobile_number',$mobile_number);
			$this->db->update('users',array("country_id"=>$country_id));
		}
		else {
			$this->db->insert('users',
				array("country_id"=>$country_id,"mobile_number"=>$mobile_number,"register_type"=>2,"password"=>md5(rand()),"joined_date"=>time(),"user_status"=>1)
			);
			$user_id = $this->db->insert_id();

			$chkAlreayExist = $this->db->query("select user_id,country_code from users 
											left join country on country.country_id = users.country_id
											where user_id = $user_id ")->result_array();
		}
		
		#Login OTP Start
		$otpNumber = otpNumber(6);
		$message = '<#> Dear Customer, ';
		$message .= ' Your Login OTP for' . SITE_NAME .' is : '.$otpNumber;
		// $sendSMSResult = sendSMS($mobile_number,$message);

		$otpMobileNumber = $chkAlreayExist[0]['country_code'].$mobile_number;
		$sendSMS = globalSMS($otpMobileNumber,$message);
		#Login OTP End

		$data = [];
		$data['otp_number'] 	= $otpNumber;
		$data['country_id'] 	= $country_id;
		

		if( count($chkAlreayExist) == 0)
		{
			$data['joined_date'] = time();
			$data['password']    = md5(time());
			$data['mobile_number'] = $mobile_number;
			$this->db->insert('users', $data);
			$user_type = 0;
		}
		else
		{	
			$this->db->where('mobile_number', $mobile_number);
			$result = $this->db->update('users', $data);
			$user_type = 1;
		}

		header("Content-Type: application/json");
		$response = array(
					"httpCode"      => 200 ,
					"mobile_number" => $mobile_number,
					"otp_number"    => $otpNumber,
					"user_type"		=> $user_type, 
					"message"       => "OTP Sent Successfully!" 
				);

		echo json_encode($response);
		exit;

	}
	
    function verify_otp()
	{
		$json = @file_get_contents('php://input');
		$data = @json_decode($json);

		if( !empty( $data->mobile_number ) && !empty( $data->otp_number )  )
		{			
			$mobile_number 	= $data->mobile_number;
			$otp_number 	= $data->otp_number;

			$user = $this->db->query("select first_name,user_id,mobile_number,country_id,email from users where  mobile_number='".$mobile_number."' and otp_number = '".$otp_number."'")->result_array();

			if( count($user) > 0 )
			{
				$user_id = $user[0]['user_id'];

				if (file_exists('uploads/profile_image/'.$user[0]['user_id'].'.png'))
				{
					$profile_imgUrl = base_url()."uploads/profile_image/".$user_id.'.png' ;			
				}
				else
				{
					$profile_imgUrl = base_url().'uploads/no-user.png' ;
				}

				$this->db->where('user_id', $user[0]['user_id']);
				$result = $this->db->update('users',array('otp_status' => 1 ,'otp_number'=>rand(1,1000),'mobile_number'=>$mobile_number));

                $response = array(	
					"httpCode" 		=> 200 ,
					"userId"		=> $user[0]['user_id'],
					"mobileNumber"	=> $user[0]['mobile_number'],
					"countryId"		=> $user[0]['country_id'],
					"email"			=> isset($user[0]['email'])	? $user[0]['email'] :null,						
					"firstName"		=> isset($user[0]['first_name']) ? $user[0]['first_name'] :null,						
					"profileImage"	=> $profile_imgUrl,						
					"message" 		=> "Mobile Number verified successfully!"
				);
				
				header("Content-Type: application/json");
				echo json_encode($response);
				exit;
            }
			else
			{
				$response = array("httpCode" => 409 , "message" => "OTP number does not match!" );
				header('HTTP/1.1 409', TRUE, 409);
				echo json_encode($response);
				exit;
			}
		}
		else
		{
			$response = array("httpCode" => 400 , "Message" => "Bad Request" );
			header('HTTP/1.1 400', TRUE, 400);
			echo json_encode($response);
			exit;
		}
		exit;
	}
		
	function myProfile($user_id="",$register_type=2)
	{
		$condition = "users.user_id='".$user_id."'";

		$getUserDetails = $this->db->query("select 
				user_id,
				first_name,
				email,
				joined_date,
				mobile_number
				from users 
				where users.user_id='".$user_id."' ")->result_array();

		if (file_exists('uploads/profile_image/'.$user_id.'.png'))
		{
			$profile_imgUrl = base_url()."uploads/profile_image/".$user_id.'.png' ;			
		}
		else
		{
			$profile_imgUrl = base_url().'uploads/no-user.png' ;
		}

		if( count($getUserDetails) > 0 )
		{
			header("Content-Type: application/json");
			$response = 
				array(
					"httpCode"       => 200, 
					"userId"      	 => (int)$user_id, 
					"firstName"      => $getUserDetails[0]['first_name'], 
					"email"          => $getUserDetails[0]['email'], 
					"mobileNumber"   => $getUserDetails[0]['mobile_number'], 
					"profileImage"	 => $profile_imgUrl,				
					"registerType"   => 'Exist', 
				);
				echo json_encode($response);
				exit;
		}
		$response = array("httpCode"       => 401 );
		echo json_encode($response);
		exit;
		
	}

	function updateMobileNumber($user_id="", $mobile_number= "",$country_id ="")
	{
		// $json = @file_get_contents('php://input');
		// $data = @json_decode($json);

		// $mobile_number 	= $data->mobileNumber;
		// $country_id	= $data->countryId;

		$this->db->where('user_id',$user_id);
		$this->db->update('users',array('country_id'=>$country_id));

		$chkAlreayExist = $this->db->query("select first_name,user_id,country_code,users.country_id,email from users 
											left join country on country.country_id = users.country_id
											where  mobile_number= '".$mobile_number."'")->result_array();

		if (count($chkAlreayExist) == 0) 
		{
			#Login OTP Start
			$otpNumber = otpNumber(6);
			$message = '<#> Dear Customer, ';
			$message .= ' Your Verification OTP for' . SITE_NAME .' is : '.$otpNumber;
			
			$query = "select country_code from country where country_id = $country_id";
			$country_code = $this->db->query($query)->result_array();

			$otpMobileNumber = $country_code[0]['country_code'].$mobile_number;
			$sendSMS = globalSMS($otpMobileNumber,$message);

			$this->db->where('user_id',$user_id);
			$this->db->update('users',array('otp_number'=>$otpNumber));

			$response = array(	"httpCode" 		=> 200 ,
								"otp_number"	=> $otpNumber,
								"message" 		=> "otp sent Successfully");

			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
		}
		elseif (count($chkAlreayExist) > 0 && $chkAlreayExist[0]['user_id'] == $user_id)
		{
			$response = array(	"httpCode" 		=> 200 ,
								"userId"		=> $chkAlreayExist[0]['user_id'],
								"mobileNumber"	=> $mobile_number,
								"countryId"		=> $chkAlreayExist[0]['country_id'],
								"email"			=> isset($chkAlreayExist[0]['email'])	? $chkAlreayExist[0]['email'] :"",						
								"message" 		=> "Already Verified sucessfully"
							);
			header("Content-Type: application/json");
			echo json_encode($response);
			exit;			
		}
		elseif( count($chkAlreayExist) > 0 && $chkAlreayExist[0]['user_id'] != $user_id )
		{
			$response = array(	"httpCode" 		=> 409 ,
								"userId"		=> $chkAlreayExist[0]['user_id'],					
								"message" 		=> "Mobile Number does not belong to you"
							);
							
			header("Content-Type: application/json");
			echo json_encode($response);
			exit;		
		}

	}

	function updateverifiy($user_id="")
	{
		$json = @file_get_contents('php://input');
		$data = @json_decode($json);

		$mobile_number 	= $data->mobileNumber;
		$otp_number 	= $data->otpNumber;
		
		if( !empty( $otp_number ) )
		{			
			$user = $this->db->query("select first_name,user_id,mobile_number,country_id,email from users where  user_id='".$user_id."' and otp_number = '".$otp_number."'")->result_array();

			if( count($user) > 0 )
			{
				if (file_exists('uploads/profile_image/'.$user[0]['user_id'].'.png'))
				{
					$profile_imgUrl = base_url()."uploads/profile_image/".$user_id.'.png' ;			
				}
				else
				{
					$profile_imgUrl = base_url().'uploads/no-user.png' ;
				}

				$this->db->where('user_id', $user[0]['user_id']);
				$result = $this->db->update('users',array('otp_status' => 1 ,'otp_number'=>rand(1,1000),'mobile_number'=>$mobile_number));

                $response = array(	
					"httpCode" 		=> 200 ,
					"userId"		=> $user[0]['user_id'],
					"mobileNumber"	=> $mobile_number,
					"firstName"		=> isset($user[0]['first_name'])?$user[0]['first_name']:null,
					"countryId"		=> $user[0]['country_id'],
					"email"			=> isset($user[0]['email'])	? $user[0]['email'] :null,						
					"profileImage"	=> $profile_imgUrl,						
					"message" 		=> "Mobile Number verified successfully!"
				);
				
				header("Content-Type: application/json");
				echo json_encode($response);
				exit;
            }
			else
			{
				$response = array("httpCode" => 409 , "message" => "OTP number does not match!" );
				header('HTTP/1.1 409', TRUE, 409);
				echo json_encode($response);
				exit;
			}
		}
	}

    function editprofile($user_id="")
	{
		if (empty($user_id))
        {
			header('HTTP/1.1 400', TRUE, 400);
			$response = array("httpCode" => 400 , "message" => "Bad Request!" );
			echo json_encode($response);
			exit;
		}

		$json = @file_get_contents('php://input');
		$data = @json_decode($json);

		if (isset($data->profileImage)) 
		{
			$image = base64_decode($data->profileImage);
			$filename = $user_id.'.png';
			$path = "uploads/profile_image/";
			file_put_contents($path . $filename, $image);
		};
		
		if($data)
		{
			$CommonData['email'] = $data->email;
			$CommonData['mobile_number'] = $data->mobileNumber;
			
			$this->db->where('user_id', $user_id);
			$result = $this->db->update('users', $CommonData);
				
			if($result > 0)
			{
				#General fields
				$updateData['first_name'] 		= $data->firstName;
				$updateData['address1'] 		= isset($data->address1) ? $data->address1 :"";
				$updateData['country_id'] 		= isset($data->countryId) ? $data->countryId :"";
				$updateData['state_id'] 		= isset($data->stateId) ? $data->stateId :"";
				$updateData['city_id'] 			= isset($data->cityId) ? $data->cityId :"";
				
				$this->db->where('user_id', $user_id);
				
				$result_1 = $this->db->update('users', $updateData); 
				
				$query = 'select first_name,email,address1,address2,country_id,state_id,city_id,mobile_number 
								from users where user_id = '.$user_id;

				$getUserDetails = $this->db->query($query)->result_array();

				if (file_exists('uploads/profile_image/'.$user_id.'.png'))
				{
					$profile_imgUrl = base_url()."uploads/profile_image/".$user_id.'.png' ;			
				}
				else
				{
					$profile_imgUrl = base_url().'uploads/no-user.png' ;
				}

				header("Content-Type: application/json");
				
				$response = array(	
					"httpCode" 		=> 200 ,
					"userId"		=> $user_id,
					"mobileNumber"	=> $getUserDetails[0]['mobile_number'],
					"countryId"		=> $getUserDetails[0]['country_id'],
					"email"			=> isset($getUserDetails[0]['email'])	? $getUserDetails[0]['email'] :null,						
					"firstName"		=> isset($getUserDetails[0]['first_name']) ? $getUserDetails[0]['first_name'] :null,						
					"profileImage"	=> $profile_imgUrl,						
					"message" 		=> "Updated successfully!"
				);
				echo json_encode($response);
				exit;
			}
		}
		else
		{
			$getUserDetails = $this->db->query("
				select 
				users.first_name,
				users.email,
				users.address1,
				users.address2,
				users.country_id,
				users.state_id,
				users.city_id,
				users.mobile_number,
				users.login_type

				from users
				
				left join country on country.country_id = users.country_id
				left join state on state.state_id = users.state_id
				left join city on city.city_id = users.city_id
				
				where users.user_id ='".$user_id."'
				")->result_array();

				if (file_exists('uploads/profile_image/'.$user_id.'.png'))
				{
					$profile_imgUrl = base_url()."uploads/profile_image/".$user_id.'.png' ;			
				}
				else
				{
					$profile_imgUrl = base_url().'uploads/no-user.png' ;
				}

				$response = array(	
					"httpCode" 		=> 200 ,
					"userId"		=> $getUserDetails[0]['user_id'],
					"mobileNumber"	=> $getUserDetails[0]['mobile_number'],
					"countryId"		=> $getUserDetails[0]['country_id'],
					"email"			=> isset($getUserDetails[0]['email'])	? $getUserDetails[0]['email'] :null,						
					"firstName"		=> isset($getUserDetails[0]['first_name']) ? $getUserDetails[0]['first_name'] :null,						
					"profileImage"	=> $profile_imgUrl,						
					"message" 		=> "Updated successfully!"
				);

			echo json_encode($response);
			exit;
		}
	}

	function updateProfileImg($user_id="")
	{
		$json = @file_get_contents('php://input');
		$data = @json_decode($json);

		if (isset($data->profileImage)) 
		{
			$image = base64_decode($data->profileImage);
			$filename = $user_id.'.png';
			$path = "uploads/profile_image/";
			file_put_contents($path . $filename, $image);

			if (file_exists('uploads/profile_image/'.$user_id.'.png'))
			{
				$profile_imgUrl = base_url()."uploads/profile_image/".$user_id.'.png' ;			
			}
			else
			{
				$profile_imgUrl = base_url().'uploads/no-user.png' ;
			}

			header("Content-Type: application/json");
				$response = array(
					"httpCode"       	=> 200, 
					"profileImage"  	=> $profile_imgUrl,												
					"message" => "Profile updated Successfully!" 
				);
				echo json_encode($response);
				exit;
		};
	}

	function orderHistory($user_id = '')
	{
		if (empty($user_id))
        {
			header('HTTP/1.1 400', TRUE, 400);
			$response = array("httpCode" => 400 , "message" => "Bad Request!" );
			echo json_encode($response);
			exit;
		}

		$condition = ' vb_order_header.user_id="'.$user_id.'" ';
		
		$query = "select 
				vb_order_header.*,
				branch.branch_name,
				branch.branch_id,
				branch.location,
				branch.address
				from vb_order_header
				
			left join branch on 
				branch.branch_id = vb_order_header.branch_id
			
		where $condition order by vb_order_header.order_id DESC";
		
		$result = $this->db->query($query)->result_array();
		
		if( count($result) > 0 )
		{
			foreach($result as $row)
			{
				$LineDataQuery = "select 
				products.product_name,
				vb_order_line.*
				from vb_order_line
				
				left join products on 
					products.product_id = vb_order_line.product_id
				
				where vb_order_line.order_id='".$row['order_id']."'";
			
				$LineResult = $this->db->query($LineDataQuery)->result_array();

				$LineData = [];
				foreach ($LineResult as  $lineValue) 
				{
					$ingredients_name = [];
					$serialized_data = unserialize($lineValue['ingredients']);
					 
					if ($serialized_data) 
					{ 
						foreach ($serialized_data as $key => $value) 
						{
							$ingredientsquery = "select ingredient_name as ingredientName  from vb_product_ingredients where ingredient_id = $key ";
							$ingredients = $this->db->query($ingredientsquery)->result_array();

							foreach ($ingredients as $name) {
								if ($value == 0 || $value == "0"  ) 
								{
									$ingredients_name[] =  $name['ingredientName'];
								}
								else {
									$ingredients_name[] =  $name['ingredientName'].' ( ' .CURRENCY_CODE." ".number_format($value,DECIMAL_VALUE,'.','').' ) ';
								}
							}
							
						}
					}
					
					$LineData[] = array(
						"productName"			=> $lineValue['product_name'],
						#"orderId"			    => (int)$lineValue['order_id'],
						"categoryId"			=> (int)$lineValue['category_id'],
						"productId"				=> (int)$lineValue['product_id'],
						"price"					=> (double)$lineValue['price'],
						"ingredientAmount"		=> (double)$lineValue['ingredient_amount'],
						"ingredients"			=> $ingredients_name,
						"quantity"				=> (int)$lineValue['quantity'],
						"linetotal"				=> (double)$lineValue['linetotal'],
						"orderDate"				=> $lineValue['order_date'],
						"cookingInstruction"	=> $lineValue['cooking_instruction'],
						"cancelStatus"	        => (double)$lineValue['cancel_status'], #0-Item Not Cancel, 1=> Item Cancelled
					);
				}
			
				if(file_exists("uploads/branches/".$row['branch_id'].'.png') )
				{
					$photo_url = base_url().'uploads/branches/'.$row['branch_id'].'.png';
				}
				else
				{
					$photo_url = base_url().'uploads/no-food-image.png';
				} 

				$response[] = array(
					"branchName"			=> $row['branch_name'],
					"branchId"				=> (int)$row['branch_id'],
					"branchImage"			=> $photo_url,
					"branchLocation"		=> $row['location'],
					"branchAddress"			=> $row['address'],
					"orderId"	 			=> (int)$row['order_id'],
					"orderNumber"	 		=> $row['order_number'],
					"deliverdDate"			=> $row['delivered_date'],
					"orderStatus"			=> (int)$row['order_status'],
					// "orderDate"				=> $row['created_date'],
					"taxValue"				=> (double)$row['tax_value'],
					"grandTotal"			=> (double)$row['grand_total'],
					"orderDate"				=> $row['order_date'],
					"paymentMethod"			=> $row['payment_method'],
					"paymentStatus"			=> $row['payment_status'], #Payment => PENDING, SUCCESS
					"paidStatus"			=> $row['paid_status'],#COD => 0-Unpaid, 1=>Paid
					"orderItems"			=> $LineData,
				);
			}
			
			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
		}
		else
		{
			header("Content-Type: application/json");
			$response = array("httpCode" => 200 , "message" => "No data found." );
			echo json_encode($response);
			exit;
		}
	}

	#Google Login
	function register_google_user()
	{
		$json = @file_get_contents('php://input');
		$data = @json_decode($json);

		$id 		= isset($data->id) ? $data->id : 0;
		$first_name = isset($data->name) ? $data->name : 0;
		$email		= isset($data->email) ? $data->email : "";
		 
		$Query = "select user_id,register_type from users where email='".$email."'"; 
	    
		$result = $this->db->query($Query)->result_array();
		
		if(count($result) == 0) #insert
		{
			$password = rand();
			
			$userData= array(
				"first_name"        => $first_name,
				"email"             => $email,
				"password"          => md5($password),
				"original_password" => $password,
				"joined_date"       => strtotime(date('d-m-Y h:i:s a',time())),
				"fb_user_id"        => $id,
				"user_status"       => 1,
				"register_type"     => 2,
				"login_type"        => 2, #GOOGLE
			);
			
			$this->db->insert('users', $userData);
			$insertID = $this->db->insert_id();
			
			$google_image_url = $data->picture;
			
			if($google_image_url)
			{
				$image = @file_get_contents($google_image_url);
				$file = 'uploads/profile_image/'.$insertID.".png";
				@file_put_contents($file, $image);
			}
			
			$user = $this->db->query("select user_id,mobile_number,country_id,email from users where  user_id = $insertID")->result_array();

			if( count($user) > 0 )
			{
				$user_id = $user[0]['user_id'];

				if (file_exists('uploads/profile_image/'.$user[0]['user_id'].'.png'))
				{
					$profile_imgUrl = base_url()."uploads/profile_image/".$user_id.'.png' ;			
				}
				else
				{
					$profile_imgUrl = base_url().'uploads/no-user.png' ;
					
				}

				$this->db->where('user_id', $user[0]['user_id']);
				$result = $this->db->update('users',array('otp_status' => 1 ,'otp_number'=>rand(1,1000)));

                $response = array(	
					"httpCode" 		=> 200 ,
					"userId"		=> $user[0]['user_id'],
					"mobileNumber"	=> !empty($user[0]['mobile_number']) ? $user[0]['mobile_number'] : null,
					"countryId"		=> !empty($user[0]['country_id']) ? $user[0]['country_id'] :null,
					"email"			=> !empty($user[0]['email'])	? $user[0]['email'] :null,						
					"firstName"		=> !empty($user[0]['first_name']) ? $user[0]['first_name'] :null,						
					"profileImage"	=> $profile_imgUrl,						
					"message" 		=> "Mobile Number verified successfully!"
				);
				header("Content-Type: application/json");
				echo json_encode($response);
				exit;
            }
		}
		else #update
		{
			$user_id = $result[0]["user_id"];
			$register_type = $result[0]["register_type"];
			
			$userData= array(
				"first_name"     => $first_name,
				"email"          => $email
			);
			
			$this->db->where('user_id', $user_id);
            $this->db->update('users', $userData);
            
            $google_image_url = $data->picture;
			
			if($google_image_url)
			{
				$image = @file_get_contents($google_image_url);
				$file = 'uploads/profile_image/'.$user_id.".png";
				@file_put_contents($file, $image);
			}
           
			$user = $this->db->query("select user_id,mobile_number,country_id,email from users where  user_id = $user_id")->result_array();

			if( count($user) > 0 )
			{
				$user_id = $user[0]['user_id'];

				if (file_exists('uploads/profile_image/'.$user[0]['user_id'].'.png'))
				{
					$profile_imgUrl = base_url()."uploads/profile_image/".$user_id.'.png' ;			
				}
				else
				{
					$profile_imgUrl = base_url().'uploads/no-user.png' ;
				}

				$this->db->where('user_id', $user[0]['user_id']);
				$result = $this->db->update('users',array('otp_status' => 1 ,'otp_number'=>rand(1,1000)));

                $response = array(	
					"httpCode" 		=> 200 ,
					"userId"		=> $user[0]['user_id'],
					"mobileNumber"	=> !empty($user[0]['mobile_number']) ? $user[0]['mobile_number'] : null,
					"countryId"		=> !empty($user[0]['country_id']) ? $user[0]['country_id'] : null,
					"email"			=> !empty($user[0]['email'])	? $user[0]['email'] : null,						
					"firstName"		=> !empty($user[0]['first_name']) ? $user[0]['first_name'] : null,						
					"profileImage"	=> $profile_imgUrl,						
					"message" 		=> "Mobile Number verified successfully!"
				);
				
				header("Content-Type: application/json");
				echo json_encode($response);
				exit;
            }
		}
	}

	function favouriteOrders($user_id = '')
	{
		if (empty($user_id))
        {
			header('HTTP/1.1 400', TRUE, 400);
			$response = array("httpCode" => 400 , "message" => "Bad Request!" );
			echo json_encode($response);
			exit;
		}

		$condition = ' vb_favourite_orders.user_id="'.$user_id.'" ';
		
		$query = "select 
					vb_order_header.*,
					branch.branch_name,
					branch.location,
					branch.address,
					expense_payment_type.payment_type

				from vb_favourite_orders
			
			left join vb_order_header on 
				vb_order_header.order_id = vb_favourite_orders.order_id
			left join branch on 
				branch.branch_id = vb_order_header.branch_id
			left join expense_payment_type on 
				expense_payment_type.payment_type_id = vb_order_header.payment_method
			
		where $condition order by vb_favourite_orders.order_id DESC 
			";
		
		$result = $this->db->query($query)->result_array();

		if( count($result) > 0 )
		{
			foreach($result as $row)
			{
				$LineDataQuery = "select 
				products.product_name,
				vb_order_line.*
				from vb_order_line
				
				left join products on 
					products.product_id = vb_order_line.product_id
				
				where vb_order_line.order_id='".$row['order_id']."'";
			
				$LineData = $this->db->query($LineDataQuery)->result_array();

				$ordersList = [];
				foreach ($LineData as $orders) 
				{
					$ordersList[] = array(
						"productName"			=>	$orders['product_name'],
						"orderLineId"			=>	$orders['order_line_id'],
						"orderId"				=>	$orders['order_id'],
						"categoryId"			=>	$orders['category_id'],
						"productId"				=>	$orders['product_id'],
						"price"					=>	$orders['price'],
						"ingredientAmount"		=>	$orders['ingredient_amount'],
						"ingredients"			=>	$orders['ingredients'],
						"quantity"				=>	$orders['quantity'],
						"linetotal"				=>	$orders['linetotal'],
						"orderDate"				=>	$orders['order_date'],
						"cookingInstruction"	=>	$orders['cooking_instruction'],
					);
				}
			
				$response[] = array(
									"branchName"			=> $row['branch_name'],
									"brachLocation"			=> $row['location'],
									"branchSddress"			=> $row['address'],
									"branchName"	 		=> $row['branch_name'],
									"orderId"	 			=> $row['order_id'],
									"orderNumber"	 		=> $row['order_number'],
									"deliverdDate"			=> $row['delivered_date'],
									"orderStatus"			=> $row['order_status'],
									"orderDate"				=> $row['created_date'],
									"orderItems"			=> $ordersList,
								);
			}
			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
		}
		else
		{
			header("Content-Type: application/json");
			$response = array("httpCode" => 200 , "message" => "No data found." );
			echo json_encode($response);
			exit;
		}
	}

	function putfavouriteOrder($order_id,$user_id)
	{
		$data['order_id'] = $order_id ;
		$data['user_id']  = $user_id;
		
		if($order_id)
		{			
			$chkFav = 'select order_id from vb_favourite_orders where order_id = '.$order_id;
			$result = $this->db->query($chkFav)->result_array();

			if( count($result) != 1 ) 
			{
				$this->db->insert('vb_favourite_orders', $data);
				header("Content-Type: application/json");
				$response = array("httpCode" => 200 , "message" => "Added to Favourite" );
				echo json_encode($response);
				exit;
			}
		}	
	}

	function deletefavouriteOrder($order_id,$user_id)
	{
		$data['order_id'] = $order_id ;
		$data['user_id']  = $user_id;
		
		if($order_id)
		{			
			$chkFav = 'select order_id from vb_favourite_orders where order_id = '.$order_id;
			$result = $this->db->query($chkFav)->result_array();

			if (count($result) == 1 ) 
			{
				$this->db->where('user_id',$user_id);
				$this->db->where('order_id', $order_id);
				$this->db->delete('vb_favourite_orders');

				header("Content-Type: application/json");
				$response = array("httpCode" => 200 , "message" => "Removed from Favourites" );
				echo json_encode($response);
				exit;
			}
		}	
	}

	function getBookmark($user_id="")
	{
		$time = date('h:i');
		$ItemQuery = "select
							vb_branch_items_line.*,
							vb_branch_items_line.price as p_price,
							products.product_code,
							products.product_id,
							products.product_name,
							products.product_image,
							products.description,
							branch.opening_time,
							branch.closing_time,
							branch.branch_id,
							bookmark_id,
							products.description as prodesc,
							category.category_id 

							from vb_bookmark_items 
							
							left join vb_branch_items_line on 
								vb_branch_items_line.product_id = vb_bookmark_items.product_id

							left join vb_branch_items_header on 
								vb_branch_items_header.branch_item_header_id = vb_branch_items_line.branch_item_header_id
							
							left join products on 
								products.product_id = vb_branch_items_line.product_id
							
							left join category on 
								category.category_id = products.category_id
							
							left join branch on 
								branch.branch_id = vb_branch_items_header.branch_id
													
							
							where (
									vb_bookmark_items.user_id = ".$user_id."
									and vb_branch_items_header.branch_id = vb_bookmark_items.branch_id and item_status = 1
								)
								order by vb_bookmark_items.bookmark_id desc ";
								// and branch.opening_time > '".$time."' and branch.closing_time < '".$time."'
		$result = $this->db->query($ItemQuery)->result_array();
		
		if( count($result) > 0 )
		{
			foreach($result as $row)
			{			
				$response[] = array(
					'productId'				=> (int)$row['product_id'],
					'branchId'				=> (int)$row['branch_id'],
					'availableQuantity'		=> (int)$row['available_quantity'],
					'productPrice'			=> (double)$row['p_price'],
					'productCode'			=> $row['product_code'],
					'productName'			=> $row['product_name'],
					'openingTime'			=> $row['opening_time'],
					'closingTime'			=> $row['closing_time'],
					'description'			=> $row['description'],
					'categoryId'			=> (int)$row['category_id']
				);
			}
			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
		}
		else
		{
			header("Content-Type: application/json");
			$response = array("httpCode" => 200 , "message" => "No data found." );
			echo json_encode($response);
			exit;
		}
	}
	
	function putbookMark($branch_id,$product_id,$user_id)
	{
		$data['branch_id'] 	= $branch_id ;
		$data['product_id'] = $product_id ;
		$data['user_id']  	= $user_id;
		
		if($product_id)
		{			
			$chkFav = 'select product_id from vb_bookmark_items where (branch_id = '.$branch_id.' and product_id = '.$product_id.' and user_id = '.$user_id.')';

			$result = $this->db->query($chkFav)->result_array();

			if (count($result) != 1 ) 
			{
				$this->db->insert('vb_bookmark_items', $data);
				$response = array("httpCode" => 200 , "message" => "Added to Bookmarks" );
				echo json_encode($response);
				exit;
			}
			else 
			{
				$response = array("httpCode" => 200 , "message" => "Added to Bookmarks" );
				echo json_encode($response);
				exit;
			}
		}	
	}

	function deletebookMark($branch_id="",$product_id="",$user_id="")
	{
		$data['branch_id'] 		= $branch_id ;
		$data['product_id'] 	= $product_id ;
		$data['user_id'] 		= $user_id ;
		
		$this->db->where('branch_id', $branch_id);
		$this->db->where('product_id', $product_id);
		$this->db->where('user_id', $user_id);
		$this->db->delete('vb_bookmark_items');

		$response = array("httpCode" => 200 , "message" => "Removed from Bookmarks" );
		echo json_encode($response);
		exit;
	}

    #Country List 
	function country_list()
	{
		$condition = " country.country_status = 1 ";
		$query = "select *
			from country
		
		where $condition
			order by country.country_name asc
		";
		$result = $this->db->query($query)->result_array();
		
		if( count($result) > 0 )
		{
			foreach($result as $row)
			{
				if(file_exists("uploads/country_icons/".$row['country_id'].'.png') )
				{
					$photo_url = base_url().'uploads/country_icons/'.$row['country_id'].'.png';
				}
				else
				{
					
					$photo_url = base_url().'uploads/no-food-image.png';
				}
				$response[] = #array(
									#"country_list" => 
									array(
										"country_id"      => $row['country_id'],
										"country_name"    => $row['country_name'],
										"country_code"    => $row['country_code'],
										"currency_symbol" => $row['currency_symbol'],
										"currency_code"   => $row['currency_code'],
										"country_flag"    => $photo_url ,
									);
								#);
			}
			#$device_response["devicelist"] = array_values($response);
			header("Content-Type: application/json");
				
			echo json_encode($response);
			exit;
		}
		else
		{
			header("Content-Type: application/json");
			$response = array("httpCode" => 200 , "message" => "No data found.");
			echo json_encode($response);
			exit;
		}
	}
	
	#State List 
	function state_list()
	{
		$condition = " state.state_status = 1 ";
		$query = "select 
			state.state_id,
			state.state_name,
			state.country_id
			
			from state
		
			left join country on country.country_id = state.country_id
		where $condition
			order by state.state_name asc
		";
		$result = $this->db->query($query)->result_array();
		
		if( count($result) > 0 )
		{
			foreach($result as $row)
			{
				$response[] = #array(
									#"state_list" => 
									array(
											"state_id"   => $row['state_id'],
											"state_name" => $row['state_name']
									);
								#);
			}
			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
		}
		else
		{
			header("Content-Type: application/json");
			$response = array("httpCode" => 200 , "message" => "No data found.");
			echo json_encode($response);
			exit;
		}
	}
	
	# City List
	function city_list()
	{
		$condition = " city.city_status = 1 ";
		$query = "select 
			city.city_id,
			city.city_name,
			city.country_id,
			city.state_id
			
			from city
		
			left join country on country.country_id = city.country_id
			left join state on state.state_id = city.state_id
			
		where $condition
			order by city.city_name asc
		";
		$result = $this->db->query($query)->result_array();
		
		if( count($result) > 0 )
		{
			foreach($result as $row)
			{
				$response[] = array(
								"city_id" => $row['city_id'],
								"city_name" => $row['city_name']
							);
									
			}
			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
		}
		else
		{
			header("Content-Type: application/json");
			$response = array("httpCode" => 200 , "message" => "No data found.");
			echo json_encode($response);
			exit;
		}
	}

	function getBranches()
	{
		$condition = " 1=1 ";

		$query = "select branch.*,
			country.country_name,
			country.country_code,
			state.state_name,
			users.first_name from branch
			left join country ON country.country_id = branch.country_id
			left join state ON state.state_id = branch.state_id
			
			left join users ON users.user_id = branch.user_id
		where $condition
				order by branch.branch_id desc
		";
		
		$result = $this->db->query($query)->result_array();

		foreach($result as $row)
		{
			if (file_exists('uploads/branches/'.$row['branch_id'].'.png'))
			{
				$branch_imgUrl = base_url()."uploads/branches/".$row['branch_id'].'.png' ;			
			}
			else
			{
				$branch_imgUrl = base_url().'uploads/no-food-image.png' ;
			}

			$row['branch_image'] = $branch_imgUrl;

			$response[] = array( 
							"branchId" 				=> (int)$row['branch_id'],
							"minimumOrderValue" 	=> (double)$row['minimum_order_value'],
							"deliveryDistance" 		=> $row['delivery_distance']*1000,
							"userId" 				=> (int)$row['user_id'],
							"branchCode" 			=> $row['branch_code'],
							"branchName" 			=> $row['branch_name'],
							"description" 			=> $row['description'],
							"branchStatus" 			=> (int)$row['branch_status'],
							"phoneNumber" 			=> $row['phone_number'],
							"address" 				=> $row['address'],
							"alternativeNumber" 	=> $row['phone_number_2'],
							"countryId" 			=> (int)$row['country_id'],
							"stateId" 				=> (int)$row['state_id'],
							"location" 				=> doubleval($row['location']),
							"latitude" 				=> doubleval($row['latitude']),
							"longitude" 			=> doubleval($row['longitude']),
							"email" 				=> $row['email'],
							"countryName" 			=> $row['country_name'],
							"countryCode" 			=> $row['country_code'],
							"stateName" 			=> $row['state_name'],
							"firstName" 			=> $row['first_name'],
							"branchImage" 			=> $row['branch_image'],
						);
								
		}
		header("Content-Type: application/json");
		echo json_encode($response);
		exit;
	}#completed

	function branchImage($branch_id="")
	{
		$query = "select branch.branch_id
			from branch 
				where branch.branch_status = 1 and
				branch_id = '".$branch_id."'
				";
		$result = $this->db->query($query)->result_array();

		$response = array("httpCode" => 400 , "message" => "Bad Request!" );
		foreach ($result as $branch)
		{
			$branche_id = isset($branch['branch_id']) ? $branch['branch_id']:0; 
			$url = "uploads/branches/".$branche_id.".png";
			
			if(file_exists($url))
			{
				$branchImage = base_url().$url;
			}
			else
			{ 
				$branchImage = base_url()."assets/frontend/img/hero_general.jpg";  
			}
			
			$response[] = array( 
							"branchImage" => $branchImage
						);
		}
		
		header("Content-Type: application/json");
		echo json_encode($response);
		exit;
	}#completed
	
	function Branchitems($branch_id)
	{
		$todayInTime = date("H:i");
		$todayOutTime = date("H:i");

		$query = "select category.*,
				branch.*,
				vb_branch_items_header.branch_item_header_id,
				minimum_order_quantity
				
				from vb_branch_items_header
				
				left join vb_branch_items_line on vb_branch_items_line.branch_item_header_id = vb_branch_items_header.branch_item_header_id

				left join products on products.product_id = vb_branch_items_line.product_id

				left join category on category.category_id = products.category_id

				left join branch on branch.branch_id = vb_branch_items_header.branch_id

				where vb_branch_items_header.branch_id = $branch_id  and category_status = 1

				group by category.category_id order by category.category_id
				" ;
		$result = $this->db->query($query)->result_array();
		
		foreach ($result as $category) 
		{
			$category_id = $category['category_id'] ;

			$ItemQuery ="select products.product_id,
					products.product_name,
					products.product_image,
					products.description,
					products.category_id,
					products.from_time_1,
					products.to_time_1,
					products.from_time_2,
					products.to_time_2

					from products

					where products.category_id = $category_id and product_status = 1";

			$resultData = $this->db->query($ItemQuery)->result_array();
			
			$products = [];
			foreach ($resultData as $product) 
			{
				if (!empty($product['product_image']))
				{
					$product_image = base_url().'uploads/products/'.$product['product_image'] ;			
				}
				else
				{
					$product_image = base_url().'uploads/no-user.png' ;
					
				}

				$priceQuery = "select available_quantity,price,branch_item_line_id from vb_branch_items_line where vb_branch_items_line.product_id = ".$product['product_id']." and vb_branch_items_line.branch_item_header_id = ".$category['branch_item_header_id']."";
				$price = $this->db->query($priceQuery)->result_array();

				$fromTime_1 = $product['from_time_1'];
				$toTime_1 = $product['to_time_1'];
				
				$fromTime_2 = $product['from_time_2'];
				$toTime_2 = $product['to_time_2'];
				
				if( (!empty($fromTime_1) && !empty($toTime_1) ) && ($fromTime_1 <= $todayInTime && $toTime_1 >= $todayOutTime) )
				{
					$productAvailabitiy = true;
				}
				else if( (!empty($fromTime_2) && !empty($toTime_2) ) && ($fromTime_2 <= $todayInTime && $toTime_2 >= $todayOutTime) )
				{
					$productAvailabitiy = true;
				}
				else
				{
					$productAvailabitiy = false;
				}

				$available_quantity = isset($price[0]['available_quantity']) ? $price[0]['available_quantity'] : 0;
				
				if($available_quantity == 0)
				{
					$productAvailabitiy = false;
				}

				$addons = count($this->itemAddonscount($branch_id,$product['product_id'])) ? true : false;

				if ($productAvailabitiy) 
				{
					$products[] = array(
						"productId"					=>	(int)$product['product_id'],
						"productName"				=>	$product['product_name'],
						"productImage"				=>	$product_image,
						"productdDescription"		=>	$product['description'],
						"productCategoryId"			=>	(int)$product['category_id'],
						"productBranchId"			=>	(int)$branch_id, 
						"productPrice"				=>	isset($price[0]['price']) ? (double)$price[0]['price'] : 0,
						"branch_item_line_id"		=>	isset($price[0]['branch_item_line_id']) ? $price[0]['branch_item_line_id'] : 0,
						"availableQuantity"			=>	isset($price[0]['available_quantity']) ? (int)$price[0]['available_quantity'] : 0,
						"productAvailabitiy"		=>	$productAvailabitiy,
						"addOns"					=>	$addons,
						"fromTime1"					=>  $product['from_time_1'],
						"toTime1"					=>  $product['to_time_1'],
						"fromTime2"					=>  $product['from_time_1'],
						"toTime2"					=>  $product['to_time_2'],
						"maximumOrderQuantity"		=>  (double)$category['minimum_order_quantity'],
						"currenyCode"				=>  CURRENCY_CODE
					);
				}
			}

			$response[] = array( 
				"categoryId"			=>	(int)$category['category_id'],
				"mainCategoryId"		=>	(int)$category['main_category_id'],
				"categoryName"			=>	$category['category_name'],
				"caytegoryLayer"		=>	(int)$category['caytegory_layer'],
				"description"			=>	$category['description'],
				"branchId"				=>	(int)$category['branch_id'],
				"branchName"			=>	$category['branch_name'],
				"openingTime"			=>	$category['opening_time'],
				"closingTime"			=>	$category['closing_time'],
				"minimumOrderValue"	    =>	$category['minimum_order_value'],
				"category_id"			=>	$category_id,
				"categoryProducts"		=>	$products,
			);
		}

		header("Content-Type: application/json");
		echo json_encode($response);
		exit;

	}#completed

	function BranchCategorys($branch_id)
	{
		$condition = 'vb_branch_items_header.branch_id ="'.$branch_id.'" and
			vb_branch_items_line.item_status=1';
			
			$query = "select 
					category.*,
					branch.branch_id,
					branch.branch_name
					
					from vb_branch_items_line
					
					join vb_branch_items_header on 
						vb_branch_items_header.branch_item_header_id = vb_branch_items_line.branch_item_header_id
					
					join products on 
						products.product_id = vb_branch_items_line.product_id
					
					join category on 
						category.category_id = products.category_id
					
					join branch on 
						branch.branch_id = vb_branch_items_header.branch_id
					
			where $condition group by products.category_id order by category.category_id asc";

		$result = $this->db->query($query)->result_array();

		if ($result) 
		{
			foreach($result as $row)
			{
				$ItemQuery ="select products.product_id
								from products
						where  products.category_id = ".$row['category_id']."
							order by products.sequence_number asc ";

				$resultData = $this->db->query($ItemQuery)->result_array(); 

				$response[] = array( 
								"categoryId"				=>	(int)$row['category_id'],
								"mainCategoryId"			=>	(int)$row['main_category_id'],
								"categoryName"				=>	$row['category_name'],
								"categoryUrl"				=>	$row['category_url'],
								"orderNumber"				=>	$row['order_number'],
								"caytegoryLayer"			=>	(int)$row['caytegory_layer'],
								"description"				=>	$row['description'],
								"branchId"					=>	(int)$row['branch_id'],
								"branchName"				=>	$row['branch_name'],
								"categoryImage"				=>  base_url().'uploads/category_image/'.$row['category_id'].'.png',
								"numberOfproducts"			=>  count($resultData)
							);						
			}

			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
		}
		else
		{
			header('HTTP/1.1 400', TRUE, 200);
			$response = array("httpCode" => 200 , "message" => "No data Found..!" );
			echo json_encode($response);
			exit;
		}

	}#completed

	function CategoryItems($category_id)
	{
		$condition = 'products.category_id ="'.$category_id.'" and
			products.product_status=1';
			
			$query = "select 
					category.*,products.*,vb_branch_items_line.price as p_price

					from vb_branch_items_line
					
					join vb_branch_items_header on 
						vb_branch_items_header.branch_item_header_id = vb_branch_items_line.branch_item_header_id
					
					join products on 
						products.product_id = vb_branch_items_line.product_id
					
					join category on 
						category.category_id = products.category_id
					
					
			where $condition  order by products.product_name asc";

		$result = $this->db->query($query)->result_array();

		if (count($result) > 0) 
		{
			foreach($result as $row)
			{
				$response[] = array( 
								"categoryId"				=>	(int)$row['category_id'],
								"mainCategoryId"			=>	(int)$row['main_category_id'],
								"productName"				=>	$row['product_name'],
								"productPrice"				=>	$row['p_price'],
								"orderNumber"				=>	$row['order_number'],
								"caytegoryLayer"			=>	$row['caytegory_layer'],
								"categoryStatus"			=>	$row['category_status'],
								"description"				=>	$row['description'],
								"branchImage"				=>  base_url().'uploads/category_image/'.$row['category_id'].'.png'
							);						
			}

			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
		}
		else
		{
			header('HTTP/1.1 400', TRUE, 400);
			$response = array("httpCode" => 400 , "message" => "Bad Request!" );
			echo json_encode($response);
			exit;
		}

	}#completed

	function itemAddons($branch_id,$product_id)
	{
		$query = "select 
				vb_branch_item_ingredients.*, 
				vb_product_ingredients.ingredient_id,
				vb_product_ingredients.ingredients_description,
				vb_product_ingredients.ingredient_name
			from
				vb_branch_item_ingredients 
			left join vb_product_ingredients on	
				vb_product_ingredients.ingredient_id = vb_branch_item_ingredients.ingredient_id
			where 
				vb_branch_item_ingredients.product_id = '".$product_id."' and
				vb_branch_item_ingredients.branch_id = '".$branch_id."' and 
				vb_branch_item_ingredients.ingredient_branch_status = 1 and 
				vb_product_ingredients.status = 1 
			";
	
		$resultData = $this->db->query($query)->result_array();

		if (count($resultData) > 0) 
		{	
			foreach ($resultData as $ingredients)
			{
				$response[] = array(
								"branchId"							=>	(int)$branch_id,
								"productId"							=>	(int)$ingredients['product_id'],
								"ingredientId"						=>	(int)$ingredients['ingredient_id'],
								"price"								=>	(double)$ingredients['price'],
								"ingredientName"					=>	$ingredients['ingredient_name'],
								"ingredientsDescription"			=>	$ingredients['ingredients_description']
							); 
			}
		}
		else
		{
			$response = array("httpCode" => 200 , "message" => "No Data Found" );
		}

		header("Content-Type: application/json");
		echo json_encode($response);
		exit;
	}#completed

	function getPosters($branch_id)
	{
		$query = 'select * from vb_posters where poster_status = 1 and branch_id = '.$branch_id;
		$resultData = $this->db->query($query)->result_array();

		if (count($resultData) > 0) 
		{			
			foreach ($resultData as $posters)
			{
				$query = 'select * from vb_posters_line where poster_header_id = '.$posters['poster_id'];
				$lineData = $this->db->query($query)->result_array();

				foreach ($lineData as  $images) 
				{
					$poster[] =  base_url().'uploads/posters/'.$images['poster_image'];
				}

				$response = $poster;
							 
			}
		}
		else
		{
			$response = array("httpCode" => 200 , "message" => "No Data Found" );
		}

		header("Content-Type: application/json");
		echo json_encode($response);
		exit;
		
	}#completed

	function popularFoods__($branch_id="")
	{
		$query = "select 
			count(vb_order_line.product_id),
			vb_order_line.product_id,
			product_image ,
			product_name 
			
			from vb_order_line 
			
			left join vb_order_header on vb_order_header.order_id = vb_order_line.order_id 

			join products on products.product_id = vb_order_line.product_id

			where  vb_order_header.branch_id = $branch_id 

			group by vb_order_line.product_id  
			
			order by count(vb_order_line.product_id) desc limit 4";

		$populardishesResult = $this->db->query($query)->result_array();

		if (count($populardishesResult) > 0)
		{
			foreach ($populardishesResult as  $foods) 
			{
				$priceQuery = "select 
									available_quantity,
									price,branch_item_line_id
									
									from vb_branch_items_header 
									
									left join vb_branch_items_line on 
										vb_branch_items_line.branch_item_header_id = vb_branch_items_header.branch_item_header_id

									where 
										vb_branch_items_line.product_id = ".$foods['product_id']." 
										and vb_branch_items_header.branch_id = ".$branch_id."
								";
				$price = $this->db->query($priceQuery)->result_array();

				if ($this->getMimeType('uploads/products/'.$foods['product_image']))
				{
					$url = base_url()."uploads/products/".$foods['product_image'];
				}
				else {
					$url = base_url()."uploads/no-food-image.png";
				}

				$response[] = array(
						"productId"							=>	(int)$foods['product_id'],
						"productPrice"						=>	(double)$price[0]['price'],
						"availableQuantity"					=>	(int)$price[0]['available_quantity'],
						"productImage"						=>	$url,
						"productName"						=>  $foods['product_name']
					); 	
			}
		}
		else 
		{
			$response = array("httpCode" => 200 , "message" => "No Data Found" );
		}

			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
	}#Completed

	function popularFoods($branch_id="")
	{
		$query = "select 

			vb_order_line.product_id
			
			from vb_order_line 
			
			left join vb_order_header on vb_order_header.order_id = vb_order_line.order_id 

			join products on products.product_id = vb_order_line.product_id

			where  vb_order_header.branch_id = $branch_id 

			group by vb_order_line.product_id  
			
			order by count(vb_order_line.product_id) desc limit 4";

		$populardishesResult = $this->db->query($query)->result_array();

		if (count($populardishesResult) > 0)
		{	

			foreach ($populardishesResult as $populardishes) 
			{
				
				$response[] = $this->popularBranchitems($branch_id,$populardishes['product_id']);
			}
		}
		else 
		{
			$response = array("httpCode" => 200 , "message" => "No Data Found" );
		}

			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
	}

	function popularBranchitems($branch_id,$product_id)
	{
		$todayInTime = date("H:i");
		$todayOutTime = date("H:i");

		$query = "select category.*,branch.*,vb_branch_items_header.branch_item_header_id
				
				from vb_branch_items_header
				
				left join vb_branch_items_line on vb_branch_items_line.branch_item_header_id = vb_branch_items_header.branch_item_header_id

				left join products on products.product_id = vb_branch_items_line.product_id

				left join category on category.category_id = products.category_id

				left join branch on branch.branch_id = vb_branch_items_header.branch_id

				where vb_branch_items_header.branch_id = $branch_id  and category_status = 1 and products.product_id = $product_id

				" ;
		
		$result = $this->db->query($query)->result_array();

		foreach ($result as $category) 
		{
			$category_id = $category['category_id'] ;

			$ItemQuery ="select products.product_id,
					products.product_name,
					products.product_image,
					products.description,
					products.category_id,
					products.from_time_1,
					products.to_time_1,
					products.from_time_2,
					products.to_time_2

					from products

					where products.category_id = $category_id and product_status = 1 and product_id = $product_id";

			$resultData = $this->db->query($ItemQuery)->result_array();
			
			$products = [];
			foreach ($resultData as $product) 
			{
				if (!empty($product['product_image']))
				{
					$product_image = base_url().'uploads/products/'.$product['product_image'] ;			
				}
				else
				{
					$product_image = base_url().'uploads/no-user.png' ;
					
				}

				$priceQuery = "select available_quantity,price,branch_item_line_id from vb_branch_items_line where vb_branch_items_line.product_id = ".$product['product_id']." and vb_branch_items_line.branch_item_header_id = ".$category['branch_item_header_id']."";
				$price = $this->db->query($priceQuery)->result_array();

				$fromTime_1 = $product['from_time_1'];
				$toTime_1 = $product['to_time_1'];
				
				$fromTime_2 = $product['from_time_2'];
				$toTime_2 = $product['to_time_2'];
				
				if( (!empty($fromTime_1) && !empty($toTime_1) ) && ($fromTime_1 <= $todayInTime && $toTime_1 >= $todayOutTime) )
				{
					$productAvailabitiy = true;
				}
				else if( (!empty($fromTime_2) && !empty($toTime_2) ) && ($fromTime_2 <= $todayInTime && $toTime_2 >= $todayOutTime) )
				{
					$productAvailabitiy = true;
				}
				else
				{
					$productAvailabitiy = false;
				}

				$available_quantity = $price[0]['available_quantity'];
				if($available_quantity == 0)
				{
					$productAvailabitiy = false;
				}

				$addons = count($this->itemAddonscount($branch_id,$product_id)) ? true : false;

				$products[] = array(
					"productId"				=>	(int)$product['product_id'],
					"productName"			=>	$product['product_name'],
					"productImage"			=>	$product_image,
					"productdDescription"	=>	$product['description'],
					"productCategoryId"		=>	(int)$product['category_id'],
					"productBranchId"		=>	(int)$branch_id, 
					"productPrice"			=>	(double)$price[0]['price'],
					"branch_item_line_id"	=>	$price[0]['branch_item_line_id'],
					"availableQuantity"		=>	(int)$price[0]['available_quantity'],
					"productAvailabitiy"	=>	$productAvailabitiy,
					"addOns"				=>	$addons,
					"fromTime1"			=>  $product['from_time_1'],
					"toTime1"				=>  $product['to_time_1'],
					"fromTime2"			=>  $product['from_time_1'],
					"toTime2"				=>  $product['to_time_2'],
					"currenyCode"			=>  CURRENCY_CODE
				);
			}

			$response = array( 
				"categoryId"			=>	(int)$category['category_id'],
				"mainCategoryId"		=>	(int)$category['main_category_id'],
				"categoryName"			=>	$category['category_name'],
				"caytegoryLayer"		=>	(int)$category['caytegory_layer'],
				"description"			=>	$category['description'],
				"branchId"				=>	(int)$category['branch_id'],
				"branchName"			=>	$category['branch_name'],
				"openingTime"			=>	$category['opening_time'],
				"closingTime"			=>	$category['closing_time'],
				"category_id"			=>	$category_id,
				"categoryProducts"		=>	$products,
	
			);

		}

		return $response;
	}

	function itemAddonscount($branch_id,$product_id)
	{
		$query = "select 
				vb_branch_item_ingredients.*, 
				vb_product_ingredients.ingredient_id,
				vb_product_ingredients.ingredients_description,
				vb_product_ingredients.ingredient_name
			from
				vb_branch_item_ingredients 
			left join vb_product_ingredients on	
				vb_product_ingredients.ingredient_id = vb_branch_item_ingredients.ingredient_id
			where 
				vb_branch_item_ingredients.product_id = '".$product_id."' and
				vb_branch_item_ingredients.branch_id = '".$branch_id."' and 
				vb_branch_item_ingredients.ingredient_branch_status = 1 and 
				vb_product_ingredients.status = 1 
			";
	
		$resultData = $this->db->query($query)->result_array();

		return $resultData;
	}

	function getMimeType($mediapath)
	{
		if(@is_array(getimagesize($mediapath)))
		{
			$image = true;
		} else {
			$image = false;
		}
		return $image;
	}
	
	function paymentMethods()
	{
		$PaymentModeQuery = "select * from expense_payment_type where payment_type_status = 1 order by sequence_number asc";
		$getPaymentMode = $this->db->query($PaymentModeQuery)->result_array();

		$taxQuery = "select tax_name,tax_value from tax where tax_status=1 and default_tax=1";
		$getTaxDetails = $this->db->query($taxQuery)->result_array();
	
		$taxName = isset($getTaxDetails[0]['tax_name']) ? $getTaxDetails[0]['tax_name'] :"";
		$tax_value = isset($getTaxDetails[0]['tax_value']) ? $getTaxDetails[0]['tax_value'] :"";

		if (count($getPaymentMode) > 0 ) 
		{
			foreach ($getPaymentMode as $payments) 
			{
				$response [] = array(
						"paymentTypeId"			=> (int)$payments['payment_type_id'],
						"paymentType"			=> $payments['payment_type'],
						"paymentTypeStatus"		=> (int)$payments['payment_type_status'],
						"sequenceNumber"		=> (int)$payments['sequence_number'],
						"defaultPayment"		=> (int)$payments['default_payment'],
						"taxName" 				=> $taxName,
						"taxValue" 				=> sprintf("%.2f", $tax_value)#(double)$tax_value#
				);
			}
		}
		else
		{
			$response = array("httpCode"  => 200, "message" =>"No Data Found");
		}

		header("Content-Type: application/json");
		echo json_encode($response);
		exit;
	}#completed

	function customerAddress($user_id="")
	{
		$getDeliveryAddress = 'select vb_customer_address.*,
										users.first_name,
										users.mobile_number from vb_customer_address
										left join users on users.user_id = vb_customer_address.user_id
					
										where vb_customer_address.user_id="'.$user_id.'" order by customer_address_id desc';
										
		$result = $this->db->query($getDeliveryAddress)->result_array();

		if (count($result) > 0) 
		{
			foreach ($result as $address)
			{
				$response[] = array(
					"customerAddressId"		=> (int)$address['customer_address_id'],
					"userId"				=> (int)$address['user_id'],
					"address"				=> $address['address'],
					"pinCode"				=> (int)$address['pin_code'],
					"landMark"				=> $address['land_mark'],
					"locality"				=> $address['locality'],
					"defaultAddress"		=> $address['default_address'],
					"alternativeNumber"		=> $address['alternative_number'],
					"firstName"				=> $address['first_name'],
					"mobileNumber"			=> $address['mobile_number'],
					"latitude"				=> (double)$address['latitude'],
					"longitude"				=> (double)$address['longitude'],
					"deliveryAddress"		=> $address['delivery_address'],
					"tags"					=> (int)$address['tags'],
					"buildingNumber"		=> $address['building_number'],
					"doorNumber"			=> $address['door_number'],
				);
			}
		}
		else
		{
			$response = array("httpCode"  => 200, "message" =>"No Data Found");
		}

		
		header("Content-Type: application/json");
		echo json_encode($response);
		exit;

	}#completed

	function cashOndelivery()
	{
		$json = @file_get_contents('php://input');
		$data = @json_decode($json);

		// print_r($data);exit;
		$wallet_chk = isset($data->walletChkEnabled) ? $data->walletChkEnabled : 0;
		
		if($wallet_chk == 1) #Enabled
		{
			$totalAmount = $grandTotal = $data->grandTotal;
			$wallet_amount = $data->walletAmount;
			
			if($totalAmount < $wallet_amount)
			{
				$walletAmount = $totalAmount;
			}
			else
			{
				$walletAmount = $wallet_amount;
			}
		}
		else #Disabled
		{
			$walletAmount = 0;
		}
		
		$branch_id  = $data->branchId;
		$orderDate  = date('Y-m-d');

		// $taxAmount = $tax_value/100 * $subTotal;
		// $totalPayableAmount = $subTotal + $taxAmount;

		$taxQuery = "select tax_value from tax where tax_status=1 and default_tax=1";
		$getTaxDetails = $this->db->query($taxQuery)->result_array();
		$tax_value = isset($getTaxDetails[0]['tax_value']) ? $getTaxDetails[0]['tax_value'] : 0;

		$headerData = array(
			#"order_number"         => randomNum(10),
			"order_date"           	=> $orderDate,
			"invoice_billing_date" 	=> time(),
			"user_id"              	=> $data->userId,
			"branch_id"            	=> $branch_id,
			"created_date"         	=> time(),
			"sub_total"            	=> $data->subTotal,
			"grand_total"          	=> $data->grandTotal,
			"payable_amount"       	=> $data->payableAmount,
			"order_type"           	=> isset($data->orderType) ? $data->orderType :"",
			"delivery_address"     	=> isset($data->deliveryAddress) ? $data->deliveryAddress :"",
			"payment_method"       	=> isset($data->paymentMethod) ? $data->paymentMethod :"",
			"tax_value"				=> $tax_value,
			// "paid_status"			=> isset($data->paidStatus) ? $data->paidStatus :"0",
			"wallet_chk_enabled"   	=> $wallet_chk,
			"wallet_amount"        	=> $walletAmount,
			"payment_status"       	=> $data->paymentStatus,
			"options"			   	=> serialize($data->options) ,
		);
		
		$result = $this->db->insert('vb_order_header', $headerData);
		$order_id = $this->db->insert_id();
		
		if($order_id > 0)
		{
			#Order No auto generate Start here
			$results = $this->db->query("select increment_id from vb_order_header order by increment_id desc")->result_array();
			if( isset($results[0]['increment_id']) && $results[0]['increment_id'] == 0 )
			{
				$incrementID = 1;
			}
			else
			{
				$incrementID = $results[0]['increment_id'] + 1;
			}
			
			$branchQry = "select branch_prefix from branch where branch_id='".$branch_id."' ";
			$getBranchDetails = $this->db->query($branchQry)->result_array();
			$branch_prefix = $getBranchDetails[0]["branch_prefix"];
			$orderDate = date("dmy");
			$randomNumber = $branch_prefix."-".$orderDate.'-00'.$incrementID;
					
			
			$UpdateData['order_number'] = $order_number = $randomNumber;
			$UpdateData['increment_id'] = $incrementID;
			
			$this->db->where('order_id', $order_id);
			$resultUpdateData = $this->db->update('vb_order_header', $UpdateData);
			#Order No auto generate end here

			if (count($data->lineData) > 0 ) 
			{
				foreach ($data->lineData as $lineData) 
				{
					$lineData->ingredients = json_decode(json_encode($lineData->ingredients), true);
					
					$insertData = array(
						'order_id'						=>	$order_id,
						'category_id'					=>	$lineData->categoryId,
						'product_id'					=>	$lineData->productId,
						'quantity'						=>	$lineData->quantity,
						'price'							=>	isset($lineData->price) ? $lineData->price:"0",
						'linetotal'						=>	isset($lineData->linetotal) ? $lineData->linetotal :"0",
						'ingredient_amount'				=>	isset($lineData->ingredientAmount) ? $lineData->ingredientAmount :"0",
						'ingredients'					=>	isset($lineData->ingredients) ? serialize($lineData->ingredients) :"",
						'cooking_instruction'			=>	!empty($lineData->cookingInstruction)?$lineData->cookingInstruction:'',
					);
					$this->db->insert('vb_order_line', $insertData);
				}
			}
			
			if($wallet_chk == 1)
			{
				$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount - $walletAmount where user_id = '". $data->userId."' ";
				$this->db->query($UpdateQuery);
			}

			$orderQuery = "select 
						vb_order_header.user_id, 
						vb_order_header.order_number,
						vb_order_header.grand_total,
						users.mobile_number, 
						country.country_code
					from vb_order_header 
					
					left join users on 
						users.user_id = vb_order_header.user_id
						
					left join country on 
						country.country_id = users.country_id 
					where order_id = '".$order_id."' ";

					$getOrderDetails = $this->db->query($orderQuery)->result_array();
					
					$country_code = $getOrderDetails[0]['country_code'];
					$mobile_number = $getOrderDetails[0]['mobile_number'];
					$order_number = $getOrderDetails[0]['order_number'];
					$otpMobileNumber = $country_code.$mobile_number;
				
					$otpMessage = '#'. $order_number.' Your order has been placed. - Thank You.  '.strtoupper(SITE_NAME);
					$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
			
			$response = array("httpCode"  => 200, "orderNumber" => $order_number, "message" =>"Order placed Sucessfully","orderStatus" =>1);
			header("Content-Type: application/json");
			echo json_encode($response);
			exit;

		}
		else
		{
			$response = array("httpCode"  => 200, "message" =>"Sorry Order Not Placed","orderStatus" =>0);
			header("Content-Type: application/json");
			echo json_encode($response);
			exit;
		}
	}#pending

	function orderDetails()
	{
			$jsonData =  @file_get_contents('php://input');
		
			$postData = json_decode($jsonData);

			$wallet_chk = isset($postData['wallet_chk_enabled']) ? $postData['wallet_chk_enabled'] : 0;
			
			if($wallet_chk == 1) #Enabled
			{
				$totalAmount = $grandTotal = $postData['grand_total'];
				$wallet_amount = $postData['wallet_amount'];
				
				if($totalAmount < $wallet_amount)
				{
					$walletAmount = $totalAmount;
				}
				else
				{
					$walletAmount = $wallet_amount;
				}
			}
			else #Disabled
			{
				$walletAmount = 0;
			}
			
			$branch_id  = isset($_SESSION['BRANCH_ID']) ? $_SESSION['BRANCH_ID'] : 0;
			$orderDate  = date('Y-m-d');

			if ($data->_embedded->payment[0]->authResponse->success)
			{
				$payment_status = "SUCCESS";	
			}
			else
			{
				$payment_status = "FAILED";
			}

			$headerData = array(
				#"order_number"         => randomNum(10),
				"order_date"           => $orderDate,
				"invoice_billing_date" => time(),
				"user_id"              => $this->UserID,
				"branch_id"            => $branch_id,
				"created_date"         => time(),
				"sub_total"            => $postData['sub_total'],
				"grand_total"          => $postData['grand_total'],
				"payable_amount"       => $postData['payable_amount'],
				"order_type"           => isset($postData['order_type']) ? $postData['order_type'] :"",
				"delivery_address"     => isset($postData['delivery_address']) ? $postData['delivery_address'] :"",
				"payment_method"       => isset($postData['payment_method']) ? $postData['payment_method'] :"",
				"wallet_chk_enabled"   => $wallet_chk,
				"wallet_amount"        => $walletAmount,
				
				"currency_code"        => $data->amount->currencyCode,
				"reference_id"         => $data->reference,
				"payment_status"       => $payment_status,
			);
			
			$this->db->insert('vb_order_header', $headerData);
			$order_id = $this->db->insert_id();

			if($order_id > 0)
			{
				$serialized_data = serialize($data);
				$payment_history = array('order_id'=>$order_id,'payment_history'=>$serialized_data);

				$this->db->insert('vb_order_payment_history', $payment_history);

				#Order No auto generate Start here
				$results = $this->db->query("select increment_id from vb_order_header order by increment_id desc")->result_array();
				if( isset($results[0]['increment_id']) && $results[0]['increment_id'] == 0 )
				{
					$incrementID = 1;
				}
				else
				{
					$incrementID = $results[0]['increment_id'] + 1;
				}
				
				$randomNumber = 'ORD-000'.$incrementID;
				
				$UpdateData['order_number'] = $randomNumber;
				$UpdateData['increment_id'] = $incrementID;
				
				$this->db->where('order_id', $order_id);
				$resultUpdateData = $this->db->update('vb_order_header', $UpdateData);
				#Order No auto generate end here

				# OrderLine start
				if( isset($postData['product_id']) && $postData['product_id'] !="" )
				{
					$count=count($postData['product_id']);
					for($dp=0;$dp<$count;$dp++)
					{	
						$quantity = isset($postData['quantity'][$dp]) ? $postData['quantity'][$dp] :"";
						$product_id = isset($postData['product_id'][$dp]) ? $postData['product_id'][$dp] :"";
						
						$lineData['order_id']          = $order_id;
						$lineData['category_id']       = isset($postData['category_id'][$dp]) ? $postData['category_id'][$dp] :"";
						$lineData['product_id']        = $product_id;
						
						$lineData['price']             = isset($postData['price'][$dp]) ? $postData['price'][$dp] :"";
						$lineData['ingredient_amount'] = isset($postData['ingredientAmount'][$dp]) ? $postData['ingredientAmount'][$dp] :"";
						$lineData['ingredients']       = isset($postData['ingredients'][$dp]) ? $postData['ingredients'][$dp] :"";
						
						$lineData['quantity']          = $quantity;
						$lineData['linetotal']         = isset($postData['linetotal'][$dp]) ? $postData['linetotal'][$dp] :"";
						$lineData['order_date']        = strtotime($orderDate);
						
						$this->db->insert('vb_order_line', $lineData);
						$lineID= $this->db->insert_id();
						
						#Update Availble Qty start
						$BrancItemHeader ="select branch_item_header_id from vb_branch_items_header where branch_id='".$branch_id."' ";
						$getBrancItemHeader = $this->db->query($BrancItemHeader)->result_array();
						$branch_item_header_id = isset($getBrancItemHeader[0]['branch_item_header_id']) ? $getBrancItemHeader[0]['branch_item_header_id'] : 0;
						
						$UpdateAvailbleQtyQuery = "update vb_branch_items_line set available_quantity = available_quantity - $quantity 
							where 
								branch_item_header_id = '".$branch_item_header_id."' and
									product_id = '".$product_id."'
							";
						$this->db->query($UpdateAvailbleQtyQuery);
						#Update Availble Qty end
					}
				}
				# OrderLine start
				
				if($wallet_chk == 1)
				{
					$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount - $walletAmount where user_id = '".$this->UserID."' ";
					$this->db->query($UpdateQuery);
				}
				
				unset($_SESSION["cart_item"]);
				unset($_SESSION["postData"]); 
				
				redirect(base_url().'confirm.html');
			}
		
	}#pending


	function vatTax()
	{
		$taxQuery = "select tax_name,tax_id,tax_value from tax where tax_status=1 and default_tax=1";
		$getTaxDetails = $this->db->query($taxQuery)->result_array();
	
		$taxName = isset($getTaxDetails[0]['tax_name']) ? $getTaxDetails[0]['tax_name'] :"";
		$tax_value = isset($getTaxDetails[0]['tax_value']) ? $getTaxDetails[0]['tax_value'] : 0;

		header("Content-Type: application/json");
		$response = array("httpCode" => 200 , "taxName" => $taxName, "taxValue" => (double)$tax_value);
		echo json_encode($response);exit;
	}


	function addAddress($user_id="")
	{
		$jsonData 	=  @file_get_contents('php://input');
		$data	 	= json_decode($jsonData);
		
		$postData['pinCode'] 	= $insert_data['pin_code']   = (double)!empty($data->pinCode) ? $data->pinCode :"0";
		$postData['address'] 	= $insert_data['address']   = isset($data->address) ? $data->address :"";
		$postData['landmark'] 	= $insert_data['land_mark'] = isset($data->landMark) ? $data->landMark :"";
		$postData['locality'] 	= $insert_data['locality']  = isset($data->locality) ? $data->locality :"";
		$postData['alternativeNumber'] = $insert_data['alternative_number'] = isset($data->alternativeNumber) ? $data->alternativeNumber :"";
		$postData['fullName'] = $insert_data['full_name'] 	= isset($data->fullName) ? $data->fullName :"";
		$postData['userId'] = $insert_data['user_id']      = $user_id;
		$postData['tags']	 =  $insert_data['tags'] 	    = isset($data->tags) ? $data->tags :"";

		$postData['latitude']	 = $insert_data['latitude'] = (double)isset($data->latitude) ? $data->latitude :"";
		$postData['longitude']	 = $insert_data['longitude'] = (double)isset($data->longitude) ? $data->longitude :"";
		$postData['deliveryAddress']	 = $insert_data['delivery_address'] = isset($data->deliveryAddress) ? $data->deliveryAddress :"";
		
		$postData['doorNumber']	 = $insert_data['door_number'] = isset($data->doorNumber) ? $data->doorNumber :"";
		$postData['buildingNumber']	 = $insert_data['building_number'] = isset($data->buildingNumber) ? $data->buildingNumber :"";
		
		$this->db->insert('vb_customer_address', $insert_data);
		$id = $this->db->insert_id();
		$postData['customeraddressId'] = (int)$id ;

		if ($id) 
		{
			header("Content-Type: application/json");
			$response = array("httpCode" => 200 , $postData);
			echo json_encode($postData);exit;			
		}
		else
		{
			header('HTTP/1.1 500', TRUE, 500);
			$response = array("httpCode" => 500 , "message" => "Some thing went Wrong");
			echo json_encode($response);exit;		
		}

	}

	function deleteAddress($Customer_address_id="")
	{
		$this->db->where('Customer_address_id',$Customer_address_id);
		$this->db->delete('vb_customer_address');
		
		header("Content-Type: application/json");
		$response = array("httpCode" => 200 , "message" => "Deleted Sucessfully");
		echo json_encode($response);exit;			
	}

	function userWallet($user_id = "")
	{
		$query = "select * from vb_customer_wallet where user_id = $user_id ";
		$wallet_amount = $this->db->query($query)->result_array();
		
		if( count($wallet_amount) > 0 ) 
		{
			$wallet_amount = $wallet_amount[0]['wallet_amount'];

			$response = array(
				'walletAmount' 	=> number_format($wallet_amount,DECIMAL_VALUE,'.',''),
				
			);
			header("Content-Type: application/json");
			echo json_encode($response);exit;	
		}
		else
		{
			$wallet_amount = "0.00";

			$response = array(
				'walletAmount' 	=> $wallet_amount,
			);
			header("Content-Type: application/json");
			echo json_encode($response);exit;	
		}
	}

	function zoneList()
	{
		$query = "select * from vb_branch_zones where zone_status = 1 ";
		$zones = $this->db->query($query)->result_array();

		foreach ($zones as $zone) 
		{
			$response[] = array(
				'zoneId' 		=> (int)$zone['zone_id'] ,
				'zoneName' 		=> $zone['zone_name'] ,
				'zoneStatus' 	=> (int)$zone['zone_status'] ,
				'branchid' 		=> (int)$zone['branch_id'] ,
				'latitude' 		=> (double)$zone['latitude'] ,
				'longitude' 	=> (double)$zone['longitude'] ,
			);
		}
		
		header("Content-Type: application/json");
		echo json_encode($response);exit;	
	}
	
	function cms()
	{
		$aboutUs = "https://www.thevasantabhavan.com/mobile-about-us.html";
		$contactUs = "https://www.thevasantabhavan.com/mobile-contact-us.html";
		
		$termsAndCondition = base_url()."terms-and-conditions.html";
		
		$response[] = array(
			'aboutUs' 		    => $aboutUs ,
			'contactUs' 	    => $contactUs,
			'termsAndCondition' => $termsAndCondition
		);
		
		header("Content-Type: application/json");
		echo json_encode($response);exit;	
	}
	
	function ajaxSearchBranch($lat="12.745436",$lon="77.81022589999999")
    {
		$deliveryAddress1 = getDeliveyrZoneBranches($lat,$lon);
		$FilerdeliveryAddress =  array_filter(explode("@",$deliveryAddress1));
		$deliveryAddress = $FilerdeliveryAddress[0];
		$deliveryAddress_1 = isset($FilerdeliveryAddress[1]) ? $FilerdeliveryAddress[1] :"";
		
		# Single Long name | Neighbourhood only start
		if(!empty($deliveryAddress))
		{
			$condition = ' (branch.branch_status = 1 ) and ';
			
			if(!empty($deliveryAddress) && !empty($deliveryAddress_1) )
			{
				$condition .= '  
				(
					vb_branch_zones.zone_name like "%'.($deliveryAddress).'%" or
					vb_branch_zones.zone_name like "%'.($deliveryAddress_1).'%"
				)  and ';	
			}
			else
			{
				$condition .= '  
				(
					vb_branch_zones.zone_name like "%'.($deliveryAddress).'%"
				)  and ';
			}
		
			$condition .= ' vb_branch_zones.zone_status = 1 ';
				
			if(!empty($_POST["query"]))
			{
				$condition .= ' and (
								branch.branch_name like "%'.($_POST["query"]).'%" or 
								branch.branch_code like "%'.($_POST["query"]).'%" or
								branch.address like "%'.($_POST["query"]).'%"
							)
						';
			}
		}
		else
		{
			$condition = ' branch.branch_status = 1 and vb_branch_zones.zone_status = 1';
		} 
		# Single Long name | Neighbourhood only end
		
		$branchQuery = "select 
				branch.branch_id,
				branch.branch_name,
				branch.branch_code,
				branch.address,

				branch.description,
				branch.branch_status,
				branch.user_id,
				branch.phone_number_2,
				branch.country_id,
				branch.state_id,
				branch.location,
				branch.latitude,
				branch.longitude,
				branch.email,
				branch.minimum_order_value,
				country.country_name,
				country.country_code,
				state.state_name,
				users.first_name,

				branch.phone_number,
				branch.delivery_distance

				from branch 
				
				left join vb_branch_zones on
					vb_branch_zones.branch_id = branch. branch_id
				
				left join country on
					country.country_id = branch. country_id

				left join state on
					state.state_id = branch. state_id

				left join users on
					users.user_id = branch. user_id

					where ".$condition." group by branch.branch_name
				ORDER BY branch.branch_name asc
		";
		#echo $branchQuery;
		$result = $this->db->query($branchQuery)->result_array();
		
		if( count($result) > 0 )  
		{  
			foreach ($result as $row) 
			{
				if (file_exists('uploads/branches/'.$row['branch_id'].'.png'))
				{
					$branch_imgUrl = base_url()."uploads/branches/".$row['branch_id'].'.png' ;			
				}
				else
				{
					$branch_imgUrl = base_url().'uploads/no-food-image.png' ;
				}

				$row['branch_image'] = $branch_imgUrl;

				$response[] = array(
					'branchId' 	   		=> (int)$row['branch_id'],
					'branchName' 		=> $row["branch_name"],
					'branchCode' 		=> (int)$row["branch_code"],
					'address' 			=> $row["address"],
					'deliveryDistance' 	=> (int)$row["delivery_distance"] * 1000,

					'description' 		=> $row["description"],
					'branchStatus' 		=> (int)$row["branch_status"],
					'userId' 			=> (int)$row["user_id"],
					'phoneNumber'		=> (int)$row["phone_number"],
					'alternativeNumber'	=> (int)$row["phone_number_2"],
					'countryId'			=> (int)$row["country_id"],
					'stateId'	    	=> (int)$row["state_id"],
					'location'	    	=> (int)$row["location"],
					'latitude'	    	=> (double)$row["latitude"],
					'longitude'	    	=> (double)$row["longitude"],
					'email'	    		=> $row["email"],
					'countryName'	   	=> $row["country_name"],
					'countryCode'	   	=> (int)$row["country_code"],
					'stateName'	   	    => $row["state_name"],
					'firstName'	        => $row["first_name"],
					'branchImage'	   	=> $row["branch_image"],
					'minimumOrderValue'	=> $row["minimum_order_value"],
				);
			}  
		}  
		else  
		{  
			header("Content-Type: application/json");
			$response = array("httpCode" => 200 , "message" => "No Branches.");
		}
		
		header("Content-Type: application/json");
		echo json_encode($response);exit;
	}	

	function getcms()
	{
		$cms = $this->db->query("select * from cms where cms_status = 1 ")->result_array();

		foreach ($cms as $cmsKey) {
			
			$response [] = array(
				"cmsId" 		=> (int)$cmsKey['cms_id'],
				"cmsTitle" 		=> $cmsKey['cms_title'],
				"cmsUrl" 		=> $cmsKey['cms_url'],
				"cmsDesciption" => $cmsKey['cms_desc'],
			);
		}

		header("Content-Type: application/json");
		echo json_encode($response);exit;
	}
	
	function edit_profile_verify_otp()
	{
		$json = @file_get_contents('php://input');
		$data = @json_decode($json);
		
		if( !empty( $data->email ) && !empty( $data->otp_number )  )
		{			
			$email 	    = $data->email;
			$otp_number = $data->otp_number;
			$mobile_number = $data->mobile_number;

			$user = $this->db->query("select first_name,user_id,mobile_number,country_id,email from users where  email='".$email."' and otp_number = '".$otp_number."'")->result_array();

			if( count($user) > 0 )
			{
				$user_id = isset($user[0]['user_id']) ? $user[0]['user_id'] :0;

				if (file_exists('uploads/profile_image/'.$user[0]['user_id'].'.png'))
				{
					$profile_imgUrl = base_url()."uploads/profile_image/".$user_id.'.png' ;			
				}
				else
				{
					$profile_imgUrl = base_url().'uploads/no-user.png' ;
				}

				$this->db->where('user_id', $user[0]['user_id']);
				$result = $this->db->update('users',array('otp_status' => 1 ,'mobile_number'=>$mobile_number));

                $response = array(	
					"httpCode" 		=> 200 ,
					"userId"		=> $user[0]['user_id'],
					"mobileNumber"	=> $mobile_number,
					"countryId"		=> $user[0]['country_id'],
					"email"			=> isset($user[0]['email'])	? $user[0]['email'] :null,						
					"firstName"		=> isset($user[0]['first_name']) ? $user[0]['first_name'] :null,						
					"profileImage"	=> $profile_imgUrl,						
					"message" 		=> "Mobile Number verified successfully!"
				);
				
				header("Content-Type: application/json");
				echo json_encode($response);
				exit;
            }
			else
			{
				$response = array("httpCode" => 409 , "message" => "OTP number does not match!" );
				header('HTTP/1.1 409', TRUE, 409);
				echo json_encode($response);
				exit;
			}
		}
		else
		{
			$response = array("httpCode" => 400 , "Message" => "Bad Request" );
			header('HTTP/1.1 400', TRUE, 400);
			echo json_encode($response);
			exit;
		}
		exit;
	}

	#Controller End
}
?>
