<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*------------------------------
#   Author  :   Sharanji P        
#   Date    :   08 - July - 2021
#   Jesperapps Software Services
--------------------------------*/
class BillGenrator extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}

    function chkbill()
    {
		if($this->user_id==1) #Admin
		{
			$condition = " 1=1 and print_status = 0";
			$joinQuery ="";
		}
		else #Branch Admins
		{
			#order_closed_status = 0-Not closd, 1-closed
			$condition = " 1=1 and print_status = 0 and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$joinQuery ="
				join users as branch_users on branch_users.branch_id = vb_order_header.branch_id 
			";
		}
		
        $orderQuery = "select order_id,print_status 
				from vb_order_header 
			
			$joinQuery
			
		where $condition";
		
        $orderResult = $this->db->query($orderQuery)->result_array();
		
		if (count($orderResult) > 0) 
		{
			$order_id = isset($orderResult[0]['order_id']) ? $orderResult[0]['order_id'] : 0;
			
			if($order_id !=0)
            {
				$this->sendArgs($order_id);
			}
        }
        else 
		{
            exit;
        }
    }
	
	function sendArgs($order_id="")
    {
		 $orderQuery =  "select 
                            orders.order_id,
							orders.order_number,
							users.first_name,
							mobile_number,
							orders.grand_total,
							orders.order_date,
							orders.sub_total,
							orders.tax_value,
							orders.created_date,
							branch.address as branch_address,
							branch.phone_number
							
                            from vb_order_header as orders
                           
				left join users on 
					orders.user_id = users.user_id 
	
				left join branch on 
					orders.branch_id = branch.branch_id 

            where orders.order_id = '".$order_id."' ";

        $orderResult = $this->db->query($orderQuery)->result_array();
		
        $lineDataQuery  = "select * from vb_order_line 
                            left join products on products.product_id = vb_order_line.product_id
                            where vb_order_line.order_id = ".$order_id;
        $lineData       = $this->db->query($lineDataQuery)->result_array();
			
        $orderResult[0]['lineData'] = $lineData;

        $orderResult[0]['gst_number'] = GST_NUMBER;
        $orderResult[0]['created_date'] = strtoupper(date("M d, Y",$orderResult[0]['created_date']));
        
        $jsonData =json_encode($orderResult[0]);
        $encodedData=  base64_encode($jsonData);
		#=print_r($encodedData);exit;
        
        $r = shell_exec("python autoprint.py $encodedData");

        $response = json_decode($r);
		$statusCode = isset($response->statusCode) ? $response->statusCode : 0;
		$orderID = isset($response->order_id) ? $response->order_id : 0;
		
		#print_r($response);exit;
		
		if( $statusCode == 1 && $orderID > 0 ) 
        {    
            $this->db->where("order_id",$order_id);
            $this->db->update("vb_order_header",array("print_status"=>1));
            $this->chkbill();
        }
    }
	#Controller End
}
?>
