<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Branch_items extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function ManageBranchItems($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['Inventory'] = 1;
		$page_data['page_name']  = 'branch_items/ManageBranchItems';
		$page_data['page_title'] = 'Manage Branch Items';
		
		switch($type)
		{
			case "add": #Add
				if($_POST)
				{
					$data['branch_id'] = $this->input->post('branch_id');
					# Check Exist Start
					$chkExistProduct = $this->db->query("select branch_item_header_id from vb_branch_items_header 
						where branch_id='".$data['branch_id']."' 
							")->result_array();
							
					if(count($chkExistProduct) > 0)
					{
						$this->session->set_flashdata('error_message' , "Branch items already assigned!");
						redirect(base_url() . 'branch_items/ManageBranchItems/add', 'refresh');
					}
					# Check Exist End
					
					$data['note'] = '';
					$data['created_date'] = time();
					
					$this->db->insert('vb_branch_items_header', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						$BranchItems = $this->input->post('table_data');
						$js_data = json_decode($BranchItems);
						
						foreach ($js_data as $key => $value) 
						{
							if($value==null)
							{
								
							}
							else
							{
								$lineData = array(
									"product_id"            => $value->product_id,
									"price"                 => $value->price,
									"available_quantity"    => $value->available_quantity,
									"minimum_order_quantity"=> $value->minimum_order_quantity,
									"item_status"           => $value->item_status,
									"branch_item_header_id" => $id
								);
								
								$this->db->insert('vb_branch_items_line', $lineData);
								$BranchItems  = $this->db->insert_id();
							}
						}
						$this->session->set_flashdata('flash_message' , "Branch Items added Successfully!");
						
						if($this->user_id==1)
						{
							redirect(base_url() . 'branch_items/ManageBranchItems', 'refresh');
						}
						else
						{
							redirect(base_url() . 'branch_items/viewBranchItems/'.$id.'/'.$this->admin_branch_id, 'refresh');
						}
					}
				}
			break;
			
			case "edit": #edit
				
				$branch_item_header_id  = $id;
				$branch_id  = $status;
				$page_data['data'] = $this->branch_items_model->getRecord($id);
				$page_data['items'] = $this->branch_items_model->getBranchItems($branch_item_header_id,$branch_id);	
				
				if($_POST)
				{
					$data['branch_id'] = $this->input->post('branch_id');
					
					# Check Exist Start
					$chkExistProduct = $this->db->query("select branch_item_header_id from vb_branch_items_header 
						where 
							branch_id='".$data['branch_id']."' and
								branch_item_header_id !='".$id."' 
							")->result_array();
							
					if(count($chkExistProduct) > 0)
					{
						$this->session->set_flashdata('error_message' , "Branch items already assigned!");
						redirect(base_url() . 'branch_items/ManageBranchItems/edit/'.$id.'/'.$branch_id, 'refresh');
					}
					# Check Exist End
					
					$data['note'] = '';
					
					$this->db->where('branch_item_header_id', $id);
					$result = $this->db->update('vb_branch_items_header', $data);
					
					if($result)
					{
						
						/* $this->db->where('branch_item_header_id',$id);
						$this->db->delete('vb_branch_items_line');
						*/
						
						/* if( isset($_POST['product_id']) && $_POST['product_id'] !="" )
						{
							
							$count=count(array_filter($_POST['product_id']));
							
							for($dp=0;$dp<$count;$dp++)
							{	
								/* $data_2['candidate_user_id'] = $id;
								$data_2['certificate_type'] = $_POST['certificate_type'][$dp];
								$data_2['certificate'] = $_POST['certificate'][$dp];
								
								$this->db->insert('certifications', $data_2);
								$id_3 = $this->db->insert_id(); */
							/*	
								$product_id = $_POST['product_id'][$dp];
								
								#if(isset($_POST['item_status'][$dp]))
								if(!empty($_POST['item_status'][$dp]) && $_POST['item_status'][$dp] == 1)
								{
									$item_status = 1;
								}
								else
								{
									$item_status = 2;
								}
								
								$lineData = array(
									"product_id"            => $product_id,
									"price"                 => $_POST['price'][$dp],
									"available_quantity"    => $_POST['available_quantity'][$dp],
									"minimum_order_quantity"=> $_POST['minimum_order_quantity'][$dp],
									"item_status"           => $item_status,
									"branch_item_header_id" => $id
								);
								
								$SelectQuery = "select price,item_status,branch_item_line_id from vb_branch_items_line 
									where 
										branch_item_header_id = $id and 
											product_id = $product_id";
										
								$result = $this->db->query($SelectQuery)->result_array();
								
								if( count($result) > 0 )
								{
									//$lineData['price'] = $result[0]['price'];
									//$lineData['item_status'] = $result[0]['item_status'];;
									
									$where = "branch_item_header_id = '".$id."' AND product_id = '".$product_id."'";
									$this->db->where($where);
									
									$this->db->update('vb_branch_items_line',$lineData);
								}
								else
								{
									$this->db->insert('vb_branch_items_line', $lineData);
									$BranchItems  = $this->db->insert_id();
								}
								#Not adding Inventory only Purchase End
							}
						} */
						
						$js_data = json_decode($this->input->post('table_data1'));			
						$php_data = json_decode($this->input->post('table_data'));
						
						if(!empty($js_data))
						{
							foreach(array_filter($js_data) as $key => $value) 
							{
								$existing_product_id = isset($php_data[$key]) ? $php_data[$key] : 0;
								
								if($value == 'delete')
								{
									$product_id = $php_data[$key];
									$DeleteBranchItems = $this->branch_items_model->deleteBranchItems($id,$product_id,$branch_id);
								}
								else if($value==null)
								{
									
								}
								else
								{
									$product_id = $value->product_id;
									
									$lineData = array(
										"product_id"            => $value->product_id,
										"price"                 => $value->price,
										"available_quantity"    => $value->available_quantity,
										"minimum_order_quantity"=> $value->minimum_order_quantity,
										"item_status"           => $value->item_status,
										"branch_item_header_id" => $id
									);
									
									$SelectQuery = "select price,item_status,branch_item_line_id from vb_branch_items_line 
										where 
											branch_item_header_id = $id and 
												product_id = $product_id";
											
									$result = $this->db->query($SelectQuery)->result_array();
									
									if( count($result) > 0 )
									{
										//$lineData['price'] = $result[0]['price'];
										//$lineData['item_status'] = $result[0]['item_status'];;
										
										$where = "branch_item_header_id = '".$id."' AND product_id = '".$product_id."'";
										$this->db->where($where);
										
										$this->db->update('vb_branch_items_line',$lineData);
									}
									else
									{
										$this->db->insert('vb_branch_items_line', $lineData);
										$BranchItems  = $this->db->insert_id();
									}
									#Not adding Inventory only Purchase End
								}
							}
						}
						
						$this->session->set_flashdata('flash_message' , "Branch Item updated Successfully!");
						
						if($this->user_id==1)
						{
							redirect(base_url() . 'branch_items/ManageBranchItems', 'refresh');
						}
						else
						{
							redirect(base_url() . 'branch_items/viewBranchItems/'.$id.'/'.$this->admin_branch_id, 'refresh');
						}
					}
				}
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->branch_items_model->getmanegeBranchItemsCount();
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('branch_items/ManageBranchItems?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('branch_items/ManageBranchItems?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->branch_items_model->getmanegeBranchItems($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	public function getProduct($product_id="")
	{
		if($product_id == 0)
		{
			$data['items'] = $this->db->select('
						p.product_id,
						p.product_code,
						p.product_name,
						p.price,
						p.product_image
				')
				->from('products p')
				->get()
				->result();
				
		}
		else
		{
			$data['items'] = $this->db->select('
						p.product_id,
						p.product_code,
						p.product_name,
						p.price,
						p.product_image
				')
				->from('products p')
				->where('p.product_id',$product_id)
				->get()
				->result();
		}
				
		$itemActive= '';
				
		foreach($this->product_branch_status as $key=>$value)
		{
			$itemActive .= '<option value="'.$key.'">'.$value.'</option>';
		}	

		$data['itemStatus'] = $itemActive;
		echo json_encode($data);
	}
	
	public function viewBranchItems($branch_item_header_id="", $branch_id="")
	{
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['id'] = $branch_item_header_id;
		$page_data['branch_id'] = $branch_id;
		$page_data['Inventory'] = 1;
		$page_data['page_name']  = 'branch_items/viewBranchItems';
		$page_data['page_title'] = 'Branch Items';

		
		# Add start
		
		if( isset($_POST) && isset($_POST['product_id']) && $_POST['product_id'] !="" )
		{
		
			$product_id =$_POST['product_id'][0];
			
			$checkIngredients = $this->db->query("
			select branch_item_ingredient_id from vb_branch_item_ingredients 
			where 
			branch_id ='".$branch_id."' and 
				product_id ='".$product_id."'
			")->result_array();
			
			if( count($checkIngredients) > 0 )
			{
				$this->db->where('branch_id',$branch_id);
				$this->db->where('product_id',$product_id);
				$this->db->delete('vb_branch_item_ingredients');
			}

			$count=count($_POST['product_id']);

			for($dp=0;$dp<$count;$dp++)
			{
				$data = array(
					"branch_item_header_id"    => $branch_item_header_id,
					"branch_id"                => $branch_id,
					"product_id"               => $_POST['product_id'][$dp],
					"ingredient_id"            => $_POST['ingredient_id'][$dp],
					"price"                    => $_POST['price'][$dp],
					"ingredient_branch_status" => $_POST['ingredient_branch_status'][$dp],
				);
				
				$this->db->insert('vb_branch_item_ingredients', $data);
				$BranchItems  = $this->db->insert_id();
			}

			$this->session->set_flashdata('flash_message' , 'Ingredient added successfully!');
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		#Add end
		
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	
	function ajaxAvailableBranchItems($type = '', $id = '', $status = '')
    {
		switch($type)
		{
			case "status": #Block & Unblock
			
				if($status == 1){
					$data['item_status'] = 1;
					$succ_msg = 'Item is Available!';
				}else{
					$data['item_status'] = 0;
					$succ_msg = 'Item is Unavailable!';
				}
				$this->db->where('branch_item_line_id', $id);
				$this->db->update('vb_branch_items_line', $data);

				// $this->session->set_flashdata('flash_message' , $succ_msg);
				// redirect(base_url() . 'products/ManageProducts', 'refresh');

				echo ($succ_msg);
				exit;
			break;
		}
	}
}
?>
