<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Branches extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
		$this->output->set_header('Pragma: no-cache');
	}

	
	
	function ManageBranches($type = '', $id = '', $status = '', $status1 = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageBranches'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'branches/ManageBranches';
		$page_data['page_title'] = 'Manage Branch';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['branch_code'] = $this->input->post('branch_code');
					$existBranchCode = $this->db->query("select branch_id from branch where branch_code='".$data['branch_code']."' ")->result_array();
					if(count($existBranchCode) > 0 )
					{
						$this->session->set_flashdata('error_message' , "Sorry! Already exist branch code!");
						redirect(base_url() . 'branches/ManageBranches', 'refresh');
					}
					$data['user_id']	= $this->input->post('user_id');
					$data['country_id']	= $this->input->post('country_id');
					$data['state_id']	= $this->input->post('state_id');
					$data['branch_code'] = $this->input->post('branch_code');
					$data['branch_name'] = $this->input->post('branch_name');
					$data['description'] = 0;
					$data['phone_number'] = $this->input->post('phone_number');
					$data['address'] = $this->input->post('address');
					$data['location'] = $this->input->post('location');
					$data['phone_number_2'] = $this->input->post('phone_number_2');
					$data['email'] = $this->input->post('email');
					
					$data['delivery_distance'] = $this->input->post('delivery_distance');
					$data['minimum_order_value'] = $this->input->post('minimum_order_value');
					$data['opening_time'] = $this->input->post('opening_time');
					$data['closing_time'] = $this->input->post('closing_time');
					
					$latLong = getGeoLatLong($data['location']);
					$data['latitude'] = $latLong['latitude'];
					$data['longitude'] = $latLong['longitude'];
					
					$data['branch_status'] = 1;
					
					
					$this->db->insert('branch', $data);
					$id = $this->db->insert_id();

					if($id !="")
					{
						if( !empty($_FILES['branch_image']['name']) )
						{  
							move_uploaded_file($_FILES['branch_image']['tmp_name'], 'uploads/branches/'.$id.'.png');
						}
						
						$this->session->set_flashdata('flash_message' , "Branch added Successfully!");
						redirect(base_url() . 'branches/ManageBranches', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('branch', array('branch_id' => $id))
										->result_array();
										
				$data['branch_code'] = $this->input->post('branch_code');
				
				$existBranchCode = $this->db->query("select branch_id from branch where branch_code='".$data['branch_code']."' and branch_id !='".$id."'")->result_array();
				
				if(count($existBranchCode) >0 )
				{
					$this->session->set_flashdata('error_message' , "Sorry! Already exist branch code!");
					redirect(base_url() . 'branches/ManageBranches/edit/'.$id, 'refresh');
				}
				if($_POST)
				{
					$data['user_id']	= $this->input->post('user_id');
					
					$data['branch_code'] = $this->input->post('branch_code');
					$data['branch_name'] = $this->input->post('branch_name');
					$data['description'] = $this->input->post('description');
					$data['phone_number'] = $this->input->post('phone_number');
					$data['address'] = $this->input->post('address');
					$data['location'] = $this->input->post('location');
					$data['phone_number_2'] = $this->input->post('phone_number_2');

					$data['country_id'] = $this->input->post('country_id');
					$data['state_id'] = $this->input->post('state_id');
					
					$latLong = getGeoLatLong($data['location']);
					$data['latitude'] = $latLong['latitude'];
					$data['longitude'] = $latLong['longitude'];
					$data['email'] = $this->input->post('email');
					
					
					$data['delivery_distance'] = $this->input->post('delivery_distance');
					$data['minimum_order_value'] = $this->input->post('minimum_order_value');
					$data['opening_time'] = $this->input->post('opening_time');
					$data['closing_time'] = $this->input->post('closing_time');
					
					$this->db->where('branch_id', $id);
					$result = $this->db->update('branch', $data);
					
					if($result)
					{
						if( !empty($_FILES['branch_image']['name']) )
						{  
							move_uploaded_file($_FILES['branch_image']['tmp_name'], 'uploads/branches/'.$id.'.png');
						}

						$this->session->set_flashdata('flash_message' , "Branch updated Successfully!");
						redirect(base_url() . 'branches/ManageBranches', 'refresh');
					}
				}
			break;
			
			case "view": #view
				$page_data['edit_data'] = $this->db->get_where('branch', array('branch_id' => $id))
										->result_array();
			break;
			
			case "delete": #Delete
				$this->db->where('branch_id', $id);
				$this->db->delete('branch');
				
				$this->session->set_flashdata('flash_message' , "Branch deleted successfully!");
				redirect(base_url() . 'branches/ManageBranches', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['branch_status'] = 1;
					$succ_msg = 'Branch unblocked successfully!';
				}else{
					$data['branch_status'] = 0;
					$succ_msg = 'Branch blocked successfully!';
				}
				$this->db->where('branch_id', $id);
				$this->db->update('branch', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'branches/ManageBranches', 'refresh');
			break;
			
			#zone starts
			case "zone":

				
				if(isset($_POST['add']))
				{
					$data['branch_id'] = $id;
					$data['zone_name'] = ucfirst($this->input->post('zone_name'));

					$zonelatLong = getGeoLatLong($data['zone_name']);
					$data['latitude'] = $zonelatLong['latitude'];
					$data['longitude'] = $zonelatLong['longitude'];
					$data['zone_status'] = 1;

					$this->db->insert('vb_branch_zones', $data);
					$zoneID = $this->db->insert_id();

					if($zoneID)
					{
						$this->session->set_flashdata('flash_message' , "Zone Added successfully!");
						redirect(base_url() . 'branches/ManageBranches/zone/'.$id, 'refresh');
					}
				}
				// else if(isset($_POST['update']))
				// {
				// 	$zone_id = $this->input->post('zone_id');
					
				// 	$data['zone_name'] = ucfirst($this->input->post('zone_name'));

				// 	$zonelatLong = getGeoLatLong($data['zone_name']);
				// 	$data['latitude'] = $zonelatLong['latitude'];
				// 	$data['longitude'] = $zonelatLong['longitude'];

				// 	$this->db->where('zone_id', $zone_id);
				// 	$this->db->update('vb_branch_zones', $data);

				// 	$this->session->set_flashdata('flash_message' , "Zone updated successfully!");
				// 	redirect($_SERVER['HTTP_REFERER'], 'refresh');
				// }
				
				$page_data["totalRows"] = $totalRows = $this->branches_model->getBranchZonesCount($id);

				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('branches/ManageBranches/zone/'.$id.'?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('branches/ManageBranches/zone/'.$id.'?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->branches_model->getBranchZones($limit, $offset,$id);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
			
			case "zonedelete": #Delete
				$this->db->where('zone_id', $id);
				$this->db->delete('vb_branch_zones');
				
				$this->session->set_flashdata('flash_message' , "Zone deleted successfully!");
				redirect($_SERVER['HTTP_REFERER'], 'refresh');
			break;

			case "zone_status": #Active Inactive
				if($status == 1){
					$data['zone_status'] = 1;
					$succ_msg = 'Zone type unblocked successfully!';
				}else{
					$data['zone_status'] = 0;
					$succ_msg = 'Zone type blocked successfully!';
				}
				$this->db->where('zone_id', $id);
				$this->db->update('vb_branch_zones', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect($_SERVER['HTTP_REFERER'], 'refresh');
				//redirect(base_url() . 'branches/ManageBranches', 'refresh');
			break;
			
			#zone Ends
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->branches_model->getManageBranchCount();#
	
				if(!empty($_SESSION['PAGE']))
				{
					$limit = $_SESSION['PAGE'];
				}else{
					$limit = 10;
				}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('branches/ManageBranches?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('branches/ManageBranches?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->branches_model->getManageBranch($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}

	function ManagePosters($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageBranches'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'branches/ManagePosters';
		$page_data['page_title'] = 'Manage Branch';
		
		switch($type)
		{
			case "add": #Add
				if($_POST)
				{
					$data['poster_title'] = $this->input->post('poster_title');
					$data['branch_id'] = $this->input->post('branch_id');

					$data['description'] = $this->input->post('description');
					$data['poster_status'] = 1;
					
					$this->db->insert('vb_posters', $data);
					$id = $this->db->insert_id();
					
					if($id > 0)
					{
						if (count(array_filter($_FILES['images']['name'])) > 0) 
						{
							foreach ($_FILES['images']['name'] as  $key => $img_names) 
							{
								$line_data['poster_header_id'] 	= $id;
								$line_data['poster_image'] 		= $img_names;

								$this->db->insert('vb_posters_line', $line_data);
								move_uploaded_file($_FILES['images']['tmp_name'][$key], 'uploads/posters/' . $img_names);
							}	
						}
						$this->session->set_flashdata('flash_message' , 'Poster added successfully');
						redirect(base_url() . 'branches/ManagePosters', 'refresh');
					}
				}
			break;
			
			case "edit": #Edit
				$page_data['edit_data'] = $this->db->query("select * from vb_posters where poster_id = $id")->result_array();
				if($_POST)
				{
					$data['poster_title'] = $this->input->post('poster_title');
					$data['branch_id'] = $this->input->post('branch_id');
					$data['description'] = $this->input->post('description');
						
					$this->db->where('poster_id', $id);
					$result = $this->db->update('vb_posters', $data);
					
					if($result > 0)
					{
						if (count(array_filter($_FILES['images']['name'])) > 0) 
						{
							foreach ($_FILES['images']['name'] as  $key => $img_names) 
							{
								$line_data['poster_header_id'] 	= $id;
								$line_data['poster_image'] 		= $img_names;

								$this->db->insert('vb_posters_line', $line_data);
								move_uploaded_file($_FILES['images']['tmp_name'][$key], 'uploads/posters/' . $img_names);
							}	
						}
						$this->session->set_flashdata('flash_message' , 'Poster updated successfully');
						redirect(base_url() . 'branches/ManagePosters', 'refresh');
					}
					
				}
			break;

			case "delete": #Delete
				$this->db->where('poster_id', $id);
				$this->db->delete('vb_posters');
				
				$this->session->set_flashdata('flash_message' , "Poster deleted successfully!");
				redirect(base_url() . 'branches/ManagePosters', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['poster_status'] = 1;
					$succ_msg = 'Poster unblocked successfully!';
				}else{
					$data['poster_status'] = 0;
					$succ_msg = 'Poster blocked successfully!';
				}
				$this->db->where('poster_id', $id);
				$this->db->update('vb_posters', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'branches/ManagePosters', 'refresh');
			break;

			case 'view':
				$query = "select * from vb_posters_line
							
							left join vb_posters on vb_posters.poster_id = vb_posters_line.poster_header_id 
							
							where vb_posters.poster_id = $id";

				$result = $this->db->query($query)->result_array();
				$page_data['poster_images'] = $result;	
			break;
			
			default : #Manage
				
				$page_data["totalRows"] = $totalRows = $this->branches_model->posterCount();#
	
				if(!empty($_SESSION['PAGE']))
				{
					$limit = $_SESSION['PAGE'];
				}else{
					$limit = 10;
				}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('branches/ManagePosters?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('branches/ManagePosters?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->branches_model->getposters($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
				
				// print_r($page_data);exit;
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}

	function ajaxRemovePoster()
	{
		if ($_POST)
		{
			$this->db->where('poster_line_id',$_POST['line_id']);
			$this->db->delete('vb_posters_line');

			echo 'Poster Deleted Sucessfully.!';die;
		}
	}
}
?>
