<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Customer extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');

		#Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function ManageCustomer($type = '', $id = '', $status = '')
	{
		
		if (empty($this->user_id))
		{
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageCustomer'] = 1;
		$page_data['page_name']  = 'customer/ManageCustomer';
		$page_data['page_title'] = 'Manage Customers';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['first_name'] = $this->input->post('first_name');
					/* $data['middle_name'] = $this->input->post('middle_name');
					$data['last_name'] = $this->input->post('last_name'); */
					$data['email'] = $this->input->post('email'); 
					$data['address1'] = $this->input->post('address1'); 
					$data['mobile_number'] = isset($_POST['mobile_number']) ? $_POST['mobile_number'] :"";
					$data['country_id'] = $this->input->post('country_id');
					$data['state_id'] = $this->input->post('state_id');
					$data['city_id'] = $this->input->post('city_id');
					$data['gst_number'] = $this->input->post('gst_number');
					$data['pan_number'] = $this->input->post('pan_number');
					$data['joined_date'] = strtotime(date('d-M-Y h:i:s a',time()));
					$data['user_status'] = 1;
					$data['register_type'] = 2; #Customer
					
					$this->db->insert('users', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						#Employee / Dealer Number auto generate Start here
						/* if($data['register_type'] == 1) #Employee
						{
							$results = $this->db->query("select increment_id from users where (register_type = '".$data['register_type']."' and register_type != 0) order by increment_id desc")->result_array();
							if( isset($results[0]['increment_id']) && $results[0]['increment_id'] == 0 )
							{
								$incrementID = 1;
							}
							else
							{
								$incrementID = $results[0]['increment_id'] + 1;
							}
							
							$randomNumber = 'EMP-000'.$incrementID;
							
							$UpdateData['random_user_id'] = $randomNumber;
							$UpdateData['increment_id'] = $incrementID;
							
							$this->db->where('user_id', $id);
							$resultUpdateData = $this->db->update('users', $UpdateData);
						} */
						#Employee Number auto generate end here
						
						if( !empty($_FILES['profile_image']['name']) )
						{  
							move_uploaded_file($_FILES['profile_image']['tmp_name'], 'uploads/profile_image/'.$id.'.png');
						}
						
						#Email sent start here
						/* $page_data['staff_registeration'] =1;
						
						$page_data['name'] = $data['first_name'];
						$page_data['mobile_number'] = $data['mobile_number'];
						
						$page_data['email'] = $email = $data['email'];
						$page_data['password'] = $data['original_password'];
						
						$to = $email;
						$from = CONTACT_EMAIL;
						$fromName = CONTACT_NAME;
						$subject = "Staff Login Details";	
						
						$message = $this->load->view('mail_template/admin_mail_template', $page_data, true);
						
						if(EMAIL_TYPE == 2) #SMTP
						{
							$sendMail = Send_SMTP($from,$to,$subject,$message,$fromName);
						}
						else  #Send Grid 
						{
							$sendMail = Send_Grid($from,$to,$subject,$message,$fromName);
						} */
						#Email sent end here
						
						$this->session->set_flashdata('flash_message' , "Employee added Successfully!");
						redirect(base_url() . 'customer/ManageCustomer', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
					
				$page_data['edit_data'] = $this->db->query("select * from users 
				where users.user_id='".$id."' ")->result_array();
				
				if($_POST)
				{
					#Personal details
					
					$data['first_name'] = $this->input->post('first_name');
					$data['email'] = $this->input->post('email'); 
					$data['address1'] = $this->input->post('address1'); 
					$data['mobile_number'] = isset($_POST['mobile_number']) ? $_POST['mobile_number'] :"";
					$data['country_id'] = $this->input->post('country_id');
					$data['state_id'] = $this->input->post('state_id');
					$data['city_id'] = $this->input->post('city_id');
					$data['gst_number'] = $this->input->post('gst_number');
					$data['pan_number'] = $this->input->post('pan_number');
					$this->db->where('user_id', $id);
					$result = $this->db->update('users', $data);
					
					if($result)
					{
						
						$this->session->set_flashdata('flash_message' , "Customer updated Successfully!");
						redirect(base_url() . 'customer/ManageCustomer', 'refresh');
					}
					
				}
			break;
			
			case "view": #view
				$query = "
					select customer.*,
					vb_customer_address.address,
					vb_customer_address.pin_code,
					vb_customer_address.land_mark
					
					from users as customer
					
					left join vb_customer_address on vb_customer_address.user_id = customer.user_id
					where customer.user_id='".$id."' 
				";
				
				$page_data['edit_data'] = $this->db->query($query)->result_array();
				
			break;
			
			case "addresslist": #addresslist
				
				$query = "
					select 
					customer.user_id,
					customer.first_name,
					customer.email,
					customer.mobile_number,
					vb_customer_address.address,
					vb_customer_address.full_name,
					vb_customer_address.locality,
					vb_customer_address.land_mark,
					vb_customer_address.alternative_number,
					vb_customer_address.pin_code
					
					from users as customer
					
					left join vb_customer_address on vb_customer_address.user_id = customer.user_id
					
					where customer.user_id='".$id."' 
				";
				
				$page_data['edit_data'] = $this->db->query($query)->result_array();
				
				$source_type_id = 2;
				$page_data["totalRows"] = $totalRows = $this->customer_model->getManageAddressCount($id);
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('customer/ManageCustomer/addresslist/'.$id.'?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('customer/ManageCustomer/addresslist/'.$id.'?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData'] = $result = $this->customer_model->getManageAddress($limit, $offset, $id);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
			
			case "bookmark": #bookmark
				
				$source_type_id = 2;
				$page_data["totalRows"] = $totalRows = $this->customer_model->getBookmarkCount($id);
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('customer/ManageCustomer/bookmark/'.$id.'?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('customer/ManageCustomer/bookmark/'.$id.'?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['edit_data']  = $result = $this->customer_model->getBookmark($limit, $offset,$id);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
			
			case "wallet": #wallet
				$query = 'select vb_customer_wallet.wallet_amount
				
						from vb_customer_wallet 
						
						left join branch on
							branch.branch_id = vb_customer_wallet.branch_id

						where  vb_customer_wallet.user_id = '.$id;
		
				$result = $this->db->query($query)->result_array();
			
				$page_data["wallet_amount"] = isset($result[0]["wallet_amount"]) ? $result[0]["wallet_amount"] : 0;
			
			break;
			
			case "ordersHistory": #ordersHistory

				$page_data["totalRows"] = $totalRows = $this->customer_model->getOrdersCount($id);#
		
				if(!empty($_SESSION['PAGE']))
				{
					$limit = $_SESSION['PAGE'];
				}else{
					$limit = 10;
				}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('customer/ManageCustomer/ordersHistory/'.$id.'?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('customer/ManageCustomer/ordersHistory/'.$id.'?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['edit_data']  = $result= $this->customer_model->getOrdersHistory($limit, $offset,$id);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
				
			break;

			case "favourite": #favourite
				
				$source_type_id = 2;
				$page_data["totalRows"] = $totalRows = $this->customer_model->getFavouriteOrdersCount($id);
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('customer/ManageCustomer/addresslist/'.$id.'?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('customer/ManageCustomer/addresslist/'.$id.'?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['edit_data'] = $result = $this->customer_model->getFavouriteOrders($limit, $offset, $id);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"] = $total_counts;
				#show start and ending Count end
				
			break;
			
			case "delete": #Delete
				$this->db->where('users_id', $id);
				$this->db->delete('users');
				
				$this->session->set_flashdata('flash_message' , "Customer deleted successfully!");
				redirect(base_url() . 'customer/ManageCustomer', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['user_status'] = 1;
					$succ_msg = 'Employee Inactivated successfully!';
				}else{
					$data['user_status'] = 0;
					$succ_msg = 'Employee Activated successfully!';
				}
				$this->db->where('user_id', $id);
				$this->db->update('users', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'customer/ManageCustomer', 'refresh');
			break;			
			
			case "export": #Block & Unblock
				$condition = " 1=1 and customer.register_type =2"; #2=> Customer
				$query = "select 
					customer.user_id,
					customer.user_status,
					customer.first_name,
					customer.mobile_number,
					customer.email,
					customer.address1,
					customer.gst_number,
					customer.pan_number,
					customer.joined_date
					
					from users as customer
					
					where $condition
						order by customer.user_id desc
					";
			
				$result = $this->db->query($query)->result_array();
				
				header("Content-type: application/csv");
				header("Content-Disposition: attachment; filename=\"customer_list".".csv\"");
				header("Pragma: no-cache");
				header("Expires: 0");

				$handle = fopen('php://output', 'w');
				fputcsv($handle, array("S.No","Customer Name","Email","Mobile Number","Address","GST Number","PAN Number","Created Date"));
				
				$cnt=1;
				foreach ($result as $row) 
				{
					if(!empty($row['joined_date']))
					{
						$joined_date = date('d-M-Y h:i:s a',$row['joined_date']);
					}else{$joined_date = '';}
					
					$narray=array(
							$cnt,
							ucfirst($row['first_name']),
							$row['email'],
							$row['mobile_number'],
							ucfirst($row['address1']),
							strtoupper($row['gst_number']),
							strtoupper($row['pan_number']),
							$joined_date
						);
					fputcsv($handle, $narray);
					$cnt++;
				}
				fclose($handle);
				exit;
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->customer_model->getManageCustomerCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('customer/ManageCustomer?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('customer/ManageCustomer?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result = $this->customer_model->getManageCustomer($limit, $offset);
			
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}

	function viewCustomerDetails($id = '')
	{
		if (empty($this->user_id))
		{
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['id'] = $id;
		
		$page_data['ManageCustomer'] = 1;
		$page_data['page_name']  = 'customer/viewCustomerDetails';
		$page_data['page_title'] = 'View Customer ';
		
		#View
		$page_data["totalRows"] = $totalRows = $this->customer_model->customerOrderHistoryCount($id);

		if(!empty($_SESSION['PAGE']))
		{$limit = $_SESSION['PAGE'];
		}else{$limit = 10;}
		
		if (!empty($_GET['keywords'])) {
			$base_url = base_url('customer/ManageCustomer?keywords='.$_GET['keywords']);
		} else {
			$base_url = base_url('customer/ManageCustomer?keywords=');
		}
		
		$config = PaginationConfig($base_url,$totalRows,$limit);
		$this->pagination->initialize($config);
		$str_links = $this->pagination->create_links();
		$page_data['pagination'] = explode('&nbsp;', $str_links);
		$offset = 0;
		if (!empty($_GET['per_page'])) {
			$pageNo = $_GET['per_page'];
			$offset = ($pageNo - 1) * $limit;
		}
		
		if($offset == 1 || $offset== "" || $offset== 0){
			$page_data["first_item"] = 1;
		}else{
			$page_data["first_item"] = $offset + 1;
		}
		
		$page_data['order_history'] 	= $this->customer_model->customerOrderHistory($id,$limit, $offset);
		$page_data['customer_details'] 	=  $this->db->query("select * from users 
											where users.user_id='".$id."' ")->result_array();;
	
		#show start and ending Count
		$total_counts = $total_count= 0;
		$pages=$page_data["starting"] = $page_data["ending"]="";
		$pageno = isset($pageNo) ? $pageNo :"";
		
		if( $totalRows == 0 ){
			$page_data["starting"] = 0;
		}else if( $pageno==1 || $pageno=="" ){
			$page_data["starting"] = 1;
		}else{
			$pages = $pageno-1;
			$total_count = $pages * $config["per_page"];
			$page_data["starting"] = ( $config["per_page"] * $pages )+1;
		}
		
		$total_counts = $total_count + count($result);
		$page_data["ending"]  = $total_counts;
		#show start and ending Count end
		
		
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	#Employee_Mailexist
	public function EmailExist()
	{
		if ( isset($_POST['email_check']) && $_POST['email_check'] == 1) 
		{
			$email = $_POST['email'];
			#$register_type = $_POST['register_type'];
			
			$results = $this->db->query("select user_id from users WHERE email='".$email."' ")->result_array(); #and register_type='".$register_type."'
			if ( count($results) > 0 ) {
				echo "taken";	
			}else{
				echo 'not_taken';
			}
			exit();
		}
	}
	
	public function MobileExist()
	{
		if ( isset($_POST['mob_check']) && $_POST['mob_check'] == 1) 
		{
			$mobile_number = $_POST['mobile_number'];
			#$register_type = $_POST['register_type'];
			
			$results = $this->db->query("select user_id from users WHERE phone_number='".$phone_number."' ")->result_array(); #and register_type='".$register_type."'
			if ( count($results) > 0 ) {
				echo "taken";	
			}else{
				echo 'not_taken';
			}
			exit();
		}
	}
	#Controller End
	
	public function UsernameExist()
	{
		if ( isset($_POST['user_name_check']) && $_POST['user_name_check'] == 1) 
		{
			$user_name = $_POST['user_name'];
			#$register_type = $_POST['register_type'];
			
			$results = $this->db->query("select user_id from users WHERE user_name='".$user_name."' ")->result_array(); #and register_type='".$register_type."'
			if ( count($results) > 0 ) {
				echo "taken";	
			}else{
				echo 'not_taken';
			}
			exit();
		}
	}
}
?>
