<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Employee extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function ManageEmployee($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageEmployee'] = 1;
		$page_data['page_name']  = 'employee/ManageEmployee';
		$page_data['page_title'] = 'Manage Users';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					#Personal details
					$data['mobile_number'] = isset($_POST['mobile_number']) ? $_POST['mobile_number'] :"";
					$data['branch_id'] = $this->input->post('branch_id'); 
					
					$ChkEmpnumber = $this->db->query("select user_id from users 
						where 
							mobile_number='".$data['mobile_number']."' and
								branch_id='".$data['branch_id']."'
							")->result_array();
							
					if( count($ChkEmpnumber) > 0)
					{
						$this->session->set_flashdata('error_message' , "Sorry! User Already exist!");
						redirect($_SERVER['HTTP_REFERER'], 'refresh');
					}
					
					$data['first_name'] = $this->input->post('first_name');
					$data['role_id'] = $this->input->post('role_id'); 
					$data['mobile_number'] = isset($_POST['mobile_number']) ? $_POST['mobile_number'] :"";
					$data['employeement_type'] = $this->input->post('employeement_type');
					
					$data['email'] = $this->input->post('email'); 
					$data['gender'] = $this->input->post('gender'); 
					$data['marital_status'] = $this->input->post('marital_status'); 
					$data['qualification_id'] = $this->input->post('qualification_id'); 
					$data['department_id'] = $this->input->post('department_id'); 
					$data['date_of_birth'] = $this->input->post('date_of_birth'); 
					$data['date_of_joining'] = $this->input->post('date_of_joining'); 
					$data['designation_id'] = $this->input->post('designation_id'); 
					
					#Login Details
					$data['user_name'] = $this->input->post('user_name');
					$data['password'] = md5($_POST['password']);
					$data['original_password'] = $_POST['password']; 
					
					$data['joined_date'] = strtotime(date('d-M-Y h:i:s a',time()));
					$data['user_status'] = 1;
					$data['register_type'] = 1; #Employee
					
					#Customer Login Details
					
					$data['user_name'] = $_POST['user_name'];
					$data['password'] = md5($_POST['password']);
					$data['original_password'] = $_POST['password'];
				
					$this->db->insert('users', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						#Employee / Dealer Number auto generate Start here
						/* if($data['register_type'] == 1) #Employee
						{
							$results = $this->db->query("select increment_id from users where (register_type = '".$data['register_type']."' and register_type != 0) order by increment_id desc")->result_array();
							if( isset($results[0]['increment_id']) && $results[0]['increment_id'] == 0 )
							{
								$incrementID = 1;
							}
							else
							{
								$incrementID = $results[0]['increment_id'] + 1;
							}
							
							$randomNumber = 'EMP-000'.$incrementID;
							
							$UpdateData['random_user_id'] = $randomNumber;
							$UpdateData['increment_id'] = $incrementID;
							
							$this->db->where('user_id', $id);
							$resultUpdateData = $this->db->update('users', $UpdateData);
						} */
						#Employee Number auto generate end here
						
						if( !empty($_FILES['profile_image']['name']) )
						{  
							move_uploaded_file($_FILES['profile_image']['tmp_name'], 'uploads/profile_image/'.$id.'.png');
						}
						
						#Email sent start here
						/* $page_data['staff_registeration'] =1;
						
						$page_data['name'] = $data['first_name'];
						$page_data['mobile_number'] = $data['mobile_number'];
						
						$page_data['email'] = $email = $data['email'];
						$page_data['password'] = $data['original_password'];
						
						$to = $email;
						$from = CONTACT_EMAIL;
						$fromName = CONTACT_NAME;
						$subject = "Staff Login Details";	
						
						$message = $this->load->view('mail_template/admin_mail_template', $page_data, true);
						
						if(EMAIL_TYPE == 2) #SMTP
						{
							$sendMail = Send_SMTP($from,$to,$subject,$message,$fromName);
						}
						else  #Send Grid 
						{
							$sendMail = Send_Grid($from,$to,$subject,$message,$fromName);
						} */
						#Email sent end here
						
						$this->session->set_flashdata('flash_message' , "User added Successfully!");
						redirect(base_url() . 'employee/ManageEmployee', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
					
				$page_data['edit_data'] = $this->db->query("select * from users 
				where users.user_id='".$id."' ")->result_array();
				
				if($_POST)
				{
					#Personal details
					$data['mobile_number'] = isset($_POST['mobile_number']) ? $_POST['mobile_number'] :"";
					$data['branch_id'] = $this->input->post('branch_id'); 
					
					$ChkEmpnumber = $this->db->query("select user_id from users 
						where 
							mobile_number='".$data['mobile_number']."' and
								branch_id='".$data['branch_id']."' and
									user_id !='".$id."'
							")->result_array();
					if( count($ChkEmpnumber) > 0)
					{
						$this->session->set_flashdata('error_message' , "Sorry! User Already exist!");
						redirect($_SERVER['HTTP_REFERER'], 'refresh');
					}
					
					$data['first_name'] = $this->input->post('first_name');
					$data['role_id'] = $this->input->post('role_id'); 
					$data['mobile_number'] = isset($_POST['mobile_number']) ? $_POST['mobile_number'] :"";
					$data['employeement_type'] = $this->input->post('employeement_type');
					
					$data['email'] = $this->input->post('email'); 
					$data['gender'] = $this->input->post('gender'); 
					$data['marital_status'] = $this->input->post('marital_status'); 
					$data['qualification_id'] = $this->input->post('qualification_id'); 
					$data['department_id'] = $this->input->post('department_id'); 
					$data['date_of_birth'] = $this->input->post('date_of_birth'); 
					$data['date_of_joining'] = $this->input->post('date_of_joining'); 
					$data['designation_id'] = $this->input->post('designation_id'); 
					$data['user_name'] = $_POST['user_name'];
					
					$this->db->where('user_id', $id);
					$result = $this->db->update('users', $data);
					
					if($result)
					{
						if( !empty($_FILES['profile_image']['name']) )
						{  
							move_uploaded_file($_FILES['profile_image']['tmp_name'], 'uploads/profile_image/'.$id.'.png');
						}
						
						$this->session->set_flashdata('flash_message' , "User updated Successfully!");
						redirect(base_url() . 'employee/ManageEmployee', 'refresh');
					}
				}
			break;
			
			case "view": #view
				$query = "
					select 
					users.first_name,
					users.middle_name,
					users.last_name,
					users.email,
					users.mobile_number,
					
					users.user_status,
					users.random_user_id,
					users.gender,
					users.date_of_birth,
					users.date_of_joining,
					users.marital_status,
					
					users.qualification_id,
					
					users.pan_number,
					
					
					users.bank_account_no,
					users.bank_name,
					users.ifsc_code,
					users.branch,
					users.last_working_date,
					
					branch.branch_name,
					department.department_name,
					designation.designation_name,
					org_roles.role_name
					
					
					from users
					left join branch on branch.branch_id = users.branch_id
					left join emp_departments as department on department.department_id = users.department_id
					left join emp_designations as designation on designation.designation_id = users.designation_id
					left join org_roles on org_roles.role_id = users.role_id
					where users.user_id='".$id."' 
				";
				$page_data['edit_data'] = $this->db->query($query)->result_array();
			break;
			
			case "change_password": #Block & Unblock
				$data['password']             = md5($this->input->post('password'));
				$data['new_password']         = md5($this->input->post('new_password'));
				$data['confirm_new_password'] = md5($this->input->post('confirm_new_password'));

				$current_password = $this->db->get_where('users', array('user_id' => $id))->row()->password;
				
				if ($current_password == $data['password'] && $data['new_password'] == $data['confirm_new_password']) 
				{
					$this->db->where('user_id', $id);
					$this->db->update('users', array('password' => $data['new_password'],'original_password' => $_POST['new_password'] ));
					$this->session->set_flashdata('flash_message', get_phrase('password_changed_successfully'));
				} 
				else 
				{
					$this->session->set_flashdata('error_message', get_phrase('password_mismatch'));
				}
				redirect(base_url() . 'employee/ManageEmployee', 'refresh');
			break;
			
			case "delete": #Delete
				$this->db->where('users_id', $id);
				$this->db->delete('users');
				
				$this->session->set_flashdata('flash_message' , "Customer deleted successfully!");
				redirect(base_url() . 'employee/ManageEmployee', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['user_status'] = 1;
					$succ_msg = 'Employee activated successfully!';
				}else{
					$data['user_status'] = 0;
					$succ_msg = 'Employee inactivated successfully!';
				}
				$this->db->where('user_id', $id);
				$this->db->update('users', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'employee/ManageEmployee', 'refresh');
			break;
			
			case "export": #Block & Unblock
				$condition = " 1=1 and employee.register_type =1";
				$query = "select 
						employee.user_id,
						employee.user_status,
						employee.random_user_id,
						employee.uan_number,
						employee.member_id,
						employee.gender,
						employee.date_of_birth,
						employee.date_of_joining,
						employee.last_working_date,
						employee.original_password,
						employee.create_attendance,
						employee.user_name,
						employee.first_name,
						employee.last_name,
						employee.middle_name,
						employee.mobile_number,
						employee.joined_date,
						org_roles.role_name,
						org_roles.role_id,
						employee.employeement_type
						
				from users as employee
				left join org_roles on org_roles.role_id = employee.role_id
				where $condition
				";
			
				$result = $this->db->query($query)->result_array();
				
				header("Content-type: application/csv");
				header("Content-Disposition: attachment; filename=\"employee_list".".csv\"");
				header("Pragma: no-cache");
				header("Expires: 0");

				$handle = fopen('php://output', 'w');
				fputcsv($handle, array("S.No","Employee Role","Employment Type","Emp No","UAN Number","Member ID","Employee Name","Gender","DOB","DOJ"));
				
				$cnt=1;
				foreach ($result as $row) 
				{
					$gender ="";
					foreach($this->gender as $key=>$value)
					{
						if($row['gender'] == $key)
						{
							$gender .=$value;
						}
					}
					
					$employeement_type ="";
					foreach($this->employeementType as $key=>$value)
					{
						if($row['employeement_type'] == $key)
						{
							$employeement_type .=$value;
						}
					}
					
					$narray=array(
							$cnt,
							ucfirst($row['role_name']),
							$employeement_type,
							$row['random_user_id'],
							$row['uan_number'],
							$row['member_id'],
							ucfirst($row['first_name'])." ".ucfirst($row['middle_name'])." ".ucfirst($row['last_name']),
							$gender,
							$row['date_of_birth'],
							$row['date_of_joining']
						);
					fputcsv($handle, $narray);
					$cnt++;
				}
				fclose($handle);
				exit;
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->employee_model->getManageEmployeeCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('employee/ManageEmployee?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('employee/ManageEmployee?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result = $this->employee_model->getManageEmployee($limit, $offset);
			
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	#Employee_Mailexist
	public function EmailExist()
	{
		if ( isset($_POST['email_check']) && $_POST['email_check'] == 1) 
		{
			$email = $_POST['email'];
			#$register_type = $_POST['register_type'];
			
			$results = $this->db->query("select user_id from users WHERE email='".$email."' ")->result_array(); #and register_type='".$register_type."'
			if ( count($results) > 0 ) {
				echo "taken";	
			}else{
				echo 'not_taken';
			}
			exit();
		}
	}
	
	public function MobileExist()
	{
		if ( isset($_POST['mob_check']) && $_POST['mob_check'] == 1) 
		{
			$mobile_number = $_POST['mobile_number'];
			$register_type = $_POST['register_type'];
			
			$results = $this->db->query("select user_id from users WHERE mobile_number='".$mobile_number."' and register_type='".$register_type."' ")->result_array(); #and register_type='".$register_type."'
			if ( count($results) > 0 ) {
				echo "taken";	
			}else{
				echo 'not_taken';
			}
			exit();
		}
	}
	
	
	#Manage Qualification
    function manage_qualification($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/login', 'refresh');
		}
		
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageEmployee'] = 1;
		
		$page_data['page_name']  = 'employee/manage_qualification';
		$page_data['page_title'] = 'Manage Qualification';
		
		switch($type)
		{
			case "add": #Add
				if($_POST)
				{
					$data['qualification_name'] = $this->input->post('qualification_name');
					$data['qualification_status'] = 1;
					
					# Qualification exist start here
						$chkExistQualification = $this->db->query("select qualification_id from qualification
							where 
								qualification_name='".$data['qualification_name']."'
								")->result_array();
								
						if(count($chkExistQualification) > 0)
						{
							$this->session->set_flashdata('error_message' , " Qualification Name already exist!");
							redirect(base_url() . 'employee/manage_qualification/add', 'refresh');
						}
					# Qualification exist end here
					
					$this->db->insert('qualification', $data);
					$id = $this->db->insert_id();
					if($id !="")
					{
						$this->session->set_flashdata('flash_message' ,'Qualification Added Successfully!');
						redirect(base_url() . 'employee/manage_qualification', 'refresh');
					}
				}
			break;
			
			case "edit": #Edit
				$page_data['edit_data'] = $this->db->get_where('qualification', array('qualification_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['qualification_name'] = $this->input->post('qualification_name');
					
					# Qualification exist start here
						$chkExistQualification = $this->db->query("select qualification_id from qualification
							where 
								qualification_id !='".$id."' and
								
									(qualification_name='".$data['qualification_name']."')
										")->result_array();
								
						if(count($chkExistQualification) > 0)
						{
							$this->session->set_flashdata('error_message' , " Qualification already exist!");
							redirect(base_url() . 'employee/manage_qualification/edit/'.$id, 'refresh');
						}
					# Qualification exist end here
					
					$this->db->where('qualification_id', $id);
					$result = $this->db->update('qualification', $data);
					if($result > 0)
					{
						$this->session->set_flashdata('flash_message' , 'Qualification Updated Successfully!');
						redirect(base_url() . 'employee/manage_qualification', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('qualification_id', $id);
				$this->db->delete('qualification');
				$this->session->set_flashdata('flash_message' , get_phrase('qualification_deleted_successfully!'));
				redirect(base_url() . 'employee/manage_qualification', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['qualification_status'] = 1;
					$succ_msg = 'Qualification unblocked successfully!';
				}else{
					$data['qualification_status'] = 0;
					$succ_msg = 'Qualification blocked successfully!';
				}
				$this->db->where('qualification_id', $id);
				$this->db->update('qualification', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'employee/manage_qualification', 'refresh');
			break;
			
			default : #Manage
				$page_data['qualification'] = $result = $this->db->query("select qualification.* from qualification
				")->result_array();
			break;
		}
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	
	function ManageDesignation($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageEmployee'] = 1;
		
		$page_data['page_name']  = 'employee/ManageDesignation';
		$page_data['page_title'] = 'Manage Designation';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['designation_name'] = $this->input->post('designation_name');
					
					$ChkExist = $this->db->query("select designation_id from emp_designations where designation_name='".$data['designation_name']."' ")->result_array();
					
					if( count($ChkExist) > 0)
					{
						$this->session->set_flashdata('error_message' , "Sorry! Designation Already exist!");
						redirect($_SERVER['HTTP_REFERER'], 'refresh');
					}
					
					$data['designation_description'] = $this->input->post('designation_description');
					$data['designation_status'] = 1;
					
					$this->db->insert('emp_designations', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						$this->session->set_flashdata('flash_message' , "Designation added Successfully!");
						redirect(base_url() . 'employee/ManageDesignation', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
					
				$page_data['edit_data'] = $this->db->query("select * from emp_designations 
				where designation_id='".$id."' ")->result_array();
				
				if($_POST)
				{
					$data['designation_name'] = $this->input->post('designation_name');
					
					$ChkExist = $this->db->query("select designation_id from emp_designations where designation_name='".$data['designation_name']."' AND designation_id !='".$id."' ")->result_array();
					
					if( count($ChkExist) > 0)
					{
						$this->session->set_flashdata('error_message' , "Sorry! Designation Already exist!");
						redirect($_SERVER['HTTP_REFERER'], 'refresh');
					}
					$data['designation_description'] = $this->input->post('designation_description');
					
					$this->db->where('designation_id', $id);
					$result = $this->db->update('emp_designations', $data);
					
					if($result)
					{
						$this->session->set_flashdata('flash_message' , "Designation updated Successfully!");
						redirect(base_url() . 'employee/ManageDesignation', 'refresh');
					}
				}
			break;
			
			/* case "delete": #Delete
				$this->db->where('expenses_id', $id);
				$this->db->delete('users');
				
				$this->session->set_flashdata('flash_message' , "Customer deleted successfully!");
				redirect(base_url() . 'employee/ManageEmployee', 'refresh');
			break; */
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['designation_status'] = 1;
					$succ_msg = 'Designation unblocked successfully!';
				}else{
					$data['designation_status'] = 0;
					$succ_msg = 'Designation blocked successfully!';
				}
				$this->db->where('designation_id', $id);
				$this->db->update('emp_designations', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'employee/ManageDesignation', 'refresh');
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->employee_model->getManageDesinationsCount();
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('employee/ManageDesignation?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('employee/ManageDesignation?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result = $this->employee_model->getManageDesinations($limit, $offset);
			
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	function ManageDepartment($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageEmployee'] = 1;
		
		$page_data['page_name']  = 'employee/ManageDepartment';
		$page_data['page_title'] = 'Manage Department';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['department_name'] = $this->input->post('department_name');
					
					$ChkExist = $this->db->query("select department_id from emp_departments where department_name='".$data['department_name']."' ")->result_array();
					
					if( count($ChkExist) > 0)
					{
						$this->session->set_flashdata('error_message' , "Sorry! Department Already exist!");
						redirect($_SERVER['HTTP_REFERER'], 'refresh');
					}
					
					$data['department_description'] = $this->input->post('department_description');
					$data['department_status'] = 1;
					
					$this->db->insert('emp_departments', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						$this->session->set_flashdata('flash_message' , "Department added Successfully!");
						redirect(base_url() . 'employee/ManageDepartment', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
					
				$page_data['edit_data'] = $this->db->query("select * from emp_departments 
				where department_id='".$id."' ")->result_array();
				
				if($_POST)
				{
					$data['department_name'] = $this->input->post('department_name');
					
					$ChkExist = $this->db->query("select department_id from emp_departments where department_name='".$data['department_name']."' AND department_id !='".$id."' ")->result_array();
					
					if( count($ChkExist) > 0)
					{
						$this->session->set_flashdata('error_message' , "Sorry! Department Already exist!");
						redirect($_SERVER['HTTP_REFERER'], 'refresh');
					}
					$data['department_description'] = $this->input->post('department_description');
					
					$this->db->where('department_id', $id);
					$result = $this->db->update('emp_departments', $data);
					
					if($result)
					{
						$this->session->set_flashdata('flash_message' , "Department updated Successfully!");
						redirect(base_url() . 'employee/ManageDepartment', 'refresh');
					}
				}
			break;
			
			/* case "delete": #Delete
				$this->db->where('expenses_id', $id);
				$this->db->delete('users');
				
				$this->session->set_flashdata('flash_message' , "Customer deleted successfully!");
				redirect(base_url() . 'employee/ManageEmployee', 'refresh');
			break; */
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['department_status'] = 1;
					$succ_msg = 'Department unblocked successfully!';
				}else{
					$data['department_status'] = 0;
					$succ_msg = 'Department blocked successfully!';
				}
				$this->db->where('department_id', $id);
				$this->db->update('emp_departments', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'employee/ManageDepartment', 'refresh');
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->employee_model->getManageDepartmentCount();
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('employee/ManageDepartment?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('employee/ManageDepartment?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result = $this->employee_model->getManageDepartment($limit, $offset);
			
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	public function UsernameExist()
	{
		if ( isset($_POST['user_name_check']) && $_POST['user_name_check'] == 1) 
		{
			$user_name = $_POST['user_name'];
			#$register_type = $_POST['register_type'];
			
			$results = $this->db->query("select user_id from users WHERE user_name='".$user_name."' or email='".$user_name."' ")->result_array(); #and register_type='".$register_type."'
			if ( count($results) > 0 ) {
				echo "taken";	
			}else{
				echo 'not_taken';
			}
			exit();
		}
	}
	
	
}
?>
