<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Expense extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function ManageExpense($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageExpense'] = 1;
		$page_data['page_name']  = 'expense/ManageExpense';
		$page_data['page_title'] = 'Manage Expense';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['expense_date'] 		= $this->input->post('expense_date');
					$data['expense_str_date'] 	= strtotime($_POST['expense_date']);
					$data['particulars'] 		= $this->input->post('particulars');
					$data['amount'] 			= $this->input->post('amount');
					$data['payment_type'] 		= $this->input->post('payment_type');
					$data['description'] 		= $this->input->post('description');
					$data['expense_title'] 		= $this->input->post('expense_title');
					$data['expense_type_id'] 	= $this->input->post('expense_type_id');
					
					$data['project_id'] = $this->input->post('project_id');
					
					$data['created_date'] = time();
					
					$this->db->insert('expense', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{	
						#Candidate UserID Start here
						$results = $this->db->query("select increment_id from expense order by increment_id desc")->result_array();
						if( isset($results[0]['increment_id']) && $results[0]['increment_id'] == 0 )
						{
							$incrementID = 1;
						}
						else
						{
							$incrementID = $results[0]['increment_id'] + 1;
						}
						
						$random_user_id =  "EXP-000".$incrementID;
						
						$UpdateData['random_user_id'] = $random_user_id;
						$UpdateData['increment_id'] = $incrementID;
						
						$this->db->where('expense_id', $id);
						$resultUpdateData = $this->db->update('expense', $UpdateData);
						#receipt_id end here
						
						if( !empty($_FILES['receipt']['name']) )
						{  
							move_uploaded_file($_FILES['receipt']['tmp_name'], 'uploads/expense_receipt/'.$id.'.png');
						}
						
						$this->session->set_flashdata('flash_message' , "Expense added Successfully!");
						#redirect($_SERVER['HTTP_REFERER'], 'refresh');
						redirect(base_url() . 'expense/ManageExpense', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('expense', array('expense_id' => $id))
										->result_array();
				if($_POST)
				{
					$random_user_id = $this->input->post('random_user_id');
					/* $ChkRandomUserId = $this->db->query("select expense_id from expense where expense_id !='".$id."' and random_user_id='".$random_user_id."'")->result_array();
					if( count($ChkRandomUserId) > 0)
					{
						$this->session->set_flashdata('error_message' , "Sorry! Already exist Receipt Number!");
						redirect($_SERVER['HTTP_REFERER'], 'refresh');
					} */
					#$data['random_user_id'] = $this->input->post('random_user_id');
					$data['expense_date'] = $this->input->post('expense_date');
					$data['expense_str_date'] =strtotime($_POST['expense_date']);
					$data['particulars'] = $this->input->post('particulars');
					$data['amount'] = $this->input->post('amount');
					$data['payment_type'] = $this->input->post('payment_type');
					$data['description'] = $this->input->post('description');
					$data['expense_title'] = $this->input->post('expense_title');
					$data['project_id'] = $this->input->post('project_id');
					$data['expense_type_id'] = $this->input->post('expense_type_id');
					
					$this->db->where('expense_id', $id);
					$result = $this->db->update('expense', $data);
					
					if($result)
					{
						if( !empty($_FILES['receipt']['name']) )
						{  
							move_uploaded_file($_FILES['receipt']['tmp_name'], 'uploads/expense_receipt/'.$id.'.png');
						}
						
						$this->session->set_flashdata('flash_message' , "Expense updated Successfully!");
						redirect(base_url() . 'expense/ManageExpense', 'refresh');
						#redirect($_SERVER['HTTP_REFERER'], 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('expense_id', $id);
				$this->db->delete('expense');
				
				$this->session->set_flashdata('flash_message' , "Expense deleted successfully!");
				redirect(base_url() . 'expense/ManageExpense', 'refresh');
			break;
			
			case "export":
			
				$data = $this->db->query("select 
				expense.*,
				expense_particulars.particular_name,
				expense_payment_type.payment_type,
				org_projects.project_code,			
				org_projects.project_description
				from expense 
				
				left join expense_particulars on expense_particulars.particular_id = expense.particulars
				left join expense_payment_type on expense_payment_type.payment_type_id = expense.payment_type
				left join org_projects on org_projects.project_id = expense.project_id
				
				order by expense_id desc")->result_array();
				
				#$data[] = array('f_name'=> "Nishit", 'l_name'=> "patel", 'mobile'=> "999999999", 'gender'=> "male");
				
				header("Content-type: application/csv");
				header("Content-Disposition: attachment; filename=\"Expense".".csv\"");
				header("Pragma: no-cache");
				header("Expires: 0");

				$handle = fopen('php://output', 'w');
				fputcsv($handle, array("S.No","Expense No.","Project Code","Project Name","Expense Date","Particulars","Payment Type","Amount"));
				$cnt=1;
				foreach ($data as $row) 
				{
					$narray=array(
							$cnt,
							$row["random_user_id"],
							$row["project_code"],
							ucfirst($row['project_description']),
							$row["expense_date"],
							ucfirst($row["particular_name"]),
							$row["payment_type"],
							number_format($row['amount'],DECIMAL_VALUE,'.','')
					);
					
					fputcsv($handle, $narray);
					$cnt++;
				}
				fclose($handle);
				exit;
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->expense_model->getManageExpenseCount();
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET)) 
				{
					if (!empty($_GET['export'])) 
					{
						$base_url = base_url().'expense/ManageExpense?from_date='.$_GET['from_date'].'&to_date='.$_GET['to_date'].'&keywords='.$_GET['keywords'].'&export=export';
					}
					else
					{
						$base_url = base_url().'expense/ManageExpense?from_date='.$_GET['from_date'].'&to_date='.$_GET['to_date'].'&keywords='.$_GET['keywords'];
					}
				} 
				else 
				{
					$base_url = base_url().'expense/ManageExpense';
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $data =$this->expense_model->getManageExpense($limit, $offset);
				#Export Option
				$export = isset($_GET['export']) ? $_GET['export']:"";
				if(!empty($export))
				{
					$date = date('d_M_Y');
					header("Content-type: application/csv");
					header("Content-Disposition: attachment; filename=\"Expense_".$date.".csv\"");
					header("Pragma: no-cache");
					header("Expires: 0");

					$handle = fopen('php://output', 'w');
					fputcsv($handle, array("S.No","Expense No.","Project Code","Project Name","Expense Date","Particulars","Payment Type","Amount"));
					$cnt=1;
					foreach ($data as $row) 
					{
						$narray=array(
								$cnt,
								$row["random_user_id"],
								$row["project_code"],
								ucfirst($row['project_description']),
								$row["expense_date"],
								ucfirst($row["particular_name"]),
								$row["payment_type"],
								number_format($row['amount'],DECIMAL_VALUE,'.','')
						);
						fputcsv($handle, $narray);
						$cnt++;
					}
					fclose($handle);
					exit;
				}
				#Export Option end
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	function ManageParticulars($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageExpense'] = 1;
		$page_data['page_name']  = 'expense/ManageParticulars';
		$page_data['page_title'] = 'Manage Particulars';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['particular_name'] = ucfirst($this->input->post('particular_name'));
					$data['particular_status'] = 1;
					
					#particular exist start here
						$chkExistParticulars = $this->db->query("select particular_id from expense_particulars 
							where 
								particular_name='".$data['particular_name']."' 
								")->result_array();
								
						if(count($chkExistParticulars) > 0)
						{
							$this->session->set_flashdata('error_message' , "particular Name already exist!");
							redirect(base_url() . 'expense/ManageParticulars/add', 'refresh');
						}
					#particular exist end here
					
					$this->db->insert('expense_particulars', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{	
						$this->session->set_flashdata('flash_message' , "Particular added Successfully!");
						redirect(base_url() . 'expense/ManageParticulars', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('expense_particulars', array('particular_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['particular_name'] = ucfirst($this->input->post('particular_name'));
					
					#particular exist start here
						$chkExistParticulars = $this->db->query("select particular_id from expense_particulars 
							where 
							particular_id !='".$id."' and 
								( particular_name='".$data['particular_name']."' )
								")->result_array();
								
						if(count($chkExistParticulars) > 0)
						{
							$this->session->set_flashdata('error_message' , "particular Name already exist!");
							redirect(base_url() . 'expense/ManageParticulars/edit'.$id, 'refresh');
						}
					#particular exist end here
					
					$this->db->where('particular_id', $id);
					$result = $this->db->update('expense_particulars', $data);
					
					if($result)
					{
						$this->session->set_flashdata('flash_message' , "Particular updated Successfully!");
						redirect(base_url() . 'expense/ManageParticulars', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('particular_id', $id);
				$this->db->delete('expense_particulars');
				
				$this->session->set_flashdata('flash_message' , "Particular deleted successfully!");
				redirect(base_url() . 'expense/ManageParticulars', 'refresh');
			break;
			
			case "status": #Block & Unblock
			
				if($status == 1){
					$data['particular_status'] = 1;
					$succ_msg = 'Particular unblocked successfully!';
				}else{
					$data['particular_status'] = 0;
					$succ_msg = 'Particular blocked successfully!';
				}
				$this->db->where('particular_id', $id);
				$this->db->update('expense_particulars', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'expense/ManageParticulars', 'refresh');
			break;
			
			case "export":
			
				$data = $this->db->query("select * from expense_particulars order by particular_id desc")->result_array();
				
				#$data[] = array('f_name'=> "Nishit", 'l_name'=> "patel", 'mobile'=> "999999999", 'gender'=> "male");
				
				header("Content-type: application/csv");
				header("Content-Disposition: attachment; filename=\"Particular".".csv\"");
				header("Pragma: no-cache");
				header("Expires: 0");

				$handle = fopen('php://output', 'w');
				fputcsv($handle, array("S.No","Particular"));
				$cnt=1;
				foreach ($data as $row) 
				{
				
					$narray=array(
							$cnt,
							$row["particular_name"]
						);
					fputcsv($handle, $narray);
					$cnt++;
				}
				fclose($handle);
				exit;
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->expense_model->getManageExpenseParticularCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('expense/ManageParticulars?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('expense/ManageParticulars?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->expense_model->getManageParticular($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	function ManagePaymentType($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['manage_settings'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'expense/ManagePaymentType';
		$page_data['page_title'] = 'Manage Payment Mode';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['payment_type'] 			= $this->input->post('payment_type');
					$data['payment_type_status'] 	= 1;
					$data['sequence_number'] 		= $this->input->post('sequence_number');
					$data['default_payment'] 		= 0;
					
					# PaymentType exist start here
						$chkExistPaymenttype = $this->db->query("select payment_type_id from expense_payment_type
							where 
								payment_type='".$data['payment_type']."'
								")->result_array();
								
						if(count($chkExistPaymenttype) > 0)
						{
							$this->session->set_flashdata('error_message' , " PaymentType already exist!");
							redirect(base_url() . 'expense/ManagePaymentType/add', 'refresh');
						}
					# PaymentType exist end here
					
					$this->db->insert('expense_payment_type', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{	
						if( !empty($_FILES['payment_icon']['name']) )
						{  
							move_uploaded_file($_FILES['payment_icon']['tmp_name'], 'uploads/payments/'.$id.'.png');
						}
						$this->session->set_flashdata('flash_message' , "Payment Type added Successfully!");
						redirect(base_url() . 'expense/ManagePaymentType', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('expense_payment_type', array('payment_type_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['payment_type'] 		= $this->input->post('payment_type');
					$data['sequence_number'] 	= $this->input->post('sequence_number');
					
					# PaymentType exist start here
						
						$chkExistPaymenttype = $this->db->query("select payment_type_id from expense_payment_type
							where 
								payment_type_id !='".$id."' and 
								( payment_type='".$data['payment_type']."' )
								")->result_array();
								
						if(count($chkExistPaymenttype) > 0)
						{
							$this->session->set_flashdata('error_message' , " PaymentType already exist!");
							redirect(base_url() . 'expense/ManagePaymentType/edit/'.$id, 'refresh');
						}
					# PaymentType exist end here
					
					$this->db->where('payment_type_id', $id);
					$result = $this->db->update('expense_payment_type', $data);
					
					if($result)
					{
						if( !empty($_FILES['payment_icon']['name']) )
						{  
							move_uploaded_file($_FILES['payment_icon']['tmp_name'], 'uploads/payments/'.$id.'.png');
						}
						$this->session->set_flashdata('flash_message' , "Payment Type updated Successfully!");
						redirect(base_url() . 'expense/ManagePaymentType', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('payment_type_id', $id);
				$this->db->delete('expense_payment_type');
				
				$this->session->set_flashdata('flash_message' , "Payment Type deleted successfully!");
				redirect(base_url() . 'expense/ManagePaymentType', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['payment_type_status'] = 1;
					$succ_msg = 'Payment Type unblocked successfully!';
				}else{
					$data['payment_type_status'] = 0;
					$succ_msg = 'Payment Type blocked successfully!';
				}
				$this->db->where('payment_type_id', $id);
				$this->db->update('expense_payment_type', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'expense/ManagePaymentType', 'refresh');
			break;
			
			case "export":
			
				$data = $this->db->query("select * from expense_payment_type order by payment_type_id desc")->result_array();
				
				#$data[] = array('f_name'=> "Nishit", 'l_name'=> "patel", 'mobile'=> "999999999", 'gender'=> "male");
				
				header("Content-type: application/csv");
				header("Content-Disposition: attachment; filename=\"PaymentType".".csv\"");
				header("Pragma: no-cache");
				header("Expires: 0");

				$handle = fopen('php://output', 'w');
				fputcsv($handle, array("S.No","Payment Type"));
				$cnt=1;
				foreach ($data as $row) 
				{
					$narray=array(
							$cnt,
							$row["payment_type"]
						);
					fputcsv($handle, $narray);
					$cnt++;
				}
				fclose($handle);
				exit;
			break;
			
			default : #Manage
				if (isset($_POST['default_payemnt_id'])) {
					
					$id = $this->input->post('default_payemnt_id');

					$data['default_payment'] = 0;
					$this->db->where('default_payment',1);
					$result = $this->db->update('expense_payment_type', $data);

					$data['default_payment'] = 1;
					$this->db->where('payment_type_id',$id);
					$result = $this->db->update('expense_payment_type', $data);
				
					if ($result) {
						$this->session->set_flashdata('flash_message' , 'Default Payment Method Updated');
						redirect(base_url() . 'expense/ManagePaymentType', 'refresh');
					}
					
				}

				$page_data["totalRows"] = $totalRows = $this->expense_model->getManageExpensePaymentTypeCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('expense/ManagePaymentType?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('expense/ManagePaymentType?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->expense_model->getManagePaymentType($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	
	
	
}
?>
