<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Menus extends CI_Controller 
{	
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	#Manage Menus
    function manageMenus($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
		
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['manage_settings'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'menus/manageMenus';
		$page_data['page_title'] = 'Manage Menus';
		
		switch($type)
		{
			case "add": #Add
				$page_data['postValue'] ='';
				if($_POST)
				{
					$data['menu_name'] = ucfirst($this->input->post('menu_name'));
					$data['menu_url'] = url($this->input->post('menu_name'));
					
					# Check already exist start here
					$chkExist = $this->db->query("select menu_id from org_menus 
						where 
							menu_name='".$data['menu_name']."' 
							")->result_array();
					
					if( count($chkExist) > 0 )
					{
						$this->session->set_flashdata('error_message' , "Menu already exist!");
						redirect(base_url() . 'menus/manageMenus/add', 'refresh');
					}
					# Check already exist end here
					
					$data['menu_description'] = $this->input->post('menu_description');
					$data['menu_status'] = 1;
					
					$this->db->insert('org_menus', $data);
					$id = $this->db->insert_id();
					if($id !="")
					{
						$this->session->set_flashdata('flash_message' , 'Menu added successfully!');
						redirect(base_url() . 'menus/manageMenus', 'refresh');
					}
				}
			break;
			
			case "edit": #Edit
				$page_data['edit_data'] = $this->db->get_where('org_menus', array('menu_id' => $id))->result_array();
				if($_POST)
				{
					$data['menu_name'] = ucfirst($this->input->post('menu_name'));
					#$data['menu_url'] = url($this->input->post('menu_name'));
					
					# Check already exist start here
					$chkExist = $this->db->query("select menu_id from org_menus 
						where 
							menu_name='".$data['menu_name']."' and
								menu_id !='".$id."'
							")->result_array();
					
					if( count($chkExist) > 0 )
					{
						$this->session->set_flashdata('error_message' , "Menu already exist!");
						redirect(base_url() . 'menus/manageMenus/edit/'.$id, 'refresh');
					}
					# Check already exist end here
					
					$data['menu_description'] = $this->input->post('menu_description');
					
					$this->db->where('menu_id', $id);
					$result = $this->db->update('org_menus', $data);
					
					if($result > 0)
					{
						$this->session->set_flashdata('flash_message' , 'Menu updated successfully!');
						redirect(base_url() . 'menus/manageMenus', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('menu_id', $id);
				$this->db->delete('org_menus');
				$this->session->set_flashdata('flash_message' , 'Menu deleted successfully!');
				redirect(base_url() . 'menus/manageMenus', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['menu_status'] = 1;
					$succ_msg = 'Menu unblocked successfully!';
				}else{
					$data['menu_status'] = 0;
					$succ_msg = 'Menu blocked successfully!';
				}
				$this->db->where('menu_id', $id);
				$this->db->update('org_menus', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'menus/manageMenus', 'refresh');
			break;
			
			default : #Manage
			
				$page_data["totalRows"] = $totalRows = $this->menus_model->getMenusCount();
				
				if(!empty($_SESSION['PAGE'])){
					$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('menus/manageMenus?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('menus/manageMenus?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->menus_model->getMenus($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				if($pageno==1 || $pageno==""){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
				
				
			break;
		}
		$this->load->view($this->adminTemplate, $page_data);
	}
	
}
?>
