<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Orders extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function ManageOrders($type = '', $id = '', $status = '', $status_1 = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
		
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['Orders'] = 1;
		$page_data['page_name']  = 'orders/ManageOrders';
		$page_data['page_title'] = 'Manage Orders';

		if(isset($_POST['delete']) && isset($_POST['checkbox']))
		{
			$cnt=array();
			$cnt=count($_POST['checkbox']);
			
			for($i=0;$i<$cnt;$i++)
			{
				$order_id=$_POST['checkbox'][$i];
				$data['order_status'] = 1;
				$this->db->where('order_id', $order_id);
				$this->db->update('vb_order_header', $data);
			}
			
			$this->session->set_flashdata('flash_message' , "Orders confirmed successfully!");
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		else if(isset($_POST['preparing_order']) && isset($_POST['checkbox']))
		{
			$cnt=array();
			$cnt=count($_POST['checkbox']);
			
			for($i=0;$i<$cnt;$i++)
			{
				$order_id=$_POST['checkbox'][$i];
				$data['order_status'] = 2;
				$this->db->where('order_id', $order_id);
				$this->db->update('vb_order_header', $data);
			}
			
			$this->session->set_flashdata('flash_message' , "Orders prepared successfully!");
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		else if(isset($_POST['deliver_order']) && isset($_POST['checkbox']))
		{
			$cnt=array();
			
			$cnt=count($_POST['checkbox']);
			
			for($i=0;$i<$cnt;$i++)
			{
				$id = $order_id = $_POST['checkbox'][$i];
				
				/* $data['order_status'] = 3;
				$this->db->where('order_id', $order_id);
				$this->db->update('vb_order_header', $data); */
			
				$data['order_status'] = 3;
				$data['delivered_date'] = time();
				$succ_msg = 'Order Deliveried successfully!';
				
				#Wallet start
				$orderQuery = "select 
					vb_order_header.user_id, 
					vb_order_header.order_number, 
					vb_order_header.branch_id,
					vb_order_header.grand_total,
					vb_order_header.payable_amount,
					vb_order_header.paid_status,
					vb_order_header.payment_method,
					users.mobile_number, 
					country.country_code,
					country.currency_code
				from vb_order_header 
				
				left join users on 
					users.user_id = vb_order_header.user_id
					
				left join country on 
					country.country_id = users.country_id
					
				where 
					vb_order_header.order_id='".$id."' ";
				$getOrderDetails = $this->db->query($orderQuery)->result_array();
				
				#Order canceled sms start
				$country_code = $getOrderDetails[0]['country_code'];
				$mobile_number = $getOrderDetails[0]['mobile_number'];
				$order_number = $getOrderDetails[0]['order_number'];
				$payable_amount = $getOrderDetails[0]['payable_amount'];
				$currency_code = $getOrderDetails[0]['currency_code'];
				$otpMobileNumber = $country_code.$mobile_number;
				
				$otpMessage = '#'. $order_number.' Your order is out for delivery. Your Order amount is '.$currency_code.' '.$payable_amount.' - Thank You.  '.strtoupper(SITE_NAME);
				$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
				#Order canceled sms end
				
				$this->db->where('order_id', $order_id);
				$this->db->update('vb_order_header', $data);
			}
			$this->session->set_flashdata('flash_message' , $succ_msg);
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		else if(isset($_POST['cancel_order']) && isset($_POST['checkbox']))
		{
			$cnt=array();
			$cnt=count($_POST['checkbox']);
			
			for($i=0;$i<$cnt;$i++)
			{
				$id = $order_id = $_POST['checkbox'][$i];
				/* $data['order_status'] = 4;
				$this->db->where('order_id', $order_id);
				$this->db->update('vb_order_header', $data); */
				
				$data['order_status'] = 4;
				$data['delivered_date'] = time();
				$succ_msg = 'Order Cancelled successfully!';
				
				#Wallet start
				$orderQuery = "select 
					vb_order_header.user_id, 
					vb_order_header.order_number, 
					vb_order_header.branch_id,
					vb_order_header.grand_total,
					vb_order_header.paid_status,
					vb_order_header.payment_method,
					users.mobile_number, 
					country.country_code
				from vb_order_header 
				
				left join users on 
					users.user_id = vb_order_header.user_id
					
				left join country on 
					country.country_id = users.country_id
					
				where 
					vb_order_header.order_id='".$id."' ";
				$getOrderDetails = $this->db->query($orderQuery)->result_array();
				
				if(count($getOrderDetails) > 0)
				{
					$userID = $getOrderDetails[0]['user_id'];
					$branchID = $getOrderDetails[0]['branch_id'];
					$grandTotal = $getOrderDetails[0]['grand_total'];
					
					$paid_status = $getOrderDetails[0]['paid_status'];
					$payment_method = $getOrderDetails[0]['payment_method'];
					
					if( $payment_method == 1 ) #COD
					{
						if($paid_status == 1) #if paid only added to wallet
						{
							$walletQuery = "select wallet_id from vb_customer_wallet 
							where user_id='".$userID."' ";
							$chkCustomerWallet = $this->db->query($walletQuery)->result_array();
							
							if(count($chkCustomerWallet) > 0) #Update Wallet Amount
							{
								$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount + $grandTotal where user_id = '".$userID."' ";
								$this->db->query($UpdateQuery);
							}
							else #Insert Wallet Amount
							{
								$WalletData['user_id'] = $userID;
								$WalletData['branch_id'] = $branchID;
								$WalletData['wallet_amount'] = $grandTotal;
								
								$this->db->insert('vb_customer_wallet', $WalletData);
								$wallet_id = $this->db->insert_id();
							}
						}
						else if($paid_status != 1) #if not paid no need add wallet
						{
							
						}
						
						#Order canceled sms start
						$country_code = $getOrderDetails[0]['country_code'];
						$mobile_number = $getOrderDetails[0]['mobile_number'];
						$order_number = $getOrderDetails[0]['order_number'];
						$otpMobileNumber = $country_code.$mobile_number;
						
						$otpMessage = '#'. $order_number.' Your order has been cancelled. Sorry for the inconvenience, amount has been refunded to wallet. '.strtoupper(SITE_NAME);
						$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
						
						#Order canceled sms end
					}
					else #Card
					{
						$walletQuery = "select wallet_id from vb_customer_wallet 
							where user_id='".$userID."' ";
						$chkCustomerWallet = $this->db->query($walletQuery)->result_array();
						
						if(count($chkCustomerWallet) > 0) #Update Wallet Amount
						{
							$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount + $grandTotal where user_id = '".$userID."' ";
							$this->db->query($UpdateQuery);
						}
						else #Insert Wallet Amount
						{
							$WalletData['user_id'] = $userID;
							$WalletData['branch_id'] = $branchID;
							$WalletData['wallet_amount'] = $grandTotal;
							
							$this->db->insert('vb_customer_wallet', $WalletData);
							$wallet_id = $this->db->insert_id();
						}
						
						#Order canceled sms start
						$country_code = $getOrderDetails[0]['country_code'];
						$mobile_number = $getOrderDetails[0]['mobile_number'];
						$order_number = $getOrderDetails[0]['order_number'];
						$otpMobileNumber = $country_code.$mobile_number;
						
						$otpMessage = '#'. $order_number.' Your order has been cancelled. Sorry for the inconvenience, amount has been refunded to wallet. '.strtoupper(SITE_NAME);
						$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
						
						#Order canceled sms end
					}
				}
				#Wallet end
				
				$this->db->where('order_id', $id);
				$this->db->update('vb_order_header', $data);
			}
			
			$this->session->set_flashdata('flash_message' , "Orders cancelled successfully!");
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		else #Order Transfer Start
		if( (isset($_POST['assignBranch'])) && (count($_POST['checkbox']) > 0) )
		{
			/* $cnt=array();
			$cnt=count($_POST['checkbox']);
			
			for($i=0;$i<$cnt;$i++)
			{
				$order_id=$_POST['checkbox'][$i];
				$data['order_status'] = 1;
				$this->db->where('order_id', $order_id);
				$this->db->update('vb_order_header', $data);
			} */
			
			if( isset($_POST['to_branch_id']) && !empty($_POST['to_branch_id']) )
			{
				$orderID = array_filter($_POST['checkbox']);
			
				if( count($orderID) > 0 )
				{
					foreach($orderID as $key=>$value)
					{
						$order_id = $value;
						
						$query = "select vb_order_header.user_id,vb_order_header.branch_id from vb_order_header where order_id = ".$order_id;
						$userDetails = $this->db->query($query)->result_array();
						$user_id = isset($userDetails[0]['user_id']) ? $userDetails[0]['user_id'] :0;
						$branch_id = isset($userDetails[0]['branch_id']) ? $userDetails[0]['branch_id'] :0;

						$data['order_id'] = $order_id;	
						$data['user_id'] = $user_id;	
						$data['from_branch_id'] = $branch_id;	
						$data['to_branch_id'] = $_POST['to_branch_id'];	
						$data['created_date'] = time();	
						
						$this->db->insert('vb_assign_branch_orders', $data);
						$AssgnedID = $this->db->insert_id();
						
						if($AssgnedID)
						{
							$AssignData['branch_id'] = $_POST['to_branch_id'];	
							$AssignData['read_status']	= 0;
							$AssignData['notification_status']	= 0;

							$this->db->where('order_id', $order_id);
							$this->db->update('vb_order_header', $AssignData);
							
						}
					}
					
					$this->session->set_flashdata('flash_message' , "Order Assigned successfully!");
					redirect(base_url()."orders/ManageOrders", 'refresh');
				}
			}
			else
			{
				$this->session->set_flashdata('error_message' , "Please select To Branch!");
				redirect(base_url()."orders/ManageOrders", 'refresh');
			}
		}
		#Order Transfer end
		
		switch($type)
		{
			case 'status':
				switch ($status) 
				{
					/* case '0':
						$data['order_status'] = 0;
						$succ_msg = 'Order canceled successfully!';
					break; */
					case 1: #Confirmed
						$data['order_status'] = 1;
						$succ_msg = 'Order confirmed successfully!';
					break;
					
					case 2: #Preparing
						$data['order_status'] = 2;
						$succ_msg = 'Order added to preparing.!';
					break;
					
					case 3: #Deliveried
						$data['order_status'] = 3;
						$data['delivered_date'] = time();
						$succ_msg = 'Order Deliveried successfully!';
						
						#Wallet start
						$orderQuery = "select 
							vb_order_header.user_id, 
							vb_order_header.order_number, 
							vb_order_header.branch_id,
							vb_order_header.grand_total,
							vb_order_header.payable_amount,
							vb_order_header.paid_status,
							vb_order_header.payment_method,
							users.mobile_number, 
							country.country_code,
							country.currency_code
						from vb_order_header 
						
						left join users on 
							users.user_id = vb_order_header.user_id
							
						left join country on 
							country.country_id = users.country_id
							
						where 
							vb_order_header.order_id='".$id."' ";
						$getOrderDetails = $this->db->query($orderQuery)->result_array();
						
						#Order canceled sms start
						$country_code = $getOrderDetails[0]['country_code'];
						$mobile_number = $getOrderDetails[0]['mobile_number'];
						$order_number = $getOrderDetails[0]['order_number'];
						$payable_amount = $getOrderDetails[0]['payable_amount'];
						$currency_code = $getOrderDetails[0]['currency_code'];
						$otpMobileNumber = $country_code.$mobile_number;
						
						$otpMessage = '#'. $order_number.' Your order is out for delivery. Your Order amount is '.$currency_code.' '.$payable_amount.' - Thank You.  '.strtoupper(SITE_NAME);
						$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
						#Order canceled sms end
					break;
					
					case 4: # Cancel
						$data['order_status'] = 4;
						$data['delivered_date'] = time();
						$succ_msg = 'Order Cancelled successfully!';
						
						#Wallet start
						$orderQuery = "select 
							vb_order_header.user_id, 
							vb_order_header.order_number, 
							vb_order_header.branch_id,
							vb_order_header.grand_total,
							vb_order_header.paid_status,
							vb_order_header.payment_method,
							users.mobile_number, 
							country.country_code
						from vb_order_header 
						
						left join users on 
							users.user_id = vb_order_header.user_id
							
						left join country on 
							country.country_id = users.country_id
							
						where 
							vb_order_header.order_id='".$id."' ";
						$getOrderDetails = $this->db->query($orderQuery)->result_array();
						
						if(count($getOrderDetails) > 0)
						{
							$userID = $getOrderDetails[0]['user_id'];
							$branchID = $getOrderDetails[0]['branch_id'];
							$grandTotal = $getOrderDetails[0]['grand_total'];
							
							$paid_status = $getOrderDetails[0]['paid_status'];
							$payment_method = $getOrderDetails[0]['payment_method'];
							
							if( $payment_method == 1 ) #COD
							{
								if($paid_status == 1) #if paid only added to wallet
								{
									$walletQuery = "select wallet_id from vb_customer_wallet 
									where user_id='".$userID."' ";
									$chkCustomerWallet = $this->db->query($walletQuery)->result_array();
									
									if(count($chkCustomerWallet) > 0) #Update Wallet Amount
									{
										$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount + $grandTotal where user_id = '".$userID."' ";
										$this->db->query($UpdateQuery);
									}
									else #Insert Wallet Amount
									{
										$WalletData['user_id'] = $userID;
										$WalletData['branch_id'] = $branchID;
										$WalletData['wallet_amount'] = $grandTotal;
										
										$this->db->insert('vb_customer_wallet', $WalletData);
										$wallet_id = $this->db->insert_id();
									}
								}
								else if($paid_status != 1) #if not paid no need add wallet
								{
									
								}
								
								#Order canceled sms start
								$country_code = $getOrderDetails[0]['country_code'];
								$mobile_number = $getOrderDetails[0]['mobile_number'];
								$order_number = $getOrderDetails[0]['order_number'];
								$otpMobileNumber = $country_code.$mobile_number;
								
								$otpMessage = '#'. $order_number.' Your order has been cancelled. Sorry for the inconvenience, amount has been refunded to wallet. '.strtoupper(SITE_NAME);
								$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
								
								#Order canceled sms end
							}
							else #Card
							{
								$walletQuery = "select wallet_id from vb_customer_wallet 
									where user_id='".$userID."' ";
								$chkCustomerWallet = $this->db->query($walletQuery)->result_array();
								
								if(count($chkCustomerWallet) > 0) #Update Wallet Amount
								{
									$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount + $grandTotal where user_id = '".$userID."' ";
									$this->db->query($UpdateQuery);
								}
								else #Insert Wallet Amount
								{
									$WalletData['user_id'] = $userID;
									$WalletData['branch_id'] = $branchID;
									$WalletData['wallet_amount'] = $grandTotal;
									
									$this->db->insert('vb_customer_wallet', $WalletData);
									$wallet_id = $this->db->insert_id();
								}
								
								#Order canceled sms start
								$country_code = $getOrderDetails[0]['country_code'];
								$mobile_number = $getOrderDetails[0]['mobile_number'];
								$order_number = $getOrderDetails[0]['order_number'];
								$otpMobileNumber = $country_code.$mobile_number;
								
								$otpMessage = '#'. $order_number.' Your order has been cancelled. Sorry for the inconvenience, amount has been refunded to wallet. '.strtoupper(SITE_NAME);
								$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
								
								#Order canceled sms end
							}
						}
						#Wallet end
					break;
				}
				
				$this->db->where('order_id', $id);
				$this->db->update('vb_order_header', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect($_SERVER["HTTP_REFERER"], 'refresh');
			break;
			
			case 'paid_status':
				$data['payment_status'] = 'SUCCESS';
				$data['paid_status'] = 1;
				$this->db->where('order_id', $id);
				$this->db->update('vb_order_header', $data);
				
				$this->session->set_flashdata('flash_message' , "Paid status updated successfully!");
				redirect($_SERVER["HTTP_REFERER"], 'refresh');
			break;
			
			default : #Manage
				
				#Transfer Branch start
				if(isset($_POST['assignBranch']))
				{
					$orderID = array_filter($_POST['order_id']);
					
					if( count($orderID) > 0 )
					{
						foreach($orderID as $key=>$value)
						{
							$order_id = $value;
							
							$query = "select vb_order_header.user_id from vb_order_header where order_id = ".$order_id;
							$userDetails = $this->db->query($query)->result_array();
							$user_id = isset($userDetails[0]['user_id']) ? $userDetails[0]['user_id'] :0;

							$data['order_id'] = $order_id;	
							$data['user_id'] = $user_id;	
							$data['from_branch_id'] = $_POST['from_branch_id'];	
							$data['to_branch_id'] = $_POST['to_branch_id'];	
							$data['created_date'] = time();	
							
							$this->db->insert('vb_assign_branch_orders', $data);
							$AssgnedID = $this->db->insert_id();
							
							if($AssgnedID)
							{
								$AssignData['branch_id'] = $_POST['to_branch_id'];	
								$AssignData['read_status']	= 0;
								$AssignData['notification_status']	= 0;

								$this->db->where('order_id', $order_id);
								$this->db->update('vb_order_header', $AssignData);
								
							}
						}
						
						$this->session->set_flashdata('flash_message' , "Order Assigned successfully!");
						redirect(base_url()."orders/ManageOrders", 'refresh');
					
					
					}
					else
					{
						$this->session->set_flashdata('error_message' , "Please select atleast one or more orders!");
						redirect(base_url()."orders/ManageOrders", 'refresh');
					}
					
					/* $query = "select vb_order_header.user_id from vb_order_header where order_id = ".$_POST['order_id'];
					$userDetails = $this->db->query($query)->result_array();
					$user_id = $userDetails[0];

					$data['order_id'] = $order_id =  $_POST['order_id'];	
					$data['user_id'] = $user_id['user_id'];	
					$data['from_branch_id'] = $_POST['from_branch_id'];	
					$data['to_branch_id'] = $_POST['to_branch_id'];	
					$data['created_date'] = time();	
					
					$this->db->insert('vb_assign_branch_orders', $data);
					$AssgnedID = $this->db->insert_id();
					
					if($AssgnedID)
					{
						$AssignData['branch_id'] = $_POST['to_branch_id'];	
						$AssignData['read_status']	= 0;
						$AssignData['notification_status']	= 0;

						$this->db->where('order_id', $order_id);
						$this->db->update('vb_order_header', $AssignData);
						
						$this->session->set_flashdata('flash_message' , "Order Assigned successfully!");
						redirect(base_url()."orders/ManageOrders", 'refresh');
					} */
				}
				#Transfer Branch end
				
				$page_data["totalRows"] = $totalRows = $this->Orders_model->getOrdersCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				$branch_id = isset($_GET['branch_id']) ? $_GET['branch_id'] :"";
				if ($_GET) {
					$base_url = base_url('orders/ManageOrders?status='.$_GET['status'].'&branch_id='.$branch_id.'&keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('orders/ManageOrders?status=&branch_id=&keywords=&filter=10');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->Orders_model->getOrders($limit, $offset);
			
				$updateData['read_status'] = 1;
				if ($this->user_id == 1) 
				{
					$this->db->where('read_status',0);
					$this->db->update('vb_order_header',$updateData);		
				}
				else
				{
					$this->db->where('branch_id',$this->admin_branch_id);
					$this->db->where('read_status',0);
					$this->db->update('vb_order_header',$updateData);	
				}
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
				// print_r(json_encode($page_data));exit;

            break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	public function printReceipt($id="")
	{
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
		
		$page_data['id'] = $id;

		$page_data['Orders'] = 1;
		$page_data['page_name']  = 'orders/printReceipt';
		$page_data['page_title'] = 'Orders Details';
		
		$page_data['data']  = $this->Orders_model->getOrderDetails($id);
		$page_data['items'] = $this->Orders_model->getOrderItems($id);
		$page_data['itemsprint'] = $this->Orders_model->getOrderItemsPrint($id);
		$html = $this->load->view('backend/orders/printReceipt',$page_data,true);
		echo $html;exit;
	}
	
	function viewOderDetails($id="")
	{
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
		
		$page_data['id'] = $id;
		
		if(isset($_POST['delete']) && isset($_POST['checkbox']))
		{
			$cnt=array();
			$cnt=count($_POST['checkbox']);
			
			$productName="";
			$sub_total = 0;
			foreach(array_filter($_POST['checkbox']) as $key=>$value)
			{
				$orderLineQuery = "select 
				products.product_id, 
				products.product_name, 
				products.product_code,
				vb_order_line.linetotal
					from vb_order_line 
					
					left join products on 
						products.product_id = vb_order_line.product_id
				
					where 
						vb_order_line.order_line_id='".$value."' ";
						
					$getOrderLineDetails = $this->db->query($orderLineQuery)->result_array();
				
				if(count($getOrderLineDetails) > 0)	
				{
					foreach($getOrderLineDetails as $itemName)	
					{
						$productName .= ucfirst($itemName['product_name']).",";
						
						$sub_total += $itemName['linetotal'];
					}
				}
			}
			
			$product_name = !empty($productName) ? substr(trim($productName), 0, -1) :"";
			
			for($i=0;$i<$cnt;$i++)
			{
				$del_id=$_POST['checkbox'][$i];
				 
				$data['cancel_status'] = 1;
				$this->db->where('order_id', $id);
				$this->db->where('order_line_id', $del_id);
				$this->db->update('vb_order_line', $data);
			}
			
			#Wallet start
			$orderQuery = "select 
				vb_order_header.user_id, 
				vb_order_header.order_number, 
				vb_order_header.branch_id,
				vb_order_header.sub_total,
				vb_order_header.grand_total,
				vb_order_header.payable_amount,
				vb_order_header.paid_status,
				vb_order_header.payment_method,
				vb_order_header.tax_value,
				users.mobile_number, 
				country.country_code
			from vb_order_header 
			
			left join users on 
				users.user_id = vb_order_header.user_id
				
			left join country on 
				country.country_id = users.country_id
		
			where 
				vb_order_header.order_id='".$id."' ";
				
			$getOrderDetails = $this->db->query($orderQuery)->result_array();
			
			if(count($getOrderDetails) > 0)
			{
				$userID = $getOrderDetails[0]['user_id'];
				$branchID = $getOrderDetails[0]['branch_id'];
				$tax_value = $getOrderDetails[0]['tax_value'];
				#$grandTotal = $getOrderDetails[0]['grand_total'];
				$tax_amount = $tax_value / 100 * $sub_total;
				$grandTotal = $sub_total + $tax_amount;

				$paid_status = $getOrderDetails[0]['paid_status'];
				$payment_method = $getOrderDetails[0]['payment_method'];
				
				if( $payment_method == 1 ) #COD
				{
					if($paid_status == 1) #if paid only added to wallet
					{
						$walletQuery = "select wallet_id from vb_customer_wallet 
						where user_id='".$userID."' ";
						$chkCustomerWallet = $this->db->query($walletQuery)->result_array();
						
						if(count($chkCustomerWallet) > 0) #Update Wallet Amount
						{
							$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount + $grandTotal where user_id = '".$userID."' ";
							$this->db->query($UpdateQuery);
						}
						else #Insert Wallet Amount
						{
							$WalletData['user_id'] = $userID;
							$WalletData['branch_id'] = $branchID;
							$WalletData['wallet_amount'] = $grandTotal;
							
							$this->db->insert('vb_customer_wallet', $WalletData);
							$wallet_id = $this->db->insert_id();
						}
					}
					else if($paid_status != 1) #if not paid no need add wallet
					{
						
					}
					
					#Order canceled sms start
					$country_code = $getOrderDetails[0]['country_code'];
					$mobile_number = $getOrderDetails[0]['mobile_number'];
					$order_number = $getOrderDetails[0]['order_number'];
					$otpMobileNumber = $country_code.$mobile_number;
					
					$chkCancelQuery = "select order_line_id from vb_order_line
					where 
						vb_order_line.order_id='".$id."' and
						vb_order_line.cancel_status = 0
					";
					$chkCancelStatus = $this->db->query($chkCancelQuery)->result_array();
					
					if (count($chkCancelStatus)>0)
					{
						$otpMessage = "Dear Customer, ".$product_name.' has been cancelled from your order. Sorry for the inconvinence, amount has been refunded to wallet. '.$order_number.''.strtoupper(SITE_NAME);
					}
					else
					{
						$CancelData['order_status'] = 4;
						$CancelData['delivered_date'] = time();
						$this->db->where('order_id', $id);
						$this->db->update('vb_order_header', $CancelData);
						
						$otpMessage = "Dear Customer, Your Order ".$order_number.' has been cancelled. Sorry for the inconvinence, amount has been refunded to wallet.  '.strtoupper(SITE_NAME);
					}
					
					$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
					#Order canceled sms end
				}
				else #Card
				{
					$walletQuery = "select wallet_id from vb_customer_wallet 
						where user_id='".$userID."' ";
					$chkCustomerWallet = $this->db->query($walletQuery)->result_array();
					
					if(count($chkCustomerWallet) > 0) #Update Wallet Amount
					{
						$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount + $grandTotal where user_id = '".$userID."' ";
						$this->db->query($UpdateQuery);
					}
					else #Insert Wallet Amount
					{
						$WalletData['user_id'] = $userID;
						$WalletData['branch_id'] = $branchID;
						$WalletData['wallet_amount'] = $grandTotal;
						
						$this->db->insert('vb_customer_wallet', $WalletData);
						$wallet_id = $this->db->insert_id();
					}
					
					#Order canceled sms start
					$country_code = $getOrderDetails[0]['country_code'];
					$mobile_number = $getOrderDetails[0]['mobile_number'];
					$order_number = $getOrderDetails[0]['order_number'];
					$otpMobileNumber = $country_code.$mobile_number;
					
					$chkCancelQuery = "select order_line_id from vb_order_line
					where 
						vb_order_line.order_id='".$id."' and
						vb_order_line.cancel_status = 0
					";
					$chkCancelStatus = $this->db->query($chkCancelQuery)->result_array();
					
					if (count($chkCancelStatus)>0)
					{
						$otpMessage = "Dear Customer, ".$product_name.' has been cancelled from your order '.$order_number.' . Sorry for the inconvinence, amount has been refunded to wallet.  '.strtoupper(SITE_NAME);
					}
					else
					{
						$CancelData['order_status'] = 4;
						$CancelData['delivered_date'] = time();
						
						$this->db->where('order_id', $id);
						$this->db->update('vb_order_header', $CancelData);
						
						$otpMessage = "Dear Customer, Your Order ".$order_number.' has been cancelled. Sorry for the inconvinence, amount has been refunded to wallet.  '.strtoupper(SITE_NAME);
					}
					
					$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
					#Order canceled sms end
				}
			}
			#Wallet end
			$this->session->set_flashdata('success_message' , "Ordered Item Cancelled Successfully!");
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}

		#update read Status
		$data['read_status'] = 1;
		$this->db->where('order_id',$id);
		$this->db->update('vb_order_header',$data);
		#update read Status end
		
		$page_data['Orders'] = 1;
		$page_data['page_name']  = 'orders/OderDetails';
		$page_data['page_title'] = 'Orders Details';
		
		if($this->user_id==1) #Admin
		{
			$condition = " 1=1 and order_id='".$id."' ";
			$joinQuery ="";
		}
		else #Branch Admins
		{
			$condition = " 1=1 and order_id='".$id."' and
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$joinQuery ="
				join users as branch_users on branch_users.branch_id = vb_order_header.branch_id 
			";
		}
		
		#From & To Date search end
		
		$query = "select 
			vb_order_header.order_id,
			vb_order_header.branch_id,
			vb_order_header.order_number,
			vb_order_header.created_date,
			vb_order_header.sub_total,
			vb_order_header.grand_total,
			vb_order_header.order_status,
			vb_order_header.order_type,
			vb_order_header.payment_method,
			vb_order_header.order_number,
			vb_order_header.delivered_date,
			vb_order_header.payment_status,
			vb_order_header.wallet_chk_enabled,
			vb_order_header.wallet_amount,
			vb_order_header.payable_amount,
			vb_order_header.tax_value,
			vb_order_header.paid_status,

            expense_payment_type.payment_type,
			
			branch.branch_code,
			branch.branch_name,
			branch.address,
			branch.phone_number,
			branch.email,
			
			users.user_id,
			users.first_name,
			users.mobile_number,
			vb_customer_address.address as customer_address,
			vb_customer_address.door_number,
			vb_customer_address.building_number,
			vb_customer_address.address_line_2,
			vb_customer_address.delivery_address as delivery_address

			from vb_order_header

		left join users on users.user_id = vb_order_header.user_id
		left join expense_payment_type on expense_payment_type.payment_type_id = vb_order_header.payment_method
		
		left join vb_customer_address on 
			vb_customer_address.customer_address_id = vb_order_header.delivery_address
		
		join branch on branch.branch_id = vb_order_header.branch_id 
		
		$joinQuery
		
		where $condition
		";
		#echo $query;
		$page_data['resultData'] = $this->db->query($query)->result_array();
		
		#$page_data['orderDetails']  = $this->Orders_model->getOrderDetails($id);
		#$page_data['resultData']    = $this->Orders_model->getOrderItems($id);
		
		$this->load->view($this->adminTemplate, $page_data);
    }

	#--| Notification Ajax Functions |--#
	function AjaxNotification()
	{
		if (!empty($_POST['read_status'])) 
		{
			if ($this->user_id == 1) 
			{
				$data['read_status'] = $_POST['read_status'];
				$this->db->update('vb_order_header',$data);
			}
			else
			{
				$data['read_status'] = $_POST['read_status'];

				$this->db->where('branch_id',$this->admin_branch_id);
				$this->db->update('vb_order_header',$data);
			}
			
		}
	}

	function AjaxNotifications()
	{
		if ($this->user_id == 1) {
			if (!empty($_POST['notification_status'])) 
			{
				$data['notification_status'] = $_POST['notification_status'];

				$this->db->where('notification_status',0);
				$this->db->update('vb_order_header',$data);
			}
		}
		else
		{
			if (!empty($_POST['notification_status'])) 
			{
				$data['notification_status'] = $_POST['notification_status'];

				$this->db->where('notification_status',0);
				$this->db->where('branch_id',$this->admin_branch_id);
				$this->db->update('vb_order_header',$data);
			}
		}
	}

	function AjaxGetcount()
	{
		if ($this->user_id == 1 )
		{
			$query = 'select order_id from vb_order_header where notification_status = 0';
			$result = $this->db->query($query)->result_array();
		} 
		else 
		{
			$query = 'select order_id from vb_order_header where notification_status = 0 and branch_id = '.$this->admin_branch_id;
			$result = $this->db->query($query)->result_array();
		}
		
		echo count($result);
	}

	function AjaxGetOrders()
	{
		if ($this->user_id == 1)
		{
			$condition = "notification_status = 0 and order_status = 0";
		}
		else
		{
			$condition = 'notification_status = 0 and order_status = 0 and vb_order_header.branch_id = '.$this->admin_branch_id ;
		}
		
		$query= "select 
				vb_order_header.order_id,
				vb_order_header.grand_total,
				users.user_id,
				vb_order_header.order_date,
				vb_order_header.order_number,
				vb_order_header.created_date

				from vb_order_header

				left join users on users.user_id = vb_order_header.user_id

				where $condition
				order by vb_order_header.created_date desc
				";

		$result = $this->db->query($query)->result_array();
		echo json_encode($result);
	}

	function AjaxDashboard()
	{
		$condition = "1=1 and order_closed_status !=1";		
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								vb_order_header.order_number like "%'.($_GET['keywords']).'%" or
								users.mobile_number like "%'.($_GET['keywords']).'%" 
							)
							';
		}
		
		if(!empty($_GET['branch_id']))
		{
			if ($this->user_id == 1)  #Admin
			{
				$condition .= ' and vb_order_header.branch_id='.$_GET['branch_id'];
			}	
		}

		if(!empty($_GET['payment_type']))
		{
			$condition .= ' and vb_order_header.payment_method='.$_GET['payment_type'];	
		}
		
		
		#From & To Date search start
		if(!empty($_GET['from_date']) && !empty($_GET['to_date']))
		{
			if($_GET['from_date'] == $_GET['to_date'])
			{
				$condition .= ' and invoice_billing_date between '.strtotime($_GET['from_date']).' and '.strtotime($_GET['to_date']).' ';
			}
			else
			{ 
				#$condition .= ' and invoice_date between '.strtotime($_GET['from_date']).' and '.strtotime($_GET['to_date']).' ';
				$condition .= ' and invoice_billing_date >= '.strtotime($_GET['from_date']).' and invoice_billing_date <= '.strtotime($_GET['to_date']).' ';
			}
		}
		
		if( !empty($_GET['from_date']) && empty($_GET['to_date']) )
		{
			$condition .= ' and invoice_billing_date <= '.strtotime($_GET['from_date']).' ';
		}
		
		if( empty($_GET['from_date']) && !empty($_GET['to_date']) )
		{
			$condition .= ' and invoice_billing_date >= '.strtotime($_GET['to_date']).' ';
		}
		

		if($this->user_id==1) #Admin
		{
			$PendingCondition = "order_status=0 and $condition";
			$ConfirmedCondition = "order_status=1 and $condition";
			$PreparingCondition = "order_status=2 and $condition";
			$DeliveredCondition = "order_status=3 and $condition";
			$CancelledCondition = "order_status=4 and $condition";
			$AllOrdersCondition = "1=1 and $condition";
			$joinQuery ="";
		}
		else #Branch Admins
		{
			$PendingCondition = "order_status=0 and $condition
				and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$ConfirmedCondition = "order_status=1 and $condition
				and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$PreparingCondition = "order_status=2 and $condition
			and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$DeliveredCondition = "order_status=3 and $condition
			and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$CancelledCondition = "order_status=4 and $condition
			and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$AllOrdersCondition = "1=1 and $condition
			and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			$joinQuery ="
				join users as branch_users on branch_users.branch_id = vb_order_header.branch_id 
			";
		}
		
		$PendingQuery = "select order_id from vb_order_header 
			$joinQuery
			where $PendingCondition";
		$PendingOrders = $this->db->query($PendingQuery)->result_array();

		$ConfirmedQuery = "select order_id from vb_order_header 
			$joinQuery
			where $ConfirmedCondition";
		$ConfirmedOrders = $this->db->query($ConfirmedQuery)->result_array();

		$PreparingQuery = "select order_id from vb_order_header 
			$joinQuery
			where $PreparingCondition";
		$PreparingOrders = $this->db->query($PreparingQuery)->result_array();

		$DeliveredQuery = "select order_id from vb_order_header 
			$joinQuery
			where $DeliveredCondition";
		$DeliveredOrders = $this->db->query($DeliveredQuery)->result_array();

		$CancelledQuery = "select order_id from vb_order_header 
			$joinQuery
			where $CancelledCondition";
		$CancelledOrders = $this->db->query($CancelledQuery)->result_array();

		$TotalQuery = "select order_id from vb_order_header
		$joinQuery
		where $AllOrdersCondition
		";

		$totalOrders = $this->db->query($TotalQuery)->result_array();

		$orderDashboard = array(
			'PendingOrders' 	=> count($PendingOrders), 
			'ConfirmedOrders' 	=> count($ConfirmedOrders), 
			'PreparingOrders'	=> count($PreparingOrders), 
			'DeliveredOrders'	=> count($DeliveredOrders), 
			'CancelledOrders' 	=> count($CancelledOrders), 
			'totalOrders' 		=> count($totalOrders)
		);
					
		echo json_encode($orderDashboard);
	}

	function AjaxappendTable()
	{
		if ($this->user_id == 1)
		{
			$condition = "order_status = 0 and read_status = 0";
		}
		else
		{
			$condition = 'order_status = 0 and read_status = 0 and vb_order_header.branch_id = '.$this->admin_branch_id ;
		}

		$query = "select 
			vb_order_header.order_id,
			vb_order_header.order_number,
			vb_order_header.created_date,
			vb_order_header.sub_total,
			vb_order_header.grand_total,
			vb_order_header.order_status,
			vb_order_header.order_type,
			vb_order_header.payment_method,
			vb_order_header.order_number,
			vb_order_header.delivered_date,
			vb_order_header.payment_status,
			vb_order_header.paid_status,
			vb_order_header.tax_value,

            expense_payment_type.payment_type,
			
			branch.branch_code,
			branch.branch_name,
			branch.address,
			branch.phone_number,
			branch.email,
			
			users.user_id,
			users.first_name,
			users.mobile_number

			from vb_order_header

		left join branch on branch.branch_id = vb_order_header.branch_id
		left join users on users.user_id = vb_order_header.user_id
		left join expense_payment_type on expense_payment_type.payment_type_id = vb_order_header.payment_method
		
		where $condition
				order by 
						vb_order_header.order_id DESC
		"; #vb_order_header.order_status ASC,

		$result = $this->db->query($query)->result_array();
		
		echo json_encode($result);
	}

	function LineData()
	{
		$_POST['order_id'];

		$LineDataQuery = "select 
					products.product_name,
					vb_order_line.*,
					vb_order_header.*,
					expense_payment_type.payment_type
					from vb_order_line
					
				left join vb_order_header on 
					vb_order_header.order_id = vb_order_line.order_id
				
				left join expense_payment_type on 
					expense_payment_type.payment_type_id = vb_order_header.payment_method
					
				left join products on 
					products.product_id = vb_order_line.product_id
				
				where vb_order_line.order_id='".$_POST['order_id']."'";
			
		$LineData = $this->db->query($LineDataQuery)->result_array();
		echo json_encode($LineData);
	}

	function ajaxOrderTransfer()
	{
		$order_id = $_POST['order_id'];

		if ($order_id != 0) {
			$query = "select 
					vb_order_header.order_number ,
					vb_order_header.branch_id,
					branch.branch_name

					from vb_order_header 
					
					left join branch on branch.branch_id = vb_order_header.branch_id

					where vb_order_header.order_id = $order_id";

			$result = $this->db->query($query)->result_array();
		
			$BranchQuery = "select branch_id,branch_name from branch where branch_status=1 and branch_id != ".$result[0]['branch_id'] ;
			$getBranch = $this->db->query($BranchQuery)->result_array();

			foreach($getBranch as $branch)
			{
				$to_branches[] = $branch;
			}

			$result[0]['to_branches'] = $to_branches;

			echo json_encode($result);die;	
		}
		else
		{
			$result = [];
			echo json_encode($result);die;		
		}
	}
	
	function cancelItem($order_id="", $order_line_id="")
	{
		$id = $order_id;
		
		#Wallet start
		$orderQuery = "select 
			vb_order_header.user_id, 
			vb_order_header.order_number, 
			vb_order_header.branch_id,
			vb_order_header.sub_total,
			vb_order_header.grand_total,
			vb_order_header.payable_amount,
			vb_order_header.paid_status,
			vb_order_header.payment_method,
			users.mobile_number, 
			country.country_code
		from vb_order_header 
		
		left join users on 
			users.user_id = vb_order_header.user_id
			
		left join country on 
			country.country_id = users.country_id
	
		where 
			vb_order_header.order_id='".$id."' ";
			
		$getOrderDetails = $this->db->query($orderQuery)->result_array();
		
		
		$orderLineQuery = "select 
			products.product_id, 
			products.product_name, 
			products.product_code
		from vb_order_line 
		
		left join products on 
			products.product_id = vb_order_line.product_id
	
		where 
			vb_order_line.order_line_id='".$order_line_id."' ";
			
		$getOrderLineDetails = $this->db->query($orderLineQuery)->result_array();
		
		$productName = ucfirst($getOrderLineDetails[0]['product_name']);
		
		if(count($getOrderDetails) > 0)
		{
			$userID = $getOrderDetails[0]['user_id'];
			$branchID = $getOrderDetails[0]['branch_id'];
			$grandTotal = $getOrderDetails[0]['grand_total'];
			
			$paid_status = $getOrderDetails[0]['paid_status'];
			$payment_method = $getOrderDetails[0]['payment_method'];
			
			if( $payment_method == 1 ) #COD
			{
				/* if($paid_status == 1) #if paid only added to wallet
				{
					$walletQuery = "select wallet_id from vb_customer_wallet 
					where user_id='".$userID."' ";
					$chkCustomerWallet = $this->db->query($walletQuery)->result_array();
					
					if(count($chkCustomerWallet) > 0) #Update Wallet Amount
					{
						$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount + $grandTotal where user_id = '".$userID."' ";
						$this->db->query($UpdateQuery);
					}
					else #Insert Wallet Amount
					{
						$WalletData['user_id'] = $userID;
						$WalletData['branch_id'] = $branchID;
						$WalletData['wallet_amount'] = $grandTotal;
						
						$this->db->insert('vb_customer_wallet', $WalletData);
						$wallet_id = $this->db->insert_id();
					}
				}
				else if($paid_status != 1) #if not paid no need add wallet
				{
					
				} */
				
				#Order canceled sms start
				$country_code = $getOrderDetails[0]['country_code'];
				$mobile_number = $getOrderDetails[0]['mobile_number'];
				$order_number = $getOrderDetails[0]['order_number'];
				$otpMobileNumber = $country_code.$mobile_number;
				
				$otpMessage = '#'. $order_number.' Your Order has been cancelled. Sorry for the inconvinence, amount has been refunded to wallet. '.strtoupper(SITE_NAME);
				$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
				
				#Order canceled sms end
			}
			else #Card
			{
				/* $walletQuery = "select wallet_id from vb_customer_wallet 
					where user_id='".$userID."' ";
				$chkCustomerWallet = $this->db->query($walletQuery)->result_array();
				
				if(count($chkCustomerWallet) > 0) #Update Wallet Amount
				{
					$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount + $grandTotal where user_id = '".$userID."' ";
					$this->db->query($UpdateQuery);
				}
				else #Insert Wallet Amount
				{
					$WalletData['user_id'] = $userID;
					$WalletData['branch_id'] = $branchID;
					$WalletData['wallet_amount'] = $grandTotal;
					
					$this->db->insert('vb_customer_wallet', $WalletData);
					$wallet_id = $this->db->insert_id();
				} */
				
				#Order canceled sms start
				$country_code = $getOrderDetails[0]['country_code'];
				$mobile_number = $getOrderDetails[0]['mobile_number'];
				$order_number = $getOrderDetails[0]['order_number'];
				$otpMobileNumber = $country_code.$mobile_number;
				
				$otpMessage = $productName.' has been cancelled from your order '.$order_number.' . Sorry for the inconvinence, amount has been refunded to wallet. '.strtoupper(SITE_NAME);
				$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
				
				#Order canceled sms end
			}
		}
		#Wallet end
		
		$data['cancel_status'] = 1;
		$this->db->where('order_id', $order_id);
		$this->db->where('order_line_id', $order_line_id);
		$this->db->update('vb_order_line', $data);
		
		$this->session->set_flashdata('success_message' , "Item Cancelled Successfully!");
		redirect(base_url()."Orders/viewOderDetails/".$order_id, 'refresh');
	}
	
}
?>

				
