<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Payment_history extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function PaymentHistory($type = '', $id = '', $status = '', $status_1 = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
		
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['PaymentHistory'] = 1;
		$page_data['page_name']  = 'payment_history/PaymentHistory';
		$page_data['page_title'] = 'Payment History';
	
		if(isset($_POST['delete']) && isset($_POST['checkbox']))
		{
			$cnt=array();
			$cnt=count($_POST['checkbox']);
			
			for($i=0;$i<$cnt;$i++)
			{
				$order_id=$_POST['checkbox'][$i];
				$data['order_closed_status'] = 1;
				$this->db->where('order_id', $order_id);
				$this->db->update('vb_order_header', $data);
			}
			
			$this->session->set_flashdata('flash_message' , "Orders closed successfully!");
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		
		switch($type)
		{
			case 'status':
			break;

			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->payment_history_model->getOrdersPaymentHistoryCount();
				
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				$branch_id = isset($_GET['branch_id']) ? $_GET['branch_id'] :"";
				$keywords = isset($_GET['keywords']) ? $_GET['keywords'] :"";
				$from_date = isset($_GET['from_date']) ? $_GET['from_date'] :"";
				$to_date = isset($_GET['to_date']) ? $_GET['to_date'] :"";
				
				$payment_type = isset($_GET['payment_type']) ? $_GET['payment_type'] :"";
				$order_closed = isset($_GET['order_closed']) ? $_GET['order_closed'] :"";
				
				if ($_GET) 
				{
					if (!empty($_GET['export'])) 
					{
						$base_url = base_url().'payment_history/PaymentHistory?branch_id='.$branch_id.'&keywords='.$keywords.'&from_date='.$from_date.'&to_date='.$to_date.'&export=export';
					}
					else
					{
						$base_url = base_url().'payment_history/PaymentHistory?branch_id='.$branch_id.'&keywords='.$keywords.'&from_date='.$from_date.'&to_date='.$to_date;
					}
				}
				else 
				{
					$base_url = base_url('payment_history/PaymentHistory?keywords=&from_date=&to_date=&filter=10');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				#Export Option
				$export = isset($_GET['export']) ? $_GET['export']:"";
				
				if($export=="export" && 
					(
						$branch_id !="" ||
						$keywords !="" ||
						$from_date !="" ||
						$order_closed !="" ||
						$payment_type !="" ||
						$to_date !=""
					)
				)
				{ #Filer Export all record
					$page_data['resultData']  = $result = $this->payment_history_model->getallFilterOrdersPaymentHistory();
				}
				else if($export=="export")
				{	
					$page_data['resultData']  = $result = $this->payment_history_model->getallOrdersPaymentHistory();
				}
				else
				{
					$page_data['resultData']  = $result = $this->payment_history_model->getOrdersPaymentHistory($limit, $offset,1);
				}
				
				
				if(!empty($export))
				{
					$date = date('d_M_Y');
					header("Content-type: application/csv");
					header("Content-Disposition: attachment; filename=\"payment_history_".$date.".csv\"");
					header("Pragma: no-cache");
					header("Expires: 0");
					
					$handle = fopen('php://output', 'w');
					
					fputcsv($handle, array("S.No","Order Number","Customer Name","Mobile Number","Branch Name","Payment Method","Payment Status","Payment Date","Order Amount"));
					
					$cnt=1;
					foreach ($result as $row) 
					{
						$narray=array(
							$cnt,
							$row["order_number"],
							ucfirst($row['first_name']),
							$row["mobile_number"],
							ucfirst($row['branch_name']),
							ucfirst($row['payment_type']),
							$row['payment_status'],
							date("d-M-Y h:i:s a",$row['created_date']),
							number_format($row['grand_total'],DECIMAL_VALUE,'.',''),
						);
						
						fputcsv($handle, $narray);
						$cnt++;
					}
					fclose($handle);
					exit;
				}
				#Export Option end
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
				// print_r(json_encode($page_data));exit;

            break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	public function printReceipt($id="")
	{
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
		
		$page_data['id'] = $id;

		$page_data['Orders'] = 1;
		$page_data['page_name']  = 'orders/printReceipt';
		$page_data['page_title'] = 'Orders Details';
		
		$page_data['data']  = $this->Orders_model->getOrderDetails($id);
		$page_data['items'] = $this->Orders_model->getOrderItems($id);
		$html = $this->load->view('backend/orders/printReceipt',$page_data,true);
		echo $html;exit;
	}
	
	function viewOderDetails($id="")
	{
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
		
		$page_data['id'] = $id;

		#update read Status
		$data['read_status'] = 1;
		$this->db->where('order_id',$id);
		$this->db->update('vb_order_header',$data);
		
		#update read Status end
		
		$page_data['Orders'] = 1;
		$page_data['page_name']  = 'orders/OderDetails';
		$page_data['page_title'] = 'Orders Details';
		
		$page_data['orderDetails']  = $this->Orders_model->getOrderDetails($id);
		$page_data['resultData']    = $this->Orders_model->getOrderItems($id);
		
		$this->load->view($this->adminTemplate, $page_data);
    }

	#--| Notification Ajax Functions |--#
	function AjaxNotification()
	{
		if (!empty($_POST['read_status']) && !empty($_POST['order_id'])) 
		{
			$data['read_status'] = $_POST['read_status'];

			$this->db->where('order_id',$_POST['order_id']);
			$this->db->update('vb_order_header',$data);
		}
	}

	function AjaxNotifications()
	{
		if ($this->user_id == 1) {
			if (!empty($_POST['notification_status'])) 
			{
				$data['notification_status'] = $_POST['notification_status'];

				$this->db->where('notification_status',0);
				$this->db->update('vb_order_header',$data);
			}
		}
		else
		{
			if (!empty($_POST['notification_status'])) 
			{
				$data['notification_status'] = $_POST['notification_status'];

				$this->db->where('notification_status',0);
				$this->db->where('branch_id',$this->admin_branch_id);
				$this->db->update('vb_order_header',$data);
			}
		}
	}

	function AjaxGetcount()
	{
		if ($this->user_id == 1 )
		{
			$query = 'select order_id from vb_order_header where notification_status = 0';
			$result = $this->db->query($query)->result_array();
		} 
		else 
		{
			$query = 'select order_id from vb_order_header where notification_status = 0 and branch_id = '.$this->admin_branch_id;
			$result = $this->db->query($query)->result_array();
		}
		
		echo count($result);
	}

	function AjaxGetOrders()
	{
		if ($this->user_id == 1)
		{
			$condition = "notification_status = 0";
		}
		else
		{
			$condition = 'notification_status = 0 and vb_order_header.branch_id = '.$this->admin_branch_id ;
		}
		
		$query= "select 
				vb_order_header.order_id,
				vb_order_header.grand_total,
				users.user_id,
				vb_order_header.order_date,
				vb_order_header.order_number,
				vb_order_header.created_date

				from vb_order_header

				left join users on users.user_id = vb_order_header.user_id

				where $condition
				order by vb_order_header.created_date desc
				";

		$result = $this->db->query($query)->result_array();
		echo json_encode($result);
	}

	function AjaxDashboard()
	{
		if($this->user_id==1) #Admin
		{
			$PendingCondition = "order_status=0";
			$ConfirmedCondition = "order_status=1";
			$PreparingCondition = "order_status=2";
			$DeliveredCondition = "order_status=3";
			$CancelledCondition = "order_status=4";
			$AllOrdersCondition = "1=1";
			$joinQuery ="";
		}
		else #Branch Admins
		{
			$PendingCondition = "order_status=0
				and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$ConfirmedCondition = "order_status=1
				and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$PreparingCondition = "order_status=2
			and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$DeliveredCondition = "order_status=3
			and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$CancelledCondition = "order_status=4 
			and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$AllOrdersCondition = "1=1
			and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			$joinQuery ="
				join users as branch_users on branch_users.branch_id = vb_order_header.branch_id 
			";
		}
		
		$PendingQuery = "select order_id from vb_order_header 
			$joinQuery
			where $PendingCondition";
		$PendingOrders = $this->db->query($PendingQuery)->result_array();

		$ConfirmedQuery = "select order_id from vb_order_header 
			$joinQuery
			where $ConfirmedCondition";
		$ConfirmedOrders = $this->db->query($ConfirmedQuery)->result_array();

		$PreparingQuery = "select order_id from vb_order_header 
			$joinQuery
			where $PreparingCondition";
		$PreparingOrders = $this->db->query($PreparingQuery)->result_array();

		$DeliveredQuery = "select order_id from vb_order_header 
			$joinQuery
			where $DeliveredCondition";
		$DeliveredOrders = $this->db->query($DeliveredQuery)->result_array();

		$CancelledQuery = "select order_id from vb_order_header 
			$joinQuery
			where $CancelledCondition";
		$CancelledOrders = $this->db->query($CancelledQuery)->result_array();

		$TotalQuery = "select order_id from vb_order_header
		$joinQuery
		where $AllOrdersCondition
		";
		$totalOrders = $this->db->query($TotalQuery)->result_array();

		$orderDashboard = array(
			'PendingOrders' 	=> count($PendingOrders), 
			'ConfirmedOrders' 	=> count($ConfirmedOrders), 
			'PreparingOrders'	=> count($PreparingOrders), 
			'DeliveredOrders'	=> count($DeliveredOrders), 
			'CancelledOrders' 	=> count($CancelledOrders), 
			'totalOrders' 		=> count($totalOrders)
		);
					
		echo json_encode($orderDashboard);
	}

	function AjaxappendTable()
	{
		if ($this->user_id == 1)
		{
			$condition = "order_status = 0 and read_status = 0";
		}
		else
		{
			$condition = 'order_status = 0 and read_status = 0 and vb_order_header.branch_id = '.$this->admin_branch_id ;
		}

		$query = "select 
			vb_order_header.order_id,
			vb_order_header.order_number,
			vb_order_header.created_date,
			vb_order_header.sub_total,
			vb_order_header.grand_total,
			vb_order_header.order_status,
			vb_order_header.order_type,
			vb_order_header.payment_method,
			vb_order_header.order_number,
			vb_order_header.delivered_date,
			vb_order_header.payment_status,

            expense_payment_type.payment_type,
			
			branch.branch_code,
			branch.branch_name,
			branch.address,
			branch.phone_number,
			branch.email,
			
			users.user_id,
			users.first_name,
			users.mobile_number

			from vb_order_header

		left join branch on branch.branch_id = vb_order_header.branch_id
		left join users on users.user_id = vb_order_header.user_id
		left join expense_payment_type on expense_payment_type.payment_type_id = vb_order_header.payment_method
		
		where $condition
				order by 
						vb_order_header.order_id DESC
		"; #vb_order_header.order_status ASC,

		$result = $this->db->query($query)->result_array();
		
		echo json_encode($result);
	}

	function LineData()
	{
		$_POST['order_id'];

		$LineDataQuery = "select 
					products.product_name,
					vb_order_line.*,
					vb_order_header.*,
					expense_payment_type.payment_type
					from vb_order_line
					
				left join vb_order_header on 
					vb_order_header.order_id = vb_order_line.order_id
				
				left join expense_payment_type on 
					expense_payment_type.payment_type_id = vb_order_header.payment_method
					
				left join products on 
					products.product_id = vb_order_line.product_id
				
				where vb_order_line.order_id='".$_POST['order_id']."'";
			
		$LineData = $this->db->query($LineDataQuery)->result_array();
		echo json_encode($LineData);
	}
	
}
?>

				
