<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Products extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function ManageProducts($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['Inventory'] = 1;
		$page_data['page_name']  = 'products/ManageProducts';
		$page_data['page_title'] = 'Manage Items';
		
		/* if(isset($_POST['delete']) && isset($_POST['checkbox']))
		{
			$cnt=array();
			$cnt=count($_POST['checkbox']);
			
			for($i=0;$i<$cnt;$i++)
			{
				$del_id=$_POST['checkbox'][$i];
				 
				$this->db->where('user_id', $del_id);
				$this->db->delete('users');
			}
			$this->session->set_flashdata('flash_message' , "Data deleted successfully!");
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		} */
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['product_code'] = $this->input->post('product_code');
					# Check Exist Start
					$chkExistProduct = $this->db->query("select product_id from products 
						where product_code='".$data['product_code']."' 
							")->result_array();
							
					if(count($chkExistProduct) > 0)
					{
						$this->session->set_flashdata('error_message' , "Item Code already exist!");
						redirect(base_url() . 'products/ManageProducts/add', 'refresh');
					}
					# Check Exist End
					
					$data['product_name'] = $this->input->post('product_name');
					$data['price'] = $this->input->post('price');
					#$data['cost'] = $this->input->post('cost');
					#$data['hsn_sac_code'] = $this->input->post('hsn_sac_code');
					#$data['unit'] = $this->input->post('unit');
					#$data['size'] = isset($_POST['size']) ? $_POST['size'] :"";
					#$data['alert_quantity'] = $this->input->post('alert_quantity');
					$data['category_id'] = $this->input->post('category_id');
					$data['subcategory_id'] = $this->input->post('subcategory_id');
					#$data['brand_id'] = $this->input->post('brand_id');
					#$data['branch_id'] = $this->input->post('branch_id');
					#$data['quantity'] = isset($_POST['quantity']) ? $_POST['quantity'] : "0";
					$data['tax_id'] = isset($_POST['tax_id']) ? $_POST['tax_id'] :"";
					#$data['track_quantity'] = isset($_POST['track_quantity']) ? $_POST['track_quantity'] :"";
					$data['description'] = $this->input->post('description');
					#$data['item_day_id'] = $this->input->post('item_day_id');
					$data['item_time_id'] = $this->input->post('item_time_id');
					
					$data['from_time_1'] = $this->input->post('from_time_1');
					$data['to_time_1'] = $this->input->post('to_time_1');
					
					$data['from_time_2'] = $this->input->post('from_time_2');
					$data['to_time_2'] = $this->input->post('to_time_2');
					
					$data['product_status'] = 1;
					
					if( isset($_POST['item_day_id']) && !empty($_POST['item_day_id']) )
					{
						$item_day_id = array_filter($_POST['item_day_id']);
						
						$data['item_day_id'] = implode(',',$item_day_id);
					}
					else
					{
						$data['item_day_id'] ='';
					}
					
					$this->db->insert('products', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						if( !empty($_FILES['product_image']['name']) )
						{  
							/* $chkExistProductImg = $this->db->query("select product_image from products 
								where product_id='".$id."' ")->result_array();
							$product_image = isset($chkExistProductImg[0]['product_image']) ? $chkExistProductImg[0]['product_image'] :"";
							
							if(!empty($product_image))
							{
								unlink('uploads/products/original_img/'.$product_image);
								unlink('uploads/products/'.$product_image);
								#unlink('uploads/products/160_160/'.$product_image);
								unlink('uploads/products/350_450/'.$product_image);
							} */
							
							$productName = $data_1['product_image'] = $fileName = $_FILES['product_image']['name'];
							
							$tmp = $_FILES['product_image']['tmp_name'];
							$uploadPath = "uploads/products/original_img/";
							
							$actualFileName = $fileName;
							$newFilePath = $uploadPath.$actualFileName;
							
							/* 
							if(move_uploaded_file($tmp, $newFilePath))
							#if(move_uploaded_file($tmp, 'uploads/products/'.$productName)
							{
								resizeImg($newFilePath, 'uploads/products/'.$actualFileName, 160, 160);	
								#resizeImg($newFilePath, 'uploads/products/160_160/'.$actualFileName, 160, 160);	
								resizeImg($newFilePath, 'uploads/products/350_450/'.$actualFileName, 350, 450);
							} */
							
							move_uploaded_file($tmp, 'uploads/products/'.$productName);
							
							$this->db->where('product_id', $id);
							$result = $this->db->update('products', $data_1);
						}
						
						$this->session->set_flashdata('flash_message' , "Item added Successfully!");
						redirect(base_url() . 'products/ManageProducts', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
			
				$page_data['edit_data'] = $this->db->get_where('products', array('product_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['product_code'] = $this->input->post('product_code');
					$data['product_name'] = $this->input->post('product_name');
					# Check Exist Start
					$chkExistProduct = $this->db->query("select product_id from products 
						where 
							product_code='".$data['product_code']."' 
								and 
								product_id !='".$id."'
							")->result_array();
							
					if(count($chkExistProduct) > 0)
					{
						$this->session->set_flashdata('error_message' , "Item Code already exist!");
						redirect(base_url() . 'products/ManageProducts/edit/'.$id, 'refresh');
					}
					# Check Exist End
					$data['price'] = $this->input->post('price');
					#$data['cost'] = $this->input->post('cost');
					#$data['hsn_sac_code'] = $this->input->post('hsn_sac_code');
					#$data['unit'] = $this->input->post('unit');
					#$data['size'] = isset($_POST['size']) ? $_POST['size'] :"";
					#$data['alert_quantity'] = $this->input->post('alert_quantity');
					$data['category_id'] 	= $this->input->post('category_id');
					$data['subcategory_id'] = $this->input->post('subcategory_id');
					#$data['brand_id'] = $this->input->post('brand_id');
					#$data['branch_id'] = $this->input->post('branch_id');
					#$data['quantity'] = isset($_POST['quantity']) ? $_POST['quantity'] : "0";
					$data['tax_id'] 			= isset($_POST['tax_id']) ? $_POST['tax_id'] :"";
					$data['sequence_number'] 	= isset($_POST['sequence_number']) ? $_POST['sequence_number'] :"";
					$data['description'] 		= $this->input->post('description');
					#$data['item_day_id'] 		= $this->input->post('item_day_id');
					$data['item_time_id'] 		= $this->input->post('item_time_id');
					
					$data['from_time_1'] = $this->input->post('from_time_1');
					$data['to_time_1'] = $this->input->post('to_time_1');
					
					$data['from_time_2'] = $this->input->post('from_time_2');
					$data['to_time_2'] = $this->input->post('to_time_2');
					
					if( isset($_POST['item_day_id']) && !empty($_POST['item_day_id']) )
					{
						$item_day_id = array_filter($_POST['item_day_id']);
						
						$data['item_day_id'] = implode(',',$item_day_id);
					}
					else
					{
						$data['item_day_id'] ='';
					}
					
					$this->db->where('product_id', $id);
					$result = $this->db->update('products', $data);
					
					if($result)
					{
						if( !empty($_FILES['product_image']['name']) )
						{  
							$chkExistProductImg = $this->db->query("select product_image from products 
								where product_id='".$id."' ")->result_array();
							$product_image = isset($chkExistProductImg[0]['product_image']) ? $chkExistProductImg[0]['product_image'] :"";
							if(!empty($product_image))
							{
								unlink('uploads/products/original_img/'.$product_image);
								unlink('uploads/products/'.$product_image);
								#unlink('uploads/products/160_160/'.$product_image);
								unlink('uploads/products/350_450/'.$product_image);
							}
							
							$data_1['product_image'] = $productName = $_FILES['product_image']['name'];
							move_uploaded_file($_FILES['product_image']['tmp_name'], 'uploads/products/'.$productName);
							
							
							/* $chkExistProductImg = $this->db->query("select product_image from products 
								where product_id='".$id."' ")->result_array();
							$product_image = isset($chkExistProductImg[0]['product_image']) ? $chkExistProductImg[0]['product_image'] :"";
							if(!empty($product_image))
							{
								unlink('uploads/products/original_img/'.$product_image);
								unlink('uploads/products/'.$product_image);
								#unlink('uploads/products/160_160/'.$product_image);
								unlink('uploads/products/350_450/'.$product_image);
							}
							
							if(!empty($product_image))
							{
								unlink('uploads/products/original_img/'.$product_image);
								unlink('uploads/products/'.$product_image);
								#unlink('uploads/products/160_160/'.$product_image);
								unlink('uploads/products/350_450/'.$product_image);
							}
							
							$data_1['product_image'] = $fileName = $_FILES['product_image']['name'];
							
							$tmp = $_FILES['product_image']['tmp_name'];
							$uploadPath = "uploads/products/original_img/";
							
							$actualFileName = $fileName;
							$newFilePath = $uploadPath.$actualFileName;
							
							if(move_uploaded_file($tmp, $newFilePath))
							#if(move_uploaded_file($tmp, 'uploads/products/'.$productName)
							{
								resizeImg($newFilePath, 'uploads/products/'.$actualFileName, 160, 160);	
								#resizeImg($newFilePath, 'uploads/products/160_160/'.$actualFileName, 160, 160);	
								resizeImg($newFilePath, 'uploads/products/350_450/'.$actualFileName, 350, 450);
							} */
						
							$this->db->where('product_id', $id);
							$result = $this->db->update('products', $data_1);
						}
						
						$this->session->set_flashdata('flash_message' , "Item updated Successfully!");
						redirect(base_url() . 'products/ManageProducts', 'refresh');
						//redirect($_SERVER['HTTP_REFERER'], 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('product_id', $id);
				$this->db->delete('products');
				
				$this->session->set_flashdata('flash_message' , "Product deleted successfully!");
				redirect(base_url() . 'products/ManageProducts', 'refresh');
			break;
			
			case "status": #Block & Unblock
			
				if($status == 1){
					$data['product_status'] = 1;
					$succ_msg = 'Item is Available!';
				}else{
					$data['product_status'] = 0;
					$succ_msg = 'Item is Unavailable!';
				}
				$this->db->where('product_id', $id);
				$this->db->update('products', $data);

				// $this->session->set_flashdata('flash_message' , $succ_msg);
				// redirect(base_url() . 'products/ManageProducts', 'refresh');

				echo ($succ_msg);
				exit;
			break;
			
			
			case "export":
			
				$data = $this->db->query("select 
						product_code,
						product_name,
						product_image
						from products where product_status =1")->result_array();
				
				#$data[] = array('f_name'=> "Nishit", 'l_name'=> "patel", 'mobile'=> "999999999", 'gender'=> "male");
				
				header("Content-type: application/csv");
				header("Content-Disposition: attachment; filename=\"item_list".".csv\"");
				header("Pragma: no-cache");
				header("Expires: 0");

				$handle = fopen('php://output', 'w');
				fputcsv($handle, array("S.No","product_code","product_name","product_image"));
				$cnt=1;
				foreach ($data as $row) 
				{
					$productImg = !empty($row["product_image"]) ? $row["product_image"] :"NO IMAGE";
					$narray=array(
							$cnt,
							$row["product_code"],
							$row["product_name"],
							$productImg
						);
					fputcsv($handle, $narray);
					$cnt++;
				}
				fclose($handle);
				exit;
			break;
			
			case "import":
				if($_FILES)
				{
					$filename = $_FILES["csv"]["tmp_name"];      
					
					if($_FILES["csv"]["size"] > 0)
					{
						$file = fopen($filename, "r");
						
						for ($lines = 0; $data = fgetcsv($file,1000,",",'"'); $lines++) 
						{
							if ($lines == 0) continue;
							
							$product_status = 1;
							
							$sql = "INSERT INTO `products`(`product_code`, `product_name`,`description`,`product_status`) 
									VALUES 
								('".$data[0]."','".$data[1]."','".$data[2]."','".$product_status."')";
							$this->db->query($sql);
						}
						fclose($file); 
					}
					else
					{
						$this->session->set_flashdata('error_message' , "Products imported error!");
						redirect(base_url() . 'products/ManageProducts', 'refresh');
					}
					$this->session->set_flashdata('flash_message' , "Products Imported successfully!");
					redirect(base_url() . 'products/ManageProducts', 'refresh');
				}
			break;
			
			case "ingredientStatus": #Block & Unblock
				if($status == 1){
					$data['status'] = 1;
					$succ_msg = 'Ingredient is Available!';
				}else{
					$data['status'] = 0;
					$succ_msg = 'Ingredient is Unavailable!';
				}
				$this->db->where('ingredient_id', $id);
				$this->db->update('vb_product_ingredients', $data);

				// $this->session->set_flashdata('flash_message' , $succ_msg);
				// redirect(base_url() . 'products/ManageProducts', 'refresh');

				echo ($succ_msg);
				exit;
			break;

			case "ingredients":
				if(isset($_POST['add']))
				{
					$data['product_id'] = $id;
					$data['ingredient_name'] = ucfirst($this->input->post('ingredient_name'));
					$data['ingredients_description'] = $this->input->post('ingredients_description');
					$data['status'] = 1;

					$this->db->insert('vb_product_ingredients', $data);
					$ingredientsID = $this->db->insert_id();

					if($ingredientsID)
					{
						$this->session->set_flashdata('flash_message' , "Ingredient Added successfully!");
						redirect(base_url() . 'products/ManageProducts/ingredients/'.$id, 'refresh');
					}
				}
				else if(isset($_POST['update']))
				{
					$ingredient_id = $this->input->post('ingredient_id');
					
					$data['ingredient_name'] = ucfirst($this->input->post('ingredient_name'));
					$data['ingredients_description'] = $this->input->post('ingredients_description');
					
					$this->db->where('ingredient_id', $ingredient_id);
					$this->db->update('vb_product_ingredients', $data);

					$this->session->set_flashdata('flash_message' , "Ingredient updated successfully!");
					redirect(base_url() . 'products/ManageProducts/ingredients/'.$id, 'refresh');
				}

				$page_data["totalRows"] = $totalRows = $this->products_model->getProductsIngredientsCount($id);
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('products/ManageProductsn/gredients/'.$id.'?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('products/ManageProducts/gredients/'.$id.'?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->products_model->getProductsIngredients($limit, $offset,$id);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
			
			default : #Manage
		
				if (!empty($_POST["product_image"])) {
					if (is_uploaded_file($_FILES['userImage']['tmp_name'])) {
						$targetPath = "uploads/" . $_FILES['userImage']['name'];
						if (move_uploaded_file($_FILES['userImage']['tmp_name'], $targetPath)) {
							$uploadedImagePath = $targetPath;
						}
					}
				}

				$page_data["totalRows"] = $totalRows = $this->products_model->getProductsCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('products/ManageProducts?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('products/ManageProducts?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->products_model->getProducts($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	function ManageProductType($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['Inventory'] = 1;
		$page_data['page_name']  = 'products/ManageProductType';
		$page_data['page_title'] = 'Manage Product Type';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['product_type'] = $this->input->post('product_type');
					$data['product_type_description'] = $this->input->post('product_type_description');
					$data['product_type_status'] = 1;
					
					# Check Exist Start
					$chkExist = $this->db->query("select product_type_id from inv_product_types 
						where 
							product_type='".$data['product_type']."' 
							")->result_array();
							
					if(count($chkExist) > 0)
					{
						$this->session->set_flashdata('error_message' , "Product type already exist!");
						redirect(base_url() . 'products/ManageProductType/add', 'refresh');
					}
					# Check Exist End
					
					$this->db->insert('inv_product_types', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						
						$this->session->set_flashdata('flash_message' , "Product type added Successfully!");
						redirect(base_url() . 'products/ManageProductType', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('inv_product_types', array('product_type_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['product_type'] = $this->input->post('product_type');
					$data['product_type_description'] = $this->input->post('product_type_description');
					
					# Check Exist Start
					$chkExist = $this->db->query("select product_type_id from inv_product_types 
						where 
							product_type='".$data['product_type']."' and 
							product_type_id !='".$id."'
							")->result_array();
							
					if(count($chkExist) > 0)
					{
						$this->session->set_flashdata('error_message' , "Product type already exist!");
						redirect(base_url() . 'products/ManageProductType/edit/'.$id, 'refresh');
					}
					# Check Exist End
					
					$this->db->where('product_type_id', $id);
					$result = $this->db->update('inv_product_types', $data);
					
					if($result)
					{
						$this->session->set_flashdata('flash_message' , "Product type updated Successfully!");
						redirect(base_url() . 'products/ManageProductType', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('product_type_id', $id);
				$this->db->delete('inv_product_types');
				
				$this->session->set_flashdata('flash_message' , "Product type deleted successfully!");
				redirect(base_url() . 'products/ManageProductType', 'refresh');
			break;
			
			case "status": #Block & Unblock
			
				if($status == 1){
					$data['product_type_status'] = 1;
					$succ_msg = 'Product type unblocked successfully!';
				}else{
					$data['product_type_status'] = 0;
					$succ_msg = 'Product type blocked successfully!';
				}
				$this->db->where('product_type_id', $id);
				$this->db->update('inv_product_types', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'products/ManageProductType', 'refresh');
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->products_model->getProductsTypeCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('products/ManageProductType?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('products/ManageProductType?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->products_model->getProductsTypes($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	
	function ManageProductsCosting($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['Inventory'] = 1;
		$page_data['page_name']  = 'products/ManageProductsCosting';
		$page_data['page_title'] = 'Manage Product Costing';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					if(!empty($_POST['end_date'])){
						$endDate = strtotime($_POST['end_date']);
					}else{
						$endDate = '';
					}
					
					$data['product_id'] = $this->input->post('product_id');
					$data['product_cost'] = $this->input->post('product_cost');
					$data['start_date'] = strtotime($this->input->post('start_date'));
					$data['end_date'] = $endDate;
					$data['product_costing_status'] = 1;
					
					# Check Exist Start
					/* $chkExist = $this->db->query("select product_type_id from inv_product_types 
						where 
							product_type='".$data['product_type']."' 
							")->result_array();
							
					if(count($chkExist) > 0)
					{
						$this->session->set_flashdata('error_message' , "Product type already exist!");
						redirect(base_url() . 'products/ManageProductType/add', 'refresh');
					} */
					# Check Exist End
					
					$this->db->insert('inv_product_costing', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						$this->session->set_flashdata('flash_message' , "Product costing added Successfully!");
						redirect(base_url() . 'products/ManageProductsCosting', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('inv_product_costing', array('product_costing_id' => $id))
								->result_array();
								
				if($_POST)
				{
					if(!empty($_POST['end_date'])){
						$endDate = strtotime($_POST['end_date']);
					}else{
						$endDate ='';
					}
					
					$data['product_id'] = $this->input->post('product_id');
					$data['product_cost'] = $this->input->post('product_cost');
					$data['start_date'] = strtotime($this->input->post('start_date'));
					$data['end_date'] = $endDate;
					
					# Check Exist Start
					/* $chkExist = $this->db->query("select product_type_id from inv_product_types 
						where 
							product_type='".$data['product_type']."' and 
							product_type_id !='".$id."'
							")->result_array();
							
					if(count($chkExist) > 0)
					{
						$this->session->set_flashdata('error_message' , "Product type already exist!");
						redirect(base_url() . 'products/ManageProductType/edit/'.$id, 'refresh');
					} */
					# Check Exist End
					
					$this->db->where('product_costing_id', $id);
					$result = $this->db->update('inv_product_costing', $data);
					
					if($result)
					{
						$this->session->set_flashdata('flash_message' , "Product Costing updated Successfully!");
						redirect(base_url() . 'products/ManageProductsCosting', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('product_costing_id', $id);
				$this->db->delete('inv_product_costing');
				
				$this->session->set_flashdata('flash_message' , "Product Costing deleted successfully!");
				redirect(base_url() . 'products/ManageProductsCosting', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['product_costing_status'] = 1;
					$succ_msg = 'Product Costing unblocked successfully!';
				}else{
					$data['product_costing_status'] = 0;
					$succ_msg = 'Product Costing blocked successfully!';
				}
				$this->db->where('product_costing_id', $id);
				$this->db->update('inv_product_costing', $data);
				
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'products/ManageProductsCosting', 'refresh');
			break;
			
			case "CopyCost": #CopyCost
				$page_data["totalRows"] = $totalRows = $this->products_model->getProductsCopyCostCount();
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('products/ManageProductsCosting/CopyCost?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('products/ManageProductsCosting/CopyCost?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->products_model->getProductsCopyCost($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
			
			case "CostingAdjustment": #CostingAdjustment
				
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->products_model->getProductsCostingCount();
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('products/ManageProductsCosting?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('products/ManageProductsCosting?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->products_model->getProductsCosting($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	function ManageItemDays($type = '', $id = '', $status = '')
	{
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['manage_settings'] = $page_data['Setups'] = 1;
		$page_data['page_name']  = 'products/ManageProductDays';
		$page_data['page_title'] = 'Manage Items Days';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['item_days'] = $this->input->post('item_days');
					$data['item_day_status'] = 1;
					
					$id=$this->db->insert('vb_item_days', $data);					
					
					if($id)
					{
						$this->session->set_flashdata('flash_message' , "Item day added successfully!");
						redirect(base_url() . 'products/ManageItemDays', 'refresh');
					}
				}
				
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('vb_item_days', array('item_day_id' => $id))
										->result_array();
				if($_POST)
				{			
					$data['item_days'] = $this->input->post('item_days');
					
					$this->db->where('item_day_id', $id);
					$result = $this->db->update('vb_item_days', $data);
					
					$this->session->set_flashdata('flash_message' , "Item day updated successfully!");
					redirect(base_url() . 'products/ManageItemDays', 'refresh');
				}
			break;
			
			/* case "delete": #Delete
				$this->db->where('item_day_id', $id);
				$this->db->delete('vb_item_days');
				
				$this->session->set_flashdata('flash_message' , "Product deleted successfully!");
				redirect(base_url() . 'products/ManageItemDays', 'refresh');
			break; */
			
			case "status": #Block & Unblock
			
				if($status == 1){
					$data['item_day_status'] = 1;
					$succ_msg = 'Item day Active successfully!';
				}else{
					$data['item_day_status'] = 0;
					$succ_msg = 'Item day Inactive successfully!';
				}
				$this->db->where('item_day_id', $id);
				$this->db->update('vb_item_days', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'products/ManageItemDays', 'refresh');
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->products_model->getItemDaysCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('products/ManageItemDays?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('products/ManageItemDays?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->products_model->getItemDays($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	
	function ManageItemTiming($type = '', $id = '', $status = '')
	{
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['manage_settings'] = $page_data['Setups'] = 1;
		$page_data['page_name']  = 'products/ManageItemTiming';
		$page_data['page_title'] = 'Manage Items Timing';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['item_from_time'] = $this->input->post('item_from_time');
					$data['item_to_time'] = $this->input->post('item_to_time');
					$data['	item_time_status'] = 1;
					
					$id=$this->db->insert('vb_item_timings', $data);					
					
					if($id)
					{
						$this->session->set_flashdata('flash_message' , "Item timing added successfully!");
						redirect(base_url() . 'products/ManageItemTiming', 'refresh');
					}
				}
				
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('vb_item_timings', array('item_time_id' => $id))
										->result_array();
				if($_POST)
				{			
					$data['item_from_time'] = $this->input->post('item_from_time');
					$data['item_to_time'] = $this->input->post('item_to_time');
					
						$this->db->where('item_time_id', $id);
					$result = $this->db->update('vb_item_timings', $data);
					
					$this->session->set_flashdata('flash_message' , "Item timing updated successfully!");
					redirect(base_url() . 'products/ManageItemTiming', 'refresh');
				}
			break;
			
			/* case "delete": #Delete
				$this->db->where('item_day_id', $id);
				$this->db->delete('vb_item_days');
				
				$this->session->set_flashdata('flash_message' , "Product deleted successfully!");
				redirect(base_url() . 'products/ManageItemDays', 'refresh');
			break; */
			
			case "status": #Block & Unblock
			
				if($status == 1){
					$data['item_time_status'] = 1;
					$succ_msg = 'Item time Active successfully!';
				}else{
					$data['item_time_status'] = 0;
					$succ_msg = 'Item time Inactive successfully!';
				}
				$this->db->where('item_time_id', $id);
				$this->db->update('vb_item_timings', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'products/ManageItemTiming', 'refresh');
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->products_model->getItemTimingsCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('products/ManageItemTiming?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('products/ManageItemTiming?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->products_model->getItemTimings($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
}
?>
