<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Products_offers extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function ManageProductsOffers($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageProductsOffers'] = 1;
		$page_data['page_name']  = 'products_offers/ManageProductsOffers';
		$page_data['page_title'] = 'Manage Items';
		
		switch($type)
		{
			case "add": #Add
				if($_POST)
				{
					$branch_id = $this->input->post('branch_id');
					$offer_date = strtotime($this->input->post('offer_date'));
					
					# Check Exist Start
					$chkExistProduct = $this->db->query("select branch_item_offer_header_id from vb_branch_item_offer_header 
						where 
							branch_id='".$branch_id."' and
								date='".date('Y-m-d',$offer_date)."'
							")->result_array();
							
					if(count($chkExistProduct) > 0)
					{
						$this->session->set_flashdata('error_message' , "Branch items offers already added in this date!");
						redirect(base_url() . 'products_offers/ManageProductsOffers/add', 'refresh');
					}
					# Check Exist End
					
					$data = array(
						"branch_id" 	=>  $branch_id,
						"date" 		    =>  date('Y-m-d',$offer_date),
						"note" 		    =>  $this->input->post('note'),
						"created_date" 	=>  $offer_date,
					);
					
					$this->db->insert('vb_branch_item_offer_header', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						$tableLineData = $this->input->post('table_data');
						$js_data = json_decode($tableLineData);
						
						foreach ($js_data as $key => $value) 
						{
							if($value==null)
							{
								
							}
							else
							{
								$lineData = array(
									"product_id"                 => $value->product_id,
									"item_offer"                  => $value->item_offer,
									
									"start_date"                  => date('Y-m-d',strtotime($value->task_start_date)),
									"end_date"                    => date('Y-m-d',strtotime($value->task_end_date)),
									
									"start_date_string"           => strtotime($value->task_start_date),
									"end_date_string"             => strtotime($value->task_end_date),
									
									"item_status"                 => $value->item_status,
									"branch_item_offer_header_id" => $id
								);
								
								$this->db->insert('vb_branch_item_offer_line', $lineData);
								$BranchItems  = $this->db->insert_id();
							}
						}
						
						$this->session->set_flashdata('flash_message' , "Branch Items offer added Successfully!");
						redirect(base_url() . 'products_offers/ManageProductsOffers', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$branch_item_offer_header_id  = $id;
				$branch_id  = $status;
				$page_data['data'] = $this->productsoffers_model->getRecord($id);
				$page_data['items'] = $this->productsoffers_model->getBranchItems($branch_item_offer_header_id,$branch_id);	
				
				if($_POST)
				{
					$branch_id = $this->input->post('branch_id');
					$offer_date = strtotime($this->input->post('offer_date'));
					
					# Check Exist Start
					$chkExistProduct = $this->db->query("select branch_item_offer_header_id from vb_branch_item_offer_header 
						where 
							branch_id='".$branch_id."' and
								date='".date('Y-m-d',$offer_date)."' and 
									branch_item_offer_header_id !='".$id."' 
							")->result_array();
							
					if(count($chkExistProduct) > 0)
					{
						$this->session->set_flashdata('error_message' , "Branch items offers already added in this date!");
						redirect(base_url() . 'products_offers/ManageProductsOffers/add', 'refresh');
					}
					# Check Exist End
					
					$data = array(
						"branch_id" 	=>  $branch_id,
						"date" 		    =>  date('Y-m-d',$offer_date),
						"note" 		    =>  $this->input->post('note'),
						"created_date" 	=>  $offer_date,
					);
					
					$this->db->where('branch_item_offer_header_id', $id);
					$result = $this->db->update('vb_branch_item_offer_header', $data);
					
					if($result)
					{
						$js_data = json_decode($this->input->post('table_data1'));			
						$php_data = json_decode($this->input->post('table_data'));
						
						if(!empty($js_data))
						{
							foreach (array_filter($js_data) as $key => $value) 
							{
								if($value == 'delete')
								{
									$product_id = $php_data[$key];
									$DeleteBranchItems = $this->productsoffers_model->deleteBranchItems($id,$product_id,$branch_id);
								}
								else if($value==null)
								{
									
								}
								else
								{
									$product_id = $value->product_id;
									
									$lineData = array(
										"product_id"                 => $value->product_id,
										"item_offer"                  => $value->item_offer,
										
										"start_date"                  => date('Y-m-d',strtotime($value->task_start_date)),
										"end_date"                    => date('Y-m-d',strtotime($value->task_end_date)),
										
										"start_date_string"           => strtotime($value->task_start_date),
										"end_date_string"             => strtotime($value->task_end_date),
										
										"item_status"                 => $value->item_status,
										"branch_item_offer_header_id" => $id
									);
									
									$SelectQuery = "select branch_item_offer_line_id from vb_branch_item_offer_line 
										where 
											branch_item_offer_header_id = '".$id."' and 
												product_id = '".$product_id."' ";
											
									$result = $this->db->query($SelectQuery)->result_array();
									
									if( count($result) > 0 )
									{
										$where = "branch_item_offer_header_id = '".$id."' AND product_id = '".$product_id."'";
										$this->db->where($where);
										$this->db->update('vb_branch_item_offer_line',$lineData);
									}
									else
									{
										$this->db->insert('vb_branch_item_offer_line', $lineData);
										$BranchItems  = $this->db->insert_id();
									}
								}
							}
						}
						
						$this->session->set_flashdata('flash_message' , "Branch Items offer updated Successfully!");
						redirect(base_url() . 'products_offers/ManageProductsOffers', 'refresh');
					}
				}
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->productsoffers_model->getBranchItemOffersCount();
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('products_offers/ManageProductsOffers?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('products_offers/ManageProductsOffers?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->productsoffers_model->getBranchItemOffers($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	public function getProducts($branch_id="") 
	{
		if($branch_id)
		{
			$query = "select 
				products.product_id,
				products.product_name,
				products.product_code from vb_branch_items_header
			
			left join vb_branch_items_line on 
				vb_branch_items_line.branch_item_header_id = vb_branch_items_header.branch_item_header_id
			
			left join products on 
				products.product_id = vb_branch_items_line.product_id
			
			where vb_branch_items_header.branch_id='".$branch_id."'
			"; 
			
			$data = $this->db->query($query)->result_array();
			
			if( count($data) > 0)
			{
				echo '<option value="">- Select Item -</option>';
				foreach($data as $val)
				{
					echo '<option value="'.$val['product_id'].'">'.ucfirst($val['product_name']).'-'.$val['product_code'].'</option>';
				}
			}
			else
			{
				echo '<option value="">No items under this branch!</option>';
			}
		}
		die;
    }
	
	public function viewBranchItemOffers($branch_item_offer_header_id="", $branch_id="")
	{
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['id'] = $branch_item_offer_header_id;
		$page_data['branch_id'] = $branch_id;
		
		$page_data['ManageProductsOffers'] = 1;
		
		$page_data['page_name']  = 'products_offers/viewBranchItemOffers';
		$page_data['page_title'] = 'Branch Item Offers';

		$this->load->view($this->adminTemplate, $page_data);
	}
	
}
?>
