<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Reviews extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function ManageReviews($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['ManageReviews'] =  1;
		
		$page_data['page_name']  = 'reviews/ManageReviews';
		$page_data['page_title'] = 'Manage Reviews';
		
		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$data['branch_code'] = $this->input->post('branch_code');
					$existBranchCode = $this->db->query("select branch_id from branch where branch_code='".$data['branch_code']."' ")->result_array();
					if(count($existBranchCode) > 0 )
					{
						$this->session->set_flashdata('error_message' , "Sorry! Already exist branch code!");
						redirect(base_url() . 'branches/ManageBranches', 'refresh');
					}
					$data['user_id']	= $this->input->post('user_id');
					$data['country_id']	= $this->input->post('country_id');
					$data['state_id']	= $this->input->post('state_id');
					$data['branch_code'] = $this->input->post('branch_code');
					$data['branch_name'] = $this->input->post('branch_name');
					$data['description'] = 0;
					$data['phone_number'] = $this->input->post('phone_number');
					$data['address'] = $this->input->post('address');
					$data['location'] = $this->input->post('location');
					$data['phone_number_2'] = $this->input->post('phone_number_2');
					
					$latLong = getGeoLatLong($data['location']);
					$data['latitude'] = $latLong['latitude'];
					$data['longitude'] = $latLong['longitude'];
					
					$data['branch_status'] = 1;
					
					# Branch Code exist start here
						$chkExistBranch = $this->db->query("select branch_id from branch
							where 
								branch_code='".$data['branch_code']."' or
								branch_name='".$data['branch_name']."'
								 ")->result_array();
						if(count($chkExistBranch) > 0)
						{
							$this->session->set_flashdata('error_message' , " Branch Name and Code already exist!");
							redirect(base_url() . 'branches/ManageBranches/add', 'refresh');
						}		
						
					# Branch Code exist end here
					
					$this->db->insert('branch', $data);
					$id = $this->db->insert_id();

					if($id !="")
					{
						$this->session->set_flashdata('flash_message' , "Branch added Successfully!");
						redirect(base_url() . 'branches/ManageBranches', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('branch', array('branch_id' => $id))
										->result_array();
										
				$data['branch_code'] = $this->input->post('branch_code');
				
				$existBranchCode = $this->db->query("select branch_id from branch where branch_code='".$data['branch_code']."' and branch_id !='".$id."'")->result_array();
				
				if(count($existBranchCode) >0 )
				{
					$this->session->set_flashdata('error_message' , "Sorry! Already exist branch code!");
					redirect(base_url() . 'branches/ManageBranches/edit/'.$id, 'refresh');
				}
				if($_POST)
				{
					$data['user_id']	= $this->input->post('user_id');
					
					$data['branch_code'] = $this->input->post('branch_code');
					$data['branch_name'] = $this->input->post('branch_name');
					$data['description'] = $this->input->post('description');
					$data['phone_number'] = $this->input->post('phone_number');
					$data['address'] = $this->input->post('address');
					$data['location'] = $this->input->post('location');
					$data['phone_number_2'] = $this->input->post('phone_number_2');

					$data['country_id'] = $this->input->post('country_id');
					$data['state_id'] = $this->input->post('state_id');
					
					$latLong = getGeoLatLong($data['location']);
					$data['latitude'] = $latLong['latitude'];
					$data['longitude'] = $latLong['longitude'];
					
					$this->db->where('branch_id', $id);
					$result = $this->db->update('branch', $data);
					
					if($result)
					{
						$this->session->set_flashdata('flash_message' , "Branch updated Successfully!");
						redirect(base_url() . 'branches/ManageBranches', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('branch_id', $id);
				$this->db->delete('branch');
				
				$this->session->set_flashdata('flash_message' , "Branch deleted successfully!");
				redirect(base_url() . 'branches/ManageBranches', 'refresh');
			break;
			
			case "view": #view
				$page_data["reviews"] = $this->Reviews_model->getReviewsview($id);

				if($_POST && !empty($_POST['review_description'])) {
					$data['review_description']			= $this->input->post('review_description');
					$data['post_status']				= 1;
					
					$data['review_id']					= $id;
					$data['created_date']				= time();
					$data['user_id']					= $this->user_id;

					$result = $this->db->insert('vb_item_reviews_line', $data);

					$data = [];
					$data['reply_status']				= 1;

					$this->db->where('review_id', $id);
					$result = $this->db->update('vb_item_reviews',$data);

					if($result)
					{
						$this->session->set_flashdata('flash_message' , "Replayed Successfully!");
						redirect(base_url() . 'reviews/ManageReviews/view/'.$id, 'refresh');
					}
				}
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->Reviews_model->getReviewsCount();#
	
				if(!empty($_SESSION['PAGE']))
				{
					$limit = $_SESSION['PAGE'];
				}else{
					$limit = 10;
				}
				
				if (!empty($_GET['keywords'])) {
					$base_url = base_url('branches/ManageBranches?keywords='.$_GET['keywords']);
				} else {
					$base_url = base_url('branches/ManageBranches?keywords=');
				}
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $this->Reviews_model->getReviews($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}	
}
?>
