<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Tax extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function manageTax($type = '', $id = '', $status = '')
    {
		if (empty($this->user_id))
        {
			redirect(base_url() . 'admin/adminLogin', 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		$page_data['manage_settings'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'tax/manageTax';
		$page_data['page_title'] = 'Manage TAX';
		
		if(isset($_POST['default_submit']))
		{
			$data['default_tax'] = 0;
			$result = $this->db->update('tax', $data);
			
			if($result)
			{
				$tax_id = $_POST['default_tax'];
				$data_1['default_tax'] = 1;
				$this->db->where('tax_id', $tax_id);
				$result1 = $this->db->update('tax', $data_1);
			}
			$this->session->set_flashdata('flash_message' , 'Default Tax updated successfully.');
			redirect(base_url() . 'tax/ManageTax', 'refresh');
		}

		switch($type)
		{
			case "add": #View
				if($_POST)
				{
					$tax_name = $this->input->post('tax_name');
					$data['tax_name'] =  str_replace(' ', '', $tax_name);
					
					# Tax Name exist start here
						$chktaxname = $this->db->query("select tax_id from tax 
							where 
								tax_name='".$data['tax_name']."'
								")->result_array();
						
						if(count($chktaxname) > 0)
						{
							$this->session->set_flashdata('error_message' , "Tax already exist!");
							redirect(base_url() . 'tax/ManageTax/add', 'refresh');
						}
					# Tax Name exist end here
					
					$p_tax = $this->input->post('purchase_tax_value');
					$s_tax = $this->input->post('tax_value');
					if($p_tax==null){
						$p_tax=0;
					}
					
					if($s_tax==null){
						$s_tax=0;
					}
			
					
					$data['start_from'] = $this->input->post('start_from');
					$data['registration_number'] = $this->input->post('registration_number');
					$data['filling_frequency'] = $this->input->post('frequency');
					$data['calculate_on'] = $this->input->post('calculate_on');
					$data['tax_value'] = $s_tax;
					$data['purchase_tax_value'] = $p_tax;
					$data['description'] = $this->input->post('description');
					$data['tax_status'] = 1;
					
					$this->db->insert('tax', $data);
					$id = $this->db->insert_id();
					
					if($id !="")
					{	
						$this->session->set_flashdata('flash_message' , "Tax added Successfully!");
						redirect(base_url() . 'tax/ManageTax', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('tax', array('tax_id' => $id))
										->result_array();
				if($_POST)
				{
					$tax_name = $this->input->post('tax_name');
					$data['tax_name'] =  str_replace(' ', '', $tax_name);
					
					# TAX exist start here
					$chktaxname = $this->db->query("select tax_id from tax 
						where 
							tax_id !='".$id."' and 
								( tax_name='".$data['tax_name']."' )
							")->result_array();
					
					if( count($chktaxname) > 0 )
					{
						$this->session->set_flashdata('error_message' , "Tax already exist!");
						redirect(base_url() . 'tax/ManageTax/edit/'.$id, 'refresh');
					}
					# TAX exist end here
					
					$p_tax = $this->input->post('purchase_tax_value');
					$s_tax = $this->input->post('tax_value');
					
					if($p_tax==null){
						$p_tax=0;
					}
					
					if($s_tax==null){
						$s_tax=0;
					}
			
					
					$data['start_from'] = $this->input->post('start_from');
					$data['registration_number'] = $this->input->post('registration_number');
					$data['filling_frequency'] = $this->input->post('frequency');
					$data['calculate_on'] = $this->input->post('calculate_on');
					$data['tax_value'] = $s_tax;
					$data['purchase_tax_value'] = $p_tax;
					$data['description'] = $this->input->post('description');
					$this->db->where('tax_id', $id);
					$result = $this->db->update('tax', $data);
					
					if($result)
					{
						$this->session->set_flashdata('flash_message' , "Tax updated Successfully!");
						redirect(base_url() . 'tax/ManageTax', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('tax_id', $id);
				$this->db->delete('tax');
				
				$this->session->set_flashdata('flash_message' , "Tax deleted successfully!");
				redirect(base_url() . 'tax/ManageTax', 'refresh');
			break;
			
			case "status": #Block & Unblock
				if($status == 1){
					$data['tax_status'] = 1;
					$succ_msg = 'Tax unblocked successfully!';
				}else{
					$data['tax_status'] = 0;
					$succ_msg = 'Tax blocked successfully!';
				}
				$this->db->where('tax_id', $id);
				$this->db->update('tax', $data);
				$this->session->set_flashdata('flash_message' , $succ_msg);
				redirect(base_url() . 'tax/ManageTax', 'refresh');
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->tax_model->getManageTAXCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				$base_url = base_url().'tax/ManageTax';
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $data =$this->tax_model->getManageTax($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->adminTemplate, $page_data);
	}
	
	
	
	
}
?>
