<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Web_items extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function itemList($category_url="",$categoryID="",$branchID="")
    {
		
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		if( isset($_POST) && isset($_POST['cartBtn']) && !empty($_POST["quantity"]))
		{	
			$IngSerialize ='';
			
			if(isset($_POST['ingredients']) && !empty($_POST['ingredients']))
			{
				$IngSerialize = serialize($_POST['ingredients']);
			}
			
			$_SESSION['category_id'] = $_POST["category_id"];
			$_SESSION['branch_id'] = $_POST["branch_id"];
			
			$productByCode = $this->db->query("SELECT product_id,product_code,product_name FROM products WHERE product_id='" . $_POST['product_id'] . "'")->result_array();
			
			$itemArray = array(
				$productByCode[0]["product_code"] =>
				array(
					'product_name'        => $productByCode[0]["product_name"], 
					'product_code'        => $productByCode[0]["product_code"], 
					'quantity'            => $_POST["quantity"], 
					'price'               => $_POST["p_price"],
					'product_id'          => $_POST["product_id"],
					'category_id'         => $_POST["category_id"],
					'branch_id'           => $_POST["branch_id"],
					'available_quantity'  => $_POST["available_quantity"],
					'ingredients'         => $IngSerialize
				)
			);
			
			if(!empty($_SESSION["cart_item"])) 
			{	
				#if(in_array($productByCode[0]["product_code"],$_SESSION["cart_item"])) 
				if(is_array($_SESSION["cart_item"])) 
				{
					foreach($_SESSION["cart_item"] as $k => $v) 
					{
						if($productByCode[0]["product_code"] == $k)
						{	
							$_SESSION["cart_item"][$k]["quantity"] = $_POST["quantity"];
							$_SESSION["cart_item"][$k]["ingredients"] = $IngSerialize;
						}
						else
						{
							$_SESSION["cart_item"] = $_SESSION["cart_item"]+$itemArray;
						}
					}
					$this->session->set_flashdata('success_message', 'Item successfully updated to your cart');
					redirect($_SERVER['HTTP_REFERER'], 'refresh');
					#redirect(base_url()."menu-items.html/".$category_url."/".$categoryID."/".$branchID."/"."#item-".$_POST["product_id"], 'refresh');
				} 
				else
				{
					$_SESSION["cart_item"] = $_SESSION["cart_item"]+$itemArray;
				}
			} 
			else 
			{	
				$_SESSION["cart_item"] = $itemArray;

				$this->session->set_flashdata('success_message', 'Item successfully added to your cart');
				redirect($_SERVER['HTTP_REFERER'], 'refresh');
			
				#redirect(base_url()."menu-items.html/".$category_url."/".$categoryID."/".$branchID."/"."#item-".$_POST["product_id"], 'refresh');
				
			}
		}
		
		$category_id = decode($categoryID);
		$branch_id = decode($branchID);
		
		
		
		$page_data['page_title'] = SITE_NAME.' | Items Listing'; #Page Title
		$page_data['category_id'] = $category_id;
		$page_data['category_url'] = $category_url;
		$page_data['branchID'] = $branch_id;
		
		$page_data['page_name']  = "web_items/itemList";
		#View Page
		
		$condition = ' vb_branch_items_line.item_status=1 and
			branch.branch_id="'.$branch_id.'" and
			category.category_status=1
		';
		
		$query = "select 
				category.*,
				branch.branch_id,
				branch.branch_name,
				branch.address,
				branch.opening_time,
				branch.closing_time,
				branch.minimum_order_value
				
				from category
				
				join products on 
					products.category_id = category.category_id
				
				join vb_branch_items_line on 
					vb_branch_items_line.product_id = products.product_id
				
				join vb_branch_items_header on 
					vb_branch_items_header.branch_item_header_id = vb_branch_items_line.branch_item_header_id
				
				join branch on 
					branch.branch_id = vb_branch_items_header.branch_id
				
		where $condition 
				group by products.category_id 
					order by products.sequence_number asc";
		$page_data["menuData"] = $this->db->query($query)->result_array();
		
		$this->load->view($this->template, $page_data);
	}
	
	function AjaxSearchBranch()
    {
		$deliveryLocation = isset($_POST['deliveryLocation']) ? $_POST['deliveryLocation'] :"";
			
		if( !empty($deliveryLocation) &&  !empty($_SESSION['DELIVERY_LATITUDE']) && !empty($_SESSION['DELIVERY_LONGITUDE']) && isset($_SESSION['DELIVERY_LATITUDE']) && isset($_SESSION['DELIVERY_LONGITUDE']))
		{
			$lat  = isset($_SESSION['DELIVERY_LATITUDE']) ? $_SESSION['DELIVERY_LATITUDE'] : "12.745458";
			$lon = isset($_SESSION['DELIVERY_LONGITUDE']) ? $_SESSION['DELIVERY_LONGITUDE'] : "77.81027069999999";
			#echo $lat."==".$lon;
		}
		else
		{
			#echo '1df';
			unset($_SESSION['DELIVERY_LATITUDE']); 
			unset($_SESSION['DELIVERY_LONGITUDE']); 
			unset($_SESSION['DELIVERY_ADDRESS']);
			
			//echo $_COOKIE['DELIVERY_LATITUDE'];
			$lat  = isset($_COOKIE['CURRENT_LATITUDE']) ? $_COOKIE['CURRENT_LATITUDE'] : "12.745458";
			$lon = isset($_COOKIE['CURRENT_LONGITUDE']) ? $_COOKIE['CURRENT_LONGITUDE'] : "77.81027069999999";
			#echo $lat."++".$lon;
		}
		
		$deliveryAddress1 = getDeliveyrZoneBranches($lat,$lon);
		$FilerdeliveryAddress =  array_filter(explode("@",$deliveryAddress1));
		$deliveryAddress = $FilerdeliveryAddress[0];
		$deliveryAddress_1 = isset($FilerdeliveryAddress[1]) ? $FilerdeliveryAddress[1] :"";
		
		#$deliveryAddress = getDeliveyrAddress($lat,$lon);
		#$deliveryAddress = getBranchByZones($lat,$lon);
		
		/* $filterdeliveryAddress = array_filter(explode(",",$deliveryAddress));
		print_r($filterdeliveryAddress);
		
		if(!empty($filterdeliveryAddress))
		{
			$condition = ' (branch.branch_status = 1 ) and ';
				
			$zone_name = '';
			
			foreach($filterdeliveryAddress as $key=>$value)
			{
				$zone_name = $value;
				
				$condition .= '  
				(
					vb_branch_zones.zone_name like "%'.($zone_name).'%"
				)  and ';	
			}
			
			$condition .= ' vb_branch_zones.zone_status = 1 ';
				
			if(!empty($_POST["query"]))
			{
				$condition .= ' and (
								branch.branch_name like "%'.($_POST["query"]).'%" or 
								branch.branch_code like "%'.($_POST["query"]).'%" or
								branch.address like "%'.($_POST["query"]).'%"
							)
						';
			}
		}
		else
		{
			$condition = ' branch.branch_status = 1 and vb_branch_zones.zone_status = 1';
		} */
		
		# Single Long name | Neighbourhood only start
		if(!empty($deliveryAddress))
		{
			$condition = ' (branch.branch_status = 1 ) and ';
			
			if(!empty($deliveryAddress) && !empty($deliveryAddress_1) )
			{
				$condition .= '  
				(
					vb_branch_zones.zone_name like "%'.($deliveryAddress).'%" or
					vb_branch_zones.zone_name like "%'.($deliveryAddress_1).'%"
				)  and ';	
			}
			else
			{
				$condition .= '  
				(
					vb_branch_zones.zone_name like "%'.($deliveryAddress).'%"
				)  and ';
			}
		
			$condition .= ' vb_branch_zones.zone_status = 1 ';
				
			if(!empty($_POST["query"]))
			{
				$condition .= ' and (
								branch.branch_name like "%'.($_POST["query"]).'%" or 
								branch.branch_code like "%'.($_POST["query"]).'%" or
								branch.address like "%'.($_POST["query"]).'%"
							)
						';
			}
		}
		else
		{
			$condition = ' branch.branch_status = 1 and vb_branch_zones.zone_status = 1';
		} 
		# Single Long name | Neighbourhood only end
		
		$branchQuery = "select 
				branch.branch_id,
				branch.branch_name,
				branch.branch_code,
				branch.address,
				branch.phone_number,
				branch.delivery_distance

				from branch 
				
				left join vb_branch_zones on
					vb_branch_zones.branch_id = branch. branch_id
				
					where ".$condition." group by branch.branch_name
				ORDER BY branch.branch_name asc
		";
		
		
		//echo $branchQuery;
		$result = $this->db->query($branchQuery)->result_array();
	
		$output = '<ul class="row list-unstyled nearest-branches">';  
			
		if( count($result) > 0 )  
		{  
			foreach($result as $row)  
			{	
				$branch_id = $row["branch_id"];
				$branch_name = $row["branch_name"];
				$branch_code = $row["branch_code"];
				$address = $row["address"];
				
				$output .= '<li onclick="return getSearchID(\'' .$branch_id. '\',\'' .$branch_name. '\');"><i class="fa fa-location-arrow"></i> &nbsp;'.ucfirst($row["branch_name"]).'</li>';  
			}  
		}  
		else  
		{  
			$branch_id = 0;
			$branch_name = '';
			$branch_code = '';
			$address = '';
			
			#$output .= '<li onclick="return getSearchID(\'' .$branch_id. '\');">'.$_POST["query"].'</li>';  
			$output .= '<li onclick="return getSearchID(\'' .$branch_id. '\',\'' .$branch_name. '\');">Sorry! No Branches.</li>';  
		}
		$output .= '</ul>';  
		echo $output; 
	}

	/* function AjaxSearchBranch()
    {
		if(isset($_POST["query"]))  
		{ 
			$output = '';  
			
			if(!empty($_POST["query"]))
			{
				$condition = 'branch.branch_status = 1 
							and 
							(
								branch.branch_name like "%'.($_POST["query"]).'%" or 
								branch.branch_code like "%'.($_POST["query"]).'%" or
								branch.address like "%'.($_POST["query"]).'%"
							)
						';
			}
			else
			{
				$condition = 'branch.branch_status =1';
			}
			
			$table1 = "branch";
			$deliveryLocation = isset($_POST['deliveryLocation']) ? $_POST['deliveryLocation'] :"";
			
			if( !empty($deliveryLocation) && isset($_SESSION['DELIVERY_LATITUDE']) && isset($_SESSION['DELIVERY_LONGITUDE']))
			{
				//echo '1';
				$lat  = isset($_SESSION['DELIVERY_LATITUDE']) ? $_SESSION['DELIVERY_LATITUDE'] : "12.745458";
				$lon = isset($_SESSION['DELIVERY_LONGITUDE']) ? $_SESSION['DELIVERY_LONGITUDE'] : "77.81027069999999";
			}
			else
			{
				unset($_SESSION['DELIVERY_LATITUDE']); 
				unset($_SESSION['DELIVERY_LONGITUDE']); 
				unset($_SESSION['DELIVERY_ADDRESS']);
				
				//echo $_COOKIE['DELIVERY_LATITUDE'];
				$lat  = isset($_COOKIE['CURRENT_LATITUDE']) ? $_COOKIE['CURRENT_LATITUDE'] : "12.745458";
				$lon = isset($_COOKIE['CURRENT_LONGITUDE']) ? $_COOKIE['CURRENT_LONGITUDE'] : "77.81027069999999";
				//echo $lat."++".$lon;
			}
			
			$query = "select 
						branch.branch_id,
						branch.branch_name,
						branch.branch_code,
						branch.address,
						branch.phone_number,
						branch.delivery_distance,
						
						(((acos(sin((".$lat."*pi()/180)) * 
									
						sin((".$table1.".latitude*pi()/180))+cos((".$lat."*pi()/180)) * 

						cos((".$table1.".latitude*pi()/180)) * cos(((".$lon."- ".$table1.".longitude)*
						pi()/180))))*180/pi())*60*1.1515) as distance
		

						from branch 
							where ".$condition." 
							
						HAVING distance < branch.delivery_distance
						
						ORDER BY branch.delivery_distance desc
						
					limit 0,1
					";
			//echo $query;
			$getDeliveryDistnce = $this->db->query($query)->result_array();
			
			$distance = isset($getDeliveryDistnce[0]['delivery_distance']) ? $getDeliveryDistnce[0]['delivery_distance'] : '0';
			//echo $distance;
			if($distance > 0)
			{
				$condition .= ' and branch.delivery_distance > 0';
				
				$branchQuery = "select 
						branch.branch_id,
						branch.branch_name,
						branch.branch_code,
						branch.address,
						branch.phone_number,
						branch.delivery_distance,
						
						(((acos(sin((".$lat."*pi()/180)) * 
									
						sin((".$table1.".latitude*pi()/180))+cos((".$lat."*pi()/180)) * 

						cos((".$table1.".latitude*pi()/180)) * cos(((".$lon."- ".$table1.".longitude)*
						pi()/180))))*180/pi())*60*1.1515) as distance
		

						from branch 
							where ".$condition." 
						HAVING distance <= ".$distance." 
						
						ORDER BY branch.delivery_distance desc
						
					";
				$result = $this->db->query($branchQuery)->result_array();
			}
			else
			{
				$result = array();
			}
			
			$output = '<ul class="row list-unstyled nearest-branches">';  
			
			if( count($result) > 0 )  
			{  
				foreach($result as $row)  
				{	
					$branch_id = $row["branch_id"];
					$branch_name = $row["branch_name"];
					$branch_code = $row["branch_code"];
					$address = $row["address"];
					
					$output .= '<li onclick="return getSearchID(\'' .$branch_id. '\',\'' .$branch_name. '\');"><i class="fa fa-location-arrow"></i> &nbsp;'.ucfirst($row["branch_name"]).'</li>';  
				}  
			}  
			else  
			{  
				$branch_id = 0;
				$branch_name = '';
				$branch_code = '';
				$address = '';
				
				#$output .= '<li onclick="return getSearchID(\'' .$branch_id. '\');">'.$_POST["query"].'</li>';  
				$output .= '<li onclick="return getSearchID(\'' .$branch_id. '\',\'' .$branch_name. '\');">Sorry! No Branches.</li>';  
			}
			$output .= '</ul>';  
			echo $output;  
		}
	} */
	
	function searchItems()
    {
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$page_data['page_title'] = SITE_NAME.' | Items Listing'; #Page Title
		$page_data['page_name']  = "web_items/searchItems"; #View Page
		
		$page_data["totalRows"] = $totalRows = $this->web_items_model->getSearchItemsCount();
		$limit = 100000;
		$base_url = base_url('search.html.html/');
		
		$config = Pagination($base_url,$totalRows,$limit);
		$this->pagination->initialize($config);
		$str_links = $this->pagination->create_links();
		$page_data['pagination'] = explode('&nbsp;', $str_links);
		$offset = 0;
		if (!empty($_GET['per_page'])) {
			$pageNo = $_GET['per_page'];
			$offset = ($pageNo - 1) * $limit;
		}
		
		if($offset == 1 || $offset== "" || $offset== 0){
			$page_data["first_item"] = 1;
		}else{
			$page_data["first_item"] = $offset + 1;
		}
		
		$page_data['resultData']  = $result = $this->web_items_model->getSearchItems($limit, $offset);
		
		#show start and ending Count
		$total_counts = $total_count= 0;
		$pages=$page_data["starting"] = $page_data["ending"]="";
		$pageno = isset($pageNo) ? $pageNo :"";
		
		if( $totalRows == 0 ){
			$page_data["starting"] = 0;
		}else if( $pageno==1 || $pageno=="" ){
			$page_data["starting"] = 1;
		}else{
			$pages = $pageno-1;
			$total_count = $pages * $config["per_page"];
			$page_data["starting"] = ( $config["per_page"] * $pages )+1;
		}
		
		$total_counts = $total_count + count($result);
		$page_data["ending"]  = $total_counts;
		#show start and ending Count end
		
		$this->load->view($this->template, $page_data);
	}
	
	function leaveReview($categoryID="")
    {
		
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$category_id = decode($categoryID);
		$branch_id = $_SESSION['BRANCH_ID'];
		
		$page_data['category_id'] = $category_id;
		$page_data['page_title'] = SITE_NAME.' | Leave Review'; #Page Title
		$page_data['page_name']  = "web_items/leaveReview";
		
		if($_POST)
		{			
			$category_url = $this->input->post('category_url');
			$category_id  = $this->input->post('category_id');
			
			$data['review_title']			= $this->input->post('review_title');
			$data['review_description']		= $this->input->post('review_description');
			$data['category_id']			= $category_id;
			$data['user_id']				= $this->UserID;
			$data['created_date']			= time();
			$data['created_date']			= time();
			$data['reply_status']			= 0;

			$this->db->insert('vb_item_reviews', $data);
			$id = $this->db->insert_id();
			
			if($id !="")
			{
				if( !empty($_FILES['fileupload']['name']) )
				{  
					move_uploaded_file($_FILES['fileupload']['tmp_name'], 'uploads/reviews/'.$id.'.png');
				}
				$this->session->set_flashdata('success_message', 'Thank you for your reviews!');
				redirect(base_url().$category_url.".html/".encode($category_id), 'refresh');
			}
		}
		$this->load->view($this->template, $page_data);
	}
	
	function removeCartItem($productCode="",$product_id="")
    {
		if(!empty($_SESSION["cart_item"])) 
		{
			foreach($_SESSION["cart_item"] as $k => $v) 
			{
				if($productCode == $k)
					unset($_SESSION["cart_item"][$k]);
				
				/* if(empty($_SESSION["cart_item"]))
					unset($_SESSION["cart_item"]); */
			}
		
			$this->session->set_flashdata('success_message', 'Cart Item removed successfully!');
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		else
		{
			$this->session->set_flashdata('error_message', 'Cart is empty!');
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
	}

	public function AjaxpostReview()
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		if($_POST)
		{
			$review_id = $this->input->post('review_id');

			$data['review_description']			= $this->input->post('message');
			$data['review_id']					= $review_id;
			$data['created_date']				= time();
			$data['post_status']				= 0;
			$data['user_id']					= $this->UserID;
			
			$this->db->insert('vb_item_reviews_line',$data);
			$id = $this->db->insert_id();

			$data = [];
			$data['reply_status']				= 0;

			$this->db->where('review_id', $review_id);
			$result = $this->db->update('vb_item_reviews',$data);

			if ($id) {
				echo 'replyed';
			}
		}
	}
	
	public function AjaxItemSession($product_id="",$quantity="",$price="", $minimum_order_quantity="", $available_quantity="")
	{
		if(!empty($product_id))
		{	
			$productByCode = $this->db->query("SELECT 
				products.product_id,
				products.product_code,
				products.product_name,
				category.category_id
				FROM products 
				left join category on 
					category.category_id = products.category_id
				WHERE products.product_id='" . $product_id . "'")->result_array();
			
				
			if($quantity > 0)
			{
				$_SESSION['category_id'] = $productByCode[0]["category_id"];	
				
				$itemArray = array(
					$productByCode[0]["product_code"] =>
					array(
						'product_name' => $productByCode[0]["product_name"], 
						'product_code' => $productByCode[0]["product_code"], 
						'quantity'     => $quantity, 
						'price'        => $price,
						'product_id'   => $product_id,
						'category_id'  => $productByCode[0]["category_id"],
						'available_quantity'       => $available_quantity,
						'minimum_order_quantity'   => $minimum_order_quantity,
					
					)
				);
				
				if(!empty($_SESSION["cart_item"])) 
				{	
					#if(in_array($productByCode[0]["product_code"],$_SESSION["cart_item"])) 
					if(is_array($_SESSION["cart_item"])) 
					{
						foreach($_SESSION["cart_item"] as $k => $v) 
						{
							if($productByCode[0]["product_code"] == $k)
							{	
								$_SESSION["cart_item"][$k]["quantity"] = $quantity;
							}
							else
							{
								$_SESSION["cart_item"] = $_SESSION["cart_item"]+$itemArray;
							}
						}
					} 
					else
					{
						$_SESSION["cart_item"] = $_SESSION["cart_item"]+$itemArray;
					}
				} 
				else 
				{	
					$_SESSION["cart_item"] = $itemArray;
				}
				//print_r($_SESSION["cart_item"]);
			}
			else #Remove
			{
				$productCode = $productByCode[0]["product_code"];
				
				if(!empty($_SESSION["cart_item"])) 
				{
					foreach($_SESSION["cart_item"] as $k => $v) 
					{
						if($productCode == $k)
							unset($_SESSION["cart_item"][$k]);
						
						/* if(empty($_SESSION["cart_item"]))
							unset($_SESSION["cart_item"]); */
					}
				
					//$this->session->set_flashdata('success_message', 'Item removed successfully!');
					//redirect($_SERVER['HTTP_REFERER'], 'refresh');
				}
			}
		}
		
		$page_data["cart_item"] = $_SESSION["cart_item"];
			
		#$htmlData["itemList"] = $this->load->view('themes/default/web_items/cart_items',$page_data,true);
		$htmlData["headerCartItem"] = $this->load->view('themes/default/web_items/headerCartItem',$page_data,true);
		$htmlData["cartCount"] = count($_SESSION["cart_item"]);
		echo json_encode($htmlData);
	}
	
	#AjaxItemCart model box
	public function AjaxItemCart()
	{
		#if( isset($_POST) && isset($_POST['cartBtn']) && !empty($_POST["quantity"]))
		if( isset($_POST) )
		{	
			$IngSerialize ='';
			
			if(isset($_POST['ingredients']) && !empty($_POST['ingredients']))
			{
				$IngSerialize = serialize($_POST['ingredients']);
			}
			
			$_SESSION['category_id'] = $_POST["category_id"];
			$_SESSION['branch_id'] = $_POST["branch_id"];
			
			$productByCode = $this->db->query("SELECT product_id,product_code,product_name FROM products WHERE product_id='" . $_POST['product_id'] . "'")->result_array();
			
			$itemArray = array(
				$productByCode[0]["product_code"] =>
				array(
					'product_name'           => $productByCode[0]["product_name"], 
					'product_code'           => $productByCode[0]["product_code"], 
					'quantity'               => $_POST["quantity"], 
					'price'                  => $_POST["p_price"],
					'product_id'             => $_POST["product_id"],
					'category_id'            => $_POST["category_id"],
					'branch_id'              => $_POST["branch_id"],
					'available_quantity'     => $_POST["available_quantity"],
					'minimum_order_quantity' => isset($_POST["minimum_order_quantity"]) ? $_POST["minimum_order_quantity"] : 0,
					'ingredients'            => $IngSerialize
				)
			);
			
			if(!empty($_SESSION["cart_item"])) 
			{	
				#if(in_array($productByCode[0]["product_code"],$_SESSION["cart_item"])) 
				if(is_array($_SESSION["cart_item"])) 
				{
					foreach($_SESSION["cart_item"] as $k => $v) 
					{
						if($productByCode[0]["product_code"] == $k)
						{	
							$_SESSION["cart_item"][$k]["quantity"] = $_POST["quantity"];
							$_SESSION["cart_item"][$k]["ingredients"] = $IngSerialize;
						}
						else
						{
							$_SESSION["cart_item"] = $_SESSION["cart_item"]+$itemArray;
						}
					}
					//$this->session->set_flashdata('success_message', 'Item successfully updated to your cart');
					//redirect($_SERVER['HTTP_REFERER'], 'refresh');
				} 
				else
				{
					$_SESSION["cart_item"] = $_SESSION["cart_item"]+$itemArray;
				}
			} 
			else 
			{	
				$_SESSION["cart_item"] = $itemArray;

				#$this->session->set_flashdata('success_message', 'Item successfully added to your cart');
				#redirect($_SERVER['HTTP_REFERER'], 'refresh');
			}
		}
		
		$page_data["cart_item"] = $_SESSION["cart_item"];
		
		$htmlData["itemList"] = $this->load->view('themes/default/web_items/cart_items',$page_data,true);
		$htmlData["headerCartItem"] = $this->load->view('themes/default/web_items/headerCartItem',$page_data,true);
		$htmlData["cartCount"] = count($_SESSION["cart_item"]);
		echo json_encode($htmlData);
	}
	
	public function AjaxItemListCart($product_id="",$quantity="",$price="",$branchID="",$minimum_order_quantity="",$available_quantity="")
	{
		if(!empty($product_id))
		{	
			$productByCode = $this->db->query("SELECT 
				products.product_id,
				products.product_code,
				products.product_name,
				category.category_id
				FROM products 
				left join category on 
					category.category_id = products.category_id
				WHERE products.product_id='" . $product_id . "'")->result_array();
			
			if($quantity > 0)
			{
				$_SESSION['category_id'] = $productByCode[0]["category_id"];	
				$_SESSION['branch_id'] = $branchID;	
				
				$itemArray = array(
					$productByCode[0]["product_code"] =>
					array(
						'product_name'             => $productByCode[0]["product_name"], 
						'product_code'             => $productByCode[0]["product_code"], 
						'quantity'                 => $quantity, 
						'price'                    => $price,
						'product_id'               => $product_id,
						'category_id'              => $productByCode[0]["category_id"],
						'available_quantity'       => $available_quantity,
						'minimum_order_quantity'   => $minimum_order_quantity,
					)
				);
				
				if(!empty($_SESSION["cart_item"])) 
				{	
					#if(in_array($productByCode[0]["product_code"],$_SESSION["cart_item"])) 
					if(is_array($_SESSION["cart_item"])) 
					{
						foreach($_SESSION["cart_item"] as $k => $v) 
						{
							if($productByCode[0]["product_code"] == $k)
							{	
								$_SESSION["cart_item"][$k]["quantity"] = $quantity;
							}
							else
							{
								$_SESSION["cart_item"] = $_SESSION["cart_item"]+$itemArray;
							}
						}
					} 
					else
					{
						$_SESSION["cart_item"] = $_SESSION["cart_item"]+$itemArray;
					}
				} 
				else 
				{	
					$_SESSION["cart_item"] = $itemArray;
				}
				//print_r($_SESSION["cart_item"]);
			}
			else #Remove
			{
				$productCode = $productByCode[0]["product_code"];
				
				if(!empty($_SESSION["cart_item"])) 
				{
					foreach($_SESSION["cart_item"] as $k => $v) 
					{
						if($productCode == $k)
							unset($_SESSION["cart_item"][$k]);
						
						/* if(empty($_SESSION["cart_item"]))
							unset($_SESSION["cart_item"]); */
					}
				
					//$this->session->set_flashdata('success_message', 'Item removed successfully!');
					//redirect($_SERVER['HTTP_REFERER'], 'refresh');
				}
			}
		
			$page_data["cart_item"] = $_SESSION["cart_item"];
			
			$htmlData["itemList"] = $this->load->view('themes/default/web_items/cart_items',$page_data,true);
			$htmlData["headerCartItem"] = $this->load->view('themes/default/web_items/headerCartItem',$page_data,true);
			$htmlData["cartCount"] = count($_SESSION["cart_item"]);
			echo json_encode($htmlData);
		}
	}
	
	function ajaxRemoveCartItem()
    {
		$productID= $_POST["product_id"];
		$productCode = $_POST["product_code"];
		
		if(!empty($productCode) && !empty($_SESSION["cart_item"])) 
		{
			foreach($_SESSION["cart_item"] as $k => $v) 
			{
				if($productCode == $k)
					unset($_SESSION["cart_item"][$k]);
				
				/* if(empty($_SESSION["cart_item"]))
					unset($_SESSION["cart_item"]); */
			}
		
			$page_data["cart_item"] = $_SESSION["cart_item"];
			
			$htmlData["itemList"] = $this->load->view('themes/default/web_items/cart_items',$page_data,true);
			$htmlData["headerCartItem"] = $this->load->view('themes/default/web_items/headerCartItem',$page_data,true);
			$htmlData["cartCount"] = count($_SESSION["cart_item"]);
			echo json_encode($htmlData);
		}
		
	}
	
	
	function AjaxSearchSavedAddress()
    {
		if(isset($_POST["query"]))  
		{ 
			$output = '';  
			
			if(!empty($_POST["query"]))
			{
				$condition = 'branch.branch_status = 1 
							and 
							(
								vb_customer_address.address like "%'.($_POST["query"]).'%" or 
								vb_customer_address.delivery_address like "%'.($_POST["query"]).'%"
							)
						';
			}
			else
			{
				$condition = 'users.user_status =1 and users.user_id="'.$this->UserID.'" ';
			}
			
			
			$query = "select 
						vb_customer_address.address,
						vb_customer_address.delivery_address,
						vb_customer_address.tags
						from vb_customer_address 
					left join users on 
						users.user_id = vb_customer_address.user_id
							where ".$condition."
					";
			
			$result = $this->db->query($query)->result_array();
			
			
			$output = '<ul class="row list-unstyled saved-address">';  
			
			if( count($result) > 0 )  
			{  
				foreach($result as $row)  
				{	
					$address = $row["address"];
					
					$deliveryTags = '';
					
					if($row['tags'] !=0)
					{
						foreach($this->deliveryTags as $key=>$value)
						{
							if($row['tags'] == $key)
							{
								if($row['tags'] == 1 )
								{
									$deliveryTags =  '<i class="fa fa-home"></i> '.$value;
								}
								else if($row['tags'] == 2 )
								{
									$deliveryTags = '<i class="fa fa-briefcase"></i> '.$value;
								}
							}
						}
					}
					$delivery_address = $row["delivery_address"];
					$completeAddress = 
							"<span class='tag'>".$deliveryTags."</span>".
							"<span class='delivery_address'>".$row["delivery_address"]."</span>"
							;
					$output .= '<li onclick="return getDeliveryAddress(\'' .$delivery_address. '\');">'.ucfirst($completeAddress).'</li>';  
				}  
			}  
			else  
			{  
				$address = '';
				$delivery_address="";
				#$output .= '<li onclick="return getSearchID(\'' .$branch_id. '\');">'.$_POST["query"].'</li>';  
				$output .= '<li onclick="return getDeliveryAddress(\'' .$delivery_address. '\');">Sorry! No Saved Address.</li>';  
			}
			$output .= '</ul>';  
			echo $output;  
		}
	}
	
}
	
?>
