<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Web_payment extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}

	function checkout()
    {
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		if(isset($_POST["addressUpdate"]))
		{
			$customer_address_id  = $this->input->post('customer_address_id');
			$data['pin_code']  = $this->input->post('pin_code');
			$data['address']   = $this->input->post('address');
			$data['land_mark'] = $this->input->post('land_mark');
			$data['locality']  = $this->input->post('locality');
			$data['country_id'] = $this->input->post('country_id');
			$data['alternative_number'] = $this->input->post('alternative_number');
			$data['full_name'] = $this->input->post('full_name');
			$data['tags'] = isset($_POST['tags']) ? $_POST['tags'] : 0;
					
			$data['delivery_address'] = $this->input->post('delivery_address');
			$latLong = getGeoLatLong($data['delivery_address']);
			$data['latitude'] = $latLong['latitude'];
			$data['longitude'] = $latLong['longitude'];
					
			$this->db->where('customer_address_id', $customer_address_id);
			$this->db->where('user_id', $this->UserID);
			$result = $this->db->update('vb_customer_address', $data);
			
			if($result)
			{
				$UserDetails = "select user_id,mobile_number,country_id from users where user_id ='".$this->UserID."'";
				$getUserDetails = $this->db->query($UserDetails)->result_array();
				
				$country_id = isset($getUserDetails[0]['country_id']) ? $getUserDetails[0]['country_id'] : 0;
				$mobile_number = isset($getUserDetails[0]['mobile_number']) ? $getUserDetails[0]['mobile_number'] :"";
				
				if($country_id == 0 && empty($mobile_number) )
				{
					$userData['mobile_number'] = $data['alternative_number'];
					$userData['country_id'] = $data['country_id'];
					$this->db->where('user_id', $this->UserID);
					$result = $this->db->update('users', $userData);
				}
						
				$this->session->set_flashdata('flash_message' , "Address updated Successfully!");
				redirect($_SERVER['HTTP_REFERER'], 'refresh');
			}
		}
		else if(isset($_POST["addressAdd"]))
		{
			$data['customer_address_id']  = $this->input->post('customer_address_id');
			$data['pin_code']  = $this->input->post('pin_code');
			$data['address']   = $this->input->post('address');
			$data['land_mark'] = $this->input->post('land_mark');
			$data['locality']  = $this->input->post('locality');
			$data['country_id'] = $this->input->post('country_id');
			$data['alternative_number'] = $this->input->post('alternative_number');
			$data['full_name'] = $this->input->post('full_name');
			$data['user_id'] = $this->UserID;
			$data['tags'] = isset($_POST['tags']) ? $_POST['tags'] : 0;
					
			$data['delivery_address'] = $this->input->post('delivery_address');
			$latLong = getGeoLatLong($data['delivery_address']);
			$data['latitude'] = $latLong['latitude'];
			$data['longitude'] = $latLong['longitude'];
			
			$this->db->insert('vb_customer_address', $data);
			$id = $this->db->insert_id();

			if($id)
			{
				$UserDetails = "select user_id,mobile_number,country_id from users where user_id ='".$this->UserID."'";
				$getUserDetails = $this->db->query($UserDetails)->result_array();
				
				$country_id = isset($getUserDetails[0]['country_id']) ? $getUserDetails[0]['country_id'] : 0;
				$mobile_number = isset($getUserDetails[0]['mobile_number']) ? $getUserDetails[0]['mobile_number'] :"";
				
				if($country_id == 0 && empty($mobile_number) )
				{
					$userData['mobile_number'] = $data['alternative_number'];
					$userData['country_id'] = $data['country_id'];
					$this->db->where('user_id', $this->UserID);
					$result = $this->db->update('users', $userData);
				}
				
				$this->session->set_flashdata('flash_message' , "Address added Successfully!");
				redirect($_SERVER['HTTP_REFERER'], 'refresh');
			}
		}
		else if($_POST)
		{
			#Card Payment
			if(isset($_POST['payment_method']) && $_POST['payment_method'] == 2)
			{
				$this->cardPayment($_POST);
			}
			else #COD
			{
				$wallet_chk = isset($_POST['wallet_chk_enabled']) ? $_POST['wallet_chk_enabled'] : 0;
				
				if($wallet_chk == 1) #Enabled
				{
					$totalAmount = $grandTotal = $_POST['grand_total'];
					$wallet_amount = $_POST['wallet_amount'];
					
					if($totalAmount < $wallet_amount)
					{
						$walletAmount = $totalAmount;
					}
					else
					{
						$walletAmount = $wallet_amount;
					}
				}
				else #Disabled
				{
					$walletAmount = 0;
				}
				
				$branch_id  = isset($_SESSION['BRANCH_ID']) ? $_SESSION['BRANCH_ID'] : 0;
				$orderDate  = date('Y-m-d');
				
				$headerData = array(
					#"order_number"         => randomNum(10),
					"order_date"           => $orderDate,
					"invoice_billing_date" => time(),
					"user_id"              => $this->UserID,
					"branch_id"            => $branch_id,
					"created_date"         => time(),
					"sub_total"            => $_POST['sub_total'],
					"grand_total"          => $_POST['grand_total'],
					"payable_amount"       => $_POST['payable_amount'],
					"order_type"           => isset($_POST['order_type']) ? $_POST['order_type'] :"",
					"delivery_address"     => isset($_POST['delivery_address_id']) ? $_POST['delivery_address_id'] :"",
					"payment_method"       => isset($_POST['payment_method']) ? $_POST['payment_method'] :"",
					"tax_value"            => isset($_POST['tax_value']) ? $_POST['tax_value'] : 0,
					"wallet_chk_enabled"   => $wallet_chk,
					"wallet_amount"        => $walletAmount,
					"payment_status"       => 'SUCCESS',
				);
				
				$this->db->insert('vb_order_header', $headerData);
				$order_id = $this->db->insert_id();
				
				$randomNumber = "";

				if($order_id > 0)
				{
					#BD-090821-001
					
					#Order No auto generate Start here
					
					$results = $this->db->query("select increment_id 
						from vb_order_header 
						where 
							branch_id = '".$branch_id."'
						order by increment_id desc")->result_array();
					if( isset($results[0]['increment_id']) && $results[0]['increment_id'] == 0 )
					{
						$incrementID = 1;
					}
					else
					{
						$incrementID = $results[0]['increment_id'] + 1;
					}
					
					$branchQry = "select branch_prefix from branch where branch_id='".$branch_id."' ";
					$getBranchDetails = $this->db->query($branchQry)->result_array();
					$branch_prefix = $getBranchDetails[0]["branch_prefix"];
					$orderDate = date("dmy");
					$randomNumber = $branch_prefix."-".$orderDate.'-00'.$incrementID;
					
					$UpdateData['order_number'] = $randomNumber;
					$UpdateData['increment_id'] = $incrementID;
					
					$this->db->where('order_id', $order_id);
					$resultUpdateData = $this->db->update('vb_order_header', $UpdateData);
					#Order No auto generate end here

					# OrderLine start
					if( isset($_POST['product_id']) && $_POST['product_id'] !="" )
					{
						$count=count($_POST['product_id']);
						for($dp=0;$dp<$count;$dp++)
						{	
							$quantity = isset($_POST['quantity'][$dp]) ? $_POST['quantity'][$dp] :"";
							$product_id = isset($_POST['product_id'][$dp]) ? $_POST['product_id'][$dp] :"";
							
							$lineData['order_id']          = $order_id;
							$lineData['category_id']       = isset($_POST['category_id'][$dp]) ? $_POST['category_id'][$dp] :"";
							$lineData['product_id']        = $product_id;
							
							$lineData['price']             = isset($_POST['price'][$dp]) ? $_POST['price'][$dp] :"";
							$lineData['ingredient_amount'] = isset($_POST['ingredientAmount'][$dp]) ? $_POST['ingredientAmount'][$dp] :"";
							$lineData['ingredients']       = isset($_POST['ingredients'][$dp]) ? $_POST['ingredients'][$dp] :"";
							
							$lineData['quantity']          = $quantity;
							$lineData['linetotal']         = isset($_POST['linetotal'][$dp]) ? $_POST['linetotal'][$dp] :"";
							$lineData['order_date']        = strtotime($orderDate);
							
							$this->db->insert('vb_order_line', $lineData);
							$lineID= $this->db->insert_id();
							
							#Update Availble Qty start
							$BrancItemHeader ="select branch_item_header_id from vb_branch_items_header where branch_id='".$branch_id."' ";
							$getBrancItemHeader = $this->db->query($BrancItemHeader)->result_array();
							$branch_item_header_id = isset($getBrancItemHeader[0]['branch_item_header_id']) ? $getBrancItemHeader[0]['branch_item_header_id'] : 0;
							
							$UpdateAvailbleQtyQuery = "update vb_branch_items_line set available_quantity = available_quantity - $quantity 
								where 
									branch_item_header_id = '".$branch_item_header_id."' and
										product_id = '".$product_id."'
								";
							$this->db->query($UpdateAvailbleQtyQuery);
							#Update Availble Qty end
						}
					}
					# OrderLine start
					
					if($wallet_chk == 1)
					{
						$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount - $walletAmount where user_id = '".$this->UserID."' ";
						$this->db->query($UpdateQuery);
					}
					
					$orderQuery = "select 
						vb_order_header.user_id, 
						vb_order_header.order_number,
						vb_order_header.grand_total,
						users.mobile_number, 
						country.country_code
					from vb_order_header 
					
					left join users on 
						users.user_id = vb_order_header.user_id
						
					left join country on 
						country.country_id = users.country_id 
					where order_id = '".$order_id."' ";

					$getOrderDetails = $this->db->query($orderQuery)->result_array();
					
					$country_code = $getOrderDetails[0]['country_code'];
					$mobile_number = $getOrderDetails[0]['mobile_number'];
					$order_number = $getOrderDetails[0]['order_number'];
					$otpMobileNumber = $country_code.$mobile_number;
				
					$otpMessage = '#'. $order_number.' Your order has been placed. - Thank You.  '.strtoupper(SITE_NAME);
					$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
					
					//echo $sendSMS ;exit;
					
					unset($_SESSION["cart_item"]);
					
					redirect(base_url() . 'confirm.html', 'refresh');
				}
			}
		}
		
		$page_data['page_title'] = SITE_NAME.' | Checkout'; #Page Title
		$page_data['page_name']  = "web_payment/checkout"; #View Page
		$this->load->view($this->template, $page_data);
	}
	
	function confirm()
    {
		$page_data['page_title'] = SITE_NAME.' | Confirm'; #Page Title
		$page_data['page_name']  = "web_payment/confirm"; #View Page
		$this->load->view($this->template, $page_data);
	}
	
	function AjaxremoveCart()
	{
		unset($_SESSION['cart_item'][$_POST['cart_item']]);
		echo json_encode('Removed from cart');die;
	}

	function access_token()
	{
		$apikey = N_GENIUS_PAYMENT_API_KEY;
		$outlet = N_GENIUS_PAYMENT_OUTLET_ID;

		$ch = curl_init(); 
		curl_setopt($ch, CURLOPT_URL, "https://api-gateway.sandbox.ngenius-payments.com/identity/auth/access-token"); 
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			"accept: application/vnd.ni-identity.v1+json",
			"authorization: Basic ".$apikey,
			"content-type: application/vnd.ni-identity.v1+json")
		); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);   
		curl_setopt($ch, CURLOPT_POST, 1); 
		curl_setopt($ch, CURLOPT_POSTFIELDS,  "{\"realmName\":\"ni\"}"); 
		$output = json_decode(curl_exec($ch)); 
		$access_token = $output->access_token;

		return $access_token;
	}

	#Card Payment
	function cardPayment($data="")
	{
		$card_deatils = array(
				"order" => 
					array("action"=>"AUTH","amount" => array("currencyCode"=>"AED", "value"=> (int)($data['payable_amount']*100) ) )
				,
				"payment" => array(
					"pan"				=> $data['card_number'],
					"expiry"			=> "2025-04",#$data['expire_year']."-".$data['expire_year'],
					"cvv"				=> $data['ccv'],
					"cardholderName"	=> $data['name_card_order'],
				)
			);

			// print_r(json_encode($card_deatils));exit;

		$apikey = N_GENIUS_PAYMENT_API_KEY;
		$outlet = N_GENIUS_PAYMENT_OUTLET_ID;

		$token = $this->access_token();

		$json = json_encode($card_deatils);
		$ch = curl_init(); 
		
		curl_setopt($ch, CURLOPT_URL, "https://api-gateway.sandbox.ngenius-payments.com/transactions/outlets/$outlet/payment/card"); 
		curl_setopt(
			$ch, CURLOPT_HTTPHEADER, array(
				"Authorization: Bearer ".$token, 
				"Content-Type: application/vnd.ni-payment.v2+json", 
				"Accept: application/vnd.ni-payment.v2+json",
			)
		); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);   
		curl_setopt($ch, CURLOPT_POST, 1); 
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json); 
		
		$output = json_decode(curl_exec($ch));

		if (isset($output->state)) 
		{
			$order_reference = $output->orderReference; 

			$_SESSION['postData'] = $data;
			$_SESSION['order_reference'] = $order_reference;
		
			switch ($output->state) 
			{
				case 'CAPTURED':
	
					redirect(base_url()."web_payment/paymentDetails");
	
				break;
	
				case 'AUTHORISED':

					redirect(base_url()."web_payment/paymentDetails");

				break;
	
				case 'AWAIT_3DS':
					
					$_SESSION['cnp3ds_url'] = base64_encode($output->_links->{'cnp:3ds'}->href);
					$_SESSION['acsurl'] = $output->{'3ds'}->acsUrl;
					$_SESSION['acspareq'] = $output->{'3ds'}->acsPaReq;
					$_SESSION['acsmd'] = $output->{'3ds'}->acsMd;
					$_SESSION['acsterm'] = "www.google.com";      
	

					redirect(base_url().'web_payment/iframe');
	
				break;
	
				case 'FAILED':
	
					$page_data['message'] = $output->errors[0]->message;
					print_r($page_data['message']);exit;
					redirect(base_url().'payment-error.html');
	
				break;
			}	
		}
		else
		{
			$page_data['message'] = $output->errors[0]->message;
			print_r($page_data['message']);exit;
			redirect(base_url().'payment-error.html');

		}
		
		
	}

	function iframe()
	{	
		
		$page_data['cnp3ds_url']	=	$_SESSION['cnp3ds_url'];	
		$page_data['acsurl'] 		=	$_SESSION['acsurl'];
		$page_data['acspareq'] 		=	$_SESSION['acspareq'];
		$page_data['acsmd'] 		=	$_SESSION['acsmd'];
		$page_data['acsterm'] 		=	$_SESSION['acsterm'];

		$page_data['page_title'] = SITE_NAME.' | 3DS'; #Page Title
		$page_data['page_name']  = "web_payment/iframe"; #View Page

		$this->load->view($this->template, $page_data);
		
	}

	function iframe_post()
	{
		$page_data['page_title'] = SITE_NAME.' | 3DS'; #Page Title
		$page_data['page_name']  = "web_payment/iframe_post"; #View Page

		$this->load->view($this->template, $page_data);
	}

	function iframe_termination()
	{
		$url  = base64_decode($_GET['url']);

		$postData = new StdClass();
		$postData->PaRes = $_POST['PaRes'];

		$json = json_encode($postData);

		$token = $this->access_token();
		$cnp3ds_url	=	$url;
		
		$ch = curl_init();
		
		curl_setopt($ch, CURLOPT_URL, $cnp3ds_url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: Bearer ".$token, "Content-Type: application/vnd.ni-payment.v2+json", "Accept: application/vnd.ni-payment.v2+json"));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);        
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json);

		$output = json_decode(curl_exec($ch));

		if (isset($output->state)) 
		{
			switch ($output->state) 
			{
				case 'CAPTURED':

					redirect(base_url()."web_payment/paymentDetails");
	
				break;
	
				case 'AUTHORISED':
					
					redirect(base_url()."web_payment/paymentDetails");
						
				break;
	
				case 'FAILED':
	
					$page_data['message'] = $output->errors[0]->message;
					print_r($page_data['message']);exit;
					redirect(base_url().'payment-error.html');
	
				break;
			}	
		}
		else
		{
			$page_data['message'] = $output->errors[0]->message;
			print_r($page_data['message']);exit;
			redirect(base_url().'payment-error.html');

		}
	}

	function paymentDetails()
	{
		if ( isset($_SESSION['order_reference']) )
		{
			$ref	=	base64_decode($_SESSION['order_reference']);
			$apikey = N_GENIUS_PAYMENT_API_KEY;
			$outlet = N_GENIUS_PAYMENT_OUTLET_ID;

			$curl = curl_init();

			$orderReference = $ref;
			$token = $this->access_token();

			curl_setopt_array($curl, [
				CURLOPT_URL => "https://api-gateway.sandbox.ngenius-payments.com/transactions/outlets/".$outlet."/orders/".$orderReference,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "GET",
				CURLOPT_HTTPHEADER => [
					"Accept: application/vnd.ni-payment.v2+json",
					"authorization: Bearer ".$token
				],
			]);

			$response = curl_exec($curl);
			$err = curl_error($curl);
			
			curl_close($curl);

			if ($err) 
			{
				#echo "cURL Error #:" . $err;
				redirect(base_url().'payment-error.html');
			} 
			else 
			{
				$data = json_decode($response);
				
				if(isset($data->_embedded->payment[0]->state) && $data->_embedded->payment[0]->state == "CAPTURED" || $data->_embedded->payment[0]->state == "AUTHORISED")
				{
					$postData = isset($_SESSION['postData']) ? $_SESSION['postData'] : "";

					$wallet_chk = isset($postData['wallet_chk_enabled']) ? $postData['wallet_chk_enabled'] : 0;
					
					if($wallet_chk == 1) #Enabled
					{
						$totalAmount = $grandTotal = $postData['grand_total'];
						$wallet_amount = $postData['wallet_amount'];
						
						if($totalAmount < $wallet_amount)
						{
							$walletAmount = $totalAmount;
						}
						else
						{
							$walletAmount = $wallet_amount;
						}
					}
					else #Disabled
					{
						$walletAmount = 0;
					}
					
					$branch_id  = isset($_SESSION['BRANCH_ID']) ? $_SESSION['BRANCH_ID'] : 0;
					$orderDate  = date('Y-m-d');

					if ($data->_embedded->payment[0]->authResponse->success)
					{
						$payment_status = "SUCCESS";	
					}
					else
					{
						$payment_status = "FAILED";
					}

					$headerData = array(
						#"order_number"         => randomNum(10),
						"order_date"           => $orderDate,
						"invoice_billing_date" => time(),
						"user_id"              => $this->UserID,
						"branch_id"            => $branch_id,
						"created_date"         => time(),
						"sub_total"            => $postData['sub_total'],
						"grand_total"          => $postData['grand_total'],
						"payable_amount"       => $postData['payable_amount'],
						"order_type"           => isset($postData['order_type']) ? $postData['order_type'] :"",
						"delivery_address"     => isset($postData['delivery_address_id']) ? $postData['delivery_address_id'] :"",
						
						"payment_method"       => isset($postData['payment_method']) ? $postData['payment_method'] :"",
						"wallet_chk_enabled"   => $wallet_chk,
						"wallet_amount"        => $walletAmount,
						"tax_value"            => isset($postData['tax_value']) ? $postData['tax_value'] : 0,
					
						"currency_code"        => $data->amount->currencyCode,
						"reference_id"         => $data->reference,
						"payment_status"       => $payment_status,
					);
					
					$this->db->insert('vb_order_header', $headerData);
					$order_id = $this->db->insert_id();

					if($order_id > 0)
					{
						$serialized_data = serialize($data);
						$payment_history = array('order_id'=>$order_id,'payment_history'=>$serialized_data);

						$this->db->insert('vb_order_payment_history', $payment_history);

						#Order No auto generate Start here
						$results = $this->db->query("select increment_id from 
						vb_order_header 
						where 
							branch_id = '".$branch_id."'
						order by increment_id desc")->result_array();
						
						if( isset($results[0]['increment_id']) && $results[0]['increment_id'] == 0 )
						{
							$incrementID = 1;
						}
						else
						{
							$incrementID = $results[0]['increment_id'] + 1;
						}
						
						$branchQry = "select branch_prefix from branch where branch_id='".$branch_id."' ";
						$getBranchDetails = $this->db->query($branchQry)->result_array();
						$branch_prefix = $getBranchDetails[0]["branch_prefix"];
						$orderDate = date("dmy");
						$randomNumber = $branch_prefix."-".$orderDate.'-00'.$incrementID;
						
						$UpdateData['order_number'] = $randomNumber;
						$UpdateData['increment_id'] = $incrementID;
						
						$this->db->where('order_id', $order_id);
						$resultUpdateData = $this->db->update('vb_order_header', $UpdateData);
						#Order No auto generate end here

						# OrderLine start
						if( isset($postData['product_id']) && $postData['product_id'] !="" )
						{
							$count=count($postData['product_id']);
							for($dp=0;$dp<$count;$dp++)
							{	
								$quantity = isset($postData['quantity'][$dp]) ? $postData['quantity'][$dp] :"";
								$product_id = isset($postData['product_id'][$dp]) ? $postData['product_id'][$dp] :"";
								
								$lineData['order_id']          = $order_id;
								$lineData['category_id']       = isset($postData['category_id'][$dp]) ? $postData['category_id'][$dp] :"";
								$lineData['product_id']        = $product_id;
								
								$lineData['price']             = isset($postData['price'][$dp]) ? $postData['price'][$dp] :"";
								$lineData['ingredient_amount'] = isset($postData['ingredientAmount'][$dp]) ? $postData['ingredientAmount'][$dp] :"";
								$lineData['ingredients']       = isset($postData['ingredients'][$dp]) ? $postData['ingredients'][$dp] :"";
								
								$lineData['quantity']          = $quantity;
								$lineData['linetotal']         = isset($postData['linetotal'][$dp]) ? $postData['linetotal'][$dp] :"";
								$lineData['order_date']        = strtotime($orderDate);
								
								$this->db->insert('vb_order_line', $lineData);
								$lineID= $this->db->insert_id();
								
								#Update Availble Qty start
								$BrancItemHeader ="select branch_item_header_id from vb_branch_items_header where branch_id='".$branch_id."' ";
								$getBrancItemHeader = $this->db->query($BrancItemHeader)->result_array();
								$branch_item_header_id = isset($getBrancItemHeader[0]['branch_item_header_id']) ? $getBrancItemHeader[0]['branch_item_header_id'] : 0;
								
								$UpdateAvailbleQtyQuery = "update vb_branch_items_line set available_quantity = available_quantity - $quantity 
									where 
										branch_item_header_id = '".$branch_item_header_id."' and
											product_id = '".$product_id."'
									";
								$this->db->query($UpdateAvailbleQtyQuery);
								#Update Availble Qty end
							}
						}
						# OrderLine start
						
						if($wallet_chk == 1)
						{
							$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount - $walletAmount where user_id = '".$this->UserID."' ";
							$this->db->query($UpdateQuery);
						}
						
						$orderQuery = "select 
						vb_order_header.user_id, 
						vb_order_header.order_number,
						vb_order_header.grand_total,
						users.mobile_number, 
						country.country_code
						
					from vb_order_header 
					
					left join users on 
						users.user_id = vb_order_header.user_id
						
					left join country on 
						country.country_id = users.country_id 
					where order_id = '".$order_id."' ";

					$getOrderDetails = $this->db->query($orderQuery)->result_array();
					
					$country_code = $getOrderDetails[0]['country_code'];
					$mobile_number = $getOrderDetails[0]['mobile_number'];
					$order_number = $getOrderDetails[0]['order_number'];
					$otpMobileNumber = $country_code.$mobile_number;
				
					$otpMessage = '#'. $order_number.' Your order has been placed. - Thank You.  '.strtoupper(SITE_NAME);
					$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
					
					//echo $sendSMS ;exit;
						
						unset($_SESSION["cart_item"]);
						unset($_SESSION["postData"]); 
						unset($_SESSION["order_reference"]); 
						
						unset($_COOKIE['DELIVERY_LATITUDE']); 
						unset($_COOKIE['DELIVERY_LONGITUDE']); 
						unset($_COOKIE['DELIVERY_ADDRESS']);
						
						redirect(base_url().'confirm.html');
					}
				}
				else
				{
					redirect(base_url().'payment-error.html');
				}
			}
		}
		else
		{
			$page_data['page_title'] = SITE_NAME.' | Payment Error'; #Page Title
			$page_data['page_name']  = "web_payment/paymentError"; #View Page
			$this->load->view($this->template, $page_data);
		}
	}

}
	
?>
