<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Web_payment extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	function checkout()
    {
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}

		if (isset($_POST['digit_1'])) 
		{
			$otp_number = "";
			if( isset($_SESSION['VERIFY_MOBILE_NUMBER']) && !empty($_SESSION['VERIFY_MOBILE_NUMBER']) )
			{
				$otp_number = $_SESSION['VERIFY_MOBILE_NUMBER']['otp_number'];
			}
			
			#$postOTP = isset($_POST['otp_number']) ? $_POST['otp_number'] :"";
			$digit_1 = isset($_POST['digit_1']) ? $_POST['digit_1'] :"";
			$digit_2 = isset($_POST['digit_2']) ? $_POST['digit_2'] :"";
			$digit_3 = isset($_POST['digit_3']) ? $_POST['digit_3'] :"";
			$digit_4 = isset($_POST['digit_4']) ? $_POST['digit_4'] :"";
			$digit_5 = isset($_POST['digit_5']) ? $_POST['digit_5'] :"";
			$digit_6 = isset($_POST['digit_6']) ? $_POST['digit_6'] :"";
			
			$postOTP = $digit_1."".$digit_2."".$digit_3."".$digit_4."".$digit_5."".$digit_6;
			
			if( $otp_number  == $postOTP )
			{
				$CustomerData = $_SESSION['VERIFY_MOBILE_NUMBER'];
				$CustomerData['otp_status'] = 1;
				
				$this->db->where('user_id',$this->UserID);
				$this->db->update('users', $CustomerData);

				unset($_SESSION["VERIFY_MOBILE_NUMBER"]);
				
				$this->session->set_flashdata('success_message' , 'Your OTP has been verified successfully!');
				redirect(base_url().'checkout.html', 'refresh');
			}
			else
			{
				$this->session->set_flashdata('error_message' , 'Your entered OTP is invalid!');
				redirect(base_url()."checkout.html", 'refresh');
			}
		}

		if (isset($_POST['mobile_number_verify'])) 
		{
			
			$country_code = $this->input->post('country_code');
			
			$data['country_id'] = $this->input->post('country_id');
			$data['mobile_number'] = $this->input->post('mobile_number_verify');
			$data['otp_number'] = $otp_number = otpNumber(6);
			
			# chkExistEmail exist start here
			$chkExistEmail = $this->db->query("select user_id from users
				where 
					mobile_number = ".$data['mobile_number']."
					")->result_array();
						
			if(count($chkExistEmail) > 0)
			{
				$this->session->set_flashdata('error_message' , " Mobile Number already exist!");
				redirect(base_url()."checkout.html", 'refresh');
			}
			# chkExistEmail exist end here
			
			$otpMobileNumber = $country_code.$data['mobile_number'];
			$otpMessage = $otp_number.' is your OTP / verification code for Signup. - Thank You.  '.strtoupper(SITE_NAME);
			$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
			
			if($sendSMS == 1)
			{
				$_SESSION['VERIFY_MOBILE_NUMBER'] = $data;
				
				$this->session->set_flashdata('success_message', 'OTP sent successfully!');
				redirect(base_url()."checkout.html", 'refresh');
			}
			else
			{
				$this->session->set_flashdata('error_message' , 'Problem in SMS. Try again later!.');
				redirect(base_url()."checkout.html", 'refresh');
			}
		
		}
		
		if(isset($_POST["addressUpdate"]))
		{
			$customer_address_id  = $this->input->post('customer_address_id');
			$data['pin_code']  = $this->input->post('pin_code');
			$data['address']   = $this->input->post('address');
			$data['land_mark'] = $this->input->post('land_mark');
			$data['locality']  = $this->input->post('locality');
			$data['country_id'] = $this->input->post('country_id');
			$data['alternative_number'] = $this->input->post('alternative_number');
			$data['door_number'] 			= $this->input->post('door_number');
			$data['building_number'] 		= $this->input->post('building_number');
			#$data['address_line_1'] 		= $this->input->post('address_line_1');
			$data['address_line_2'] 		= $this->input->post('address_line_2');
			$data['full_name'] = $this->input->post('full_name');
			$data['tags'] = isset($_POST['tags']) ? $_POST['tags'] : 0;
					
			$data['delivery_address'] = $this->input->post('delivery_address');
			$latLong = getGeoLatLong($data['delivery_address']);
			$data['latitude'] = $latLong['latitude'];
			$data['longitude'] = $latLong['longitude'];
					
			$this->db->where('customer_address_id', $customer_address_id);
			$this->db->where('user_id', $this->UserID);
			$result = $this->db->update('vb_customer_address', $data);
			
			if($result)
			{
				$UserDetails = "select user_id,mobile_number,country_id from users where user_id ='".$this->UserID."'";
				$getUserDetails = $this->db->query($UserDetails)->result_array();
				
				$country_id = isset($getUserDetails[0]['country_id']) ? $getUserDetails[0]['country_id'] : 0;
				$mobile_number = isset($getUserDetails[0]['mobile_number']) ? $getUserDetails[0]['mobile_number'] :"";
				
				if($country_id == 0 && empty($mobile_number) )
				{
					$userData['mobile_number'] = $data['alternative_number'];
					$userData['country_id'] = $data['country_id'];
					$this->db->where('user_id', $this->UserID);
					$result = $this->db->update('users', $userData);
				}
						
				$this->session->set_flashdata('flash_message' , "Address updated Successfully!");
				redirect($_SERVER['HTTP_REFERER'], 'refresh');
			}
		}
		else if(isset($_POST["addressAdd"]))
		{
			$data['customer_address_id']  	= $this->input->post('customer_address_id');
			$data['pin_code']  				= $this->input->post('pin_code');
			$data['address']   				= $this->input->post('address');
			$data['land_mark'] 				= $this->input->post('land_mark');
			$data['locality']  				= $this->input->post('locality');
			$data['country_id']	 			= $this->input->post('country_id');
			$data['alternative_number'] 	= $this->input->post('alternative_number');
			$data['full_name'] 				= $this->input->post('full_name');
			$data['door_number'] 			= $this->input->post('door_number');
			$data['building_number'] 		= $this->input->post('building_number');
			#$data['address_line_1'] 		= $this->input->post('address_line_1');
			$data['address_line_2'] 		= $this->input->post('address_line_2');
			$data['user_id'] = $this->UserID;
			$data['tags'] = isset($_POST['tags']) ? $_POST['tags'] : 0;
					
			$data['delivery_address'] = $this->input->post('delivery_address');
			$latLong = getGeoLatLong($data['delivery_address']);
			$data['latitude'] = $latLong['latitude'];
			$data['longitude'] = $latLong['longitude'];
			
			$this->db->insert('vb_customer_address', $data);
			$id = $this->db->insert_id();

			if($id)
			{
				$UserDetails = "select user_id,mobile_number,country_id from users where user_id ='".$this->UserID."'";
				$getUserDetails = $this->db->query($UserDetails)->result_array();
				
				$country_id = isset($getUserDetails[0]['country_id']) ? $getUserDetails[0]['country_id'] : 0;
				$mobile_number = isset($getUserDetails[0]['mobile_number']) ? $getUserDetails[0]['mobile_number'] :"";
				
				if($country_id == 0 && empty($mobile_number) )
				{
					$userData['mobile_number'] = $data['alternative_number'];
					$userData['country_id'] = $data['country_id'];
					$this->db->where('user_id', $this->UserID);
					$result = $this->db->update('users', $userData);
				}
				
				$this->session->set_flashdata('flash_message' , "Address added Successfully!");
				redirect($_SERVER['HTTP_REFERER'], 'refresh');
			}
		}
		else if($_POST)
		{
			// print_r($_POST);exit;
			#Card Payment
			if(isset($_POST['payment_method']) && $_POST['payment_method'] == 2)
			{
				$this->cardPayment($_POST);
			}
			else #COD
			{
				$wallet_chk = isset($_POST['wallet_chk_enabled']) ? $_POST['wallet_chk_enabled'] : 0;
				
				if($wallet_chk == 1) #Enabled
				{
					$totalAmount = $grandTotal = $_POST['grand_total'];
					$wallet_amount = $_POST['wallet_amount'];
					
					if($totalAmount < $wallet_amount)
					{
						$walletAmount = $totalAmount;
					}
					else
					{
						$walletAmount = $wallet_amount;
					}
				}
				else #Disabled
				{
					$walletAmount = 0;
				}
				
				$branch_id  = isset($_SESSION['BRANCH_ID']) ? $_SESSION['BRANCH_ID'] : 0;
				$orderDate  = date('Y-m-d');
				
				$headerData = array(
					#"order_number"         => randomNum(10),
					"order_date"           => $orderDate,
					"invoice_billing_date" => time(),
					"user_id"              => $this->UserID,
					"branch_id"            => $branch_id,
					"created_date"         => time(),
					"sub_total"            => $_POST['sub_total'],
					"grand_total"          => $_POST['grand_total'],
					"payable_amount"       => $_POST['payable_amount'],
					"order_type"           => isset($_POST['order_type']) ? $_POST['order_type'] :"",
					"delivery_address"     => isset($_POST['delivery_address_id']) ? $_POST['delivery_address_id'] :"",
					"payment_method"       => isset($_POST['payment_method']) ? $_POST['payment_method'] :"",
					"tax_value"            => isset($_POST['tax_value']) ? $_POST['tax_value'] : 0,
					"wallet_chk_enabled"   => $wallet_chk,
					"wallet_amount"        => $walletAmount,
					"payment_status"       => 'PENDING',
				);
				
				$this->db->insert('vb_order_header', $headerData);
				$order_id = $this->db->insert_id();
				
				$randomNumber = "";

				if($order_id > 0)
				{
					#BD-090821-001
					
					#Order No auto generate Start here
					
					$results = $this->db->query("select increment_id 
						from vb_order_header 
						where 
							branch_id = '".$branch_id."'
						order by increment_id desc")->result_array();
					if( isset($results[0]['increment_id']) && $results[0]['increment_id'] == 0 )
					{
						$incrementID = 1;
					}
					else
					{
						$incrementID = $results[0]['increment_id'] + 1;
					}
					
					$branchQry = "select branch_prefix from branch where branch_id='".$branch_id."' ";
					$getBranchDetails = $this->db->query($branchQry)->result_array();
					$branch_prefix = $getBranchDetails[0]["branch_prefix"];
					$orderDate = date("dmy");
					$randomNumber = $branch_prefix."-".$orderDate.'-00'.$incrementID;
					
					$UpdateData['order_number'] = $randomNumber;
					$UpdateData['increment_id'] = $incrementID;
					
					$this->db->where('order_id', $order_id);
					$resultUpdateData = $this->db->update('vb_order_header', $UpdateData);
					#Order No auto generate end here

					# OrderLine start
					if( isset($_POST['product_id']) && $_POST['product_id'] !="" )
					{
						$count=count($_POST['product_id']);
						for($dp=0;$dp<$count;$dp++)
						{	
							$quantity = isset($_POST['quantity'][$dp]) ? $_POST['quantity'][$dp] :"";
							$product_id = isset($_POST['product_id'][$dp]) ? $_POST['product_id'][$dp] :"";
							
							$lineData['order_id']          = $order_id;
							$lineData['category_id']       = isset($_POST['category_id'][$dp]) ? $_POST['category_id'][$dp] :"";
							$lineData['product_id']        = $product_id;
							
							$lineData['price']             = isset($_POST['price'][$dp]) ? $_POST['price'][$dp] :"";
							$lineData['ingredient_amount'] = isset($_POST['ingredientAmount'][$dp]) ? $_POST['ingredientAmount'][$dp] :"";
							$lineData['ingredients']       = isset($_POST['ingredients'][$dp]) ? $_POST['ingredients'][$dp] :"";
							
							$lineData['quantity']          = $quantity;
							$lineData['linetotal']         = isset($_POST['linetotal'][$dp]) ? $_POST['linetotal'][$dp] :"";
							$lineData['order_date']        = strtotime($orderDate);
							
							$this->db->insert('vb_order_line', $lineData);
							$lineID= $this->db->insert_id();
							
							#Update Availble Qty start
							$BrancItemHeader ="select branch_item_header_id from vb_branch_items_header where branch_id='".$branch_id."' ";
							$getBrancItemHeader = $this->db->query($BrancItemHeader)->result_array();
							$branch_item_header_id = isset($getBrancItemHeader[0]['branch_item_header_id']) ? $getBrancItemHeader[0]['branch_item_header_id'] : 0;
							
							$UpdateAvailbleQtyQuery = "update vb_branch_items_line set available_quantity = available_quantity - $quantity 
								where 
									branch_item_header_id = '".$branch_item_header_id."' and
										product_id = '".$product_id."'
								";
							$this->db->query($UpdateAvailbleQtyQuery);
							#Update Availble Qty end
						}
					}
					# OrderLine start
					
					if($wallet_chk == 1)
					{
						$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount - $walletAmount where user_id = '".$this->UserID."' ";
						$this->db->query($UpdateQuery);
					}
					
					$orderQuery = "select 
						vb_order_header.user_id, 
						vb_order_header.order_number,
						vb_order_header.grand_total,
						users.mobile_number, 
						country.country_code
					from vb_order_header 
					
					left join users on 
						users.user_id = vb_order_header.user_id
						
					left join country on 
						country.country_id = users.country_id 
					where order_id = '".$order_id."' ";

					$getOrderDetails = $this->db->query($orderQuery)->result_array();
					
					$country_code = $getOrderDetails[0]['country_code'];
					$mobile_number = $getOrderDetails[0]['mobile_number'];
					$order_number = $getOrderDetails[0]['order_number'];
					$otpMobileNumber = $country_code.$mobile_number;
				
					$otpMessage = '#'. $order_number.' Your order has been placed. - Thank You.  '.strtoupper(SITE_NAME);
					$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
					
					//echo $sendSMS ;exit;
					
					unset($_SESSION["cart_item"]);
					
					redirect(base_url() . 'confirm.html', 'refresh');
				}
			}
		}
		
		$page_data['page_title'] = SITE_NAME.' | Checkout'; #Page Title
		$page_data['page_name']  = "web_payment/checkout"; #View Page
		$this->load->view($this->template, $page_data);
	}
	
	function AjaxVerifyMobileNumber()
	{
		if (strlen($_POST['mobile_number']) > 8) 
		{
			$chkExistEmail = $this->db->query("select user_id from users
							where 
								mobile_number = ".$_POST['mobile_number']."
								")->result_array();

			if(count($chkExistEmail) > 0)
			{
				echo 0;exit;
			}
			else {
				echo 1;exit;
			}
		}
		else 
		{
			echo 0;exit;
		}
		
	}

	function cancel_verification()
	{
		unset($_SESSION["VERIFY_MOBILE_NUMBER"]);
		redirect(base_url().'home.html');
	}
	
	function confirm()
    {
		$page_data['page_title'] = SITE_NAME.' | Confirm'; #Page Title
		$page_data['page_name']  = "web_payment/confirm"; #View Page
		$this->load->view($this->template, $page_data);
	}
	
	function AjaxremoveCart()
	{
		unset($_SESSION['cart_item'][$_POST['cart_item']]);
		echo json_encode('Removed from cart');die;
	}

	#Card Payment
	function cardPayment($data="")
	{
		$apikey = N_GENIUS_PAYMENT_API_KEY;
		
		$ch = curl_init(); 
		curl_setopt($ch, CURLOPT_URL, "https://api-gateway.sandbox.ngenius-payments.com/identity/auth/access-token"); 
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			"accept: application/vnd.ni-identity.v1+json",
			"authorization: Basic ".$apikey,
			"content-type: application/vnd.ni-identity.v1+json")
		); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);   
		curl_setopt($ch, CURLOPT_POST, 1); 
		curl_setopt($ch, CURLOPT_POSTFIELDS,  "{\"realmName\":\"ni\"}"); 
		$output = json_decode(curl_exec($ch)); 
		$access_token = $output->access_token;

		$postData = new StdClass(); 
		$postData->action = "SALE"; 
		$postData->amount = new StdClass();
		$postData->amount->currencyCode = CURRENCY_CODE;
		
		$postData->amount->value = $data['payable_amount'] * 100; 		

		$postData->merchantAttributes  = new StdClass();
		$postData->merchantAttributes->redirectUrl = base_url()."web_payment/paymentDetails"; 
	
		$postData->merchantAttributes->skipConfirmationPage = true;
		$outlet = N_GENIUS_PAYMENT_OUTLET_ID;
		$token = $output->access_token;

		$json = json_encode($postData);
		$ch = curl_init(); 
		
		curl_setopt($ch, CURLOPT_URL, "https://api-gateway.sandbox.ngenius-payments.com/transactions/outlets/".$outlet."/orders"); 
		curl_setopt(
			$ch, CURLOPT_HTTPHEADER, array(
				"Authorization: Bearer ".$token, 
				"Content-Type: application/vnd.ni-payment.v2+json", 
				"Accept: application/vnd.ni-payment.v2+json",
			)
		); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);   
		curl_setopt($ch, CURLOPT_POST, 1); 
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json); 
		
		$output = json_decode(curl_exec($ch)); 
		$order_reference = $output->reference; 
		$order_paypage_url = $output->_links->payment->href; 
		// curl_close ($ch);
		$_SESSION['postData'] = $data;
		
		redirect($order_paypage_url);
	}

	function paymentDetails()
	{
		if ( isset($_GET['ref']) ) 
		{
			$apikey = N_GENIUS_PAYMENT_API_KEY;
			$outlet = N_GENIUS_PAYMENT_OUTLET_ID;

			$ch = curl_init(); 
			curl_setopt($ch, CURLOPT_URL, "https://api-gateway.sandbox.ngenius-payments.com/identity/auth/access-token"); 
			curl_setopt($ch, CURLOPT_HTTPHEADER, array(
				"accept: application/vnd.ni-identity.v1+json",
				"authorization: Basic ".$apikey,
				"content-type: application/vnd.ni-identity.v1+json")
			); 
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);   
			curl_setopt($ch, CURLOPT_POST, 1); 
			curl_setopt($ch, CURLOPT_POSTFIELDS,  "{\"realmName\":\"ni\"}"); 
			$output = json_decode(curl_exec($ch)); 
			$access_token = $output->access_token;

			$curl = curl_init();

			$orderReference = $_GET['ref'];

			curl_setopt_array($curl, [
				CURLOPT_URL => "https://api-gateway.sandbox.ngenius-payments.com/transactions/outlets/".$outlet."/orders/".$orderReference,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "GET",
				CURLOPT_HTTPHEADER => [
					"Accept: application/vnd.ni-payment.v2+json",
					"authorization: Bearer ".$access_token
				],
			]);

			$response = curl_exec($curl);
			$err = curl_error($curl);
			
			curl_close($curl);

			if ($err) 
			{
				#echo "cURL Error #:" . $err;
				redirect(base_url().'payment-error.html');
			} 
			else 
			{
				$data = json_decode($response);
				
				if(isset($data->_embedded->payment[0]->state) && $data->_embedded->payment[0]->state == "CAPTURED" || $data->_embedded->payment[0]->state == "AUTHORISED")
				{
					$postData = isset($_SESSION['postData']) ? $_SESSION['postData'] : "";

					$wallet_chk = isset($postData['wallet_chk_enabled']) ? $postData['wallet_chk_enabled'] : 0;
					
					if($wallet_chk == 1) #Enabled
					{
						$totalAmount = $grandTotal = $postData['grand_total'];
						$wallet_amount = $postData['wallet_amount'];
						
						if($totalAmount < $wallet_amount)
						{
							$walletAmount = $totalAmount;
						}
						else
						{
							$walletAmount = $wallet_amount;
						}
					}
					else #Disabled
					{
						$walletAmount = 0;
					}
					
					$branch_id  = isset($_SESSION['BRANCH_ID']) ? $_SESSION['BRANCH_ID'] : 0;
					$orderDate  = date('Y-m-d');

					if ($data->_embedded->payment[0]->authResponse->success)
					{
						$payment_status = "SUCCESS";	
					}
					else
					{
						$payment_status = "FAILED";
					}

					$headerData = array(
						#"order_number"         => randomNum(10),
						"order_date"           => $orderDate,
						"invoice_billing_date" => time(),
						"user_id"              => $this->UserID,
						"branch_id"            => $branch_id,
						"created_date"         => time(),
						"sub_total"            => $postData['sub_total'],
						"grand_total"          => $postData['grand_total'],
						"payable_amount"       => $postData['payable_amount'],
						"order_type"           => isset($postData['order_type']) ? $postData['order_type'] :"",
						"delivery_address"     => isset($postData['delivery_address_id']) ? $postData['delivery_address_id'] :"",
						
						"payment_method"       => isset($postData['payment_method']) ? $postData['payment_method'] :"",
						"wallet_chk_enabled"   => $wallet_chk,
						"wallet_amount"        => $walletAmount,
						"tax_value"            => isset($postData['tax_value']) ? $postData['tax_value'] : 0,
					
						"currency_code"        => $data->amount->currencyCode,
						"reference_id"         => $data->reference,
						"payment_status"       => $payment_status,
					);
					
					$this->db->insert('vb_order_header', $headerData);
					$order_id = $this->db->insert_id();

					if($order_id > 0)
					{
						$serialized_data = serialize($data);
						$payment_history = array('order_id'=>$order_id,'payment_history'=>$serialized_data);

						$this->db->insert('vb_order_payment_history', $payment_history);

						#Order No auto generate Start here
						$results = $this->db->query("select increment_id from 
						vb_order_header 
						where 
							branch_id = '".$branch_id."'
						order by increment_id desc")->result_array();
						
						if( isset($results[0]['increment_id']) && $results[0]['increment_id'] == 0 )
						{
							$incrementID = 1;
						}
						else
						{
							$incrementID = $results[0]['increment_id'] + 1;
						}
						
						$branchQry = "select branch_prefix from branch where branch_id='".$branch_id."' ";
						$getBranchDetails = $this->db->query($branchQry)->result_array();
						$branch_prefix = $getBranchDetails[0]["branch_prefix"];
						$orderDate = date("dmy");
						$randomNumber = $branch_prefix."-".$orderDate.'-00'.$incrementID;
						
						$UpdateData['order_number'] = $randomNumber;
						$UpdateData['increment_id'] = $incrementID;
						
						$this->db->where('order_id', $order_id);
						$resultUpdateData = $this->db->update('vb_order_header', $UpdateData);
						#Order No auto generate end here

						# OrderLine start
						if( isset($postData['product_id']) && $postData['product_id'] !="" )
						{
							$count=count($postData['product_id']);
							for($dp=0;$dp<$count;$dp++)
							{	
								$quantity = isset($postData['quantity'][$dp]) ? $postData['quantity'][$dp] :"";
								$product_id = isset($postData['product_id'][$dp]) ? $postData['product_id'][$dp] :"";
								
								$lineData['order_id']          = $order_id;
								$lineData['category_id']       = isset($postData['category_id'][$dp]) ? $postData['category_id'][$dp] :"";
								$lineData['product_id']        = $product_id;
								
								$lineData['price']             = isset($postData['price'][$dp]) ? $postData['price'][$dp] :"";
								$lineData['ingredient_amount'] = isset($postData['ingredientAmount'][$dp]) ? $postData['ingredientAmount'][$dp] :"";
								$lineData['ingredients']       = isset($postData['ingredients'][$dp]) ? $postData['ingredients'][$dp] :"";
								
								$lineData['quantity']          = $quantity;
								$lineData['linetotal']         = isset($postData['linetotal'][$dp]) ? $postData['linetotal'][$dp] :"";
								$lineData['order_date']        = strtotime($orderDate);
								
								$this->db->insert('vb_order_line', $lineData);
								$lineID= $this->db->insert_id();
								
								#Update Availble Qty start
								$BrancItemHeader ="select branch_item_header_id from vb_branch_items_header where branch_id='".$branch_id."' ";
								$getBrancItemHeader = $this->db->query($BrancItemHeader)->result_array();
								$branch_item_header_id = isset($getBrancItemHeader[0]['branch_item_header_id']) ? $getBrancItemHeader[0]['branch_item_header_id'] : 0;
								
								$UpdateAvailbleQtyQuery = "update vb_branch_items_line set available_quantity = available_quantity - $quantity 
									where 
										branch_item_header_id = '".$branch_item_header_id."' and
											product_id = '".$product_id."'
									";
								$this->db->query($UpdateAvailbleQtyQuery);
								#Update Availble Qty end
							}
						}
						# OrderLine start
						
						if($wallet_chk == 1)
						{
							$UpdateQuery = "update vb_customer_wallet set wallet_amount=wallet_amount - $walletAmount where user_id = '".$this->UserID."' ";
							$this->db->query($UpdateQuery);
						}
						
						$orderQuery = "select 
						vb_order_header.user_id, 
						vb_order_header.order_number,
						vb_order_header.grand_total,
						users.mobile_number, 
						country.country_code
						
					from vb_order_header 
					
					left join users on 
						users.user_id = vb_order_header.user_id
						
					left join country on 
						country.country_id = users.country_id 
					where order_id = '".$order_id."' ";

					$getOrderDetails = $this->db->query($orderQuery)->result_array();
					
					$country_code = $getOrderDetails[0]['country_code'];
					$mobile_number = $getOrderDetails[0]['mobile_number'];
					$order_number = $getOrderDetails[0]['order_number'];
					$otpMobileNumber = $country_code.$mobile_number;
				
					$otpMessage = '#'. $order_number.' Your order has been placed. - Thank You.  '.strtoupper(SITE_NAME);
					$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
					
					//echo $sendSMS ;exit;
						
						unset($_SESSION["cart_item"]);
						unset($_SESSION["postData"]); 
						
						
						unset($_COOKIE['DELIVERY_LATITUDE']); 
						unset($_COOKIE['DELIVERY_LONGITUDE']); 
						unset($_COOKIE['DELIVERY_ADDRESS']);
						
						redirect(base_url().'confirm.html');
					}
				}
				else
				{
					redirect(base_url().'payment-error.html');
				}
			}
		}
		else
		{
			$page_data['page_title'] = SITE_NAME.' | Payment Error'; #Page Title
			$page_data['page_name']  = "web_payment/paymentError"; #View Page
			$this->load->view($this->template, $page_data);
		}
	}

}
	
?>
