<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Web_users extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
        $this->load->library('session');
      
        #Cache Control
		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
		$this->output->set_header('Pragma: no-cache');
	}
	
	#Signup
	public function signUp()
	{
		$page_data['page_title'] = SITE_NAME.' | Signup'; #Page Title
		$page_data['page_name']  = "signUp"; #View Page
		
		if($_POST)
		{
			$country_id = $this->input->post('country_id');
			$CountryQry ="select country_code from country where country_id='".$country_id."' ";
			$getCountryCode =$this->db->query($CountryQry)->result_array();
			$country_code = isset($getCountryCode[0]['country_code']) ? $getCountryCode[0]['country_code'] : "+971";
			
			$data['country_id'] = $this->input->post('country_id');
			$data['first_name'] = $this->input->post('first_name');
			$data['email'] = $this->input->post('email');
			$data['mobile_number'] = $this->input->post('mobile_number');
			$data['password'] = md5($this->input->post('password'));
			$data['original_password'] = $this->input->post('password');
			$data['user_status'] = 1;
			$data['register_type'] = 2; #customers
			$data['joined_date'] = strtotime(date('d-m-Y h:i:s a',time()));
			$data['otp_number'] = $otp_number = otpNumber(6);
			
			# chkExistEmail exist start here
			$chkExistEmail = $this->db->query("select user_id from users
				where 
					email='".$data['email']."'
					")->result_array();
						
				if(count($chkExistEmail) > 0)
				{
					$this->session->set_flashdata('error_message' , " Email already exist!");
					redirect(base_url()."sign-up.html", 'refresh');
				}
			# chkExistEmail exist end here
			
			$otpMobileNumber = $country_code.$data['mobile_number'];
			$otpMessage = $otp_number.' is your OTP / verification code for Signup. - Thank You.  '.strtoupper(SITE_NAME);
			
			$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
			
			if($sendSMS == 1)
			{
				$_SESSION['CUSTOMER_DATA'] = $data;
				/* $this->db->insert('users', $data);
				$id = $this->db->insert_id();
				*/
				$this->session->set_flashdata('success_message', 'OTP sent successfully!');
				redirect(base_url()."verification-otp.html", 'refresh');
			}
			else
			{
				$this->session->set_flashdata('error_message' , 'Problem in SMS. Try again later!.');
				redirect(base_url()."sign-up.html", 'refresh');
			}
		}
		$this->load->view($this->template,  $page_data);
	}
	
	public function verificationOtp()
	{
		$page_data['page_title'] = SITE_NAME.' | Login'; #Page Title
		$page_data['page_name']  = "verificationOtp"; #View Page
		
		if($_POST)
		{
			$otp_number = "";
			if( isset($_SESSION['CUSTOMER_DATA']) && !empty($_SESSION['CUSTOMER_DATA']) )
			{
				$otp_number = $_SESSION['CUSTOMER_DATA']['otp_number'];
			}
			
			#$postOTP = isset($_POST['otp_number']) ? $_POST['otp_number'] :"";
			$digit_1 = isset($_POST['digit_1']) ? $_POST['digit_1'] :"";
			$digit_2 = isset($_POST['digit_2']) ? $_POST['digit_2'] :"";
			$digit_3 = isset($_POST['digit_3']) ? $_POST['digit_3'] :"";
			$digit_4 = isset($_POST['digit_4']) ? $_POST['digit_4'] :"";
			$digit_5 = isset($_POST['digit_5']) ? $_POST['digit_5'] :"";
			$digit_6 = isset($_POST['digit_6']) ? $_POST['digit_6'] :"";
			
			$postOTP = $digit_1."".$digit_2."".$digit_3."".$digit_4."".$digit_5."".$digit_6;
			
			if( $otp_number  == $postOTP )
			{
				$CustomerData = $_SESSION['CUSTOMER_DATA'];
				$CustomerData['otp_status'] = 1;
				$this->db->insert('users', $CustomerData);
				$id = $this->db->insert_id();
				
				$result = $this->db->query("select 
						users.user_id,
						users.user_status,
						users.register_type,
						country.country_id,
						country.country_code,
						users.signin_otp_number
						from users 
						
						left join country on
							country.country_id = users.country_id
							
						where users.user_id='".$id."' and
								users.register_type=2
				")->result_array();
			
			
				$this->session->set_userdata('UserID',$result[0]['user_id']);
				$this->session->set_userdata('register_type',$result[0]['register_type']); #2=>Web User
				
				unset($_SESSION["CUSTOMER_DATA"]);
				
				$this->session->set_flashdata('success_message' , 'Your OTP has been verified successfully!');
				redirect(base_url(), 'refresh');
			}
			else
			{
				$this->session->set_flashdata('error_message' , 'Your entered OTP is invalid!');
				redirect(base_url()."verification-otp.html", 'refresh');
			}
		}
		
		$this->load->view($this->template, $page_data);
	}
	
	public function cancelOtp()
	{
		unset($_SESSION["CUSTOMER_DATA"]);
		redirect(base_url(), 'refresh');
	}
	
	#Login
	public function login()
	{
		if (!empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$page_data['page_title'] = SITE_NAME.' | Login'; #Page Title
		$page_data['page_name']  = "login"; #View Page
		
		if($_POST)
		{
			$register_type = 2;
			$mobile_number = $this->input->post('mobile_number');
			$country_code = $this->input->post('country_code');
			
			#$password = $this->input->post('password');
			
			$status = $this->webusers_model->login($mobile_number,$register_type,$country_code); #$password,
			
			if( $status == 10 )
			{
				$this->session->set_flashdata('success_message' , 'OTP Sent to your Mobile Number!');
				redirect(base_url(), 'refresh');
			}
			if( $status == 11 )
			{
				$this->session->set_flashdata('error_message' , 'Problem in SMS. Try again later!.');
				redirect(base_url(), 'refresh');
			}
			else if($status == 9)
			{
				$this->session->set_flashdata('error_message' , 'Your account has been Blocked!');
				redirect(base_url(), 'refresh');
			}
			else if($status == 8)
			{
				$this->session->set_flashdata('error_message' , 'Please Register Your Mobile Number!');
				redirect(base_url(), 'refresh');
			}
			else if($status == 0)
			{
				$this->session->set_flashdata('error_message' , 'Mobile Number does not exist!');
				redirect(base_url(), 'refresh');
			}
			else
			{
				$this->session->set_flashdata('error_message' , "Can't login this time!");
				redirect(base_url(), 'refresh');
			}
		}
		$this->load->view($this->template, $page_data);
	}
	
	public function SignInverificationOtp()
	{
		if($_POST)
		{
			$mobile_number = $_SESSION['mobile_number'];
			$register_type = $_SESSION['register_type'];
			
			$result = $this->db->query("select 
			users.user_id,
			users.user_status,
			users.register_type,
			country.country_id,
			country.country_code,
			users.signin_otp_number
			from users 
			
			left join country on
				country.country_id = users.country_id
			where users.mobile_number='".$mobile_number."' and
					users.register_type='".$register_type."'
			")->result_array();
			
			#$postOTP = isset($_POST['otp_number']) ? $_POST['otp_number'] :"";
			$digit_1 = isset($_POST['digit_1']) ? $_POST['digit_1'] :"";
			$digit_2 = isset($_POST['digit_2']) ? $_POST['digit_2'] :"";
			$digit_3 = isset($_POST['digit_3']) ? $_POST['digit_3'] :"";
			$digit_4 = isset($_POST['digit_4']) ? $_POST['digit_4'] :"";
			$digit_5 = isset($_POST['digit_5']) ? $_POST['digit_5'] :"";
			$digit_6 = isset($_POST['digit_6']) ? $_POST['digit_6'] :"";
			
			$postOTP = $digit_1."".$digit_2."".$digit_3."".$digit_4."".$digit_5."".$digit_6;
			
			$otp_number = isset($result[0]['signin_otp_number'])? $result[0]['signin_otp_number'] : 0;
			
			if( $otp_number  == $postOTP )
			{
				$userData['signin_otp_status'] = 1;
				
				$this->db->where('mobile_number', $mobile_number);
				$this->db->where('register_type', $register_type);
				$this->db->update('users', $userData);
				
				$this->session->set_userdata('UserID',$result[0]['user_id']);
				$this->session->set_userdata('register_type',$result[0]['register_type']); #2=>Web User
				
				unset($_SESSION["mobile_number"]);
				unset($_SESSION["register_type"]);
				unset($_SESSION["SIGNIN_VERIFY"]);
				
				$this->session->set_flashdata('success_message' , 'Login OTP has been verified successfully!');
				redirect(base_url(), 'refresh');
			}
			else
			{
				$this->session->set_flashdata('error_message' , 'Your entered OTP is invalid!');
				redirect(base_url(), 'refresh');
			}
		}
	}
	
	public function cancel_singin_otp()
	{
		unset($_SESSION["mobile_number"]);
		unset($_SESSION["register_type"]);
		unset($_SESSION["SIGNIN_VERIFY"]);
		redirect(base_url(), 'refresh');
	}
	
	#Forgot Password
	public function forgotPassword()
	{
		$page_data['page_title'] = 'Forgot Password'; #Page Title
		$page_data['page_name']  = "forgotPassword"; #View Page
		
		if($_POST)
		{
			$mobile_number = $this->input->post('mobile_number');
			$register_type = 2;
			
			if($mobile_number !="")
			{
				$checkExistUser = $this->db->query("select 
					users.user_id,
					users.original_password,
					users.user_status,
					users.mobile_number, 
					country.country_code
					from users 
					left join country on 
							country.country_id = users.country_id
					WHERE 
						users.mobile_number='".$mobile_number."' and 
							users.login_type=0 and 
								users.register_type='".$register_type."'
				")->result_array();
				
				if(count($checkExistUser) > 0)
				{
					#Order canceled sms start
					$country_code = $checkExistUser[0]['country_code'];
					$original_password = $checkExistUser[0]['original_password'];
					$otpMobileNumber = $country_code.$mobile_number;
					
					$otpMessage ='Your forgot password is - '.$original_password.' - Thank You.  '.strtoupper(SITE_NAME);
					$sendSMS = globalSMS($otpMobileNumber,$otpMessage);
					#Order canceled sms end
							
					#Email sent start here
					/* $user_status = $checkExistUser[0]['user_status'];
					$page_data['forgotPassword'] =1;
					$user_status = $checkEmail[0]['user_status'];
					$id = $user_id = $checkEmail[0]['user_id'];
					
					$page_data['password'] = $checkEmail[0]['original_password'];
					
					$to = $email;
					$from = CONTACT_EMAIL;
					$fromName = CONTACT_NAME;
					$subject = "Forgot Password";	
					
					$message = $this->load->view('mail_template/front_mail_template', $page_data, true);
					
					#echo $message;exit;
					
					if(EMAIL_TYPE == 2) #SMTP
					{
						$sendMail = Send_SMTP($from,$to,$subject,$message,$fromName);
					}
					else  #Send Grid 
					{
						$sendMail = Send_Grid($from,$to,$subject,$message,$fromName);
					} */
					#Email sent end here
					
					$this->session->set_flashdata('success_message' , 'Your Password sent to registered Mobile Number.');
					redirect(base_url(), 'refresh');
				}
				else
				{
					$this->session->set_flashdata('error_message' , 'Sorry! This Mobile Number not registered!');
					redirect(base_url().'sign-up.html', 'refresh');
				}
			}
		}
		$this->load->view($this->template, $page_data);
	}
	
	#change Password
	function change_password($param1 = '', $param2 = '', $param3 = '')
    {
        if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$page_data['page_name']  = 'web_users/change_password';
		$page_data['page_title'] = 'Change Password';
			
        if ($_POST)
		{
            $data['password']             = md5($this->input->post('password'));
            $data['new_password']         = md5($this->input->post('new_password'));
            $data['original_password']    = $this->input->post('new_password');
            $data['confirm_new_password'] = md5($this->input->post('confirm_new_password'));

            $current_password = $this->db->get_where('users', array('user_id' => $this->UserID))->row()->password;
			
            if ($current_password == $data['password'] && $data['new_password'] == $data['confirm_new_password']) 
			{
                $this->db->where('user_id', $this->UserID);
                $this->db->update('users', array('password' => $data['new_password'],'original_password' => $_POST['new_password'] ));
                $this->session->set_flashdata('flash_message' , 'Password changed Successfully!');
            } 
			else 
			{
                $this->session->set_flashdata('error_message' , 'Password mismatched!');
            }
            redirect(base_url() . 'change-password.html', 'refresh');
        }
       
        $this->load->view($this->template, $page_data);
    }
	
	public function myprofile()
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$page_data['page_name']  = 'web_users/myprofile';
		$page_data['page_title'] = 'myprofile';
		
		$page_data['view_data'] = $this->db->query("
					select 
					users.email,
					users.user_id,
					users.first_name,
					users.last_name,
					users.mobile_number,
					users.joined_date,
					users.address1,
					users.address2,
					country.country_name,
					country.country_code,
					state.state_name,
					city.city_name,
					users.user_status,
					users.login_type,
					users.otp_status,
					users.signin_otp_status
					
					from users 
					left join country on country.country_id = users.country_id
					left join state on state.state_id = users.state_id
					left join city on city.city_id = users.city_id
					where users.user_id ='".$this->UserID."' 
					")->result_array();
					
		$this->load->view($this->template, $page_data);
	}
	
	public function editprofile()
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$page_data['page_name']  = 'web_users/editprofile';
		$page_data['page_title'] = 'Edit Profile';
		
		$page_data['view_data'] = $this->db->query("
			select 
			users.first_name,
			users.email,
			users.address1,
			users.address2,
			users.country_id,
			users.state_id,
			users.city_id,
			users.mobile_number,
			users.otp_status,
			users.login_type

			from users
			
			left join country on country.country_id = users.country_id
			left join state on state.state_id = users.state_id
			left join city on city.city_id = users.city_id
			
			where users.user_id ='".$this->UserID."'
			")->result_array();


		if($_POST)
		{
			$CommonData['email'] = $this->input->post('email');
			$CommonData['mobile_number'] = $this->input->post('mobile_number');
			
			$this->db->where('user_id', $this->UserID);
			$result = $this->db->update('users', $CommonData);
				
			if($result > 0)
			{
				#General fields
				$data['first_name'] = $this->input->post('first_name');
				$data['email'] = $this->input->post('email');
				$data['mobile_number'] = $this->input->post('mobile_number');
				$data['address1'] = $this->input->post('address1');
				$data['country_id'] = $this->input->post('country_id');
				$data['state_id'] = $this->input->post('state_id');
				$data['city_id'] = $this->input->post('city_id');

				$users = $this->db->query("select login_type,otp_status from users where user_id = $this->UserID")->result_array();

				if ($users[0]['login_type'] == 2 && $users[0]['otp_status'] == 0 ) 
				{
					$_SESSION['edit_profile'] = $data;
					 
					$country_id = $this->input->post('country_id');
					$CountryQry ="select country_code from country where country_id='".$country_id."' ";
					$getCountryCode =$this->db->query($CountryQry)->result_array();
					$country_code = isset($getCountryCode[0]['country_code']) ? $getCountryCode[0]['country_code'] : "+971";

					$otp_number = otpNumber(6);
					$otpMobileNumber = $country_code.$data['mobile_number'];
					$otpMessage = $otp_number.' is your OTP / verification code for Mobile Number Verification. - Thank You.  '.strtoupper(SITE_NAME);
					$sendSMS = globalSMS($otpMobileNumber,$otpMessage);

					if($sendSMS == 1)
					{
						$data['otp_number'] = $otp_number;
						$_SESSION['edit_profile'] = $data;

						$this->db->where('user_id',$this->UserID);
						$this->db->update('users',array('signin_otp_number'=>$otp_number));

						$this->session->set_flashdata('success_message', 'OTP sent successfully!');
						redirect(base_url()."verify-otp.html", 'refresh');exit;
					}
				}

				
				
				$this->db->where('user_id', $this->UserID);
				
				$result_1 = $this->db->update('users', $data); 
				
				if( !empty($_FILES['profile_image']['name']) )
				{  
					move_uploaded_file($_FILES['profile_image']['tmp_name'], 'uploads/profile_image/'.$this->UserID.'.png');
				}
				
				$this->session->set_flashdata('flash_message' , 'User Details Updated Successfully');
				redirect(base_url().'myprofile.html', 'refresh');
			}
			
		}
		$this->load->view($this->template, $page_data);
	}

	function editverifyOtp()
	{
		if (!isset($_SESSION['edit_profile']))
        {
			redirect(base_url()."myprofile.html", 'refresh');
		}
		
		$page_data['page_name']  = 'web_users/editverifyOtp';
		$page_data['page_title'] = 'Edit Profile';

		if($_POST)
		{
			$otp_number = "";
			if( isset($_SESSION['edit_profile']) && !empty($_SESSION['edit_profile']) )
			{
				$otp_number = $_SESSION['edit_profile']['otp_number'];
			}
			
			#$postOTP = isset($_POST['otp_number']) ? $_POST['otp_number'] :"";
			$digit_1 = isset($_POST['digit_1']) ? $_POST['digit_1'] :"";
			$digit_2 = isset($_POST['digit_2']) ? $_POST['digit_2'] :"";
			$digit_3 = isset($_POST['digit_3']) ? $_POST['digit_3'] :"";
			$digit_4 = isset($_POST['digit_4']) ? $_POST['digit_4'] :"";
			$digit_5 = isset($_POST['digit_5']) ? $_POST['digit_5'] :"";
			$digit_6 = isset($_POST['digit_6']) ? $_POST['digit_6'] :"";
			
			$postOTP = $digit_1."".$digit_2."".$digit_3."".$digit_4."".$digit_5."".$digit_6;
			
			if( $otp_number  == $postOTP )
			{
				$CustomerData = $_SESSION['edit_profile'];
				$CustomerData['otp_status'] = 1;
			
				$this->db->where('user_id',$this->UserID);
				$this->db->update('users', $CustomerData);
							
				unset($_SESSION["edit_profile"]);
				
				$this->session->set_flashdata('success_message' , 'Your OTP has been verified successfully!');
				redirect(base_url()."myprofile.html", 'refresh');
			}
			else
			{
				$this->session->set_flashdata('error_message' , 'Your entered OTP is invalid!');
				redirect($_SERVER['HTTP_REFERER'], 'refresh');
				// redirect(base_url()."verification-otp.html", 'refresh');
			}
		}
		
		$this->load->view($this->template, $page_data);
	}

	function ajaxeditverifyOtp()
	{
		if (isset($_POST['mobile_number'])) 
		{
			$country_id = $_POST['country_id'];
			$CountryQry ="select country_code from country where country_id='".$country_id."' ";
			$getCountryCode =$this->db->query($CountryQry)->result_array();
			$country_code = isset($getCountryCode[0]['country_code']) ? $getCountryCode[0]['country_code'] : "+971";

			$otp_number = otpNumber(6);
			$otpMobileNumber = $country_code.$_POST['mobile_number'];
			$otpMessage = $otp_number.' is your OTP / verification code for Mobile Number Verification. - Thank You.  '.strtoupper(SITE_NAME);
			$sendSMS = globalSMS($otpMobileNumber,$otpMessage);

			if($sendSMS == 1)
			{
				$data['otp_number'] = $otp_number;
				$_SESSION['edit_profile'] = $data;
				$_SESSION['edit_profile']['otp_number'] = $otp_number;

				$this->db->where('user_id',$this->UserID);
				$this->db->update('users',array('signin_otp_number'=>$otp_number));

				$jsonData= array('otpStatus'=>1);
				echo json_encode($jsonData);exit;
			}
			else {
				$jsonData= array('otpStatus'=>0);
				echo json_encode($jsonData);exit;
			}
		}

		if (isset($_POST['otp_number'])) {

			$otp_number = "";
			if( isset($_SESSION['edit_profile']) && !empty($_SESSION['edit_profile']) )
			{
				$otp_number = $_SESSION['edit_profile']['otp_number'];
			}

			if( $otp_number  == $_POST['otp_number'] )
			{
				$CustomerData['otp_status'] = 1;
			
				$this->db->where('user_id',$this->UserID);
				$this->db->update('users', $CustomerData);
							
				unset($_SESSION["edit_profile"]);

				$userMobile = $this->db->query('select mobile_number from users where user_id = '.$this->UserID)->result_array();
				
				$jsonData = array("message"=>'Your OTP has been verified successfully!',"status"=>1,"mobile_number"=>$userMobile[0]['mobile_number']);
				echo json_encode($jsonData);exit;
			}
			else {
				$jsonData= array("message"=>'OTP Does\'t Match',"status"=>01);
				echo json_encode($jsonData);exit;
			}
		}
		
	}
	
	function address($type = '', $id = '', $status = '')
    {
		#print_r($this->UserID);exit;
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		//$page_data['manage_settings'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'web_users/address';
		$page_data['page_title'] = 'Manage Address';
		
		switch($type)
		{
			case "add": #add
				if($_POST)
				{
					$data['pin_code'] = $this->input->post('pin_code');
					$data['address'] = $this->input->post('address');
					$data['land_mark'] = $this->input->post('land_mark');
					$data['locality'] = $this->input->post('locality');
					$data['user_id'] = $this->UserID;
					
					$data['country_id'] = $this->input->post('country_id');
					$data['alternative_number'] = $this->input->post('alternative_number');
					
					$data['full_name'] = $this->input->post('full_name');
					$data['tags'] = isset($_POST['tags']) ? $_POST['tags'] : 0;
					
					$data['delivery_address'] = $this->input->post('delivery_address');
					$latLong = getGeoLatLong($data['delivery_address']);
					$data['latitude'] = $latLong['latitude'];
					$data['longitude'] = $latLong['longitude'];
					
					
					$data['door_number'] = $this->input->post('door_number');
					$data['building_number'] = $this->input->post('building_number');
					$data['address_line_2'] = $this->input->post('address_line_2');
					
					
					$this->db->insert('vb_customer_address', $data);				
					$id = $this->db->insert_id();
					
					if($id !="")
					{
						$UserDetails = "select user_id,mobile_number,country_id from users where user_id ='".$this->UserID."'";
						$getUserDetails = $this->db->query($UserDetails)->result_array();
						
						$country_id = isset($getUserDetails[0]['country_id']) ? $getUserDetails[0]['country_id'] : 0;
						$mobile_number = isset($getUserDetails[0]['mobile_number']) ? $getUserDetails[0]['mobile_number'] :"";
						
						if($country_id == 0 && empty($mobile_number) )
						{
							$userData['mobile_number'] = $data['alternative_number'];
							$userData['country_id'] = $data['country_id'];
							$this->db->where('user_id', $this->UserID);
							$result = $this->db->update('users', $userData);
						}
						
						$this->session->set_flashdata('flash_message' , "Address added Successfully!");
						redirect(base_url() . 'address.html', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('vb_customer_address', array('customer_address_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['pin_code'] = $this->input->post('pin_code');
					$data['address'] = $this->input->post('address');
					$data['land_mark'] = $this->input->post('land_mark');
					$data['locality'] = $this->input->post('locality');
					$data['country_id'] = $this->input->post('country_id');
					
					$data['alternative_number'] = $this->input->post('alternative_number');
					$data['full_name'] = $this->input->post('full_name');
					$data['tags'] = isset($_POST['tags']) ? $_POST['tags'] : 0;
					
					$data['delivery_address'] = $this->input->post('delivery_address');
					$latLong = getGeoLatLong($data['delivery_address']);
					$data['latitude'] = $latLong['latitude'];
					$data['longitude'] = $latLong['longitude'];
					
					$data['door_number'] = $this->input->post('door_number');
					$data['building_number'] = $this->input->post('building_number');
					$data['address_line_2'] = $this->input->post('address_line_2');
					
					
					$this->db->where('customer_address_id', $id);
					$this->db->where('user_id', $this->UserID);
					$result = $this->db->update('vb_customer_address', $data);
					
					if($result)
					{
						$UserDetails = "select user_id,mobile_number,country_id from users where user_id ='".$this->UserID."'";
						$getUserDetails = $this->db->query($UserDetails)->result_array();
						
						$country_id = isset($getUserDetails[0]['country_id']) ? $getUserDetails[0]['country_id'] : 0;
						$mobile_number = isset($getUserDetails[0]['mobile_number']) ? $getUserDetails[0]['mobile_number'] :"";
						
						if($country_id == 0 && empty($mobile_number) )
						{
							$userData['mobile_number'] = $data['alternative_number'];
							$userData['country_id'] = $data['country_id'];
							$this->db->where('user_id', $this->UserID);
							$result = $this->db->update('users', $userData);
						}
						unset($_SESSION['EDIT_ADDRESS_CURRENT_LOCATION']);
						$this->session->set_flashdata('flash_message' , "Address updated Successfully!");
						redirect(base_url() . 'address.html', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('customer_address_id', $id);
				$this->db->delete('vb_customer_address');
				
				$this->session->set_flashdata('flash_message' , "Address deleted successfully!");
				redirect(base_url() . 'address.html', 'refresh');
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->webusers_model->getManageAddressCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				$base_url = base_url().'address.html';
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $data =$this->webusers_model->getManageAddress($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->template, $page_data);
	}
	
	function favouriteOrders($type = '', $id = '', $status = '')
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		$page_data['page_name']  = 'web_users/favouriteOrders';
		$page_data['page_title'] = SITE_NAME.' | Favourite Orders';
		
		$page_data["totalRows"] = $totalRows = $this->webusers_model->getFavouriteOrdersCount();
		$limit = 10;
		$base_url = base_url()."my-orders.html";
		
		$config = Pagination($base_url,$totalRows,$limit);
		$this->pagination->initialize($config);
		$str_links = $this->pagination->create_links();
		$page_data['pagination'] = explode('&nbsp;', $str_links);
		$offset = 0;
		if (!empty($_GET['per_page'])) {
			$pageNo = $_GET['per_page'];
			$offset = ($pageNo - 1) * $limit;
		}
		
		if($offset == 1 || $offset== "" || $offset== 0){
			$page_data["first_item"] = 1;
		}else{
			$page_data["first_item"] = $offset + 1;
		}
		
		$page_data['resultData']  = $result = $this->webusers_model->getFavouriteOrders($limit, $offset);
		
		#show start and ending Count
		$total_counts = $total_count= 0;
		$pages=$page_data["starting"] = $page_data["ending"]="";
		$pageno = isset($pageNo) ? $pageNo :"";
		
		if( $totalRows == 0 ){
			$page_data["starting"] = 0;
		}else if( $pageno==1 || $pageno=="" ){
			$page_data["starting"] = 1;
		}else{
			$pages = $pageno-1;
			$total_count = $pages * $config["per_page"];
			$page_data["starting"] = ( $config["per_page"] * $pages )+1;
		}
		
		$total_counts = $total_count + count($result);
		$page_data["ending"]  = $total_counts;
		#show start and ending Count end
				
		$this->load->view($this->template, $page_data);
	}
	
	/* 
	public function address()
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$page_data['page_name']  = 'web_users/address';
		$page_data['page_title'] = 'Address';
		

		$page_data['view_data'] = $this->db->query("
			select 
			users.first_name,
			users.mobile_number,
			users.address1,
			users.address2

			from users
			
			where users.user_id ='".$this->UserID."'
			")->result_array();
		#print_r($page_data['view_data']);exit;
		if($_POST)
		{
			$CommonData['address1'] = $this->input->post('address1');
			$CommonData['address2'] = $this->input->post('address2');
			
			$this->db->where('user_id', $this->UserID);
				
			$result = $this->db->update('users', $CommonData); 
			
			$this->session->set_flashdata('flash_message' , 'Address Updated Successfully');
			redirect(base_url().'myprofile.html', 'refresh');			
		}
		$this->load->view($this->template, $page_data);
	} */
	
	public function logout() 
	{
        $this->session->sess_destroy();
        redirect(base_url().'home.html', 'refresh');
    }
	
	#Employee_Mailexist
	public function EmailExist()
	{
		if ( isset($_POST['email_check']) && $_POST['email_check'] == 1) 
		{
			$email = $_POST['email'];
			$register_type = 2;
			
			$results = $this->db->query("select user_id from users WHERE email='".$email."' and register_type='".$register_type."' ")->result_array(); #and register_type='".$register_type."'
			if ( count($results) > 0 ) {
				echo "taken";	
			}else{
				echo 'not_taken';
			}
			exit();
		}
	}
	
	#Mobile Exist
	public function MobileExist()
	{
		if ( isset($_POST['mob_check']) && $_POST['mob_check'] == 1) 
		{
			$mobile_number = $_POST['mobile_number'];
			
			$register_type = 2;
			
			$qry = "select user_id from users 
				WHERE 
					mobile_number='".$mobile_number."' and 
						register_type='".$register_type."' ";
			
			$results = $this->db->query($qry)->result_array(); #and register_type='".$register_type."'
			
			
			if ( count($results) > 0 ) 
			{
				echo "taken";	
			}
			else
			{
				echo 'not_taken';
			}
		}
		exit();
	}
	
	#Mobile Exist check in edit profile
	public function MobileExistProfile()
	{
		if ( isset($_POST['mob_check']) && $_POST['mob_check'] == 1) 
		{
			$mobile_number = $_POST['mobile_number'];
			
			$register_type = 2;
			
			$qry = "select user_id from users 
				WHERE 
					user_id !='".$this->UserID."' and 
					mobile_number='".$mobile_number."' and 
						register_type='".$register_type."' ";
			
			$results = $this->db->query($qry)->result_array(); #and register_type='".$register_type."'
			
			if ( count($results) > 0 ) 
			{
				echo "taken";	
			}
			else
			{
				echo 'not_taken';
			}
		}
		exit();
	}
	
	#Employee_Mailexist
	public function EmailExistProfile()
	{
		if ( isset($_POST['email_check']) && $_POST['email_check'] == 1) 
		{
			$email = $_POST['email'];
			$register_type = 2;
			
			$results = $this->db->query("select user_id from users 
				WHERE 
					user_id !='".$this->UserID."' and 
						email='".$email."' and 
							register_type='".$register_type."' 
				
				")->result_array(); #and register_type='".$register_type."'
			if ( count($results) > 0 ) {
				echo "taken";	
			}else{
				echo 'not_taken';
			}
			exit();
		}
	}

	# Ajax  Change
	public function ajaxselectState() 
	{
        $id = $_POST["id"];		
		if($id)
		{			
			$data =  $this->db->query("select state.* from state
					left join country on country.country_id = state.state_id
					where state.country_id='".$id."' order by state.state_name asc
					")->result_array();
		
			if( count($data) > 0)
			{
				echo '<option value="">- Select State -</option>';
				foreach($data as $val)
				{
					echo '<option value="'.$val['state_id'].'">'.ucfirst($val['state_name']).'</option>';
				}
			}
			else
			{
				echo '<option value="">No states under this country!</option>';
			}
		}
		die;
    }
	
	# Ajax Select cities under State
	public function ajaxSelectCity() 
	{
        $id = $_POST["id"];		
		if($id)
		{			
			$data =  $this->db->query("select city.city_id,city.city_name from city
					left join state on state.state_id = city.state_id
					where city.state_id='".$id."' order by city.city_name asc
					")->result_array();
		
			if( count($data) > 0)
			{
				echo '<option value="">- Select City -</option>';
				foreach($data as $val)
				{
					echo '<option value="'.$val['city_id'].'">'.ucfirst($val['city_name']).'</option>';
				}
			}
			else
			{
				echo '<option value="">No cities under this state!</option>';
			}
		}
		die;
    }
	
	#Facebook Login
	public function facebook()
	{ 
		if (!empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		#$user_referral_id = $this->session->get("User_Referral_ID");
		#$fb_access_token = $this->session->get("fb_access_token"); 
		
		require(APPPATH.'third_party/facebook_login/config.php');
		require(APPPATH.'third_party/facebook_login/storeData.php');
	
		$user = $facebook->getUser();
		$loginUrl = $facebook->getLoginUrl(['scope'=>'public_profile']);
		
		if(empty($this->UserID))
		{
			redirect($loginUrl);
		}
		else
		{
			?><script>window.close();</script><?php
		}
	}
	
	public function facebookCallback($code="",$state="")
	{ 
		$_SESSION["FB_CODE"] = $code;
		$_SESSION["FB_status"] = $state;
		
		#$redirect_url = "https://www.vasanta.jespersoft.com/";
		$redirect_url = base_url();
		
		if($code)
		{
			$token_url = "https://graph.facebook.com/oauth/access_token?client_id=".FB_APP_ID."&redirect_uri=".$redirect_url."&client_secret=".FB_APP_SECRET."&code=".$code;
			$access_token = $this->curl_function($token_url);
			
			$_SESSION["ACCESS_TOKEN"] = $access_token;
			
			#$FBtoken = str_replace("access_token=","", $access_token);
			#$FBtoken = explode("&expires=", $FBtoken);
		
			$faceBookToken = isset(json_decode($access_token)->access_token) ? json_decode($access_token)->access_token : "";
		   
			if(!empty($faceBookToken))
			{
				$profile_data_url = "https://graph.facebook.com/me?access_token=".$faceBookToken;
				$Profile_data = json_decode($this->curl_function($profile_data_url));
					
				if(isset($Profile_data->error))
				{
					$this->session->set_flashdata('error_message' , 'Problem in Facebook Connect. Try again later.');
					redirect(base_url()."sign-in.html", 'refresh');
				}
				else
				{
					$status = $this->webusers_model->register_facebook_user($Profile_data, $faceBookToken);
					
					if($status == 1)
					{
						$this->session->set_flashdata('success_message' , "Signup successfully!");
						redirect(base_url(), 'refresh');
					}
				}
			}
			else
			{
				$this->session->set_flashdata('error_message' , 'Problem in Facebook Connect. Try again later!.');
				redirect(base_url()."sign-in.html", 'refresh');
			}
			?><script>window.close();</script><?php
		}
		else
		{ 
			redirect("https://www.facebook.com/dialog/oauth?client_id=".FB_APP_ID."&redirect_uri=".urlencode($redirect_url)."&scope=email,read_stream,publish_stream,offline_access&display=popup");
			die();
		}
	}
	
	private function curl_function($req_url = "" , $type = "", $arguments =  array())
	{
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $req_url);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_TIMEOUT, 100);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		if($type == "POST"){
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $arguments);
		}

		$result = curl_exec($ch);
		curl_close ($ch);
		return $result;
	}
	
	
	#Google Login
	public function googleLogin()
	{ 
		if (!empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		include_once(APPPATH.'libraries/vendor/autoload.php');
		
		$google_client = new Google_client();
		$google_client->setClientId(GOOGLE_CLIENT_ID);
		$google_client->setClientSecret(GOOGLE_SECRET_KEY);
		$redirectUrl = base_url()."web_users/googleCallback";
		$google_client->setRedirectUri($redirectUrl);
		$google_client->addScope('email');
		$google_client->addScope('profile');
		
		if(empty($this->UserID))
		{
			redirect($google_client->createAuthUrl());
		}
	}
	
	#Google Login
	public function googleCallback()
	{ 
		include_once(APPPATH.'libraries/vendor/autoload.php');
		
		$google_client = new Google_client();
		$google_client->setClientId(GOOGLE_CLIENT_ID);
		$google_client->setClientSecret(GOOGLE_SECRET_KEY);
		$redirectUrl = base_url()."web_users/googleCallback";
		$google_client->setRedirectUri($redirectUrl);
		$google_client->addScope('email');
		$google_client->addScope('profile');
		
		if(isset($_GET['code']))
		{
		    $token = $google_client->fetchAccessTokenWithAuthCode($_GET['code']);
			
			if(!isset($token['error']))
			{
			    $google_client->setAccessToken($token['access_token']);
				$this->session->set_userdata('access_token',$token['access_token']);
				
				$google_service = new Google_Service_Oauth2($google_client);
				
				$data = $google_service->userinfo->get();
				
				$chkAlready = $this->webusers_model->register_google_user($data);
				
				if($chkAlready)
				{
					$this->session->set_flashdata('success_message' , 'Successfully loggedin!');
					redirect(base_url(), 'refresh');
				}
			}
			else
			{
			    $this->session->set_flashdata('error_message' , 'Problem in google Connect. Try again later.');
				redirect(base_url()."sign-in.html", 'refresh');
			}
		}
		else
		{
			$this->session->set_flashdata('error_message' , 'Problem in google Connect. Try again later.');
			redirect(base_url()."sign-in.html", 'refresh');
		}
	}
	
	#My Orders
	public function myOrders()
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		$page_data['page_name']  = 'web_users/myOrders';
		$page_data['page_title'] = SITE_NAME.' | Order History';
		
		$page_data["totalRows"] = $totalRows = $this->webusers_model->getOrderHistoryCount();
		$limit = 10;
		$base_url = base_url()."my-orders.html";
		
		$config = Pagination($base_url,$totalRows,$limit);
		$this->pagination->initialize($config);
		$str_links = $this->pagination->create_links();
		$page_data['pagination'] = explode('&nbsp;', $str_links);
		$offset = 0;
		if (!empty($_GET['per_page'])) {
			$pageNo = $_GET['per_page'];
			$offset = ($pageNo - 1) * $limit;
		}
		
		if($offset == 1 || $offset== "" || $offset== 0){
			$page_data["first_item"] = 1;
		}else{
			$page_data["first_item"] = $offset + 1;
		}
		
		$page_data['resultData']  = $result = $this->webusers_model->getOrderHistory($limit, $offset);
		
		#show start and ending Count
		$total_counts = $total_count= 0;
		$pages=$page_data["starting"] = $page_data["ending"]="";
		$pageno = isset($pageNo) ? $pageNo :"";
		
		if( $totalRows == 0 ){
			$page_data["starting"] = 0;
		}else if( $pageno==1 || $pageno=="" ){
			$page_data["starting"] = 1;
		}else{
			$pages = $pageno-1;
			$total_count = $pages * $config["per_page"];
			$page_data["starting"] = ( $config["per_page"] * $pages )+1;
		}
		
		$total_counts = $total_count + count($result);
		$page_data["ending"]  = $total_counts;
		#show start and ending Count end
				
		$this->load->view($this->template, $page_data);
	}
	
	#My Orders
	public function myOrderDetails()
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$page_data['page_name']  = 'web_users/myOrderDetails';
		$page_data['page_title'] = 'My Orders Details';
		
		$page_data['view_data'] = $this->db->query("
					select 
					users.email,
					users.user_id,
					users.first_name,
					users.last_name,
					users.mobile_number,
					users.joined_date,
					users.address1,
					users.address2,
					country.country_name,
					state.state_name,
					city.city_name,
					users.user_status,
					users.login_type
					
					from users 
					left join country on country.country_id = users.country_id
					left join state on state.state_id = users.state_id
					left join city on city.city_id = users.city_id
					where users.user_id ='".$this->UserID."' 
					")->result_array();
					
		$this->load->view($this->template, $page_data);
	}
	
	#Favourite Unfavourite
	public function AjaxFavourite()
	{
		$order_id 	= $_POST["order_id"];		
		$user_id 	= $this->UserID;		

		$data['order_id'] = $order_id ;
		$data['user_id']  = $user_id;
		
		if ($_POST['add_remove'] == 'remove') 
		{
			$this->db->where('order_id', $order_id);
			$this->db->delete('vb_favourite_orders');
		}
		else
		{
			if($order_id)
			{			
				$chkFav = 'select order_id from vb_favourite_orders where order_id = '.$order_id;
				$result = $this->db->query($chkFav)->result_array();

				if (count($result) != 1 ) 
				{
					$this->db->insert('vb_favourite_orders', $data);
				}
			}	
		}
	}

	function bookmark()
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}

		if(isset($_POST['cartBtn']) && !empty($_POST["quantity"]))
		{
			$_SESSION['category_id'] = $_POST["category_id"];
			$_SESSION['branch_id'] = $_POST["branch_id"];
			
			$productByCode = $this->db->query("SELECT product_id,product_code,product_name FROM products WHERE product_id='" . $_POST['product_id'] . "'")->result_array();
			
			$itemArray = array(
				$productByCode[0]["product_code"] =>
				array(
					'product_name' => $productByCode[0]["product_name"], 
					'product_code' => $productByCode[0]["product_code"], 
					'quantity'     => $_POST["quantity"], 
					'price'        => $_POST["p_price"],
					'product_id'   => $_POST["product_id"],
					'category_id'  => $_POST["category_id"],
					'branch_id'    => $_POST["branch_id"],
				)
			);
			
			if(!empty($_SESSION["cart_item"])) 
			{	
				#if(in_array($productByCode[0]["product_code"],$_SESSION["cart_item"])) 
				if(is_array($_SESSION["cart_item"])) 
				{
					foreach($_SESSION["cart_item"] as $k => $v) 
					{
						if($productByCode[0]["product_code"] == $k)
						{	
							$_SESSION["cart_item"][$k]["quantity"] = $_POST["quantity"];
						}
						else
						{
							$_SESSION["cart_item"] = $_SESSION["cart_item"]+$itemArray;
						}
					}
				} 
				else
				{
					$_SESSION["cart_item"] = $_SESSION["cart_item"]+$itemArray;
				}
			} 
			else 
			{	
				$_SESSION["cart_item"] = $itemArray;
			}
			redirect(base_url() . 'checkout.html', 'refresh');

		}

		$page_data['page_name']  = 'web_users/bookMark';
		$page_data['page_title'] = SITE_NAME.' | Bookmark';
		
		$page_data["totalRows"] = $totalRows = $this->webusers_model->getBookmarkCount();
		$limit = 10;
		$base_url = base_url()."bookmark.html";
		
		$config = Pagination($base_url,$totalRows,$limit);
		$this->pagination->initialize($config);
		$str_links = $this->pagination->create_links();
		$page_data['pagination'] = explode('&nbsp;', $str_links);
		$offset = 0;
		if (!empty($_GET['per_page'])) {
			$pageNo = $_GET['per_page'];
			$offset = ($pageNo - 1) * $limit;
		}
		
		if($offset == 1 || $offset== "" || $offset== 0){
			$page_data["first_item"] = 1;
		}else{
			$page_data["first_item"] = $offset + 1;
		}
		
		$page_data['resultData']  = $result = $this->webusers_model->getBookmark($limit, $offset);
		
		#show start and ending Count
		$total_counts = $total_count= 0;
		$pages=$page_data["starting"] = $page_data["ending"]="";
		$pageno = isset($pageNo) ? $pageNo :"";
		
		if( $totalRows == 0 ){
			$page_data["starting"] = 0;
		}else if( $pageno==1 || $pageno=="" ){
			$page_data["starting"] = 1;
		}else{
			$pages = $pageno-1;
			$total_count = $pages * $config["per_page"];
			$page_data["starting"] = ( $config["per_page"] * $pages )+1;
		}
		
		$total_counts = $total_count + count($result);
		$page_data["ending"]  = $total_counts;
		#show start and ending Count end
		// print_r($page_data);exit;
		$this->load->view($this->template, $page_data);
	}

	function Ajaxbookmark()
	{
		$branch_id 		= $_POST["branch_id"];	
		$product_id 	= $_POST["product_id"];
		$user_id 		= $this->UserID;		

		$data['branch_id'] 	= $branch_id ;
		$data['product_id'] = $product_id ;
		$data['user_id']  	= $user_id;
		
		if ($_POST['add_remove'] == 'remove') 
		{
			$this->db->where('branch_id', $branch_id);
			$this->db->where('product_id', $product_id);
			$this->db->where('user_id', $user_id);
			$this->db->delete('vb_bookmark_items');
		}
		else
		{
			if($product_id)
			{			
				$chkFav = 'select product_id from vb_bookmark_items where (branch_id = '.$branch_id.' and product_id = '.$product_id.' and user_id = '.$user_id.')';

				$result = $this->db->query($chkFav)->result_array();

				if (count($result) != 1 ) 
				{
					$this->db->insert('vb_bookmark_items', $data);
				}
			}	
		}
	}

	function Ajaxremovebookmark()
	{
		$bookmark_id 	= $_POST['bookmark_id'];
		$user_id 		= $this->UserID;
		
		$this->db->where('bookmark_id', $bookmark_id);
		$this->db->where('user_id', $user_id);
		$this->db->delete('vb_bookmark_items');

	}
	
	function wallet()
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$page_data['page_name']  = 'web_users/wallet';
		$page_data['page_title'] = SITE_NAME.' | Wallet';
		
		$this->load->view($this->template, $page_data);
	}
	

	public function feedback()
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$page_data['page_title'] = SITE_NAME.' | Feedback'; #Page Title
		$page_data['page_name']  = "web_users/feedback"; #View Page
		
		$page_data['view_data'] = $this->db->query("
			select 
			users.first_name,
			users.email,
			users.mobile_number

			from users
			
			where users.user_id ='".$this->UserID."'
			")->result_array();
			
		if($_POST)
		{
			
			$data['first_name'] = $this->input->post('first_name');
			$data['email'] = $this->input->post('email');
			$data['phone_number'] = $this->input->post('phone_number');
			$data['branch_id'] = $this->input->post('branch_id');
			$data['message'] = $this->input->post('message');
			$data['created_date'] = time();

			$this->db->insert('feedback', $data);
			$id = $this->db->insert_id();
			
			if($id !="")
			{
				#Email sent start here
				$page_data['feedback'] =1;
				
				$to = CONTACT_EMAIL;
				$from = $data['email'];
				$subject = "Feedback";
				$page_data['cname'] = $fromName = $data['first_name']; 
				$page_data['message'] = $data['message'];	 
				
				$message = $this->load->view('mail_template/front_mail_template', $page_data, true);
				
				#echo $message;exit;
				if(EMAIL_TYPE == 2) #SMTP
				{
					$sendMail = Send_SMTP($from,$to,$subject,$message,$fromName);
				}
				else  #Send Grid 
				{
					$sendMail = Send_Grid($from,$to,$subject,$message,$fromName);
				}
				#Email sent end here
			}
			
			//$this->session->sess_destroy();
			
			$this->session->set_flashdata('success_message' , 'Thank you for contact!! Our Team will get back to you soon...');
			redirect(base_url(), 'refresh');
		}
		$this->load->view($this->template, $page_data);
	}

	function terms_conditions()
    {
        // if (empty($this->UserID))
        // {
		// 	redirect(base_url().'terms-and-conditions.html', 'refresh');
		// }
		
		$page_data['page_name']  = 'web_users/terms_conditions';
		$page_data['page_title'] = 'Terms and Conditions';
		
		$this->load->view($this->template, $page_data);
    }

	function privacy_policy()
    {
        // if (empty($this->UserID))
        // {
		// 	redirect(base_url().'terms-and-conditions.html', 'refresh');
		// }
		
		$page_data['page_name']  = 'web_users/privacy_policy';
		$page_data['page_title'] = 'Privacy Policu';
		
		redirect(base_url() . 'terms-and-conditions.html', 'refresh');
    }


	function cards($type = '', $id = '', $status = '')
    {
		#print_r($this->UserID);exit;
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
	
		$page_data['type'] = $type;
		$page_data['id'] = $id;
		
		//$page_data['manage_settings'] = $page_data['Setups'] = 1;
		
		$page_data['page_name']  = 'web_users/cards';
		$page_data['page_title'] = 'Manage Cards';
		
		switch($type)
		{
			case "add": #add
		
				if($_POST)
				{
					$data['card_holder_name'] = $_POST['card_holder_name'];
					$data['card_number'] = base64_encode($_POST['card_number']);
					$data['expiry_month'] = $_POST['expiry_month'];
					$data['expiry_year'] = $_POST['expiry_year'];
					$data['cvv'] = $_POST['cvv'];
					$data['user_id'] = $this->UserID;
					
					# Card Number exist start here
					$chkExistCardnum = $this->db->query("select card_id from vb_saved_cards
						where 
							card_number='".$data['card_number']."'
							")->result_array();
							
					if(count($chkExistCardnum) > 0)
					{
						$this->session->set_flashdata('error_message' , " Card Number already exist!");
						redirect(base_url() . 'cards.html/add', 'refresh');
					}
					# Card Number exist end here

					$this->db->insert('vb_saved_cards', $data);				
					$id = $this->db->insert_id();
					
					if($id !="")
					{	
						$this->session->set_flashdata('flash_message' , "Card added Successfully!");
						redirect(base_url() . 'cards.html', 'refresh');
					}
				}
			break;
			
			case "edit": #edit
				$page_data['edit_data'] = $this->db->get_where('vb_saved_cards', array('card_id' => $id))
										->result_array();
				if($_POST)
				{
					$data['card_holder_name'] = $_POST['card_holder_name'];
					$data['card_number'] = base64_encode($_POST['card_number']);
					$data['expiry_month'] = $_POST['expiry_month'];
					$data['expiry_year'] = $_POST['expiry_year'];
					$data['cvv'] = $_POST['cvv'];
					
					$this->db->where('card_id', $id);
					$this->db->where('user_id', $this->UserID);
					$result = $this->db->update('vb_saved_cards', $data);
					
					if($result)
					{
						
						$this->session->set_flashdata('flash_message' , "Card updated Successfully!");
						redirect(base_url() . 'cards.html', 'refresh');
					}
				}
			break;
			
			case "delete": #Delete
				$this->db->where('card_id', $id);
				$this->db->delete('vb_saved_cards');
				
				$this->session->set_flashdata('flash_message' , "Card deleted successfully!");
				redirect(base_url() . 'cards.html', 'refresh');
			break;
			
			default : #Manage
				$page_data["totalRows"] = $totalRows = $this->webusers_model->getManageCardsCount();#
	
				if(!empty($_SESSION['PAGE']))
				{$limit = $_SESSION['PAGE'];
				}else{$limit = 10;}
				
				$base_url = base_url().'cards.html';
				
				$config = PaginationConfig($base_url,$totalRows,$limit);
				$this->pagination->initialize($config);
				$str_links = $this->pagination->create_links();
				$page_data['pagination'] = explode('&nbsp;', $str_links);
				$offset = 0;
				if (!empty($_GET['per_page'])) {
					$pageNo = $_GET['per_page'];
					$offset = ($pageNo - 1) * $limit;
				}
				
				if($offset == 1 || $offset== "" || $offset== 0){
					$page_data["first_item"] = 1;
				}else{
					$page_data["first_item"] = $offset + 1;
				}
				
				$page_data['resultData']  = $result= $data =$this->webusers_model->getManageCards($limit, $offset);
				
				#show start and ending Count
				$total_counts = $total_count= 0;
				$pages=$page_data["starting"] = $page_data["ending"]="";
				$pageno = isset($pageNo) ? $pageNo :"";
				
				if( $totalRows == 0 ){
					$page_data["starting"] = 0;
				}else if( $pageno==1 || $pageno=="" ){
					$page_data["starting"] = 1;
				}else{
					$pages = $pageno-1;
					$total_count = $pages * $config["per_page"];
					$page_data["starting"] = ( $config["per_page"] * $pages )+1;
				}
				
				$total_counts = $total_count + count($result);
				$page_data["ending"]  = $total_counts;
				#show start and ending Count end
			break;
		}	
		$this->load->view($this->template, $page_data);
	}

	function aadhaarUnique()
	{
		$card_no = $_POST['card_number'];
		if (isset($_POST['id']))
		{
			$query = "select card_number from vb_saved_cards where card_number = '".$card_no."' ";
			$ChkExist = $this->db->query($query)->result_array();

			if (count($ChkExist) > 0) {
				echo 'already_taken';die;
			}
			else {
				echo 'not_taken';die;
			}
		}
		else
		{
			$query = "select card_number from vb_saved_cards where card_number = '".$card_no."' ";
			$ChkExist = $this->db->query($query)->result_array();

			if (count($ChkExist) > 0) {
				echo 'already_taken';die;
			}
			else {
				echo 'not_taken';die;
			}
		}
	}
	
	public function editVerifyMobileNumber()
	{
		if (empty($this->UserID))
        {
			redirect(base_url(), 'refresh');
		}
		
		$page_data['page_name']  = 'web_users/editVerifyMobileNumber';
		$page_data['page_title'] = 'Edit Profile';
		
		$page_data['view_data'] = $this->db->query("
			select 
			users.first_name,
			users.email,
			users.address1,
			users.address2,
			users.country_id,
			users.state_id,
			users.city_id,
			users.mobile_number,
			users.otp_status,
			users.login_type

			from users
			
			left join country on country.country_id = users.country_id
			left join state on state.state_id = users.state_id
			left join city on city.city_id = users.city_id
			
			where users.user_id ='".$this->UserID."'
			")->result_array();


		if($_POST)
		{
			#General fields
			$data['mobile_number'] = $this->input->post('mobile_number');
			$data['country_id'] = $this->input->post('country_id');
			
			$country_id = $data['country_id'];
			$CountryQry ="select country_code from country where country_id='".$country_id."' ";
			$getCountryCode =$this->db->query($CountryQry)->result_array();
			$country_code = isset($getCountryCode[0]['country_code']) ? $getCountryCode[0]['country_code'] : "+971";

			$otp_number = otpNumber(6);
			$otpMobileNumber = $country_code.$data['mobile_number'];
			$otpMessage = $otp_number.' is your OTP / verification code for Mobile Number Verification. - Thank You.  '.strtoupper(SITE_NAME);
			$sendSMS = globalSMS($otpMobileNumber,$otpMessage);

			if($sendSMS == 1)
			{
				$data['otp_number'] = $otp_number;
				$_SESSION['edit_profile'] = $data;

				$this->db->where('user_id',$this->UserID);
				$this->db->update('users',array('signin_otp_number' => $otp_number));
			}
			
			$this->session->set_flashdata('success_message', 'OTP sent successfully!');
			redirect(base_url()."verify-mobile-otp.html", 'refresh');
		}
		$this->load->view($this->template, $page_data);
	}
	
	

	#Controller End here
}
	
?>
