<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	if ( ! function_exists('encode'))
	{
		function encode($string="")  #echo encode_url(98); 
		{
		   return str_replace(['+','/','='], ['-','_',''], base64_encode($string));
		}
	}
	
	if ( ! function_exists('decode'))
	{
		function decode($string="") #decode_url('OTg');
		{
		   return base64_decode(str_replace(['-','_'], ['+','/'], $string));
		}
	}
	
	if ( ! function_exists('url'))
	{
		function url($title, $separator = '-')
		{
			$separator = ($separator === '') ? '' : '-';
			$title = preg_replace ( "/&([\x{0600}-\x{06FF}a-zA-Z])(uml|acute|grave|circ|tilde|ring),/u", "", $title );
			$title = preg_replace ( "/[^\x{0600}-\x{06FF}a-zA-Z0-9_ .-]/u", "", $title );

			$title = preg_replace('/['.$separator.'\s]+/', $separator, $title);
			
			return trim(strtolower($title), $separator);
		}
	}
	
	
	if ( ! function_exists('url_1'))
	{
		function url_1($title, $separator = '_')
		{
			$separator = ($separator === '') ? '' : '_';
			$title = preg_replace ( "/&([\x{0600}-\x{06FF}a-zA-Z])(uml|acute|grave|circ|tilde|ring),/u", "", $title );
			$title = preg_replace ( "/[^\x{0600}-\x{06FF}a-zA-Z0-9_ .-]/u", "", $title );

			$title = preg_replace('/['.$separator.'\s]+/', $separator, $title);
			
			return trim(strtolower($title), $separator);
		}
	}
	
	if ( ! function_exists('read_docx'))
	{
		function read_docx($resume='')
		{
			$striped_content = '';
			$content = '';

			$zip = zip_open($resume);

			if (!$zip || is_numeric($zip)) return false;

			while ($zip_entry = zip_read($zip)) 
			{
				if (zip_entry_open($zip, $zip_entry) == FALSE) continue;
				if (zip_entry_name($zip_entry) != "word/document.xml") continue;
				$content .= zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));
				zip_entry_close($zip_entry);
			}
			zip_close($zip);
			$content = str_replace('</w:r></w:p></w:tc><w:tc>', " ", $content);
			$content = str_replace('</w:r></w:p>', "\r\n", $content);
			$striped_content = strip_tags($content);
			return $striped_content;
		}
	}
	
	if ( ! function_exists('pagination_configuration'))
	{
		function pagination_configuration($base_url, $total_rows, $per_page='50', $uri_segment='3', $num_links='4', $use_page_numbers=TRUE,$suffix) 
		{
			$config = array();
			$config["base_url"] = $base_url;
			$config["total_rows"] = $total_rows;
			$config["per_page"] = $per_page;
			$config["uri_segment"] = $uri_segment;
			$config['num_links'] = $num_links;
			$config['use_page_numbers'] = $use_page_numbers;
			$config['suffix'] = $suffix;
			
			$config['full_tag_open'] = '<ul class="dynamic_pagination">';
			$config['full_tag_close'] = '</ul>';
			
			#First Link
			$config['first_link'] = 'First';
			$config['first_tag_open'] = '<li>';
			$config['first_tag_close'] = '</li>';
			
			#Last Link
			$config['last_link'] = 'Last';
			$config['last_tag_open'] = '<li>';
			$config['last_tag_close'] = '</li>';
			
			
			#Next Link
			$config['next_link'] = 'Next';
			$config['next_tag_open'] = '<li>';
			$config['next_tag_close'] = '</li>';
			
			#Previous Link
			$config['prev_link'] = 'Prev';
			$config['prev_tag_open'] = '<li>';
			$config['prev_tag_close'] = '</li>';
			
			#Current link
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</li></a>';
			
			#Digits Link
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			return $config;
		}
	}
	
	if ( ! function_exists('randomNumAlpha'))
	{
		function randomNumAlpha($n='') 
		{ 
			$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
			$randomString = ''; 
		  
			for ($i = 0; $i < $n; $i++) { 
				$index = rand(0, strlen($characters) - 1); 
				$randomString .= $characters[$index]; 
			} 
			return $randomString; 
		}
	}
	
	if ( ! function_exists('randomNum'))
	{
		function randomNum($n='') 
		{ 
			$characters = '0123456789'; 
			$randomString = ''; 
		  
			for ($i = 0; $i < $n; $i++) { 
				$index = rand(0, strlen($characters) - 1); 
				$randomString .= $characters[$index]; 
			} 
			return $randomString; 
		}
	}
	
	if ( ! function_exists('otpNumber'))
	{
		function otpNumber($n='') 
		{ 
			$characters = '0123456789'; 
			$randomString = ''; 
		  
			for ($i = 0; $i < $n; $i++) { 
				$index = rand(0, strlen($characters) - 1); 
				$randomString .= $characters[$index]; 
			} 
			return $randomString; 
		}
	}
	
	if ( ! function_exists('PaginationConfig'))
	{
		function PaginationConfig($base_url="", $totalRows="", $limit="") 
		{
			$config = array();
			
			$config["base_url"] =$base_url;
			$config["total_rows"] = $totalRows;
			$config["per_page"] = $limit;
			$config['use_page_numbers'] = TRUE;
			$config['page_query_string'] = TRUE;
			$config['enable_query_strings'] = TRUE;
			
			$config['num_links'] = 9;
			
			$config['full_tag_open'] = '<ul class="dynamic_pagination">';
			$config['full_tag_close'] = '</ul>';
			
			#First Link
			$config['first_link'] = 'First';
			$config['first_tag_open'] = '<li>';
			$config['first_tag_close'] = '</li>';
			
			#Last Link
			$config['last_link'] = 'Last';
			$config['last_tag_open'] = '<li>';
			$config['last_tag_close'] = '</li>';
			
			#Next Link
			$config['next_link'] = 'Next';
			$config['next_tag_open'] = '<li>';
			$config['next_tag_close'] = '</li>';
			
			#Previous Link
			$config['prev_link'] = 'Prev';
			$config['prev_tag_open'] = '<li>';
			$config['prev_tag_close'] = '</li>';
			
			$config['cur_tag_open'] = '&nbsp;<li class="active"><a>';
			$config['cur_tag_close'] = '</a></li>';
			
			#Digits Link
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			
			
			///$config['next_link'] = 'Next';
			///$config['prev_link'] = 'Previous';
			return $config;
		}
	}
	
	
	if ( ! function_exists('Pagination'))
	{
		function Pagination($base_url="", $totalRows="", $limit="") 
		{
			$config = array();
			
			$config["base_url"] =$base_url;
			$config["total_rows"] = $totalRows;
			$config["per_page"] = $limit;
			$config['use_page_numbers'] = TRUE;
			$config['page_query_string'] = TRUE;
			$config['enable_query_strings'] = TRUE;
			
			$config['num_links'] = 9;
			
			/* $config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>'; */
			
			#First Link
			$config['first_link'] = 'First';
			/* $config['first_tag_open'] = '<li>';
			$config['first_tag_close'] = '</li>'; */
			
			#Last Link
			$config['last_link'] = '&raquo;';
			/* $config['last_tag_open'] = '<li>';
			$config['last_tag_close'] = '</li>'; */
			
			#Next Link
			$config['next_link'] = '&raquo;';
			/* $config['next_tag_open'] = '<li>';
			$config['next_tag_close'] = '</li>'; */
			
			#Previous Link
			$config['prev_link'] = '&laquo;';
			/* $config['prev_tag_open'] = '<li>';
			$config['prev_tag_close'] = '</li>'; */
			
			#$config['cur_tag_open'] = '&nbsp;<li class="active"><a>';
			#$config['cur_tag_close'] = '</a></li>';
			
			$config['cur_tag_open'] = '&nbsp;<a class="active">';
			$config['cur_tag_close'] = '</a>';
			
			
			#Digits Link
			/* $config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>'; */
			
			
			///$config['next_link'] = 'Next';
			///$config['prev_link'] = 'Previous';
			return $config;
		}
	}
	
	if ( ! function_exists('moneyFormat'))
	{
		function moneyFormat($num='') 
		{
			$explrestunits = "" ;
			if(strlen($num)>3) 
			{
				$lastthree = substr($num, strlen($num)-3, strlen($num));
				$restunits = substr($num, 0, strlen($num)-3); #Extracts the last three digits
				$restunits = (strlen($restunits)%2 == 1)?"0".$restunits:$restunits; #Explodes the remaining digits in 2's formats, adds a zero in the beginning to maintain the 2's grouping.
				$expunit = str_split($restunits, 2);
				for($i=0; $i<sizeof($expunit); $i++) 
				{
					if($i==0) 
					{
						$explrestunits .= (int)$expunit[$i].","; #if is first value , convert into integer
					} 
					else 
					{
						$explrestunits .= $expunit[$i].",";
					}
				}
				$thecash = $explrestunits.$lastthree;
			} 
			else 
			{
				$thecash = $num;
			}
			return $thecash; # Writes the final format where $currency is the currency symbol.
		}
	}
	
	if ( ! function_exists('timeAgo'))
	{
		function timeAgo($tm,$rcs = 0)
		{
			 $cur_tm = time(); 
			$dif = $cur_tm-$tm;
			$pds = array('second','minute','hour','day','week','month','year','decade');
			$lngh = array(1,60,3600,86400,604800,2630880,31570560,315705600);

			for($v = sizeof($lngh)-1; ($v >= 0)&&(($no = $dif/$lngh[$v])<=1); $v--); if($v < 0) $v = 0; $_tm = $cur_tm-($dif%$lngh[$v]);
				$no = floor($no);
				if($no <> 1)
					$pds[$v] .="s ago";
				$x = sprintf("%d %s ",$no,$pds[$v]);
				if(($rcs == 1)&&($v >= 1)&&(($cur_tm-$_tm) > 0))
					$x .= time_ago($_tm);
				return $x;
		}
	}
	
	if ( ! function_exists('compressImage'))
	{
		function compressImage($source="", $destination="", $quality="") 
		{
			$info = getimagesize($source);
			
			if ($info['mime'] == 'image/jpeg') 
				$image = imagecreatefromjpeg($source);
			
			else if ($info['mime'] == 'image/jpg') 
				$image = imagecreatefromgif($source);
			
			else if ($info['mime'] == 'image/gif') 
				$image = imagecreatefromgif($source);

			else if ($info['mime'] == 'image/png') 
				$image = imagecreatefrompng($source);

			imagejpeg($image, $destination, $quality);
		}
	}
	
	# Amount In Words
	if ( ! function_exists('amountInWords'))
	{
		function amountInWords($amount="") 
		{
			$amount_after_decimal = round($amount - ($num = floor($amount)), 2) * 100;
		   // Check if there is any number after decimal
		   $amt_hundred = null;
		   $count_length = strlen($num);
		   $x = 0;
		   $string = array();
		   $change_words = array(0 => '', 1 => 'One', 2 => 'Two',
			 3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
			 7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
			 10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
			 13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
			 16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
			 19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
			 40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
			 70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety');
			$here_digits = array('', 'Hundred','Thousand','Lakh', 'Crore');
			while( $x < $count_length ) {
			  $get_divider = ($x == 2) ? 10 : 100;
			  $amount = floor($num % $get_divider);
			  $num = floor($num / $get_divider);
			  $x += $get_divider == 10 ? 1 : 2;
			  if ($amount) {
			   $add_plural = (($counter = count($string)) && $amount > 9) ? 's' : null;
			   $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
			   $string [] = ($amount < 21) ? $change_words[$amount].' '. $here_digits[$counter]. $add_plural.' 
			   '.$amt_hundred:$change_words[floor($amount / 10) * 10].' '.$change_words[$amount % 10]. ' 
			   '.$here_digits[$counter].$add_plural.' '.$amt_hundred;
				}
		   else $string[] = null;
		   }
		   $implode_to_Rupees = implode('', array_reverse($string));
		   $get_paise = ($amount_after_decimal > 0) ? "And " . ($change_words[$amount_after_decimal / 10] . " 
		   " . $change_words[$amount_after_decimal % 10]) . ' Paise' : '';
		   return ($implode_to_Rupees ? $implode_to_Rupees . 'Rupees ' : '') . $get_paise;
		}
	}
	
	if ( ! function_exists('sendSMS'))
	{
		function sendSMS($phone_number="",$message="") 
		{
			$fields = array(
				"sender_id" => "FSTSMS",
				"message" => $message,
				"language" => "english",
				"route" => "t",
				"numbers" => $phone_number,
			);

			$curl = curl_init();

			curl_setopt_array($curl, array(
			  CURLOPT_URL => "https://www.fast2sms.com/dev/bulk",
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => "",
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 30,
			  CURLOPT_SSL_VERIFYHOST => 0,
			  CURLOPT_SSL_VERIFYPEER => 0,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => "POST",
			  CURLOPT_POSTFIELDS => json_encode($fields),
			  CURLOPT_HTTPHEADER => array(
				"authorization: elNIWdPL4TVuhKAGt7BnjMoEw9ZFyYU6cXx5kg2J8zHaiOs01Dn50wUgxpFkDubhRT9Ba87Ny6vlMtWr",
				"accept: */*",
				"cache-control: no-cache",
				"content-type: application/json"
			  ),
			));

			$response = curl_exec($curl);
			$err = curl_error($curl);

			curl_close($curl);

			/* if ($err) {
			  echo "cURL Error #:" . $err;
			} else {
			  echo $response;
			} */
			
			if ($err) 
			{
				return 0;
			} 
			else 
			{
				return 1;
			} 
		}
	}
	
	if ( ! function_exists('globalSMS'))
	{
		function globalSMS($mobileNumber="",$message="")
		{
			/* $curl = curl_init();
			curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode([
				'destination' => $mobileNumber,
				'message'     => $message,
				'origin'      => 'VB REG REST'
			]));
			$response = curl_exec($curl);
			$err = curl_error($curl);

			curl_close($curl);

			/* if ($err) {
			  echo "cURL Error #:" . $err;
			} else {
			  echo $response;
			} */
			
			/* if ($err) 
			{
				return 0;
			} 
			else 
			{
				return 1;
			} 
			
			exit; */

			#require_once __DIR__ . '/vendor/autoload.php';
			include_once('vendor/autoload.php');
			
			#get your REST API keys from MXT https://mxt.smsglobal.com/integrations
			\SMSGlobal\Credentials::set(SMS_API_KEY, SMS_API_SECRET);

			$sms = new \SMSGlobal\Resource\Sms();
		
			try 
			{
				
				$response = $sms->sendToOne($mobileNumber,$message,"VB VEG REST"); //AD-VBVEGRES
				#print_r($response['messages']);
				$result = 1; #Success
			} 
			catch (\Exception $e) 
			{
				#echo $e->getMessage();
				$result = 0; #Not Success
			}
			
			return $result;
		}
	}
	
	if ( ! function_exists('expenseDays'))
	{
		function expenseDays($fromDay="",$toDay="") 
		{
			$value = '';
			
			for ($i = $fromDay; $i <= $toDay; $i++)
			{
				$value .= ltrim($i, "0");
				//$value .= '"' . ltrim($i, "0") . '"' . "\t";
			}
			return $value. "\t";
		}
	}
	
	#get getGeoLatLong using address
	if ( ! function_exists('getGeoLatLong'))
	{
		function getGeoLatLong($address1="")
		{
			if($address1)
			{
			    $address = str_replace(' ', '%20', $address1);
				#send request and receive json data by latitude and longitude
				#$url = 'https://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($_POST['latitude']).','.trim($_POST['longitude']).'&key=AIzaSyAbs0hgqNa7G6Chjooy0iC_YST4kq0bCwc';
				
				$url = "https://maps.googleapis.com/maps/api/geocode/json?address=".trim($address)."&key=".GOOGLE_MAP_API_KEY."";
				
				$json = @file_get_contents($url);
				$data = @json_decode($json);
				
				$status = isset($data->status) ? $data->status :"";
				
				#if request status is successful
				if($status == "OK")
				{
				    //get Lat,lan from json data
					$latLan['address'] = $data->results[0]->formatted_address;
					
					$latLan['latitude']   = $data->results[0]->geometry->location->lat;
                    $latLan['longitude']  = $data->results[0]->geometry->location->lng;
				}
				else
				{
					$latLan['address'] = $address;
					$latLan['latitude'] = "12.745458";
					$latLan['longitude'] ="77.81027069999999";
				}
				return $latLan;
			}
		}
	}
	
	#get getGeoAddress using latitude,longitude
	if ( ! function_exists('getGeoAddress'))
	{
		function getGeoAddress($latitude="",$longitude="") 
		{
			if($latitude !="" && $longitude !="")
			{
				#send request and receive json data by latitude and longitude
				$url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=".trim($latitude).",".trim($longitude)."&key=".GOOGLE_MAP_API_KEY."";
				
				#$url = "https://maps.googleapis.com/maps/api/geocode/json?address='".trim($address)."'&key='".GOOGLE_MAP_API_KEY."'";
				
				$json = @file_get_contents($url);
				$data = @json_decode($json);
				$status = isset($data->status) ? $data->status :"";
				
				#if request status is successful
				if($status == "OK")
				{
					#get Lat,lan from json data
					$address['address']    = $data->results[0]->formatted_address;
					$address['latitude']   = $data->results[0]->geometry->location->lat;
                    $address['longitude']  = $data->results[0]->geometry->location->lng;
				}
				else
				{
					$address['address'] = "Not Available";
					$address['latitude'] = "";
					$address['longitude'] ="";
				}
				return $address;
			}
		}
	}
	
	#accessMenu
	if ( ! function_exists('accessMenu'))
	{
		function accessMenu($menu_url="")
		{
			$CI = get_instance();
			$CI->load->database();
			
			$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 1 ;
			
			$query = 'select 
				org_roles_items.menu_enabled,
				org_roles_items.create_edit_only,
				org_roles_items.read_only,
				org_roles.role_id,
				org_menus.menu_url
				
				from users 
					left join org_roles on org_roles.role_id = users.role_id
					left join org_roles_items on org_roles_items.role_id = org_roles.role_id
					left join org_menus on org_menus.menu_id = org_roles_items.menu_id
				where 
					org_menus.menu_url = "'.$menu_url.'" and
						users.user_id = "'.$user_id.'" and 
						org_menus.menu_status = 1
				';
			$result = $CI->db->query($query)->result_array();
			
			if(count($result) > 0)
			{
				foreach($result as $row)
				{
					$data['menu_enabled'] = $row['menu_enabled'];
					$data['create_edit_only'] = $row['create_edit_only'];
					$data['read_only'] = $row['read_only'];
					$data['role_id'] = $row['role_id'];
				}
			}
			else
			{
				$data['menu_enabled'] = "";
				$data['create_edit_only'] = "";
				$data['read_only'] = "";
				$data['role_id'] = "";
			}
			return $data;
		}
	}
	
	if ( ! function_exists('resizeImg'))
	{
		function resizeImg($file="", $newfile="", $newwidth="", $newheight="")
		{
			if(!is_file($file) == true)
			{
				echo 'Cannot find file, upload it again !';
				exit();
			}

			list($width, $height) = getimagesize($file);
			#prepare for creating a new image that would be the thumbnail image
			$thumb = imagecreatetruecolor($newwidth, $newheight);
			$pathinfo = pathinfo($file);

			switch(strtolower($pathinfo['extension']))
			{
				case "jpeg" || "jpg":
					$source = @imagecreatefromjpeg($file);
					@imagecopyresized($thumb, $source, 0, 0, 0, 0, floor($newwidth), floor($newheight), $width, $height);
					@imagejpeg($thumb, $newfile);
				break;

				case "png":
					$source = @imagecreatefrompng($file);
					@imagecopyresized($thumb, $source, 0, 0, 0, 0, floor($newwidth), floor($newheight), $width, $height);
					@imagepng($thumb, $newfile);
				break;

				case "gif":
					$source = @imagecreatefromgif($file);
					@imagecopyresized($thumb, $source, 0, 0, 0, 0, floor($newwidth), floor($newheight), $width, $height);
					@imagegif($thumb, $newfile);
				break;

				default:
					$newfile = 'false';
				break;
			}
			
			@imagedestroy($thumb);
			return $newfile;
		}
	}
	
	if ( ! function_exists('getCurrentAddress'))
	{
		function getCurrentAddress($latitude="",$longitude="")
		{
			if(!empty($latitude) && !empty($longitude))
			{
				//$GeoAddress = getGeoAddress($_POST['latitude'],$_POST['longitude']);
				//$location = $GeoAddress['address'];
				
				#send request and receive json data by latitude and longitude
				$url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=".trim($latitude).",".trim($longitude)."&key=".GOOGLE_MAP_API_KEY."";
				//$url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=25.1123129,55.2209081&key=".GOOGLE_MAP_API_KEY."";
				
				#$url = "https://maps.googleapis.com/maps/api/geocode/json?address='".trim($address)."'&key='".GOOGLE_MAP_API_KEY."'";
				
				$json = @file_get_contents($url);
				$data = @json_decode($json);
				$status = isset($data->status) ? $data->status :"";
				
				#if request status is successful
				if($status == "OK")
				{
					#get Lat,lan from json data
					
					$formatLocation = $address['address'] = $data->results[0]->formatted_address;
					
					/* $address_components = isset($data->results[0]->address_components) ? $data->results[0]->address_components : "";
					
					if(!empty($address_components))
					{
						foreach($address_components as $key=>$value)
						{
							if(in_array("political", $value->types) && in_array("sublocality", $value->types) && in_array("sublocality_level_1", $value->types))
							{
								$location_1 = $address['address'] = isset($value->long_name) ? $value->long_name :"Unnammed Road!";
							}
							else if($data->results[0]->formatted_address !="")
							{
								$location_2 = $address['address'] = $data->results[0]->formatted_address;
							}
						}
					}
					else
					{
						$location_3 = $address['address'] = $data->results[0]->formatted_address;
					} */
				}
				else
				{
					$formatLocation = $address['address'] = "Not Available";
				}
				
				return $formatLocation;
			}
		}
	}
	
	#getDeliveyrAddress
	if ( ! function_exists('getDeliveyrAddress'))
	{
		function getDeliveyrAddress($latitude="", $longitude="")
		{
			if(!empty($latitude) && !empty($longitude))
			{
				//$GeoAddress = getGeoAddress($_POST['latitude'],$_POST['longitude']);
				//$location = $GeoAddress['address'];
				
				#send request and receive json data by latitude and longitude
				$url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=".trim($latitude).",".trim($longitude)."&key=".GOOGLE_MAP_API_KEY."";
				//$url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=25.1123129,55.2209081&key=".GOOGLE_MAP_API_KEY."";
				
				#$url = "https://maps.googleapis.com/maps/api/geocode/json?address='".trim($address)."'&key='".GOOGLE_MAP_API_KEY."'";
				
				$json = @file_get_contents($url);
				$data = @json_decode($json);
				$status = isset($data->status) ? $data->status :"";
				
				#if request status is successful
				if($status == "OK")
				{
					#get Lat,lan from json data
					
					$formatLocation = $address['address'] = $data->results[0]->formatted_address;
					
					$address_components = isset($data->results[0]->address_components) ? $data->results[0]->address_components : "";
					
					if(!empty($address_components))
					{
						foreach($address_components as $key=>$value)
						{
							if(in_array("political", $value->types) && in_array("sublocality", $value->types) && in_array("sublocality_level_1", $value->types))
							{
								$location_1 = $address['address'] = isset($value->long_name) ? $value->long_name :"Unnammed Road!";
							}
							else if($data->results[0]->formatted_address !="")
							{
								$location_2 = $address['address'] = $data->results[0]->formatted_address;
							}
						}
					}
					else
					{
						$location_3 = $address['address'] = $data->results[0]->formatted_address;
					}
				}
				else
				{
					$location_3 = $address['address'] = "Not Available";
				}
				
				if(!empty($location_1))
				{
					$location = $location_1;
				}
				else if(!empty($location_2))
				{
					$location = $location_2;
				}
				else if(!empty($location_3))
				{
					$location = $location_3;
				}
				else
				{
					$location = isset($formatLocation) ? $formatLocation :"";
				}
				return $location;
			}
		}
	}
	
	#getDeliveyrAddress
	if ( ! function_exists('getDeliveyrZoneBranches'))
	{
		function getDeliveyrZoneBranches($latitude="", $longitude="")
		{
			if(!empty($latitude) && !empty($longitude))
			{
				//$GeoAddress = getGeoAddress($_POST['latitude'],$_POST['longitude']);
				//$location = $GeoAddress['address'];
				
				#send request and receive json data by latitude and longitude
				$url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=".trim($latitude).",".trim($longitude)."&key=".GOOGLE_MAP_API_KEY."";
				//$url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=25.1123129,55.2209081&key=".GOOGLE_MAP_API_KEY."";
				
				#$url = "https://maps.googleapis.com/maps/api/geocode/json?address='".trim($address)."'&key='".GOOGLE_MAP_API_KEY."'";
				
				$json = @file_get_contents($url);
				$data = @json_decode($json);
				$status = isset($data->status) ? $data->status :"";
				
				#if request status is successful
				if($status == "OK")
				{
					#get Lat,lan from json data
					
					$formatLocation = $address['address'] = $data->results[0]->formatted_address;
					
					$address_components = isset($data->results[0]->address_components) ? $data->results[0]->address_components : "";
					
					if(!empty($address_components))
					{
						foreach($address_components as $key=>$value)
						{
							if(in_array("political", $value->types) && in_array("sublocality", $value->types) && in_array("sublocality_level_1", $value->types))
							{
								$location_1 = $address['address'] = isset($value->long_name) ? $value->long_name :"Unnammed Road!";
							}
							else if($data->results[0]->formatted_address !="")
							{
								$location_2 = $address['address'] = $data->results[0]->formatted_address;
							}
							
							if(in_array("political", $value->types) && in_array("neighborhood", $value->types))
							{
								$location_11 = $address['address'] = isset($value->long_name) ? $value->long_name :"Unnammed Road!";
							}
						}
					}
					else
					{
						$location_3 = $address['address'] = $data->results[0]->formatted_address;
						$location_31 = $address['address'] = $data->results[0]->formatted_address;
					}
				}
				else
				{
					$location_31 = $address['address'] = "Not Available";
				}
				if(!empty($location_1))
				{
					$location = $location_1;
				}
				else if(!empty($location_2))
				{
					$location = $location_2;
				}
				else if(!empty($location_3))
				{
					$location = $location_3;
				}
				else
				{
					$location = isset($formatLocation) ? $formatLocation :"";
				}
				
				
				if(!empty($location_11))
				{
					$location_1 = $location_11;
				}
				
				else if(!empty($location_31))
				{
					$location_1 = $location_31;
				}
				else
				{
					$location_1 = "";
				}
				
				
				
				return $location.'@'.$location_1;
			}
		}
	}
	
	#getDeliveyrAddress loop
	if ( ! function_exists('getBranchByZones'))
	{
		function getBranchByZones($latitude="", $longitude="")
		{
			if(!empty($latitude) && !empty($longitude))
			{
				//$GeoAddress = getGeoAddress($_POST['latitude'],$_POST['longitude']);
				//$location = $GeoAddress['address'];
				
				#send request and receive json data by latitude and longitude
				$url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=".trim($latitude).",".trim($longitude)."&key=".GOOGLE_MAP_API_KEY."";
				//$url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=25.1123129,55.2209081&key=".GOOGLE_MAP_API_KEY."";
				
				#$url = "https://maps.googleapis.com/maps/api/geocode/json?address='".trim($address)."'&key='".GOOGLE_MAP_API_KEY."'";
				
				$json = @file_get_contents($url);
				$data = @json_decode($json);
				$status = isset($data->status) ? $data->status :"";
				
				#if request status is successful
				if($status == "OK")
				{
					#get Lat,lan from json data
					
					$formatLocation = $address['address'] = $data->results[0]->formatted_address;
					
					$address_components = isset($data->results[0]->address_components) ? $data->results[0]->address_components : "";
					
					if(!empty($address_components))
					{
						$locality='';
						foreach($address_components as $key => $value)
						{
							if(
								in_array("country", $value->types) && 
								in_array("political", $value->types)
							)
							{
								
							}
							/* else if(
								in_array("administrative_area_level_1", $value->types) && 
								in_array("political", $value->types)
							)
							{
								
							} */
							else if(
								in_array("administrative_area_level_2", $value->types) && 
								in_array("political", $value->types)
							)
							{
								
							}
							else if(
								in_array("locality", $value->types) && 
								in_array("political", $value->types)
							)
							{
								
							}
							else if(
								in_array("postal_code", $value->types)
							)
							{
								
							}
							else if(isset($value->long_name))
							{
								$locality .=$value->long_name .",";
							}
								
							//print_r(array_flip($value->types));
							
							//$location_1 = $address['address'] = isset($value->long_name) ? $value->long_name :"Unnammed Road!";
							
							/* if(
								(
									in_array("political", $value->types) || 
									in_array("sublocality", $value->types) ||
									in_array("sublocality_level_1", $value->types)
								) &&
								
								(
									in_array("neighborhood", $value->types) || 
									in_array("political", $value->types)
								) &&
								
								(
									in_array("administrative_area_level_1", $value->types) || 
									in_array("political", $value->types)
								)
							)
							{
								echo  $value->long_name .",";
							} */
							/*{ 
								if(isset($value->long_name))
								{
									$location_1 =  $value->long_name .",";
								}
								//echo $location_1;
							/* }
							else if($data->results[0]->formatted_address !="")
							{
								$location_2 =  $address['address'] = $data->results[0]->formatted_address;
							} */
						}
					}
					/* else
					{
						$location_3 = $address['address'] = $data->results[0]->formatted_address;
					} */
				}
				else
				{
					$locality = "Not Available";
				}
				
				return $locality;
				
				//echo $location_1;
				/*if(!empty($location_1))
				{
					$location = $location_1;
				}
				else if(!empty($location_2))
				{
					$location = $location_2;
				}
				else if(!empty($location_3))
				{
					$location = $location_3;
				}
				else
				{
					$location = isset($formatLocation) ? $formatLocation :"";
				}
				
				return $location; */
			}
		}
	}