<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Customer_model  extends CI_Model 
{
	function __construct()
    {
        parent::__construct();
		$this->load->library('session');
    }

	function getManageCustomerCount()
	{
		if($this->user_id==1) #Admin
		{
			$condition = " 1=1 and customer.register_type =2"; #2=> Customer
		
			$joinQuery ="";
			$groupby = "";
		}
		else #Branch Admins
		{
			$condition = " 1=1 and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			
			$joinQuery ="
				join vb_order_header on 
					vb_order_header.user_id = customer.user_id
				
				join branch on 
					branch.branch_id = vb_order_header.branch_id 
					
				join users as branch_users on 
					branch_users.branch_id = vb_order_header.branch_id 
			
			";
			$groupby = "group by vb_order_header.user_id";
		}
		
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								customer.first_name like "%'.($_GET['keywords']).'%" or 
								customer.mobile_number like "%'.($_GET['keywords']).'%" or 
								customer.gst_number like "%'.($_GET['keywords']).'%" or 
								customer.pan_number like "%'.($_GET['keywords']).'%"
							)
							';
		}
		
		
		$query = "select 
					customer.user_id
					
		from users as customer
		left join country on 
			country.country_id = customer.country_id
		$joinQuery
		where $condition $groupby";
		$result = $this->db->query($query)->result_array();
		return count($result);
	}
	
	function getManageCustomer($offset="",$record="")
	{
		if($this->user_id==1) #Admin
		{
			$condition = " 1=1 and customer.register_type =2"; #2=> Customer
		
			$joinQuery ="";
			$groupby = "";
		}
		else #Branch Admins
		{
			$condition = " 1=1 and 
				branch_users.user_id='".$this->user_id."' and 
				branch_users.branch_id='".$this->admin_branch_id."'
			";
			$groupby = "group by vb_order_header.user_id";
			$joinQuery ="
				join vb_order_header on 
					vb_order_header.user_id = customer.user_id
				
				join branch on 
					branch.branch_id = vb_order_header.branch_id 
					
				join users as branch_users on 
					branch_users.branch_id = vb_order_header.branch_id 
			";
		}
		
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								customer.first_name like "%'.($_GET['keywords']).'%" or 
								customer.mobile_number like "%'.($_GET['keywords']).'%" or 
								customer.gst_number like "%'.($_GET['keywords']).'%" or 
								customer.pan_number like "%'.($_GET['keywords']).'%"
							)
							';
		}
		
		$query = "select 
					customer.user_id,
					customer.user_status,
					customer.first_name,
					customer.mobile_number,
					customer.email,
					customer.address1,
					customer.gst_number,
					customer.pan_number,
					customer.joined_date,
					customer.login_type,
					customer.otp_status,
					country.country_code

					
		from users as customer
		left join country on 
			country.country_id = customer.country_id
		$joinQuery
		
		where $condition $groupby 
			order by customer.user_id desc 
				limit ".$record." , ".$offset."
		";
		
		$result = $this->db->query($query)->result_array();
		
		return $result;
	}

	function customerOrderHistoryCount($id="")
	{
		$condition = ' vb_order_header.user_id="'.$id.'" ';
		
		$query = "select vb_order_header.order_id from vb_order_header where $condition";
		
		$result = $this->db->query($query)->result_array();
		
		return count($result);
	}

	function customerOrderHistory($id="",$limit="", $offset="")
	{
		$condition = ' vb_order_header.user_id="'.$id.'" ';
		
		$query = "select 
				vb_order_header.*,
				branch.branch_name,
				branch.location,
				branch.address
				from vb_order_header
				
			left join branch on 
				branch.branch_id = vb_order_header.branch_id
			
			where $condition order by vb_order_header.order_id desc";
		
		$result = $this->db->query($query)->result_array();
		
		return $result;
	}
	
	function getManageAddressCount($id="")
	{
		$condition = " 1=1 and vb_customer_address.customer_address_id='".$id."' ";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								vb_customer_address.customer_address_id like "%'.($_GET['keywords']).'%" 
							)
							';
		}
		
		$query = "select vb_customer_address.customer_address_id from vb_customer_address
		where $condition";
		
		$result = $this->db->query($query)->result_array();
		return count($result);
	}
	
	
	function getManageAddress($offset="",$record="",$id=" ")
	{
		$condition = " 1=1 and vb_customer_address.customer_address_id='".$id."' ";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								vb_customer_address.pin_code like "%'.($_GET['keywords']).'%" 
							)
							';
		}
		
		$query = "select vb_customer_address.* ,
		users.user_id,
		users.first_name,
		users.email,
		users.mobile_number
		
		from vb_customer_address
		left join users on users.user_id = vb_customer_address.user_id
		where $condition
				order by vb_customer_address.customer_address_id desc
					limit ".$record." , ".$offset."
		";
		
		$result = $this->db->query($query)->result_array();
		return $result;
	}
	
	function getManageBookmarkCount($id="")
	{
		$condition = " 1=1 and vb_bookmark_items.bookmark_id='".$id."' ";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								vb_bookmark_items.bookmark_id like "%'.($_GET['keywords']).'%" )
							';
		}
		
		$query = "select vb_bookmark_items.bookmark_id from vb_bookmark_items
		where $condition";
		
		$result = $this->db->query($query)->result_array();
		return count($result);
	}
	
	
	function getManageBookmark($offset="",$record="",$id=" ")
	{
		$condition = " 1=1";
		
		$query = "select vb_bookmark_items.*,
		users.user_id,
		users.first_name,
		users.email,
		users.mobile_number
		
		from vb_bookmark_items
		left join users on users.user_id = vb_bookmark_items.user_id
		where $condition
				order by vb_bookmark_items.bookmark_id desc
					limit ".$record." , ".$offset."
		";
		
		$result = $this->db->query($query)->result_array();
		return $result;
	}

	function getBookmarkCount($user_id)
	{
		$condition = ' vb_bookmark_items.user_id="'.$user_id.'" ';
		
		$query = "select 
				vb_bookmark_items.user_id

				from vb_bookmark_items
			
		where $condition ";
					
		$result = $this->db->query($query)->result_array();
		return count($result);
	}

	function getBookmark($offset="",$record="",$user_id)
	{
		$condition = ' ';

		$ItemQuery = "select
							vb_branch_items_line.*,
							branch.branch_id,
							branch.branch_name,
							products.product_name,
							vb_bookmark_items.user_id,
							users.first_name,
							users.mobile_number,
							users.email

							from vb_bookmark_items 
							
							left join vb_branch_items_line on 
								vb_branch_items_line.product_id = vb_bookmark_items.product_id

							left join vb_branch_items_header on 
								vb_branch_items_header.branch_item_header_id = vb_branch_items_line.branch_item_header_id
							
							left join products on 
								products.product_id = vb_branch_items_line.product_id
							
							left join branch on 
								branch.branch_id = vb_branch_items_header.branch_id
													
							left join users on
								users.user_id = vb_bookmark_items.user_id
							where vb_bookmark_items.user_id = ".$user_id." and vb_branch_items_header.branch_id = vb_bookmark_items.branch_id order by vb_bookmark_items.bookmark_id desc ";

		$result = $this->db->query($ItemQuery)->result_array();
		return $result;

	}

	function walletCount($user_id)
	{
		$query = 'select wallet_id from vb_customer_wallet where vb_customer_wallet.user_id = '.$user_id;

		$result = $this->db->query($query)->result_array();

		return count($result);
	}

	function wallet($walletUserID="")
	{
		// print_r($user_id);
		$query = 'select vb_customer_wallet.wallet_amount,
						branch.branch_name						
						
						from vb_customer_wallet 
						
						left join branch on
							branch.branch_id = vb_customer_wallet.branch_id

						where  vb_customer_wallet.user_id = '.$user_id;

		$result = $this->db->query($query)->result_array();

		return $result;
	}
	
	function getOrdersCount($user_id)
	{
		$query = 'select vb_order_header.order_id from vb_order_header where vb_order_header.user_id = '.$user_id;

		$result = $this->db->query($query)->result_array(); 
		return count($result);
	}

	function getOrdersHistory($limit="", $offset="",$id="")
	{
		$query = 'select 
					vb_order_header.order_number,
					vb_order_header.grand_total,
					vb_order_header.created_date,
					vb_order_header.order_status,
					branch.branch_name
					
					from vb_order_header 

					left join branch on branch.branch_id = vb_order_header.branch_id

					where vb_order_header.user_id = '.$id.' limit 10 offset '.$offset;

		$result = $this->db->query($query)->result_array(); 

		return $result;
	}

	function getFavouriteOrdersCount($id)
	{
		$condition = ' vb_favourite_orders.user_id="'.$id.'" ';
		
		$query = "select 
				vb_favourite_orders.order_id
				from vb_favourite_orders

			left join vb_order_header on 
				vb_order_header.order_id = vb_favourite_orders.order_id
			left join branch on 
				branch.branch_id = vb_order_header.branch_id
			
		where $condition ";
					
		$result = $this->db->query($query)->result_array();
		return count($result);
	}

	function getFavouriteOrders($limit="",$offset="",$id)
	{
		$condition = ' vb_favourite_orders.user_id="'.$id.'" ';
		
		$query = "select 
					vb_order_header.*,
					branch.branch_name,
					branch.location,
					branch.address

				from vb_favourite_orders
			
			left join vb_order_header on 
				vb_order_header.order_id = vb_favourite_orders.order_id
			left join branch on 
				branch.branch_id = vb_order_header.branch_id
			
		where $condition 
			order by vb_favourite_orders.order_id desc
			
			limit $limit offset  $offset";

		$result = $this->db->query($query)->result_array();
		return $result;
	}
}
