<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Products_model extends CI_Model 
{
	function __construct()
    {
        parent::__construct();
		$this->load->library('session');
    }

	function getProductsCount()
	{
		$condition = " 1=1";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								products.product_name like "%'.($_GET['keywords']).'%" or 
								products.product_code like "%'.($_GET['keywords']).'%" or
								branch.branch_name like "%'.($_GET['keywords']).'%"
							)
							';
		}
		
		if(!empty($_GET['category_id']))
		{
			$condition .= ' and products.category_id='.$_GET['category_id'];
		}
		if(!empty($_GET['branch_id']))
		{
			$condition .= ' and products.branch_id='.$_GET['branch_id'];
		}
		
		$query = "select products.product_id from products
		left join category on category.category_id = products.category_id
		left join branch on branch.branch_id = products.branch_id
		left join vb_item_days on vb_item_days.item_day_id = products.item_day_id
		left join vb_item_timings on vb_item_timings.item_time_id = products.item_time_id
		
		where $condition";
		$result = $this->db->query($query)->result_array();
		return count($result);
	}
	
	function getProducts($offset="",$record="")
	{
		$condition = " 1=1";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								products.product_name like "%'.($_GET['keywords']).'%" or 
								products.product_code like "%'.($_GET['keywords']).'%" or
								branch.branch_name like "%'.($_GET['keywords']).'%"
							)
							';
		}
		
		if(!empty($_GET['category_id']))
		{
			$condition .= ' and products.category_id='.$_GET['category_id'];
		}
		if(!empty($_GET['branch_id']))
		{
			$condition .= ' and products.branch_id='.$_GET['branch_id'];
		}
		
		$query = "select 
			products.product_id,
			products.product_name,
			products.product_code,
			products.price,
			products.product_image,
			
			products.product_status,
			
			category.category_name, 
			category.category_id,
			branch.branch_name,
			vb_item_days.item_days,
			vb_item_timings.item_from_time,
			vb_item_timings.item_to_time
			from products
		left join category on category.category_id = products.category_id
		left join branch on branch.branch_id = products.branch_id
		left join vb_item_days on vb_item_days.item_day_id = products.item_day_id
		left join vb_item_timings on vb_item_timings.item_time_id = products.item_time_id
		
		where $condition
				order by products.product_id desc
					limit ".$record." , ".$offset."
		";
		
		$result = $this->db->query($query)->result_array();
		return $result;
	}
	
	
	function getProductsTypeCount()
	{
		$condition = " 1=1";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								inv_product_types.product_type like "%'.($_GET['keywords']).'%" or 
								inv_product_types.product_type_description like "%'.($_GET['keywords']).'%"
							)
							';
		}
		
		$query = "select inv_product_types.product_type_id from inv_product_types
		where $condition";
		$result = $this->db->query($query)->result_array();
		return count($result);
	}
	
	function getProductsTypes($offset="",$record="")
	{
		$condition = " 1=1";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								inv_product_types.product_type like "%'.($_GET['keywords']).'%" or 
								inv_product_types.product_type_description like "%'.($_GET['keywords']).'%"
							)
							';
		}
		
		$query = "select inv_product_types.* from inv_product_types
		where $condition
				order by inv_product_types.product_type_id desc
					limit ".$record." , ".$offset."
		";
		
		$result = $this->db->query($query)->result_array();
		return $result;
	}
	
	function getProductsCostingCount()
	{
		$condition = " 1=1";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								products.product_name like "%'.($_GET['keywords']).'%" or 
								inv_product_costing.product_cost like "%'.($_GET['keywords']).'%"
							)
							';
		}
		
		$query = "select inv_product_costing.product_costing_id from inv_product_costing
		left join products on products.product_id = inv_product_costing.product_id
		where $condition";
		$result = $this->db->query($query)->result_array();
		return count($result);
	}
	
	function getProductsCosting($offset="",$record="")
	{
		$condition = " 1=1";
		if(!empty($_GET['keywords']))
		{	
			$condition .= ' and (
								products.product_name like "%'.($_GET['keywords']).'%" or 
								inv_product_costing.product_cost like "%'.($_GET['keywords']).'%"
							)
							';
		}
		
		$query = "select inv_product_costing.*,products.product_name from inv_product_costing
		
		left join products on products.product_id = inv_product_costing.product_id
		where $condition
				order by inv_product_costing.product_costing_id desc
					limit ".$record." , ".$offset."
		";
		
		$result = $this->db->query($query)->result_array();
		return $result;
	}
	
	function getProductsCopyCostCount()
	{
		if($_GET)
		{
			$condition = " 1=1";
			if(!empty($_GET['keywords']))
			{
				$condition .= ' and (
									products.product_name like "%'.($_GET['keywords']).'%" or 
									inv_product_costing.product_cost like "%'.($_GET['keywords']).'%"
								)
								';
			}
			
			$query = "select inv_product_costing.product_costing_id from inv_product_costing
			left join products on products.product_id = inv_product_costing.product_id
			where $condition";
			$result = $this->db->query($query)->result_array();
			return count($result);
		}
		else
		{
			return 0;
		}
	}
	
	function getProductsCopyCost($offset="",$record="")
	{
		if($_GET)
		{
			$condition = " 1=1";
			if(!empty($_GET['keywords']))
			{	
				$condition .= ' and (
									products.product_name like "%'.($_GET['keywords']).'%" or 
									inv_product_costing.product_cost like "%'.($_GET['keywords']).'%"
								)
								';
			}
			
			$query = "select inv_product_costing.*,products.product_name from inv_product_costing
			
			left join products on products.product_id = inv_product_costing.product_id
			where $condition
					order by inv_product_costing.product_costing_id desc
						limit ".$record." , ".$offset."
			";
			
			$result = $this->db->query($query)->result_array();
			return $result;
		}
		else
		{
			return array();
		}
	}
	
	function getItemDaysCount()
	{
		$condition = " 1=1";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								vb_item_days.item_days like "%'.($_GET['keywords']).'%" 
							)
							';
		}
		
		$query = "select 
				vb_item_days.item_day_id,
				vb_item_days.item_days,
				vb_item_days.item_day_status
				from vb_item_days

		where $condition";
		$result = $this->db->query($query)->result_array();
		return count($result);
	}
	
	function getItemDays($offset="",$record="")
	{
		$condition = " 1=1";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								vb_item_days.item_days like "%'.($_GET['keywords']).'%" 
							)
							';
		}
			
		$query = "select 
			vb_item_days.item_day_id,
			vb_item_days.item_days,
			vb_item_days.item_day_status
			from vb_item_days
		where $condition
				order by vb_item_days.item_day_id desc
					limit ".$record." , ".$offset."
		";
		
		$result = $this->db->query($query)->result_array();
		return $result;
	}

	function getItemTimingsCount()
	{
		$condition = " 1=1";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								vb_item_timings.item_from_time like "%'.($_GET['keywords']).'%" or
								vb_item_timings.item_to_time like "%'.($_GET['keywords']).'%"
							)
							';
		}

		$query = "select 
				vb_item_timings.item_time_id,
				vb_item_timings.item_from_time,
				vb_item_timings.item_to_time,
				vb_item_timings.item_time_status
				from vb_item_timings

		where $condition";
		$result = $this->db->query($query)->result_array();
		return count($result);
	}
	
	function getItemTimings($offset="",$record="")
	{
		$condition = " 1=1";
		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
								vb_item_timings.item_from_time like "%'.($_GET['keywords']).'%" or
								vb_item_timings.item_to_time like "%'.($_GET['keywords']).'%"
							)
							';
		}

		$query = "select 
			vb_item_timings.item_time_id,
			vb_item_timings.item_from_time,
			vb_item_timings.item_to_time,
			vb_item_timings.item_time_status
			from vb_item_timings

		where $condition
				order by vb_item_timings.item_time_id desc
					limit ".$record." , ".$offset."
		";
		
		$result = $this->db->query($query)->result_array();

		return $result;
	}


	function getProductsIngredientsCount($product_id="")
	{
		$condition = " 1=1 and product_id=".$product_id." ";

		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
				vb_product_ingredients.ingredient_name like "%'.($_GET['keywords']).'%" or 
				vb_product_ingredients.ingredients_description like "%'.($_GET['keywords']).'%")
			';
		}
		
		$query = "select ingredient_id from vb_product_ingredients
		
		where $condition ";

		$result = $this->db->query($query)->result_array();
		return count($result);
	}
	
	function getProductsIngredients($offset="",$record="",$product_id="")
	{
		$condition = " 1=1 and product_id=".$product_id." ";

		if(!empty($_GET['keywords']))
		{
			$condition .= ' and (
				vb_product_ingredients.ingredient_name like "%'.($_GET['keywords']).'%" or 
				vb_product_ingredients.ingredients_description like "%'.($_GET['keywords']).'%")
			';
		}
		
		$query = "select * from vb_product_ingredients
		
		where $condition
				order by vb_product_ingredients.ingredient_id desc
					limit ".$record." , ".$offset."
		";
		
		$result = $this->db->query($query)->result_array();
		return $result;
	}
	
}
