<?php
	$settingsMenu = accessMenu(settings);
?>
<div class="page-header page-header-light">
	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="<?php echo base_url();?>admin/dashboard" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Home</a>
				<a href="<?php echo base_url(); ?>admin/manage_banner" class="breadcrumb-item">
					<?php echo $page_title;?>
				</a>
			</div>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>
		<?php
			if(isset($type) && $type == "add" || $type == "edit")
			{ 
				?>
				<div class="text-right new-import-btn">
					<a href="<?php echo base_url(); ?>admin/manage_banner" class="btn btn-warning">
					<i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Back
					</a>
				</div>
				<?php
			}
			else
			{ 
				?>
				<div class="text-right new-import-btn">
					<a href="<?php echo base_url(); ?>admin/manage_banner/add" class="btn btn-info">
						Add Banner
					</a>
				</div>
				<?php 
			} 
		?>
	</div>
</div>
<!-- Page header end-->

<div class="content"><!-- Content start-->
	<div class="card"><!-- Card start-->
		<div class="card-body">
		<?php
			if(isset($type) && $type == "add" || $type == "edit")
			{
				?>
				<fieldset class="mt-2">
					<legend class="text-uppercase font-size-sm font-weight-bold">
						<?php echo ucfirst($type);?> Banner
					</legend>
				</fieldset>
					
				<form action="" class="form-validate-jquery" enctype="multipart/form-data" method="post">
					<div class="form-group row">
						<label class="col-form-label col-lg-3"><?php echo get_phrase('banner_title');?> <span class="text-danger">*</span></label>
						<div class="col-lg-4">
							<input type="text" name="banner_title" class="form-control" required value="<?php echo isset($edit_data[0]['banner_title'])?$edit_data[0]['banner_title']:"";?>" placeholder="">
						</div>
					</div>
					
					<div class="form-group row">
						<label class="col-form-label col-lg-3">Food Category </label>
						<?php
							$query = 'select category_id,category_name,category_url from category where category_status = 1';

							$category = $this->db->query($query)->result_array();
						?>
						<div class="col-lg-4">
							<select name="category_id" id="" class="searchDropdown form-control">
								<option value=""> - Select Category - </option>
								<?php 
									foreach ($category as $value ) 
									{
										$selected = "";
										if (isset($edit_data[0]['category_id']) && $edit_data[0]['category_id'] == $value['category_id'] ) {
											$selected = "selected";
										}
										?>
											<option <?php echo $selected ?> value="<?php echo $value['category_id'] ?>"><?php echo $value['category_name'] ?></option>
										<?php 
									}
								?>
							</select>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-form-label col-lg-3">Banner URL </label>
						<div class="col-lg-4">
							<input type="url" name="banner_url" class="form-control" value="<?php echo isset($edit_data[0]['banner_url'])?$edit_data[0]['banner_url']:"";?>" placeholder="">
						</div>
					</div>
					
					<div class="form-group row">
						<label class="col-form-label col-lg-3">Banner Link Name </label>
						<div class="col-lg-4">
							<input type="text" name="banner_link_name" class="form-control" value="<?php echo isset($edit_data[0]['banner_link_name'])?$edit_data[0]['banner_link_name']:"";?>" placeholder="">
						</div>
					</div>
					
					<div class="form-group row">
						<label class="col-form-label col-lg-3">Banner Description</label>
						<div class="col-lg-4">
							<textarea name="banner_description" class="form-control"><?php echo isset($edit_data[0]['banner_description'])?$edit_data[0]['banner_description']:"";?></textarea>
						</div>
					</div>
					
					<div class="form-group row">
						<label class="col-form-label col-lg-3"><?php echo get_phrase('banner_image');?></label>
						<div class="col-lg-4">
							<input type="file" name="banner_image" class="form-control">
							<?php 
								if($type == "edit")
								{
									if (file_exists('uploads/banner/'.$edit_data[0]['banner_id'].'.png'))
									{
										?><br>
										<img src="<?php echo base_url()."uploads/banner/".$edit_data[0]['banner_id'].'.png';?>" width="100" height="60" alt=""> 
										<?php
									}
								}
							?>
						</div>
					</div>
					
					<div class="d-flexad text-right">
						<a href="<?php echo base_url(); ?>admin/manage_banner" class="btn btn-outline-dark waves-effect ">Cancel</a>
						<?php 
							if($type == "edit")
							{
								?>
								<button type="submit" class="btn btn-info waves-effect ml-2 ">Update</button>
								<?php 
							}
							else
							{
								?>
								<button type="submit" class="btn btn-info waves-effect ml-2">Submit</button>
								<?php 
							}
						?>
					</div>
					
				</form>
				<?php
			}
			else
			{
				?>
				<fieldset class="mt-2">
					<legend class="text-uppercase font-size-sm font-weight-bold">
						Manage Banner
					</legend>
				</fieldset>
				
				<form action="" method="get">
					<div class="row">
						<div class="col-md-3">	
							<input type="search" autocomplete="off" class="form-control" name="keywords" value="<?php echo !empty($_GET['keywords']) ? $_GET['keywords'] :""; ?>" placeholder="Search...">
							<p class="search-note">Note : Banner Title</p>
						</div>	
						<div class="col-md-3">
							<button type="submit" class="btn btn-info waves-effect">Search <i class="fa fa-search" aria-hidden="true"></i></button>
						</div>
					</div>
					
					<div class="row">
						<div class="col-md-8"></div>
						<div class="col-md-4 text-right">
							<?php 
								$redirect_url = substr($_SERVER['REQUEST_URI'],'1');
							?>
							<input type="hidden" id="redirect_url" value="<?php echo $redirect_url; ?>"/>
													
							<div class="filter_page">
								<label>
									<span>Show :</span> 
									<select name="filter" onchange="location.href='<?php echo base_url(); ?>admin/sort_itemper_page/'+$(this).val()+'?redirect=<?php echo $redirect_url; ?>'">
										<?php 
											$pageLimit = $_SESSION['PAGE'];
											foreach($this->items_per_page as $key => $value)
											{
												$selected="";
												if($key == $pageLimit){
													$selected="selected=selected";
												}
												?>
												<option value="<?php echo $key; ?>" <?php echo $selected;?>><?php echo $value; ?></option>
												<?php 
											} 
										?>
									</select>
								</label>
							</div>
						</div>
					</div>
				</form>
				<form method="post">
					<div class="table-scroll">
						<table class="table --table-striped table-hover table-bordered dt-responsive-sureshchanges nowrap" cellspacing="0" width="100%">
							<thead>
								<tr>
									<th class="text-center">Controls</th>
									<th>Banner Title</th>
									<th>Redirect URL</th>
									<th class="text-center">Banner Image</th>
									<th style="text-align:center;">Status</th>
									<th class="text-center">Default Banner</th>
								</tr>
							</thead>
							<tbody>
								<?php 	
									$i=0; 
									$firstItem = $first_item;
									foreach($banner as $row)
									{
										?>
										<tr>
											<!--<td align="center"><?php echo $i + $firstItem ;?></td>
											-->
											
											<td style="width: 12%;" class="text-center">
												<div class="dropdown" style="display: inline-block;padding-right: 10px!important;width:92px;">
													<button type="button" class="btn btn-outline-primary gropdown-toggle waves-effect waves-light" data-toggle="dropdown" aria-expanded="false">
														Action <i class="fa fa-angle-down"></i>
													</button>
													<ul class="dropdown-menu dropdown-menu-right">
														<li>
															<?php											
																if($settingsMenu['create_edit_only'] == 1 || $this->user_id == 1)
																{
																	?>
																	<a title="Edit" href="<?php echo base_url(); ?>admin/manage_banner/edit/<?php echo $row['banner_id'];?>">	
																		<i class="fa fa-edit"></i> Edit
																	</a>
																	<?php 
																} 
															?>
														</li>
														
														<li>
															<?php 
																if($row['banner_status'] == 1)
																{
																	?>
																	<a class="unblock" href="<?php echo base_url(); ?>admin/manage_banner/status/<?php echo $row['banner_id'];?>/0" title="Inactive">
																		<i class="fa fa-ban"></i> Inactive
																	</a>
																	<?php 
																} 
																else
																{  ?>
																	<a class="block" href="<?php echo base_url(); ?>admin/manage_banner/status/<?php echo $row['banner_id'];?>/1" title="Active">
																		<i class="fa fa-ban"></i> Active
																	</a>
																	<?php 
																} 
															?>
														<li>
														
														<!--
														<li>
															<a href="<?php echo base_url(); ?>roles/viewRoleDetails/<?php echo $row['role_id'];?>">
																<i class="fa fa-eye"></i> View
															</a>
														</li>-->
													</ul>
												</div>
											</td>
											
											<?php
											/* <td class="text-center">
												<a title="Edit" href="<?php echo base_url(); ?>admin/manage_banner/edit/<?php echo $row['banner_id'];?>">
													<i class="icon-pencil4"></i>
												</a> &nbsp;|&nbsp;
												<?php 
													if($row['banner_status'] == 1)
													{
														?>
														<a style="color:#4cec49;" href="<?php echo base_url(); ?>admin/manage_banner/status/<?php echo $row['banner_id'];?>/0" title="Block">
															<i class="icon-blocked"></i>
														</a> &nbsp; |&nbsp;
														<?php 
													} 
													else
													{  ?>
														<a class="block" href="<?php echo base_url(); ?>admin/manage_banner/status/<?php echo $row['banner_id'];?>/1" title="Unblock">
															<i class="icon-blocked"></i>
														</a> &nbsp; |&nbsp;
														<?php 
													} 
												?>
												<a href="<?php echo base_url();?>admin/manage_banner/delete/<?php echo $row['banner_id'];?>" title="Delete" onclick="return confirm('Are you sure you want to delete?')">
													<i class="icon-trash"></i>
												</a>
											</td> */ ?>
											
											<td><?php echo ucfirst($row['banner_title']);?></td>
											<td><?php echo $row['banner_url'];?></td>
											
											<td class="text-center">
												<?php
													if (file_exists('uploads/banner/'.$row['banner_id'].'.png'))
													 {
														?><br>
														<img src="<?php echo base_url()."uploads/banner/".$row['banner_id'].'.png';?>" width="100" height="60" alt=""> 
														<?php
													 }
													 else
													 {
														?>
														<br>
														<img src="<?php echo base_url()."uploads/no-image.png";?>" width="100" height="90" alt=""> 
														<?php 
													} 
												?>
											</td>
											
											<td style="text-align:center;">
												<?php 
													if($row['banner_status'] == 1)
													{
														?>
														<span class="btn btn-outline-success" title="Active"><i class="fa fa-check"></i> Active</span>
														<?php 
													} 
													else
													{ 
														?>
														<span class="btn btn-outline-warning" title="Inactive"><i class="fa fa-close"></i> Inactive</span>
														<?php 
													} 
												?>
											</td>
											
											<td class="text-center">
												<input type="radio" name="default_banner" <?php if($row['default_banner'] == 1){?>checked<?php }?> value="<?php echo $row['banner_id']; ?>"/>
											</td>
										</tr>
										<?php 
										$i++;
									}
								?>
								
								<tr>
									<td colspan="5"></td>
									
									<td class="text-center">
										<input type="submit" name="default_bannerddd" class="btn btn-info" value="Update">
									</td>
								</tr>
								
							</tbody>
						</table>
					</div>
					
					<div class="row">
						<div class="col-md-4 showing-count">
							Showing <?php echo $starting;?> to <?php echo $ending;?> of <?php echo $totalRows;?> entries
						</div>
						<!-- pagination start here -->
						<?php 
							if( isset($pagination) )
							{
								?>	
								<div class="col-md-8" class="admin_pagination" style="float:right;padding: 0px 20px 0px 0px;"><?php foreach ($pagination as $link){echo $link;} ?></div>
								<?php
							}
						?>
						<!-- pagination end here -->
					</div>
					
				</form>
				<?php 
			} 
		?>
	</div><!-- Card end-->
	</div><!-- Card end-->
</div><!-- Content end-->

