<style>
	.switch {
		position: relative;
		display: inline-block;
		width: 79px;
		height: 25px;
	}
	.switch input {display:none;}

	.slider {
		position: absolute;
		cursor: pointer;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background-color: #f51658;
		-webkit-transition: .4s;
		transition: .4s;
		border-radius: 34px;
	}

	.slider:before {
		position: absolute;
		content: "";
		height: 15px;
		width: 15px;
		left: 5px;
		bottom: 5px;
		background-color: white;
		-webkit-transition: .4s;
		transition: .4s;
		border-radius: 50%;
	}

	input:checked + .slider {
		background-color: #2ab934;
	}

	input:focus + .slider {
		box-shadow: 0 0 1px #2196F3;
	}

	input:checked + .slider:before {
		-webkit-transform: translateX(26px);
		-ms-transform: translateX(26px);
		transform: translateX(55px);
	}

	/*------ ADDED CSS ---------*/
	.slider:after
	{
		content:'OFF';
		color: white;
		display: block;
		position: absolute;
		transform: translate(-50%,-50%);
		top: 50%;
		left: 50%;
		font-size: 8px;
		font-family: Verdana, sans-serif;
	}

	input:checked + .slider:after
	{  
		content:'ON';
	}

</style>
<div class="page-header page-header-light">
	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="<?php echo base_url();?>admin/dashboard" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Home</a>
				<a href="<?php echo base_url(); ?>products/ManageProducts" class="breadcrumb-item">
					<?php echo $page_title;?>
				</a>
			</div>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>
		<?php
			if(isset($type) && $type == "add" || $type == "edit" || $type == "ingredients")
			{ 
				?>
				<div class="text-right new-import-btn">
					<a href="<?php echo base_url(); ?>products/ManageProducts" class="btn btn-warning">
					<i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Back
					</a>
				</div>
				<?php
			}
			else
			{ 
				?>
				<div class="text-right new-import-btn">
					<a href="#" data-toggle="modal" data-target="#importcountryCSV" title="Import" class="btn btn-warning">
						Import
					</a>
					<a href="<?php echo base_url(); ?>products/ManageProducts/add" class="btn btn-info">
						Add Item
					</a>
				</div>
				<?php 
			} 
		?>
	</div>
</div>
<!-- Page header end-->


<!-- Import csv start -->
<div class="modal fade" id="importcountryCSV" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
	<div class="modal-content">
	  <div class="modal-header" style="background: #1a4363;color: #fff;">
		<h5 class="modal-title" id="exampleModalLabel">Import Items</h5>
		<button type="button" class="close" data-dismiss="modal" aria-label="Close">
		  <span aria-hidden="true">&times;</span>
		</button>
	  </div>
	   <form action="<?php echo base_url(); ?>products/ManageProducts/import" enctype="multipart/form-data" method="post">
			<div class="modal-body">
				<div class="row">
					<div class="col-md-12">
						<div class="well well-small">
							<span style="color:red; font-size:16px;">Note : The first line in downloaded csv file should remain as it is. Please do not change the order of columns and Update valid data to CSV..</span><br>
							<a href="<?php echo base_url(); ?>assets/upload_sample_products.csv" class="btn btn-info btn-flat pull-right" title="Download Sample File"><i class="fa fa-download"></i> Download</a>
							<br/><br/><br/>The correct column order is <span class="text-info">(Item Code, Item Name, Description.)</span> &nbsp; &amp; You must follow this.
						</div>
					</div>
				</div>
				<br>
				<div class="row">
					<div class="form-group col-md-10">
						<label class="col-form-label">Upload File</label>
						<input type="file" name="csv"  id="chooseFile" class="form-control singleDocument" onchange="return validateSingleDocumentExtension(this)" required />
						<span style="color:#a0a0a0;font-style: italic;">Note : Upload format CSV and upload size is 5 mb.</span>
					</div>
				</div>
			
				<script>
					/** Single Document Type & Size Validation **/
					function validateSingleDocumentExtension(fld) 
					{
						var fileUpload = fld;
						
						if (typeof (fileUpload.files) != "undefined")
						{
							var size = parseFloat( fileUpload.files[0].size / 1024 ).toFixed(2);
							var validSize = 1024 * 5; //1024 - 1Mb multiply 4mb
							
							//var validSize = 500; 
							
							if( size > validSize )
							{
								//alert("Document upload size is 4 MB");
								alert("File size should not exceed 5 MB.");
								$('.singleDocument').val('');
								var value = 1;
								return false;
							}
							else if(!/(\.csv)$/i.test(fld.value))
							//else if(!/(\.pdf)$/i.test(fld.value))
							{
								alert("Invalid document file type.");      
								$('.singleDocument').val('');
								return false;   
							}
							
							if(value != 1)	
								return true; 
						}
					}
				</script>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
				<button type="submit" class="btn btn-primary ml-3">Import</button>
			</div>
		</form>
	</div>
  </div>
</div>
<!-- Import csv end -->

<div class="content"><!-- Content start-->
	<div class="card"><!-- Card start-->
		<div class="card-body">
			<?php
				if(isset($type) && $type == "add" || $type == "edit")
				{
					?>
					<fieldset class="mt-2">
						<legend class="text-uppercase font-size-sm font-weight-bold">
							<?php echo $type;?> Item
						</legend>
					</fieldset>
					
					<form action="" class="form-validate-jquery" enctype="multipart/form-data" method="post">
						<div class="row">
							<div class="form-group col-md-3">
								<label class="col-form-label">Items Code <span class="text-danger">*</span></label>
								<input type="text" name="product_code" <?php echo $this->validation;?> required class="form-control" value="<?php echo isset($edit_data[0]['product_code']) ? $edit_data[0]['product_code'] :"";?>" placeholder="">
							</div>
							<div class="form-group col-md-3">
								<label class="col-form-label">Items Name <span class="text-danger">*</span></label>
								<input type="text" name="product_name" <?php echo $this->validation;?> required class="form-control" value="<?php echo isset($edit_data[0]['product_name']) ? $edit_data[0]['product_name'] :"";?>" placeholder="">
							</div>
							<div class="form-group col-md-3">
								<label class="col-form-label">
									Items Days
									<?php 
										/* $longdate = time();
										$dayname = date('D', strtotime($longdate));
										echo $dayname; */
									?>
								</label>
								<?php $getItemsDays = $this->db->query("select item_days,item_day_id from vb_item_days where item_day_status=1")->result_array(); ?>
								<select name="item_day_id[]" multiple class="form-control searchDropdown">
									<option value="">- Select Items Day -</option>
									<?php 
										foreach($this->ItemsDays as $key => $value)
										{
											/* $selected="";
											if( isset($edit_data[0]['item_day_id']) && ($edit_data[0]['item_day_id'] == $key) )
											{
												$selected="selected='selected'";
											} */
											$selected="";
											if(	isset($edit_data[0]['item_day_id']) )
											{
												$explodeBrand = explode(",",$edit_data[0]['item_day_id']);
												foreach($explodeBrand as $key1 => $value1)
												{
													if($key == $value1)
													{
														$selected="selected='selected'";
													}
												}
											}
											?>
											<option value="<?php echo $key; ?>" <?php echo $selected;?>><?php echo $value; ?></option>
											<?php 
										} 
									?>
								</select>
							</div>
							<?php
							/* <div class="form-group col-md-3">
								<label class="col-form-label">Cost Price <span class="text-danger">*</span></label>
								<input type="text" name="cost" <?php echo $this->validation;?> required class="form-control mobile_vali" value="<?php echo isset($edit_data[0]['cost']) ? $edit_data[0]['cost'] :"";?>" placeholder="">
							</div>
							
							<div class="form-group col-md-3">
								<label class="col-form-label">Price (<?php echo CURRENCY_CODE;?>) <span class="text-danger">*</span></label>
								<input type="text" name="price" <?php echo $this->validation;?> required class="form-control mobile_vali" value="<?php echo isset($edit_data[0]['price']) ? $edit_data[0]['price'] :"0";?>" placeholder="">
							</div> */ ?>
							
							<input type="hidden" name="price" value="0">
						</div>
						
						<div class="row">
							<div class="form-group col-md-3">
								<label class="col-form-label">Category <span class="text-danger">*</span></label>
								<?php $getCategory = $this->db->query("select category_name,category_id from category where category_status=1 and main_category_id =0 order by category_name asc")->result_array(); ?>
								<select name="category_id" onchange="selectSubCategory(this.value);" required class="form-control searchDropdown">
									<option value="">- Select Category -</option>
									<?php 
										foreach($getCategory as $category)
										{
											$selected="";
											if(isset($edit_data[0]['category_id']) && ($edit_data[0]['category_id'] == $category['category_id']) )
											{
												$selected="selected='selected'";
											}
											?>
											<option value="<?php echo $category['category_id']; ?>" <?php echo $selected;?>><?php echo $category['category_name']; ?></option>
											<?php 
										} 
									?>
								</select>
							</div>
							<div class="form-group col-md-3">
								<label class="col-form-label">Sub Category </label>
								<?php 
									if( isset($edit_data[0]['category_id']) && !empty($edit_data[0]['category_id']) )
									{
										$getsubCategory = $this->db->query("select category_name,category_id from category where category_status=1 and main_category_id = '".$edit_data[0]['category_id']."' order by category_name asc")->result_array(); 
									}
								?>
								<select name="subcategory_id" id="subcategory_id" class="form-control searchDropdown">
									<option value="">- Select Sub Category -</option>
									<?php
										if( isset($edit_data[0]['category_id']) && !empty($edit_data[0]['category_id']) )
										{										
											foreach($getsubCategory as $category)
											{
												$selected="";
												if(isset($edit_data[0]['subcategory_id']) && ($edit_data[0]['subcategory_id'] == $category['category_id']) )
												{
													$selected="selected='selected'";
												}
												?>
												<option value="<?php echo $category['category_id']; ?>" <?php echo $selected;?>><?php echo $category['category_name']; ?></option>
												<?php 
											} 
										} 
									?>
								</select>
							</div>
							
							<?php $get_tax = $this->db->query("select tax_name, tax_id from tax where tax_status=1")->result_array(); ?>
							<div class="form-group col-md-3">
								<label class="col-form-label">Item Tax </label>
								<select name="tax_id" class="form-control searchDropdown">
									<option value="">- Select Tax -</option>
									<?php 
										foreach($get_tax as $row)
										{
											$selected="";
											if(isset($edit_data[0]['tax_id']) && ($edit_data[0]['tax_id'] == $row['tax_id']) )
											{
												$selected="selected='selected'";
											}
											?>
											<option value="<?php echo $row['tax_id']; ?>" <?php echo $selected;?>><?php echo $row['tax_name']; ?></option>
											<?php 
										} 
									?>
								</select>
							</div>
							<input type="hidden" name="item_time_id" value="0">
							
							<?php /* <div class="form-group col-md-3">
								<label class="col-form-label">Items Timing</label>
								<?php $getItemsTiming = $this->db->query("select item_time_id,item_from_time,item_to_time from vb_item_timings where item_time_status=1")->result_array(); ?>
								<select name="item_time_id" class="form-control searchDropdown">
									<option value="">- Select Timing -</option>
									<?php 
										foreach($getItemsTiming as $category)
										{
											$selected="";
											if(isset($edit_data[0]['item_time_id']) && ($edit_data[0]['item_time_id'] == $category['item_time_id']) )
											{
												$selected="selected='selected'";
											}
											?>
											<option value="<?php echo $category['item_time_id']; ?>" <?php echo $selected;?>><?php echo $category['item_from_time']; ?> <?php if(!empty($category['item_to_time'])){?>- <?php echo $category['item_to_time']; ?><?php } ?></option>
											<?php 
										} 
									?>
								</select>
							</div> */ ?>
							
							<script>
								function selectSubCategory(val)
								{
								   if(val !='')
								   {
										$.ajax({
										  type: "POST",
										  url:"<?php echo base_url().'admin/ajaxSubCategory';?>",
										  data: { id: val }
										}).done(function( msg ) {   
											$( "#subcategory_id").html(msg);
										});
									}
									else 
									{ 
										alert("No sub category under this category!");
									}
								}
							</script>
							
							
							
							<?php
							/* <div class="form-group col-md-3">
								<label class="col-form-label">Branch <span class="text-danger">*</span></label>
								<?php $getbranch = $this->db->query("select * from branch where branch_status=1")->result_array(); ?>
								<select name="branch_id" required class="form-control searchDropdown">
									<option value="">- Select Branch -</option>
									<?php 
										foreach($getbranch as $row)
										{
											$selected="";
											if(isset($edit_data[0]['branch_id']) && ($edit_data[0]['branch_id'] == $row['branch_id']) )
											{
												$selected="selected='selected'";
											}
											?>
											<option value="<?php echo $row['branch_id']; ?>" <?php echo $selected;?>><?php echo ucfirst($row['branch_name']); ?></option>
											<?php 
										} 
									?>
								</select>
							</div>
							<?php
								$getHsnCodes = $this->db->query("select hsn_code,hsn_code_id from inv_hsn_codes 
									where 
										hsn_code_status=1 order by hsn_code asc")->result_array(); 
							?>		
							<div class="form-group col-md-3">
								<label class="col-form-label">HSN Code </label>
								<select name="hsn_sac_code" class="form-control searchDropdown">
									<option value="">- Select HSN Code -</option>
									<?php 
										foreach($getHsnCodes as $row)
										{
											$selected="";
											if(isset($edit_data[0]['hsn_sac_code']) && ($edit_data[0]['hsn_sac_code'] == $row['hsn_code_id']) )
											{
												$selected="selected='selected'";
											}
											?>
											<option value="<?php echo $row['hsn_code_id']; ?>" <?php echo $selected;?>><?php echo $row['hsn_code']; ?></option>
											<?php 
										} 
									?>
								</select>
							</div>
							<div class="form-group col-md-3">
								<label class="col-form-label">Alert Quantity </label>
								<input type="text" name="alert_quantity" <?php echo $this->validation;?> class="form-control mobile_vali" value="<?php echo isset($edit_data[0]['alert_quantity']) ? $edit_data[0]['alert_quantity'] :'0';?>" placeholder="">
							</div> */
							?>
						</div>
						
						<div class="row">
							<div class="form-group col-md-3">
								<label class="col-form-label">Item Sequence No. </label>
								<input type="number" name="sequence_number" id="sequence_number" class="form-control" value="<?php echo isset($edit_data[0]['sequence_number'])? $edit_data[0]['sequence_number']:''?>">
							</div>
						</div>
						
						<div class="row">
							<div class="col-md-4">
								<div class="form-group col-md-12">
									<label class="col-form-label">Time 1</label>
									<div class="row">
										<div class="form-group col-md-6">
											<label class="col-form-label">Open Time </label>
											<input type="time" name="from_time_1" value="<?php echo isset($edit_data[0]['from_time_1']) ? $edit_data[0]['from_time_1'] :"";?>"  class="form-control" placeholder="">
										</div>
										<div class="form-group col-md-6">
											<label class="col-form-label">Close Time </label>
											<input type="time" name="to_time_1" value="<?php echo isset($edit_data[0]['to_time_1']) ? $edit_data[0]['to_time_1'] :"";?>"  class="form-control" placeholder="">
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-md-4">
								<div class="form-group col-md-12">
									<label class="col-form-label">Time 2</label>
									<div class="row">
										<div class="form-group col-md-6">
											<label class="col-form-label">Open Time</label>
											<input type="time" name="from_time_2" value="<?php echo isset($edit_data[0]['from_time_2']) ? $edit_data[0]['from_time_2'] :"";?>"  class="form-control" placeholder="">
										</div>
										<div class="form-group col-md-6">
											<label class="col-form-label">Close Time</label>
											<input type="time" name="to_time_2" value="<?php echo isset($edit_data[0]['to_time_2']) ? $edit_data[0]['to_time_2'] :"";?>"  class="form-control" placeholder="">
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="row">
							<div class="form-group col-md-9">
								<label class="col-form-label">Detailed Description </label>
								<textarea name="description" rows="5" class="form-control" placeholder="Please enter detailed description"><?php echo isset($edit_data[0]['description']) ? $edit_data[0]['description'] :"";?></textarea>
							</div>
						</div>

						<div class="row">
							<div class="form-group col-md-3">
								<label class="col-from-label" for="upload_image">Choose Image </label>
								<input type="file" name="product_image" class="form-control">
							</div>

							<div class="col-md-3 mt-4 pt-1">
								<a href="https://pixelixe.com/image-cropper-online/crop-image.html" target="_blank" class=" btn btn-primary text-light btn-block" for="upload_image">Click to Crop Image </a>
							</div>
							
							<?php 
								if($type == "edit")
								{
									if( !empty($edit_data[0]['product_image']) && file_exists("uploads/products/".$edit_data[0]['product_image']) )
									{
										
										?>
										<div class="form-group col-md-6">
											<label class="col-form-label"></label>
											<img src="<?php echo base_url(); ?>uploads/products/<?php echo $edit_data[0]['product_image'];?>" width="75" height="75">
										</div>
										<?php 
									}
								} 
							?>
						</div>
						
						
						<div class="d-flexad text-right">
							<a href="<?php echo base_url(); ?>products/ManageProducts" class="btn btn-outline-dark waves-effect ">Cancel</a>
							<?php 
								if($type == "edit")
								{
									?>
									<button type="submit" class="btn btn-info waves-effect ml-2 ">Update</button>
									<?php 
								}
								else
								{
									?>
									<button type="submit" class="btn btn-info waves-effect ml-2">Submit</button>
									<?php 
								}
							?>
						</div>
						
					</form>
					<?php
				}
				else if($type=="ingredients")
				{ 
					$itemQuery = "select * from products where product_id ='".$id."' ";
					$getProducrDetails = $this->db->query($itemQuery)->result_array();
					?>
					<fieldset class="mt-2">
						<legend class="text-uppercase font-size-sm font-weight-bold">
							Item Details
						</legend>
					</fieldset>
					
					<div class="row">
						<div class="col-md-2">	
							Item Code
						</div>	
						<div class="col-md-1">:</div>
						<div class="col-md-8"><?php echo $getProducrDetails[0]['product_code'];?></div>
					</div>

					<div class="row mt-2">
						<div class="col-md-2">	
							Item Name
						</div>	
						<div class="col-md-1">:</div>
						<div class="col-md-8"><?php echo ucfirst($getProducrDetails[0]['product_name']);?></div>
					</div>
					
					<div class="row mt-2">
						<div class="col-md-2">	
							Item Description
						</div>	
						<div class="col-md-1">:</div>
						<div class="col-md-8"><?php echo ucfirst($getProducrDetails[0]['description']);?></div>
					</div>
				
					<hr>

					<fieldset class="mt-2">
						<legend class="text-uppercase font-size-sm font-weight-bold">
							Add Ingredient
						</legend>
					</fieldset>
					
					
					<form action="" class="form-validate-jquery" enctype="multipart/form-data" method="post">
						<div class="row">
							<div class="form-group col-md-3">
								<label class="col-form-label">Ingredient Name <span class="text-danger">*</span></label>
								<input type="text" name="ingredient_name" required class="form-control" value="" placeholder="">
							</div>
							<div class="form-group col-md-3">
								<label class="col-form-label">Descriptiopn</label>
								<input type="text" name="ingredients_description"  class="form-control" value="" placeholder="">
							</div>
							<div class="col-md-3" style="margin-top:37px;">
								<input type="submit" name="add" class="btn btn-primary" value="Add">
							</div>
						</div>
					</form>
					
					<hr>

					<fieldset class="mt-2">
						<legend class="text-uppercase font-size-sm font-weight-bold">
							Manage Ingredients
						</legend>
					</fieldset>
					<form action="" method="get">
						<div class="row">
							<div class="col-md-3">	
								<input type="search" autocomplete="off" class="form-control" name="keywords" value="<?php echo !empty($_GET['keywords']) ? $_GET['keywords'] :""; ?>" placeholder="Search...">
								<p class="search-note">Note : Ingredient Name, Description</p>
							</div>	
							
							<div class="col-md-3">
								<button type="submit" class="btn btn-info waves-effect">Search <i class="fa fa-search" aria-hidden="true"></i></button>
							</div>
						</div>
						
						<div class="row">
							<div class="col-md-8"></div>
							<div class="col-md-4 text-right">
								<?php 
									$redirect_url = substr($_SERVER['REQUEST_URI'],'1');
								?>
								<input type="hidden" id="redirect_url" value="<?php echo $redirect_url; ?>"/>
														
								<div class="filter_page">
									<label>
										<span>Show :</span> 
										<select name="filter" onchange="location.href='<?php echo base_url(); ?>admin/sort_itemper_page/'+$(this).val()+'?redirect=<?php echo $redirect_url; ?>'">
											<?php 
												$pageLimit = $_SESSION['PAGE'];
												foreach($this->items_per_page as $key => $value)
												{
													$selected="";
													if($key == $pageLimit){
														$selected="selected=selected";
													}
													?>
													<option value="<?php echo $key; ?>" <?php echo $selected;?>><?php echo $value; ?></option>
													<?php 
												} 
											?>
										</select>
									</label>
								</div>
							</div>
						</div>
					</form>
				
					<form action="" method="post">
						<div class="new-scroller">
							<table id="myTable" class="table table-bordered table-hover --table-striped --dataTable">
								<thead>
									<tr>
										<th class="text-center">Controls</th>
										<th onclick="sortTable(3)">Ingredient Name</th>
										<th onclick="sortTable(4)">Description</th>
										<th onclick="sortTable(9)" class="text-center">Status</th>
									</tr>
								</thead>
								<tbody>
									<?php 	
										$i=0;
										$firstItem = $first_item;
										foreach($resultData as $row)
										{
											?>
											<tr>
												<?php 
												/*
												<td style="text-align:center;"><?php echo $i + $firstItem;?></td> */ ?>
												<td style="width: 8%;" class="text-center">
													<a title="Edit" href="#" data-toggle="modal" data-target="#exampleModal<?php echo $row['ingredient_id'];?>">
														<i class="fa fa-pencil"></i>
													</a>

													<!-- Modal -->
													<div class="modal fade" id="exampleModal<?php echo $row['ingredient_id'];?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
														<div class="modal-dialog" role="document">
															<div class="modal-content">
																<div class="modal-header" style="background: #022646;color: #fff;">
																	<h5 class="modal-title" id="exampleModalLabel">Edit Ingredient</h5>
																	<button type="button" class="close" data-dismiss="modal" aria-label="Close">
																		<span aria-hidden="true">&times;</span>
																	</button>
																</div>
																
																<form action="" method="post">
																	<div class="modal-body">
																		<div class="row">
																			<div class="form-group col-md-8">
																				<label class="col-form-label float-left">Ingredient Name <span class="text-danger">*</span></label>
																				<input type="text" name="ingredient_name" value="<?php echo $row['ingredient_name'];?>" id="ingredient_name" class="form-control" required/>
																				<input type="hidden" name="ingredient_id" value="<?php echo $row['ingredient_id'];?>"/>
																			</div>
																		</div>
																		
																		<div class="row">
																			<div class="form-group col-md-8">
																				<label class="col-form-label float-left">Descriptiopn</label>
																				<input type="text" name="ingredients_description" value="<?php echo $row['ingredients_description'];?>" id="ingredients_description" class="form-control"/>
																			</div>
																		</div>
																	</div>
																	<div class="modal-footer">
																		<button type="button" class="btn btn-light" data-dismiss="modal">Close </button>
																		<button type="submit" name="update" class="btn btn-primary ml-3">Update</button>
																	</div>
																</form>
															</div>
														</div>
													</div>

												</td>
												<td class="tab-medium-width">
													<?php echo ucfirst($row['ingredient_name']);?>
												</td>
												<td class="tab-medium-width">
													<?php echo ucfirst($row['ingredients_description']);?>
												</td>
												<td class="text-center">
													<?php 
														if($row['status'] == 1)
														{
															?>
															<label class="switch">
																<input type="checkbox" checked id="<?php echo $row['ingredient_id'];?>">
																<div class="slider round"></div>
															</label>
															<?php 
														} 
														else
														{ 
															?>
															<label class="switch">
																<input type="checkbox" id="<?php echo $row['ingredient_id'];?>">
																<div class="slider round"></div>
															</label>
															<?php 
														} 
													?>
												</td>
											</tr>
											<?php 
											$i++;
										}
									?>
								</tbody>
							</table>
							<?php 
								if(count($resultData) == 0)
								{
									?>
									<p class="admin-no-data">No data found.</p>
									<?php 
								} 
							?>
						</div>
					</form>
				
					<div class="row">
						<div class="col-md-4 showing-count">
							Showing <?php echo $starting;?> to <?php echo $ending;?> of <?php echo $totalRows;?> entries
						</div>
						
						<!-- pagination start here -->
						<?php 
							if( isset($pagination) )
							{
								?>	
								<div class="col-md-8" class="admin_pagination" style="float:right;padding: 0px 20px 0px 0px;"><?php foreach ($pagination as $link){echo $link;} ?></div>
								<?php
							}
						?>
						<!-- pagination end here -->
					</div>
					<script>
						$('input[type="checkbox"]').on('click',function () 
						//$('#status_<?php echo $row['ingredient_id'];?>').click(function () {
						{
							var id = $(this).attr("id");
							
							if($(this).is(':checked',true))
							{
								$.ajax({
									type: "get",
									url:"<?php echo base_url().'products/ManageProducts/ingredientStatus/';?>"+id+"/"+1,
									data: { }
								}).done(function( msgs ) 
								{   
									toastr.success(msgs)
								});
							}
							else 
							{
								$.ajax({
									type: "get",
									url:"<?php echo base_url().'products/ManageProducts/ingredientStatus/';?>"+id+"/"+0,
									data: { }
								}).done(function( msgs ) 
								{   
									toastr.success(msgs)
								});
							}
						})
					</script>
					<?php 
				}
				else
				{ 
					?>
					<fieldset class="mt-2">
						<legend class="text-uppercase font-size-sm font-weight-bold">
							Manage Items
						</legend>
					</fieldset>
					<form action="" method="get">
						<div class="row">
							<div class="col-md-3">	
								<input type="search" autocomplete="off" class="form-control" name="keywords" value="<?php echo !empty($_GET['keywords']) ? $_GET['keywords'] :""; ?>" placeholder="Search...">
								<p class="search-note">Note : Item Code, Item Name</p>
							</div>	
							<div class="col-md-3">	
								<?php $getCategory = $this->db->query("select category.category_name,category.category_id from category 
								join products on products.category_id = category.category_id
								where category_status=1 and main_category_id =0 group by products.category_id order by category.category_name asc ")->result_array(); ?>
								<select name="category_id" class="form-control searchDropdown">
									<option value="">- Select Category -</option>
									<?php 
										foreach($getCategory as $category)
										{
											$selected="";
											if(isset($_GET['category_id']) && ($_GET['category_id'] == $category['category_id']) )
											{
												$selected="selected='selected'";
											}
											?>
											<option value="<?php echo $category['category_id']; ?>" <?php echo $selected;?>><?php echo $category['category_name']; ?></option>
											<?php 
										} 
									?>
								</select>
							</div>	
							<div class="col-md-3">
								<button type="submit" class="btn btn-info waves-effect">Search <i class="fa fa-search" aria-hidden="true"></i></button>
							</div>
						</div>
						
						<?php /* <div class="row">
							<div class="col-md-3">	
								<?php $getbranch = $this->db->query("select branch_id,branch_name from branch where branch_status=1")->result_array(); ?>
								<select name="branch_id" class="form-control searchDropdown">
									<option value="">- Select Branch -</option>
									<?php 
										foreach($getbranch as $row)
										{
											$selected="";
											if(isset($_GET['branch_id']) && ($_GET['branch_id'] == $row['branch_id']) )
											{
												$selected="selected='selected'";
											}
											?>
											<option value="<?php echo $row['branch_id']; ?>" <?php echo $selected;?>><?php echo ucfirst($row['branch_name']); ?></option>
											<?php 
										} 
									?>
								</select>
							</div>	
						</div> */?>

						<div class="row">
							<div class="col-md-8"></div>
							<div class="col-md-4 text-right">
								<?php 
									$redirect_url = substr($_SERVER['REQUEST_URI'],'1');
								?>
								<input type="hidden" id="redirect_url" value="<?php echo $redirect_url; ?>"/>
														
								<div class="filter_page">
									<label>
										<span>Show :</span> 
										<select name="filter" onchange="location.href='<?php echo base_url(); ?>admin/sort_itemper_page/'+$(this).val()+'?redirect=<?php echo $redirect_url; ?>'">
											<?php 
												$pageLimit = $_SESSION['PAGE'];
												foreach($this->items_per_page as $key => $value)
												{
													$selected="";
													if($key == $pageLimit){
														$selected="selected=selected";
													}
													?>
													<option value="<?php echo $key; ?>" <?php echo $selected;?>><?php echo $value; ?></option>
													<?php 
												} 
											?>
										</select>
									</label>
								</div>
							</div>
						</div>
					</form>
				
					<form action="" method="post">
						<?php /* <a href="javascript::void(0);" onclick="showbtn();" style="margin: 0px 0px 13px 0px;" class="showbtn btn btn-warning">Show Multi Delete<br></a>
						<script>
							function showbtn()
							{
								$('.deleteBtn').toggle();
							}
						</script> */ ?>
						
						<div class="new-scroller">
							<table id="myTable" class="table table-bordered table-hover --table-striped --dataTable">
								<thead>
									<tr>
										<?php
										/* <th>
											<input type="checkbox" id="select_all">&nbsp;
											<button style="display:none;" class="deleteBtn" type="submit" name="delete" value="delete" title="Patient Multi Delete"><i class="fa fa-trash" style="font-size:16px;"></i></button>
										</th>
										<th onclick="sortTable(0)" style="width: 10%;">S.No <i class="fa fa-fw fa-sort"></i></th>
										 */ ?>
										<th class="text-center">Controls</th>
										<!--<th>Branch</th>-->
										<th class="text-center">Image</th>
										<th onclick="sortTable(1)" class="text-center">Item Code</th>
										<!--<th onclick="sortTable(2)" class="text-center">HSN Code</th>-->
										<th onclick="sortTable(3)">Item Name</th>
										<th onclick="sortTable(4)">Category</th>
										<!-- <th onclick="sortTable(4)">Items Days</th>
										<th onclick="sortTable(4)">Items Timing</th> -->
										<!--<th onclick="sortTable(5)" class="text-center">Cost</th>-->
										<!--<th onclick="sortTable(6)" class="text-center">Price</th>-->
										<!--<th onclick="sortTable(7)">Quantity</th>-->
										<!--<th onclick="sortTable(8)" class="text-center">UOM</th>
										<th onclick="sortTable(9)">Alert Quantity</th>-->
										<th onclick="sortTable(9)" class="text-center">Status</th>
									</tr>
								</thead>
								<tbody>
									<?php 	
										$i=0;
										$firstItem = $first_item;
										foreach($resultData as $row)
										{
											?>
											<tr>
												<?php 
												/* <td>
													<input type="checkbox" name="checkbox[]" class="emp_checkbox" value="<?php echo $row['user_id']; ?>">
												</td>
												<td style="text-align:center;"><?php echo $i + $firstItem;?></td> */ ?>
												<td style="width: 8%;" class="text-center">
													<a title="Edit" href="<?php echo base_url(); ?>products/ManageProducts/edit/<?php echo $row['product_id'];?>">
														<i class="fa fa-pencil"></i>
													</a>
												</td>
												<!--<td class="tab-medium-width">
													<?php echo ucfirst($row['branch_name']);?>
												</td>-->
												
												<td style="text-align:center;">
													<?php 
														if(!empty($row['product_image']) && file_exists("uploads/products/".$row['product_image']) )
														{
															$photo_url = base_url().'uploads/products/'.$row['product_image'];
															$CustomerName = ucfirst($row['product_name']);
															?>
															<a --href="<?php echo $photo_url;?>" data-magnify="gallery" data-caption="<?php echo $CustomerName;?>">
																<img src="<?php echo $photo_url;?>"  style="height:60px; width:60px;" alt="">
															</a>
															<?php 
														}
														else
														{
															?>
															<img src="<?php echo base_url();?>uploads/no-image.png"  style="max-width:60px !important; max-height:60px !important;" alt="...">
															<?php
														}
													?>
												</td>
												
												<td class="tab-medium-width text-center">
													<?php echo $row['product_code'];?>
												</td>
												<!--<td class="text-center tab-medium-width"><?php echo $row['hsn_code'];?></td>
												-->
												<td class="tab-medium-width ">
													<?php echo ucfirst($row['product_name']);?><br>
													<?php 
														$IngredientsQuery = "select ingredient_id from vb_product_ingredients where product_id='".$row['product_id']."' ";
														$getIngredients = $this->db->query($IngredientsQuery)->result_array();
														
														if(count($getIngredients) > 0)
														{
															$countIngredients = "info";
														}else{
															$countIngredients = "warning";
														}
													?>

													<a class="btn btn-<?php echo $countIngredients;?> btn-sm" href="<?php echo base_url();?>products/ManageProducts/ingredients/<?php echo $row['product_id'];?>">
														Add Ingredients (<?php echo count($getIngredients);?>)
													</a>
													<!--<a href="<?php echo base_url();?>products/ManageProducts/ingredients/<?php echo $row['product_id'];?>">
														<i class="fa fa-plus-circle"></i>
													</a> -->
												</td>
												<td class="tab-medium-width"><?php echo ucfirst($row['category_name']);?></td>
												<!-- <td class="tab-medium-width"><?php echo ucfirst($row['item_days']);?></td>
												<td class="tab-full-width"><?php echo $row['item_from_time'];?>  <?php echo !empty($row['item_to_time']) ? "- ".$row['item_to_time']:"";?></td> -->
												<!--<td class="text-center tab-medium-width"><?php echo CURRENCY_SYMBOL; ?> <?php echo number_format($row['cost'],DECIMAL_VALUE,'.','');?></td>-->
												<!--<td class="text-center tab-medium-width"><?php echo CURRENCY_SYMBOL; ?> <?php echo number_format($row['price'],DECIMAL_VALUE,'.','');?></td>-->
												<!--<td style="text-align:center;"><?php echo $row['quantity'];?></td>-->
												<!--<td class="text-center"><?php echo $row['unit'];?></td>-->
												<!--<td style="text-align:center;"><?php echo $row['alert_quantity'];?></td>-->
												<td class="text-center">
													<?php 
														if($row['product_status'] == 1)
														{
															?>
																<!-- <input type="checkbox" > -->
																<label class="switch">
																	<input type="checkbox" checked id="<?php echo $row['product_id'];?>">
																	<div class="slider round"></div>
																</label>
															<?php 
														} 
														else
														{ 
															?>
																<label class="switch">
																	<input type="checkbox" id="<?php echo $row['product_id'];?>">
																	<div class="slider round"></div>
																</label>
															<?php 
														} 
													?>
												</td>
											</tr>
											<?php 
											$i++;
										}
									?>
								</tbody>
							</table>
							<?php 
								if(count($resultData) == 0)
								{
									?>
									<p class="admin-no-data">No data found.</p>
									<?php 
								} 
							?>
						</div>
					</form>
				
					<div class="row">
						<div class="col-md-4 showing-count">
							Showing <?php echo $starting;?> to <?php echo $ending;?> of <?php echo $totalRows;?> entries
						</div>
						
						<!-- pagination start here -->
						<?php 
							if( isset($pagination) )
							{
								?>	
								<div class="col-md-8" class="admin_pagination" style="float:right;padding: 0px 20px 0px 0px;"><?php foreach ($pagination as $link){echo $link;} ?></div>
								<?php
							}
						?>
						<!-- pagination end here -->
						
					</div>
					<script>
						$('input[type="checkbox"]').on('click',function () 
						{
							id = $(this).attr("id");
							if($(this).is(':checked',true))
							{
								$.ajax({
									type: "get",
									url:"<?php echo base_url().'products/ManageProducts/status/';?>"+id+"/"+1,
									data: { }
								}).done(function( msg ) 
								{   
									toastr.success(msg)
								});
							}
							else 
							{
								$.ajax({
									type: "get",
									url:"<?php echo base_url().'products/ManageProducts/status/';?>"+id+"/"+0,
									data: { }
								}).done(function( msg ) 
								{   
									toastr.success(msg)
								});
							}
						})
					</script>
					<?php 
				} 
			?>

			
		
		</div><!-- Card body end-->
	</div><!-- Card end-->
	<?php if(isset($type) && $type =='view'){?>
		<a href='<?php echo $_SERVER['HTTP_REFERER'];?>' class='btn btn-info' style="float:right;"><i class="icon-arrow-left16"></i> Back</a>
	<?php } ?>
</div><!-- Content end-->


<script>
	// select all checkbox
	$('#select_all').on('click', function(e) 
	{
		if($(this).is(':checked',true)) {
			$(".emp_checkbox").prop('checked', true);
		}
		else {
			$(".emp_checkbox").prop('checked',false);
		}
		// set all checked checkbox count
		//$("#select_count").html($("input.emp_checkbox:checked").length+" Selected");
	});
</script>

