
<script>
	function initMap() 
	{
		var input = document.getElementById('autocomplete');
		
		var autocomplete = new google.maps.places.Autocomplete(input);

		autocomplete.addListener('place_changed', function() 
		{
			var place = autocomplete.getPlace();
			if (!place.geometry) {
				window.alert("Autocomplete's returned place contains no geometry");
				return;
			}

			var address = '';
			if (place.address_components) 
			{
				address = [
					(place.address_components[0] && place.address_components[0].short_name || ''),
					(place.address_components[1] && place.address_components[1].short_name || ''),
					(place.address_components[2] && place.address_components[2].short_name || '')
				].join(' ');
			}
		});
	}
</script>
<script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo GOOGLE_MAP_API_KEY;?>&libraries=places&callback=initMap"></script>

<?php 
	$branch_id = isset($_SESSION['branch_id']) ? $_SESSION['branch_id'] : 0;
	
	$BranchQuerys = "select opening_time,closing_time,minimum_order_value from branch where branch_id='".$branch_id."' ";
	$getBranchDetails = $this->db->query($BranchQuerys)->result_array();
	
	$openingTime = isset($getBranchDetails[0]['opening_time']) ? $getBranchDetails[0]['opening_time'] : 0;
	$closingTime = isset($getBranchDetails[0]['closing_time']) ? $getBranchDetails[0]['closing_time'] : 0;
	$minimumOrderValue = isset($getBranchDetails[0]['minimum_order_value']) ? $getBranchDetails[0]['minimum_order_value'] : 0;
		
	/* $BranchZonesQry = "select latitude,longitude,zone_name from 
	vb_branch_zones 
		where 
			vb_branch_zones.branch_id=".$branch_id." and 
				vb_branch_zones.zone_status=1
	";
	$getBranchZones = $this->db->query($BranchZonesQry)->result_array();
	
	if( !empty($_SESSION['DELIVERY_LATITUDE']) && !empty($_SESSION['DELIVERY_LONGITUDE']) && isset($_SESSION['DELIVERY_LATITUDE']) && isset($_SESSION['DELIVERY_LONGITUDE']))
	{
		#echo "delivery";
		#echo $_SESSION['DELIVERY_LATITUDE']."".$_SESSION['DELIVERY_LONGITUDE'];
		
		$currentLat  = isset($_SESSION['DELIVERY_LATITUDE']) ? $_SESSION['DELIVERY_LATITUDE'] : "12.745458";
		$currentLon = isset($_SESSION['DELIVERY_LONGITUDE']) ? $_SESSION['DELIVERY_LONGITUDE'] : "77.81027069999999";
	
	}
	else
	{
		#echo "current";
		$currentLat = isset($_COOKIE['CURRENT_LATITUDE']) ? $_COOKIE['CURRENT_LATITUDE'] :"";
		$currentLon = isset($_COOKIE['CURRENT_LONGITUDE']) ? $_COOKIE['CURRENT_LONGITUDE'] :"";
	}
	
	$deliveryAddress = getDeliveyrAddress($currentLat,$currentLon);
	
	#echo $deliveryAddress;
	
	$deliveryAvailable = 0;
	if( count($getBranchZones) > 0)
	{
		foreach($getBranchZones as $zones)
		{
			$getZoneAddress = getDeliveyrAddress($zones['latitude'],$zones['longitude']);
			$ZoneAddress1 = $getZoneAddress.",";
			$zoneAddress1 = array_filter(explode(",",$ZoneAddress1));
			
			$zoneAddress = array_flip($zoneAddress1);
			
			#print_r($zoneAddress);
			
			if(is_array($zoneAddress))
			{
				if(array_key_exists($deliveryAddress, $zoneAddress) && in_array($deliveryAddress, $zoneAddress))
				{
					$deliveryAvailable = 1;
				}
			}
			else
			{
				$deliveryAvailable = 0;
			}
		}
	}
	else
	{
		$deliveryAvailable = 1;
	} */
	
	if( !empty($_SESSION['DELIVERY_LATITUDE']) && !empty($_SESSION['DELIVERY_LONGITUDE']) && isset($_SESSION['DELIVERY_LATITUDE']) && isset($_SESSION['DELIVERY_LONGITUDE']))
	{
		$lat  = isset($_SESSION['DELIVERY_LATITUDE']) ? $_SESSION['DELIVERY_LATITUDE'] : "12.745458";
		$lon = isset($_SESSION['DELIVERY_LONGITUDE']) ? $_SESSION['DELIVERY_LONGITUDE'] : "77.81027069999999";
		#echo $lat."==".$lon;
	}
	else
	{
		unset($_SESSION['DELIVERY_LATITUDE']); 
		unset($_SESSION['DELIVERY_LONGITUDE']); 
		unset($_SESSION['DELIVERY_ADDRESS']);
		
		//echo $_COOKIE['DELIVERY_LATITUDE'];
		$lat  = isset($_COOKIE['CURRENT_LATITUDE']) ? $_COOKIE['CURRENT_LATITUDE'] : "12.745458";
		$lon = isset($_COOKIE['CURRENT_LONGITUDE']) ? $_COOKIE['CURRENT_LONGITUDE'] : "77.81027069999999";
	}
	
	$deliveryAddress1 = getDeliveyrZoneBranches($lat,$lon);
	$FilerdeliveryAddress =  array_filter(explode("@",$deliveryAddress1));
	$deliveryAddress = $FilerdeliveryAddress[0];
	$deliveryAddress_1 = isset($FilerdeliveryAddress[1]) ? $FilerdeliveryAddress[1] :"";
	
	# Single Long name | Neighbourhood only start
	if(!empty($deliveryAddress))
	{
		$condition = ' (branch.branch_status = 1 ) and ';
		
		if(!empty($deliveryAddress) && !empty($deliveryAddress_1) )
		{
			$condition .= '  
			(
				vb_branch_zones.zone_name like "%'.($deliveryAddress).'%" or
				vb_branch_zones.zone_name like "%'.($deliveryAddress_1).'%"
			)  and ';	
		}
		else
		{
			$condition .= '  
			(
				vb_branch_zones.zone_name like "%'.($deliveryAddress).'%"
			)  and ';
		}
	
		$condition .= ' vb_branch_zones.zone_status = 1 ';
			
		if(!empty($_POST["query"]))
		{
			$condition .= ' and (
							branch.branch_name like "%'.($_POST["query"]).'%" or 
							branch.branch_code like "%'.($_POST["query"]).'%" or
							branch.address like "%'.($_POST["query"]).'%"
						)
					';
		}
	}
	else
	{
		$condition = ' branch.branch_status = 1 and vb_branch_zones.zone_status = 1';
	} 
	# Single Long name | Neighbourhood only end
	
	
	$branchQuery = "select 
			branch.branch_id,
			branch.branch_name,
			branch.branch_code,
			branch.address,
			branch.phone_number,
			branch.delivery_distance

			from branch 
			
			left join vb_branch_zones on
				vb_branch_zones.branch_id = branch. branch_id
			
				where ".$condition." group by branch.branch_name
			ORDER BY branch.branch_name asc
	";
	
	$result = $this->db->query($branchQuery)->result_array();
	
	if( count($result) > 0 )
	{
		$deliveryAvailable = 1;
	}
	else
	{
		$deliveryAvailable = 0;
	}
?>

<main class="bg_gray margin_60">
	<div class="container --margin_60 margintop_35">
		<form action="" id="formValidation" method="post" enctype="multipart/form-data" novalidate="novalidate">
			<div class="row justify-content-center margin_60">
				<?php 
					if(isset($_SESSION["cart_item"]) && $_SESSION["cart_item"])
					{ 
						?>
						<div class="col-xl-8 col-lg-8">
							<!-- You are securely logged in start -->
							<div class="box_order_form" id="deliveryAddress">
								<?php 
									$userDetails = $this->db->query('select first_name from users where user_id="'.$this->UserID.'"')->result_array();
								?>
								<div class="main">
									<div class="row">
										<div class="col-md-12">
											<div class="form-group">
												<h3><?php echo ucfirst($userDetails[0]['first_name']);?></h3>
												<span>You are securely logged in</span>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- You are securely logged in End -->
							
							<?php 
								if( isset($_SESSION['DELIVERY_ADDRESS']) && !empty($_SESSION['DELIVERY_ADDRESS']))
								{
									$currentAddress = $delivery_address = $_SESSION['DELIVERY_ADDRESS'];
								}
								else
								{
									$latitude  = isset($_COOKIE['CURRENT_LATITUDE']) ? $_COOKIE['CURRENT_LATITUDE'] : "12.745458";
									$longitude = isset($_COOKIE['CURRENT_LONGITUDE']) ? $_COOKIE['CURRENT_LONGITUDE'] : "77.81027069999999";
							
									$currentAddress=getCurrentAddress($latitude,$longitude);
								}
							?>

							<style>
								.choosen-del-address
								{
									font-size:13px!important;color:#ababab!important;
								}
								.otp-box {
									text-align: center;
								}
								.splitter {
									padding: 0 5px;
									color: white;
									font-size: 24px;
								}
								.otp {
									width: 30px;
									height: 50px;
									background-color: lighten($BaseBG, 5%);
									border: none;
									line-height: 50px;
									text-align: center;
									font-size: 30px;
									color: #e54750;
									margin: 0 2px;
									border: 1px solid #e54750;
								}
								.prompt {
									margin-bottom: 20px;
									font-size: 20px;
									color: white;
								}
							</style>

							<!-- Delivery Address start -->
							<?php
								$getDeliveryAddress = $this->db->query('select vb_customer_address.*,
								users.first_name,
								users.mobile_number from vb_customer_address
								left join users on users.user_id = vb_customer_address.user_id
			
								where users.user_id="'.$this->UserID.'" order by customer_address_id desc')->result_array();
							?>
							<div class="box_order_form" id="Delivery_Address">
								<div class="head">
									<div class="title">
										<h3>
											Delivery Address 
											<?php if(count($getDeliveryAddress) > 0){?>
											<a href="javascript:void(0);" data-toggle="modal" data-target="#exampleModal" class="btn btn-cancel-1">
												<i class="fa fa-plus"></i> Add New Address
											</a>
											<?php } ?>
										</h3> 
										
										<?php /* <h3 class="choosen-del-address"><i class="fa fa-map-marker"></i> <?php echo $currentAddress;?></h3> */ ?>
									</div>
									
									
								</div>
								
								<div class="main" >
									<?php 
										if(count($getDeliveryAddress) > 0)
										{
											$i=1;
											foreach($getDeliveryAddress as $row)
											{
												if($i == 1)
												{
													$checked="checked='checked'";
												}
												else
												{
													$checked="";
												}
												?>
												<div class="col-md-12">
													<div class="row">
														<div class="col-md-10">	
															<div class="form-group address-deliver">
																<input type="radio" <?php echo $checked;?> id="delivery_address<?php echo $row['customer_address_id'];?>" name="delivery_address_id" value="<?php echo $row['customer_address_id'];?>">
																
																<?php 
																	if($row['tags'] !='0')
																	{
																		?>
																		<span class="address-tags">
																			<?php
																				foreach($this->deliveryTags as $key=>$value)
																				{
																					if($row['tags'] == $key)
																					{
																						if($row['tags'] == 1 )
																						{
																							echo '<i class="fa fa-home"></i>';
																						}
																						else if($row['tags'] == 2 )
																						{
																							echo '<i class="fa fa-briefcase"></i> ';
																						}
																						echo $value;
																					}
																				}
																			?>
																		</span>
																		<?php 
																	} 
																?>
																
																<span>
																	<?php echo ucfirst($row['delivery_address']);?> 
																</span>
																	
																<?php if(!empty($row['door_number'])){?>
																	<span>
																		<?php echo $row['door_number'];?>, <?php echo $row['building_number'];?>
																	</span>
																<?php } ?>
													
																<span> 
																	<?php echo ucfirst($row['address']);?> 
																</span>
																
																<?php if(!empty($row['address_line_2'])){?>
																	<span>
																		<?php echo ucfirst($row['address_line_2']);?>
																	</span>
																<?php } ?>
																	
																<?php if(!empty($row['land_mark'])){?>
																	<span> 
																		<?php echo ucfirst($row['land_mark']);?>
																	</span> 
																<?php } ?> 
																
																<?php if(!empty($row['locality'])){?>
																	<span> 	
																		<?php echo ucfirst($row['locality']);?>
																	</span>																	
																<?php } ?>
																
																
																<?php if(!empty($row['pin_code'])){?>
																<span>
																	<?php echo $row['pin_code'];?>
																	</span>
																<?php } ?>
																	
																	
																<span> 		
																	<?php /* if(!empty($row['mobile_number'])){?>
																		Mobile Number : <?php echo $row['mobile_number'];?>
																	<?php } */ ?>
																 		
																	<?php if(!empty($row['alternative_number'])){?>
																		Mobile Number : <?php echo $row['alternative_number'];?>
																	<?php } ?>
																</span>
																
															</div>
														</div>
														<div class="col-md-2">
															<a href="javascript::void(0);" class="btn btn-cancel modal_dialog" data-toggle="modal" data-target="#exampleModal<?php echo $row['customer_address_id'];?>" >
																Edit
															</a>
														</div>
													</div>
												</div>
												<hr>
												
												<!-- Modal item order -->
												<div class="modal fade" id="exampleModal<?php echo $row['customer_address_id'];?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel<?php echo $row['customer_address_id'];?>" aria-hidden="true">
													<div class="modal-dialog" role="document">
														<div class="modal-content">
															<div class="modal-header new-model-popup">
																<h5 class="modal-title" id="exampleModalLabel">Edit Delivery Address</h5>
																<button type="button" class="close new-close-popup" data-dismiss="modal" aria-label="Close">
																	<span aria-hidden="true">&times;</span>
																</button>
															</div>
															
															<form action="" method="post">
																<div class="modal-body">
																	<input type="hidden" name="full_name" value="<?php echo ucfirst($row['full_name']);?>" id="full_name" class="form-control" required />
																	<input type="hidden" name="customer_address_id" value="<?php echo $row['customer_address_id'];?>"/>
																	<input type="hidden" name="pin_code" value="<?php echo $row['pin_code'];?>" id="pin_code" class="form-control"/>
																	<input type="hidden" name="locality" value="<?php echo $row['locality'];?>" id="locality" class="form-control" />
																		
																	<div class="row">
																		<div class="form-group col-md-6">
																			<label class="col-form-label">Delivery Location  <span class="text-danger">*</span></label>
																			<?php 
																				/* $latitude  = isset($_COOKIE['CURRENT_LATITUDE']) ? $_COOKIE['CURRENT_LATITUDE'] : "12.745458";
																				$longitude = isset($_COOKIE['CURRENT_LONGITUDE']) ? $_COOKIE['CURRENT_LONGITUDE'] : "77.81027069999999";
																			
																				$currentAddress=getCurrentAddress($latitude,$longitude);
																				*/
																			
																				if(!empty($row['delivery_address']) && !empty($row['delivery_address']))
																				{
																					$delivery_address = $row['delivery_address'];
																				}
																				else
																				{
																					if( isset($_SESSION['DELIVERY_ADDRESS']) && !empty($_SESSION['DELIVERY_ADDRESS']))
																					{
																						$delivery_address = $_SESSION['DELIVERY_ADDRESS'];
																					}
																					else
																					{
																						$latitude  = isset($_COOKIE['CURRENT_LATITUDE']) ? $_COOKIE['CURRENT_LATITUDE'] : "12.745458";
																						$longitude = isset($_COOKIE['CURRENT_LONGITUDE']) ? $_COOKIE['CURRENT_LONGITUDE'] : "77.81027069999999";
																				
																						$delivery_address=getCurrentAddress($latitude,$longitude);
																					}
																				}
																			?>
																			<input type="text" autocomplete="off" name="delivery_address" id="autocomplete" value="<?php echo $delivery_address;?>" class="form-control" required />
																		</div>
																		
																		<div class="form-group col-md-6">
																			<label class="col-form-label">Post Box No / Flat No   <span class="text-danger">*</span></label>
																			<input type="text" name="door_number" value="<?php echo ucfirst($row['door_number']);?>" id="door_number" autocomplete="off" class="form-control" required />
																		</div>
																	</div>
																	
																	<div class="row">
																		<div class="form-group col-md-6">
																			<label class="col-form-label">Building No / Name  <span class="text-danger">*</span></label>
																			<input type="text" name="building_number" autocomplete="off" value="<?php echo ucfirst($row['building_number']);?>" id="building_number" class="form-control" required />
																		</div>
																		<div class="form-group col-md-6">
																			<label class="col-form-label">Landmark (Optional)</label>
																			<input type="text" autocomplete="off" name="land_mark" placeholder="Eg.Near Chennai Silks" id="land_mark" value="<?php echo $row['land_mark'];?>" class="form-control" />
																		</div>
																	</div>
																	<div class="row">
																		<div class="form-group col-md-6">
																			<label class="col-form-label"> Address Line 1  <span class="text-danger">*</span></label>
																			<input type="text" name="address" value="<?php echo ucfirst($row['address']);?>" id="address" class="form-control" required />
																		</div>
																		<div class="form-group col-md-6">
																			<label class="col-form-label">Address Line 2 </label>
																			<input type="text" name="address_line_2" value="<?php echo ucfirst($row['address_line_2']);?>" id="address_line_2" class="form-control" />
																		</div>
																	</div>
																	
																	<div class="row">
																		<?php 
																			$UserDetails = "select user_id,mobile_number,country_id,otp_status from users where user_id ='".$this->UserID."'";
																			$getUserDetails = $this->db->query($UserDetails)->result_array();
																			
																			$country_id = isset($getUserDetails[0]['country_id']) ? $getUserDetails[0]['country_id'] : 0;
																			$mobile_number = isset($getUserDetails[0]['mobile_number']) ? $getUserDetails[0]['mobile_number'] :"";
																		?>
																		<div class="form-group col-md-6">
																			<div class="row">
																				<div class="col-md-6">
																					<label class="col-form-label">Country Code <span class="text-danger">*</span></label>
																					<?php 
																						$verifiedStatus = $this->db->query("select otp_status from  users where user_id = ".$this->UserID)->result_array();
																						$getCountry = $this->db->query("select country_id,country_name,country_code from country where country_status=1 order by default_country desc")->result_array();

																						$disabledatttr	="";
																						$readonlyatttr	="";
																						if ($verifiedStatus[0]['otp_status'] == 1) 
																						{
																							?>
																								<input type="hidden" name="country_id" value="<?php echo $row['country_id'] ?>">
																							<?php
																							$disabledatttr = "disabled";
																							$readonlyatttr = "readonly";
																						}
																					?>
																					<select name="country_id" <?php echo $disabledatttr ?>  id="country_id" onchange="selectState(this.value);"  class="form-control searchDropdown">
																						<option value="">- Select Country -</option>
																						<?php 
																							foreach($getCountry as $row1)
																							{
																								$selected="";
																								if( isset($row['country_id']) && $row['country_id'] == $row1['country_id'])
																								{
																									$selected="selected='selected'";
																								}
																								else if($country_id == $row1['country_id'])
																								{
																									$selected="selected='selected'";
																								}
																								?>
																								<option value="<?php echo $row1['country_id']; ?>" <?php echo $selected;?>><?php echo ucfirst($row1['country_code']);?> - <?php echo ucfirst($row1['country_name']);?></option>
																								<?php 
																							} 
																						?>
																					</select>
																				</div>
																				
																				<div class="col-md-6">
																					<label class="col-form-label">Mobile Number <span class="text-danger">*</span></label>
																					<input type="text" <?php echo $readonlyatttr ?> required autocomplete="off" placeholder="2345 8734" name="alternative_number" value="<?php echo !empty($row['alternative_number']) ? $row['alternative_number'] : $mobile_number ;?>" id="alternative_number" class="form-control" />
																				</div>
																			</div>
																		</div>
																		
																		<div class="form-group col-md-6">
																			<label class="col-form-label">Tag this Location</label><br>
																			<?php
																				foreach($this->deliveryTags as $key=>$value)
																				{
																					$chedked="";
																					if(isset($row['tags']) && $row['tags'] == $key)
																					{
																						$chedked="checked='checked'";
																					}
																					?>
																					<input <?php echo $chedked;?> type="radio" id="tags<?php echo $key;?>" name="tags" value="<?php echo $key;?>">
																					<label for="css"><?php echo $value;?></label>
																					<?php
																				}
																			?>
																		</div>
																	</div>
																</div>
																
																<div class="modal-footer mt-0 mb-0">
																	<div class="col-md-12">
																		<div class="popup-command-btns">
																			<div class="row">
																				<div class="col-md-4 offset-4">
																					<a href="javascript:void(0)" class="btn btn-cancel mb-0" data-dismiss="modal">Close </a>
																				</div>
																				<div class="col-md-4">
																					<button type="submit" name="addressUpdate" class="btn_1 btn-info">Save </button>
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</form>
														</div>
													</div>
												</div>
												<!-- Modal item order -->
												<?php 
												$i++;
											}
										}
										else
										{
											?>
											
											<a href="javascript:void(0);" data-toggle="modal" data-target="#exampleModal" class="btn btn-cancel">
												<i class="fa fa-plus"></i> Add New Address
											</a>
											<?php
										}								
									?>
									
									<!-- Modal item order -->
									<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
										<div class="modal-dialog" role="document">
											<div class="modal-content">
												<div class="modal-header new-model-popup">
													<h5 class="modal-title" id="exampleModalLabel">Add Delivery Address</h5>
													<button type="button" class="close new-close-popup" data-dismiss="modal" aria-label="Close">
														<span aria-hidden="true">&times;</span>
													</button>
												</div>
												
												<form action="" method="post" id="addaddressFrom">
													<div class="modal-body">
														
														<input type="hidden" name="full_name" value="" id="full_name" class="form-control" required />
														<input type="hidden" name="pin_code" value="" id="pin_code" class="form-control"/>
														<input type="hidden" name="locality" value="" id="locality" class="form-control" />
															
														<div class="row">
															<div class="form-group col-md-6">
																<?php 
																	if( isset($_SESSION['DELIVERY_ADDRESS']) && !empty($_SESSION['DELIVERY_ADDRESS']))
																	{
																		$currentAddress = $delivery_address = $_SESSION['DELIVERY_ADDRESS'];
																	}
																	else
																	{
																		$latitude  = isset($_COOKIE['CURRENT_LATITUDE']) ? $_COOKIE['CURRENT_LATITUDE'] : "12.745458";
																		$longitude = isset($_COOKIE['CURRENT_LONGITUDE']) ? $_COOKIE['CURRENT_LONGITUDE'] : "77.81027069999999";
																
																		$currentAddress=getCurrentAddress($latitude,$longitude);
																	}
																?>
																<label class="col-form-label">Delivery Location  <span class="text-danger">*</span></label>
																<input type="text" autocomplete="off" name="delivery_address" id="autocomplete" value="<?php echo isset($currentAddress) ? $currentAddress :"";?>" class="form-control" required />
															</div>
															
															<div class="form-group col-md-6">
																<label class="col-form-label">Post Box No / Flat No <span class="text-danger">*</span></label>
																<input type="text" name="door_number" id="door_number" autocomplete="off" class="form-control" required />
															</div>
														</div>
														
														<div class="row">
															<div class="form-group col-md-6">
																<label class="col-form-label">Building No / Name <span class="text-danger">*</span></label>
																<input type="text" name="building_number" id="address" autocomplete="off" class="form-control" required />
															</div>
															
															<div class="form-group col-md-6">
																<label class="col-form-label">Landmark (Optional)</label>
																<input type="text" autocomplete="off" name="land_mark" placeholder="Eg.Near Chennai Silks" id="land_mark" value="" class="form-control" />
															</div>
														</div>
														
														<div class="row">
															<div class="form-group col-md-6">
																<label class="col-form-label"> Address Line 1  <span class="text-danger">*</span></label>
																<input type="text" name="address" id="address" autocomplete="off" class="form-control" required />
															</div>
															<div class="form-group col-md-6">
																<label class="col-form-label">Address Line 2</label>
																<input type="text" name="address_line_2" id="address_line_2" autocomplete="off" class="form-control" />
															</div>
														</div>
														
														<div class="row">
															<?php 
																$UserDetails = "select user_id,mobile_number,country_id,otp_status from users where user_id ='".$this->UserID."'";
																$getUserDetails = $this->db->query($UserDetails)->result_array();
																
																$country_id = isset($getUserDetails[0]['country_id']) ? $getUserDetails[0]['country_id'] : 0;
																$mobile_number = isset($getUserDetails[0]['mobile_number']) ? $getUserDetails[0]['mobile_number'] :"";

																$disabledatttr	="";
																$readonlyatttr	="";
																if ($getUserDetails[0]['otp_status'] == 1) 
																{
																	?>
																	<input type="hidden" name="country_id" value="<?php echo isset($edit_data[0]['country_id']) ? $edit_data[0]['country_id'] : $country_id ?>">
																	<?php
																	$disabledatttr = "disabled";
																	$readonlyatttr = "readonly";
																}
															?>
															<div class="form-group col-md-6" id="country_mobile_box">
																<div class="row" >
																	<div class="col-md-6">
																		<label class="col-form-label">Country Code <span class="text-danger">*</span></label>
																		<?php 
																			$getCountry = $this->db->query("select country_id,country_name,country_code from country where country_status=1 order by default_country desc")->result_array();
																		?>
																		<select name="country_id" id="country_id" <?php echo $disabledatttr ?> required --onchange="selectState(this.value);"  class="form-control searchDropdown">
																			<option value="">- Select Country -</option>
																			<?php 
																				foreach($getCountry as $row)
																				{
																					$selected="";
																					if( isset($edit_data[0]['country_id']) && $edit_data[0]['country_id'] == $row['country_id'])
																					{
																						$selected="selected='selected'";
																					}
																					else if($country_id == $row['country_id'])
																					{
																						$selected="selected='selected'";
																					}
																					?>
																					<option value="<?php echo $row['country_id']; ?>" <?php echo $selected;?>><?php echo ucfirst($row['country_code']);?> - <?php echo ucfirst($row['country_name']);?></option>
																					<?php 
																				} 
																			?>
																		</select>
																	</div>
																	
																	<div class="col-md-6">
																		<label class="col-form-label">Mobile Number <span class="text-danger">*</span></label>
																		<input type="text" <?php echo $readonlyatttr ?> required autocomplete="off" value="<?php echo $mobile_number;?>" placeholder="2345 8734" name="alternative_number" value="" id="alternative_number" class="form-control" />
																	</div>
																	<div class="col-md-12 " id="otp_box">
																		
																	</div>
																</div>
															</div>
															
															<div class="form-group col-md-6">
																<label class="col-form-label">Tag this Location</label><br>
																<?php
																	foreach($this->deliveryTags as $key=>$value)
																	{
																		$chedked="";
																		if(isset($row['tags']) && $row['tags'] == $key)
																		{
																			$chedked="checked='checked'";
																		}
																		?>
																		<input <?php echo $chedked;?> type="radio" id="tags<?php echo $key;?>" name="tags" value="<?php echo $key;?>">
																		<label for="css"><?php echo $value;?></label>
																		<?php
																	}
																?>
															</div>
														</div>
														
														
														
														<?php /* <div class="">
															<input id="pac-input" class="controls form-control"type="text" placeholder="Search Box" />
														</div>
														
														<div class="row address-map-main">
															<div id="map" class="address-map"></div>
														</div> */ ?>
														
														
														<style>
															div.address-map {
																display: inline-block;
																float: left;
																height: 200px !important;
																width: 100% !important;
															}
															
															#description {
															  font-family: Roboto;
															  font-size: 15px;
															  font-weight: 300;
															}

															#infowindow-content .title {
															  font-weight: bold;
															}

															#infowindow-content {
															  display: none;
															}

															#map #infowindow-content {
															  display: inline;
															}

															.pac-card {
															  margin: 10px 10px 0 0;
															  border-radius: 2px 0 0 2px;
															  box-sizing: border-box;
															  -moz-box-sizing: border-box;
															  outline: none;
															  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);
															  background-color: #fff;
															  font-family: Roboto;
															}

															#pac-container {
															  padding-bottom: 12px;
															  margin-right: 12px;
															}

															.pac-controls {
															  display: inline-block;
															  padding: 5px 11px;
															}

															.pac-controls label {
															  font-family: Roboto;
															  font-size: 13px;
															  font-weight: 300;
															}

															#pac-input {
															  background-color: #fff;
															  font-family: Roboto;
															  font-size: 15px;
															  font-weight: 300;
															  margin-left: 12px;
															  padding: 0 11px 0 13px;
															  text-overflow: ellipsis;
															  
															}

															#pac-input:focus {
															  border-color: #4d90fe;
															}

															#title {
															  color: #fff;
															  background-color: #4d90fe;
															  font-size: 25px;
															  font-weight: 500;
															  padding: 6px 12px;
															}

															#target {
															  width: 345px;
															}
														</style>
													</div>
													
													<div class="modal-footer mt-0 mb-0">
														<div class="col-md-12">
															<div class="popup-command-btns">
																<div class="row">
																	<div class="col-md-4 offset-4">
																		<!-- <a href="javascript:void(0)" class="btn btn-cancel mb-0" data-dismiss="modal">Close </a> -->
																	</div>
																	<div class="col-md-4">
																		<button type="submit" name="addressAdd" id="addressAdd" class="btn_1 btn-info">Save </button>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</form>
											</div>
										</div>
									</div>
									<!-- Modal item order -->
								</div>
							</div>
							<!-- Delivery Address End -->
							
							<div class="box_order_form">
								<div class="head">
									<div class="title">
										<h3>Select Payment Method</h3>
									</div>
								</div>
								<!-- /head -->
								<div class="main">
									<?php /*
									<div class="payment_select">
										<label class="container_radio">Credit Card
											<input type="radio" value="" checked name="payment_method">
											<span class="checkmark"></span>
										</label>
										<i class="icon_creditcard"></i>
									</div>
									
									<div class="form-group">
										<label>Name on card</label>
										<input type="text" class="form-control" id="name_card_order" name="name_card_order" placeholder="First and last name">
									</div>
									
									<div class="form-group">
										<label>Card number</label>
										<input type="text" id="card_number" name="card_number" class="form-control" placeholder="Card number">
									</div>
									
									<div class="row">
										<div class="col-md-6">
											<label>Expiration date</label>
											<div class="row">
												<div class="col-md-6 col-6">
													<div class="form-group">
														<input type="text" id="expire_month" name="expire_month" class="form-control" placeholder="mm">
													</div>
												</div>
												<div class="col-md-6 col-6">
													<div class="form-group">
														<input type="text" id="expire_year" name="expire_year" class="form-control" placeholder="yyyy">
													</div>
												</div>
											</div>
										</div>
										<div class="col-md-6 col-sm-12">
											<div class="form-group">
												<label>Security code</label>
												<div class="row">
													<div class="col-md-4 col-6">
														<div class="form-group">
															<input type="text" id="ccv" name="ccv" class="form-control" placeholder="CCV">
														</div>
													</div>
													<div class="col-md-8 col-6">
														<img src="<?php echo base_url();?>assets/frontend/img/icon_ccv.gif" width="50" height="29" alt="ccv">
														&nbsp;<small>Last 3 digits</small>
													</div>
												</div>
											</div>
										</div>
									</div>
									<!--End row -->
									*/ ?>
									
									<?php 
										$PaymentModeQuery = "select * from expense_payment_type 
											where payment_type_status=1
												order by sequence_number asc";
										$getPaymentMode = $this->db->query($PaymentModeQuery)->result_array();
										
										if(count($getPaymentMode)>0)
										{
											foreach($getPaymentMode as $paymentMode)
											{	
												$checked = '';
												if($paymentMode['default_payment'] == 1)
												{
													$checked = 'checked="checked"';
												}
												
												if($paymentMode['payment_type_id'] == 2) #Pay by Card
												{
													?>
													<div class="payment_select">
														<label class="container_radio">
															<?php echo ucfirst($paymentMode['payment_type']);?>
															<input type="radio" value="<?php echo $paymentMode['payment_type_id'];?>" class="payment_method<?php echo $paymentMode['payment_type_id'];?>" name="payment_method" <?php echo $checked;?>>
															<span class="checkmark"></span>
														</label>
														<div class="float-right">
															<i class="icon_creditcard"></i>
														</div>
														<?php
															/* if(file_exists("uploads/payments/".$paymentMode['payment_type_id'].'.png') )
															{
																$photo_url = base_url().'uploads/payments/'.$paymentMode['payment_type_id'].'.png';
																?>
																<div class="float-right">
																	<img src="<?php echo $photo_url;?>" style="height:30px;width:45px;position: relative;top: -6px;" alt="">
																</div>
																<?php 
															} */
														?>
													</div>
													
													<div class="pay_by_card<?php echo $paymentMode['payment_type_id'];?> pay_by_card">
														<!-- <div class="form-group">
															<label>Name on card <span class="text-danger star">*</span></label>
															<input type="text" name="name_card_order" id="name_card_order" class="form-control" placeholder="First and last name">
														</div>
														
														<div class="form-group">
															<label>Card Number <span class="text-danger star">*</span></label>
															<input type="text" name="card_number" id="card_number" class="form-control" placeholder="Card Number">
														</div>
														
														<div class="row">
															<div class="col-md-6">
																<label>Expiration Date <span class="text-danger star">*</span></label>
																<div class="row">
																	<div class="col-md-6 col-6">
																		<div class="form-group">
																			<input type="number" min="1" max="12" name="expire_month" id="expire_month" class="form-control" placeholder="Expiry Month">
																		</div>
																	</div>
																	<div class="col-md-6 col-6">
																		<div class="form-group">
																			<input type="number" min="<?php echo date('Y')?>" name="expire_year" id="expire_year" class="form-control" placeholder="Expiry Year">
																		</div>
																	</div>
																</div>
															</div>
															<div class="col-md-6 col-sm-12">
																<div class="form-group">
																	<label>Security Code <span class="text-danger star">*</span></label>
																	<div class="row">
																		<div class="col-md-4 col-6">
																			<div class="form-group">
																				<input type="text" minlength="3" maxlength="3" id="ccv" name="ccv" class="form-control" placeholder="CCV">
																			</div>
																		</div>
																		<div class="col-md-8 col-6">
																			<img src="<?php echo base_url();?>assets/frontend/img/icon_ccv.gif" width="50" height="29" alt="ccv">
																			&nbsp;<small>Last 3 digits</small>
																		</div>
																	</div>
																</div>
															</div>
														</div> -->
													</div>
													<script>
														$('#expire_month').blur(function () {
															val = $(this).val();
															if (val < 10 && val.length >= 2) {
																val = "0"+val;
																$(this).val(val);
																console.log('h');
															}
														});
														$('#expire_year').blur(function () {
															mon = $('#expire_month').val()
															year = $('#expire_year').val()

															now_date = <?php echo time() ?>;

															var myDate = "26"+"-"+mon+"-"+year;
															myDate = myDate.split("-");
															var newDate = new Date( myDate[2], myDate[1] - 1, myDate[0]);
															console.log(newDate.getTime(),now_date);
															
															if (newDate.getTime()/1000 < now_date) {
																$('.place_order_submit').hide();
															}
														})
													</script>
													<?php 
												}
												
												if($paymentMode['payment_type_id'] == 1) #Cash On Delivery (COD)
												{
													?>
													<div class="payment_select">
														<label class="container_radio">
															<?php echo ucfirst($paymentMode['payment_type']);?>
															<input type="radio" value="<?php echo $paymentMode['payment_type_id'];?>" class="payment_method<?php echo $paymentMode['payment_type_id'];?>" name="payment_method" <?php echo $checked;?>>
															<span class="checkmark"></span>
														</label>
														
														<?php
															if(file_exists("uploads/payments/".$paymentMode['payment_type_id'].'.png') )
															{
																$photo_url = base_url().'uploads/payments/'.$paymentMode['payment_type_id'].'.png';
																?>
																<div class="float-right">
																	<img src="<?php echo $photo_url;?>" style="height:30px;width:45px;position: relative;top: -6px;" alt="">
																</div>
																<?php 
															}
														?>
													</div>
													<?php 
												}
												?>
												<script>
													$(document).ready(function()
													{ 
														var checkedValue = $("input[type=radio][class=payment_method<?php echo $paymentMode['payment_type_id'];?>]:checked").val();
														
														if(checkedValue == 2)
														{
															$(".pay_by_card").show();
															cardValidation(checkedValue);
														}	
														else
														{
															$(".pay_by_card").hide();
															cardValidation(checkedValue);
														}
														
														$(".payment_method<?php echo $paymentMode['payment_type_id'];?>").click(function() 
														{
															var value = $(".payment_method<?php echo $paymentMode['payment_type_id'];?>").val() ;
															if(value == 2)
															{
																$(".pay_by_card").show();
																cardValidation(value);
															}
															else
															{	
																$(".pay_by_card").hide();
																cardValidation(value);
															}
														});

														function cardValidation(val)
														{
															
															if(val == 2)
															{
																$("#name_card_order").attr("required", "true");
																$("#card_number").attr("required", "true");
																$("#expire_month").attr("required", "true");
																$("#expire_year").attr("required", "true");
																$("#ccv").attr("required", "true");
															}
															else
															{
																$("#name_card_order").removeAttr("required", "false");
																$("#card_number").removeAttr("required", "false");
																$("#expire_month").removeAttr("required", "false");
																$("#expire_year").removeAttr("required", "false");
																$("#ccv").removeAttr("required", "false");
															}
														}
													});
												</script>
												<?php
											} 
										} 
									?>
								</div>
							</div>
							<!-- box_order_form -->
						</div>
						
						<!-- Order Summary -->
						<div class="col-xl-4 col-lg-4" id="sidebar_fixed">
							<div class="box_order">
								<div class="head">
									<h3>Order Summary</h3>
								</div>
								<div class="main">
									<?php 
										if(isset($_SESSION["cart_item"]) && $_SESSION["cart_item"])
										{ 
											?>
											<ul class="order-summary-checkout clearfix mb-0">
												<?php
													$subTotal = 0;
													//$sessionCart = array_shift($_SESSION["cart_item"]);
													foreach ($_SESSION["cart_item"] as $code => $item)
													{
														$SessionCatID = isset($item["category_id"]) ? $item["category_id"] : 0;
														$product_id = $item["product_id"];
														$availableQty = isset($item["available_quantity"]) ? $item["available_quantity"] : "0";
														$minimum_order_quantity = isset($item["minimum_order_quantity"]) ? $item["minimum_order_quantity"] : 0;
														?>
														<div class="order-summ-items product_table cartproduct_<?php echo $product_id?>">
															<div class="row">
																<div class="col-md-7 pl-2">
																	<li class="price-summary">
																		<?php echo ucfirst($item["product_name"]);?>
																	</li>
																	<li class="price-peritem-summary">
																		<?php echo CURRENCY_CODE;?> 
																		<?php echo number_format($item["price"],DECIMAL_VALUE,'.','');?> |
																		<a class="summary-delete" onclick="removeorders(<?php echo $product_id ?>,'<?php echo $code;?>')" --href="<?php echo base_url();?>remove-cart-item/<?php echo $item["product_code"]; ?>/<?php echo $item["product_id"]; ?>.html" class="action">
																			Remove
																		</a>
																	</li>
																</div>
																<div class="col-md-5 pr-1">
																	<div class="rightside-section-order">
																		<div class="increment-decrement">
																			<ul class="row">
																				<li class="decrement-summary minus<?php echo $product_id;?>">-</li>
																				<li class="count-summary li_quantity<?php echo $product_id;?>"><?php echo $item["quantity"];?></li>
																				<li class="increment-summary plus<?php echo $product_id;?>">+</li>
																			</ul>
																		</div>
																	</div>
																</div>
															</div>
															
															<div class="row">
																<!-- ingredients start -->
																<div class="col-md-9 pl-2">
																	<?php 
																		$ingredients = isset($item["ingredients"]) ? $item["ingredients"] :"";
																		$ingredientAmount =0;
																		if(!empty($ingredients))
																		{
																			?>
																			<li class="price-peritem-summary">
																				<?php 
																					$unserializeIngredients = unserialize($ingredients);
																					echo count($unserializeIngredients);
																				?>
																				ADD ONS : <br>
																				<?php
																					foreach($unserializeIngredients as $key => $value)
																					{
																						$IngredientID = $key;
																						$IngredientPrice = $value;
																						
																						$IngredientsQuery = "select ingredient_name from 
																							vb_product_ingredients
																							where 
																								ingredient_id='".$IngredientID."' and 
																									product_id='".$product_id."'
																							";
																						$getIngredients = $this->db->query($IngredientsQuery)->result_array();
																						?>
																						<?php $Ingredients = $getIngredients[0]['ingredient_name'].' | '; ?>
																						<?php echo $Ingredients; ?>
																						<?php
																						$ingredientAmount += $IngredientPrice;
																					}
																				?>
																			</li>
																			<?php 
																		} 
																	?>
																</div>
																<!-- ingredients end -->
																
																<div class="col-md-3">
																	<div class="rightside-section-order">
																		<div class="product-per-price">
																			<?php echo CURRENCY_CODE;?> 
																			<span class="itemTotal<?php echo $product_id;?>">
																				<?php 
																					$totalItemAmount = $item["price"] ;
																					$totalAmount = ($totalItemAmount + $ingredientAmount) * $item["quantity"];
																					echo number_format($totalAmount,DECIMAL_VALUE,'.','');
																				?>
																			</span>
																			<input type="hidden" name="linetotal[]" id="linetotal<?php echo $product_id;?>" value="<?php echo number_format($totalAmount,DECIMAL_VALUE,'.','');?>">
																			<input type="hidden" name="ingredients[]" id="ingredients<?php echo $product_id;?>" value='<?php echo $ingredients;?>'>
																			<input type="hidden" name="ingredientAmount[]" id="ingredientAmount<?php echo $product_id;?>" value="<?php echo number_format($ingredientAmount,DECIMAL_VALUE,'.','');?>">
																		</div>
																	</div>
																</div>
															</div>
															
															<input type="hidden" name="category_id[]" id="category_id<?php echo $product_id;?>" value="<?php echo $SessionCatID;?>">
															<input type="hidden" name="product_id[]" id="product_id<?php echo $product_id;?>" value="<?php echo $product_id;?>">
															<input type="hidden" name="price[]" id="price<?php echo $product_id;?>" value="<?php echo $item["price"];?>">
															<input type="hidden" name="quantity[]" id="quantity<?php echo $product_id;?>" value="<?php echo $item["quantity"];?>">
															<input type="hidden" name="minimum_order_quantity[]" id="minimum_order_quantity<?php echo $product_id;?>" value="<?php echo isset($minimum_order_quantity) ? $minimum_order_quantity :0;?>">
														</div>
														
														<script>
															/** Qty Increment **/
															$('.plus<?php echo $product_id;?>').click(function()
															{
																var incQty = parseInt($('.li_quantity<?php echo $product_id;?>').html());
																var totalQty = incQty;
																var minimum_order_quantity = $('#minimum_order_quantity<?php echo $product_id;?>').val();
																
																if(totalQty < minimum_order_quantity || minimum_order_quantity == 0)
																{
																	var availableQty = '<?php echo $availableQty;?>';
																	var incQty = $('#quantity<?php echo $product_id;?>').val();
																	if( incQty == availableQty )
																	{
																		alert("Available Qty is "+availableQty);
																	}
																	else
																	{
																		var incQty = parseInt($('.li_quantity<?php echo $product_id;?>').html());
																		var totalQty =  incQty + 1;
																		$('.li_quantity<?php echo $product_id;?>').html(totalQty);
																		$('#quantity<?php echo $product_id;?>').val(totalQty);
																		
																		var quantity = $('#quantity<?php echo $product_id;?>').val();
																		var price = $('#price<?php echo $product_id;?>').val();
																		var ingredientAmount = $('#ingredientAmount<?php echo $product_id;?>').val();
																		var product_id = '<?php echo $product_id;?>';
																		calculateRow(quantity,price,ingredientAmount,product_id,minimum_order_quantity,availableQty);
																		calculateGrandTotal();
																	}
																}
																else if(totalQty >= minimum_order_quantity)
																{
																	alert("Max Order Qty is "+minimum_order_quantity+" only.");
																}
															});
															
															/** Qty Decrement **/
															$('.minus<?php echo $product_id;?>').click(function()
															{
																var decQty = $('.li_quantity<?php echo $product_id;?>').html();
																
																if(decQty == 1)
																{
																	$('.li_quantity<?php echo $product_id;?>' ).html(1);
																	$('#quantity<?php echo $product_id;?>').val(1);
																}
																else if(decQty >= 1)
																{
																	var decQty = parseInt($('.li_quantity<?php echo $product_id;?>').html());
																	var totalQty =  decQty - 1;
																	$('.li_quantity<?php echo $product_id;?>' ).html(totalQty);
																	$('#quantity<?php echo $product_id;?>').val(totalQty);
																}
																
																var quantity = $('#quantity<?php echo $product_id;?>').val();
																var price = $('#price<?php echo $product_id;?>').val();
																var ingredientAmount = $('#ingredientAmount<?php echo $product_id;?>').val();
																var product_id = '<?php echo $product_id;?>';
																
																var minimum_order_quantity = $('#minimum_order_quantity<?php echo $product_id;?>').val();
																var availableQty = '<?php echo $availableQty;?>';
							
																calculateRow(quantity,price,ingredientAmount,product_id,minimum_order_quantity,availableQty);
																calculateGrandTotal();
															});
															
															function calculateRow(quantity,price,ingredientAmount,product_id,minimum_order_quantity,availableQty) 
															{	
																var totalAmount = parseFloat(price) + parseFloat(ingredientAmount);
																
																var itemTotal = (totalAmount * quantity).toFixed(2);
																$('.itemTotal'+product_id).text(itemTotal);
																$('#linetotal'+product_id).val(itemTotal);
																calculateGrandTotal();
																
																if(product_id != "" && quantity != "")
																{
																	$.ajax({
																		url: '<?php echo base_url(); ?>web_items/AjaxItemSession/'+product_id+'/'+quantity+'/'+price+'/'+minimum_order_quantity+'/'+availableQty,
																		type: "POST",
																		data:{
																			'<?php echo $this->security->get_csrf_token_name(); ?>' : '<?php echo $this->security->get_csrf_hash(); ?>'
																		},
																		datatype: JSON,
																		success: function(result)
																		{
																			if(quantity == 0)
																			{
																				location.reload();
																			}
																			
																			data = JSON.parse(result);
																			//$(".ajaxOrderSummary").html(data['itemList']);
																			$(".cartCount").html(data['cartCount']);
																			$(".headerCartItem").html(data['headerCartItem']);
																		
																			if($('.wallet_chk_enabled').is(":checked"))
																			{ 
																				//$(".place_order_disabled_class_1").show();
																				//$(".miminum_wallet_disabled").attr("disabled",true);
																				$(".enter_wallet").hide();
																				$(".wallet_amt").val('');
																				$('.miminum_wallet_disabled').prop('checked', false); // Checks it
																			}
																			else
																			{
																				
																			}
																		}
																	});
																}
																else
																{
																	
																}
															}
															
															function calculateGrandTotal() 
															{
																var subTotal = 0;
																$("div.product_table").find('input[name^="linetotal"]').each(function () 
																{
																	subTotal += +$(this).val();
																});
																
																$('.subTotal').text(subTotal.toFixed(2));
																$('.totalAmount').text(subTotal.toFixed(2));
																
																$('#sub_total').val(subTotal.toFixed(2));
																$('#grand_total').val(subTotal.toFixed(2));

																var tax_value = $("#tax_value").val();
																var PayAmount = $("#sub_total").val();
																var taxAmount = tax_value / 100 * subTotal;

																$('#vatAmt').html(parseFloat(taxAmount).toFixed(2));
																
																//var totalPayableAmount = parseFloat(PayAmount) + parseFloat(taxAmount);
																var totalPayableAmount = parseFloat(PayAmount);
																var minimumOrderValue = '<?php echo $minimumOrderValue; ?>';
																
																if(totalPayableAmount < minimumOrderValue)
																{
																	alert('sure');
																	$(".minimumOrderValue").show();
																	
																	$(".place_order_submit_1").hide();
																	$(".place_order_submit").hide();
																	
																	$(".place_order_disabled").hide();
																	$(".place_order_disabled_class_1").show();
																	
																	$(".miminum_wallet_disabled").attr("disabled",true);
																	$(".enter_wallet").hide();
																	$(".wallet_amt").val('');
																	$('.miminum_wallet_disabled').prop('checked', false); // Checks it
																}
																else //if(totalPayableAmount >= minimumOrderValue)
																{
																	$(".place_order_submit_2").show();
																	$(".place_order_disabled").hide();
																	$(".place_order_disabled_class_1").hide();
																	$(".minimumOrderValue").hide();
																	$(".place_order_submit").hide();
																	/* $(".place_order_submit_2").show();
																	$(".place_order_submit_1").hide(); */
																	
																	
																	$(".miminum_wallet_disabled").removeAttr("disabled");
																	
																	if($('.wallet_chk_enabled').is(":checked"))
																	{ 
																		$(".enter_wallet").show();
																	}else{
																		$(".enter_wallet").hide();
																	}
																}
																/* else
																{
																	//$(".place_order_submit").hide();
																} */
																
																$(".Payable_Amount").text(totalPayableAmount.toFixed(2));
																$("#payable_amount").val(totalPayableAmount.toFixed(2));
																	
															}
														</script>
														<?php 
														$subTotal += $totalAmount;														
													} 
												?>
											</ul>
									
											<ul class="clearfix summary-total-subtotal">
												<li class="wallet-check-sec">
													<?php
														$walletQuery = "select wallet_amount from vb_customer_wallet 
															where user_id='".$this->UserID."' ";
														$CustomerWallet = $this->db->query($walletQuery)->result_array();
														
														$walletAmount = isset($CustomerWallet[0]['wallet_amount']) ? $CustomerWallet[0]['wallet_amount'] : 0;
														$disabledChkBox= $ReadonlyChkBox = 
														$disabledColor="";
														
														if($walletAmount == 0 || ($subTotal < $minimumOrderValue) )
														{
															$disabledChkBox="disabled";
															$ReadonlyChkBox="readonly";
															$disabledColor="color:#ccc !important;";
														}
													?>
													<b style="<?php echo $disabledColor;?>">
														Wallet Amount <img src="<?php echo base_url();?>assets/frontend/img/wallet.png" height="15px;" width="15px">
													</b>
													<label class="container_check wallet-check">
														<input onchange="walletChanged()"  <?php echo $disabledChkBox; ?> <?php echo $ReadonlyChkBox; ?> type="checkbox" name="wallet_chk_enabled" value="1" class="wallet_chk_enabled miminum_wallet_disabled">
														<span class="checkmark checkmark-new"></span>
														<script type="text/javascript">
															function walletChanged()
															{
																//var totalAmount = '<?php echo number_format($subTotal,DECIMAL_VALUE,'.','');?>';
																var totalAmount = $("#grand_total").val();
																var walletAmount = '<?php echo number_format($walletAmount,DECIMAL_VALUE,'.','');?>';
																var enterAmount = $(".wallet_amt").val();
																	
																if($('.wallet_chk_enabled').is(":checked"))
																{   
																	$(".WalletPayableAmount").show();
																	$(".enter_wallet").show();
																	
																	$(".wallet_amt").attr("required", "true");
																	
																	if( enterAmount !="" && parseFloat(walletAmount) > parseFloat(totalAmount))
																	{
																		var PayAmount = 0;
																	}
																	else if( parseFloat(walletAmount) < parseFloat(totalAmount))
																	{
																		var PayAmount = totalAmount - walletAmount;
																	}
																	else
																	{
																		var PayAmount = totalAmount;
																	}
																	
																	$(".Payable_Amount").text(parseFloat(PayAmount).toFixed(2));
																	$("#payable_amount").val(parseFloat(PayAmount).toFixed(2));
																}
																else
																{
																	var tax_value = $("#tax_value").val();
																	var PayAmount = $("#sub_total").val();
																	var taxAmount = tax_value / 100 * totalAmount;
																	
																	//var totalPayableAmount = parseFloat(PayAmount) + parseFloat(taxAmount);
																	var totalPayableAmount = parseFloat(PayAmount);
																	
																	//$(".WalletPayableAmount").hide();
																	$(".Payable_Amount").text(totalPayableAmount.toFixed(2));
																	$("#payable_amount").val(totalPayableAmount.toFixed(2));
																	
																	$(".wallet_amt").val('');
																	$(".enter_wallet").hide();
																	$(".wallet_amt").removeAttr("required", "false");
																}
															}
														</script>
														
														<script>
															$(document).ready(function()
															{
																$(".wallet_amt").on("input keyup", function()
																{
																	var entered_wallet_amt = parseFloat( $(".wallet_amt").val() );
																	var tax_value = $("#tax_value").val();
																	
																	var walletAmount = '<?php echo number_format($walletAmount,DECIMAL_VALUE,'.','');?>';
																	//var total_Amount = '<?php //echo number_format($subTotal,DECIMAL_VALUE,'.','');?>';
																	var total_Amount = $("#grand_total").val();
																	var tax_value = $('#tax_value').val();
																	
																	var totalTaxAmount = tax_value / 100 * parseFloat(total_Amount);
																	
																	//var totalAmount =  parseFloat(total_Amount) + parseFloat(totalTaxAmount);
																	var totalAmount = parseFloat(total_Amount);
																	
																	
																	//var payable_amount = $('#payable_amount').val();
																	
																	if(isNaN(entered_wallet_amt)) 
																	{
																		$(".wallet_amt").val("");
																		
																		var PayAmount = totalAmount;
																		var entered_wallet_amt = 0;
																	}
																	else if(parseFloat(entered_wallet_amt) > parseFloat(walletAmount))
																	{
																		alert('Please enter the amount below or equal to wallet amount.');
																		$(".wallet_amt").val("");
																		var PayAmount = totalAmount;
																	}
																	else if(parseFloat(entered_wallet_amt) > parseFloat(totalAmount))
																	{
																		alert('Please enter the amount below or equal to payable amount.');
																		$(".wallet_amt").val("");
																		var PayAmount = totalAmount;
																	}
																	else
																	{
																		
																		/* if( parseFloat(walletAmount) > parseFloat(totalAmount))
																		{
																			var PayAmount = entered_wallet_amt;
																		}
																		else if( parseFloat(walletAmount) < parseFloat(totalAmount))
																		{ */
																			var PayAmount = totalAmount - entered_wallet_amt;
																		/* }
																		else
																		{
																			var PayAmount = totalAmount;
																		} */
																	}
																	
																	//var taxAmount = tax_value / 100 * totalAmount;
																	
																	//var totalPayableAmount = parseFloat(PayAmount) + parseFloat(taxAmount);
																	
																	$(".Payable_Amount").text(PayAmount.toFixed(2));
																	$("#payable_amount").val(PayAmount.toFixed(2));
																	
																	$("#wallet_amount").val(entered_wallet_amt.toFixed(2));
																	
																});
															});
														</script>
													</label>
													
													<span class="wallet-amnt" style="<?php echo $disabledColor;?>">
														<?php echo CURRENCY_CODE;?> 
														<?php echo number_format($walletAmount,DECIMAL_VALUE,'.','');?>
													</span>
													
													<div class="mt-2 enter_wallet" style="display:none;">
														<input type="text" class="form-control wallet_amt" name="wallet_amt" value="" placeholder="Enter your wallet amount">
													</div>
												</li>
												
												<li class="pt-2">
													<b>Sub Total</b>
													<div class="seprate-cost">
														<?php /*
														<span class="totalAmount-currency">
															<?php echo CURRENCY_CODE;?>
														</span>
														*/
														?>
														<span class="subTotal">
															<?php echo number_format($subTotal,DECIMAL_VALUE,'.','');?>
														<span>
													</div>
												</li>
												<!--<li>Delivery fee<span>AED 10</span></li>-->
												<li>
													<b>Total</b>
													<div class="seprate-cost">
														<?php /*<span class="totalAmount-currency"><?php echo CURRENCY_CODE;?></span>
														*/ ?>
														<span class="totalAmount"> 
															<?php echo number_format($subTotal,DECIMAL_VALUE,'.','');?>
														</span>
													</div>
												</li>
												
												<?php 
													$taxQuery = "select tax_name,tax_id,tax_value from tax where tax_status=1 and default_tax=1";
													$getTaxDetails = $this->db->query($taxQuery)->result_array();
												
													$taxName = isset($getTaxDetails[0]['tax_name']) ? $getTaxDetails[0]['tax_name'] :"";
													$tax_value = isset($getTaxDetails[0]['tax_value']) ? $getTaxDetails[0]['tax_value'] :"";
												?>
												<li>
													<b>
														<?php #echo ucfirst($taxName);?>
														VAT <?php echo $tax_value;?> % 
													</b>
													
													<div class="seprate-cost">
														<?php /*<span class="totalAmount-currency"><?php echo CURRENCY_CODE;?></span>
														*/ ?>
														<span class="totalAmount" id="vatAmt"> 
															<?php
																$taxAmount = $tax_value/100 * $subTotal;
																echo number_format($taxAmount,DECIMAL_VALUE,'.','');
															?>
														</span>
													</div>
												</li>
												
												<?php 
													#$totalPayableAmount = $subTotal + $taxAmount;
													$totalPayableAmount = $subTotal;
												?>
												
												<li class="WalletPayableAmount" >
													<b>Payable Amount</b>
													<div class="seprate-cost">
														<span class="totalAmount-currency"><?php echo CURRENCY_CODE;?></span>
														<span class="Payable_Amount">	
															<?php echo number_format($totalPayableAmount,DECIMAL_VALUE,'.','');?>
														</span>
													</div>
												</li>
												
												<input type="hidden" name="tax_value" id="tax_value" value="<?php echo $tax_value;?>">
												<input type="hidden" name="wallet_amount" id="wallet_amount" value="0<?php //echo number_format($walletAmount,DECIMAL_VALUE,'.','');?>">
												<input type="hidden" name="sub_total" id="sub_total" value="<?php echo number_format($subTotal,DECIMAL_VALUE,'.','');?>">
												<input type="hidden" name="grand_total" id="grand_total" value="<?php echo number_format($subTotal,DECIMAL_VALUE,'.','');?>">
												<input type="hidden" name="payable_amount" id="payable_amount" value="<?php echo number_format($totalPayableAmount,DECIMAL_VALUE,'.','');?>">
											</ul>
											
											<div class="row opt_order">
												<div class="col-6">
													<label class="container_radio">Delivery
														<input type="radio" value="1" name="order_type" checked>
														<span class="checkmark"></span>
													</label>
												</div>
												<div class="col-6">
													<label class="container_radio">Take away
														<input type="radio" value="2" name="order_type">
														<span class="checkmark"></span>
													</label>
												</div>
											</div>
											
											<script>
												$(document).ready(function()
												{ 
													$("input[name$='order_type']").click(function() 
													{
														var order_type = $(this).val();
														
														if( order_type == 1 || order_type == 2 )
														{
															
															var wallet_amt = $(".wallet_amt").val();
															
															if(wallet_amt == "" && wallet_amt == "0")
															{
																var totalPayableAmount = $("#payable_amount").val();
																var minimumOrderValue = '<?php echo $minimumOrderValue; ?>';
																
																if(totalPayableAmount < parseFloat(minimumOrderValue))
																{
																	$(".minimumOrderValue").show();
																	$(".place_order_submit_1").hide();
																	$(".place_order_submit").hide();
																	$(".place_order_disabled").hide();
																	$(".place_order_disabled_class_1").show();
																}
																else
																{
																	$(".minimumOrderValue").hide();
																	$(".place_order_submit").hide();
																	$(".place_order_disabled").hide();
																	$(".place_order_disabled_class_1").hide();
																	$(".place_order_submit_1").show();
																}
															}
															else
															{
																if( order_type == 1 ) //Delivery
																{
																	var deliveryAddress = '<?php echo count($getDeliveryAddress);?>';
																	if(deliveryAddress == 0)
																	{
																		$("#Delivery_Address").show();
																		$(".place_order_submit").hide();
																		$(".place_order_disabled").show();
																		$(".place_order_text").show();
																	}
																	else
																	{
																		$("#Delivery_Address").show();
																		$(".place_order_submit").show();
																		$(".place_order_disabled").hide();
																		$(".place_order_text").hide();
																	}
																}
																else if( order_type == 2 )//Take away
																{
																	$("#Delivery_Address").hide();
																	$(".place_order_submit").show();
																	$(".place_order_disabled").hide();
																	$(".place_order_text").hide();
																}
															}
														}
														else
														{
															
															if( order_type == 1 ) //Delivery
															{
																var deliveryAddress = '<?php echo count($getDeliveryAddress);?>';
																if(deliveryAddress == 0)
																{
																	$("#Delivery_Address").show();
																	$(".place_order_submit").hide();
																	$(".place_order_disabled").show();
																	$(".place_order_text").show();
																}
																else
																{
																	$("#Delivery_Address").show();
																	$(".place_order_submit").show();
																	$(".place_order_disabled").hide();
																	$(".place_order_text").hide();
																}
															}
															else if( order_type == 2 )//Take away
															{
																$("#Delivery_Address").hide();
																$(".place_order_submit").show();
																$(".place_order_disabled").hide();
																$(".place_order_text").hide();
															}
														}
														
													}); 
												});
											</script>
											
											<?php 
										}
										else
										{
											?>
											<div class="text-center">
												<img src="<?php echo base_url();?>uploads/no_food.png"><br>
												<span>Good food is always cooking! Go ahead, order some yummy items from the menu.</span>
											</div>
											<?php
										} 
									?>
								</div>
							</div>
							
							<?php 
								if(isset($_SESSION["cart_item"]) && $_SESSION["cart_item"])
								{ 
									?>
									<div class="box_order mt-3 mb-2">
										<div class="main">
											<div style="color:red;" class="mt-2 mb-2">
												<!-- <small>Orders once placed cannot be cancelled and are non-refundable.</small> -->
											</div>
											<?php 
												$deliveryAddress = count($getDeliveryAddress);
												$style = $style1 = '';
												
												if($deliveryAddress == 0)
												{
													$style = "display:none;";
												}
												else
												{
													$style1 = "display:none;";
												}
											?>
											<style>
												.disabled-class {
												  pointer-events: none;
												  cursor: default;
												  background: #eeeeee !important;
												}
											</style>
											<div class="text-center minimum-order-value mb-3 minimumOrderValue" style="display:none;">
												<small>
													Minimum Order Value is :  
													<?php echo CURRENCY_CODE; ?> 
													<?php echo number_format($minimumOrderValue,DECIMAL_VALUE,'.','');?>
												</small>
											</div>
											
											<a href="javascript:void(0);" disabled="disabled" class="btn_1 gradient full-width mb_5 order-disabled-class place_order_disabled_class_1" style="display:none;">
												Place Order
											</a>
											
											<div class="place_order_submit_2 place_order_submit_1" style="display:none">
												<input type="submit" name="place_order" value="Place Order" class="btn_1 gradient full-width mb_5"/>
											</div>
											
											<?php 
												if($totalPayableAmount < $minimumOrderValue)
												{
													?>
													<a href="javascript:void(0);" disabled="disabled" class="btn_1 gradient full-width mb_5 order-disabled-class place_order_disabled">
														Place Order
													</a>
													<?php
												}
												else
												{
													?>
													<a href="javascript:void(0);" disabled="disabled" class="btn_1 gradient full-width mb_5 order-disabled-class place_order_disabled_class" style="display:none;">
														Place Order
													</a>
													
													<div class="place_order_submit" style="<?php echo $style;?>">
														<input type="submit" name="place_order" value="Place Order" class="btn_1 gradient full-width mb_5"/>
													</div>
													<?php 
												} 
											?>
											
											<?php 
												if($deliveryAvailable == 1)
												{
													?>
													<div style="<?php echo $style1;?>" class="mt-2 mb-2 place_order_text">
														<a href="javscript:void(0);" disabled="disabled" class="btn_1 gradient full-width mb_5 disabled-class place_order_disabled">
															Place Order
														</a>
														<small style="color:red;">
															<a href="#deliveryAddress">Click and Add your delivery address.</a>
															<!--<a href="javascript:void(0);" data-toggle="modal" data-target="#exampleModal">Add Address</a>
															-->
														</small>
													</div>
													<?php 
												}
												else
												{
													?>
													<div class="btn_1_mobile">
														<div class="text-center">
															<small style="color: #e54750;">
																Sorry! We could not deliver to  this location.
															</small>
														</div>
													</div>
													<?php
												}
											?>
													
										</div>
									</div>
									<?php 
								} 
							?>
						</div>
						<!-- Order Summary end-->
						<?php 
					}
					else
					{ 
						?>
						<div class="col-xl-12 col-lg-12">
							<div class="text-center">
								<img src="<?php echo base_url();?>uploads/no_food.png"><br>
								<span class="mt-3">
									Good food is always cooking! Go ahead, order some yummy items from the menu.
								</span>
								<h3 class="mt-3">Oops! Your cart is empty</h3>
							</div>
						</div>
						<?php 
					} 
				?>
			</div>
			<!-- row -->
		</form>
	</div>
	<!--container -->
	
</main>
<!--main -->

<script>
	function removeorders(product_id,code)
	{
		$.ajax({
			url: '<?php echo base_url();?>web_payment/AjaxremoveCart',
			type: 'POST',
			data: {
				'cart_item' : code
			},
			success: function(response)
			{   
				$('.cartproduct_'+product_id).remove();
				data = JSON.parse(response);
				toastr.success("Cart Item Removed successfully!");
				location.reload();
			}
		});
	}

</script>

<?php 
	if(isset($getUserDetails[0]['otp_status']) && $getUserDetails[0]['otp_status'] != 1 ) 
	{
		?>
		<script type="text/javascript">
			$(document).ready(function() 
			{	
				$('#loginModal').modal({
					backdrop: 'static',
					keyboard: false  // to prevent closing with Esc button (if you want this too)
				})
				$('#loginModal').modal('show');
			});	
		</script>
		<style>
			.modal 
			{
				display: none;
				position: fixed;
				padding-top: 100px;
				left: 0;
				top: 0;
				width: 100%;
				height: 100%;
				background-color: rgb(0,0,0);
				background-color: rgba(0,0,0,0.4);
			}
		</style>
		<!-- Modal start -->

		<div id="register1" class="welcome-screen">
			<div class="modal show" id="loginModal" role="dialog" tabindex="-1" aria-labelledby="myModalLabel" style="z-index:99999;overflow:hidden;padding: 0px!important;top: 0px;">
				<div class="modal-dialog modal-md loginpopup-new">
					<!-- Modal content-->
					<div class="modal-content popup-new">
						<div class="modal-header heading-popup">
							<?php /* <h4 class="modal-title">WELCOME TO <?php echo strtoupper(SITE_NAME);?></h4> */ ?>
							<img src="<?php echo base_url();?>uploads/logo.png" alt="Vasantabhavan">
						</div>
						<div class="modal-body popup-title">
							<div class="col-md-12">
								<?php 
									if( isset($_SESSION['VERIFY_MOBILE_NUMBER']) && !empty($_SESSION['VERIFY_MOBILE_NUMBER']) )
									{
										?>
										<style>
											.otp-box {
												text-align: center;
											}
											.splitter {
												padding: 0 5px;
												color: white;
												font-size: 24px;
											}
											.otp {
												width: 30px;
												height: 50px;
												background-color: lighten($BaseBG, 5%);
												border: none;
												line-height: 50px;
												text-align: center;
												font-size: 30px;
												color: #e54750;
												margin: 0 2px;
												border: 1px solid #e54750;
											}
											.prompt {
												margin-bottom: 20px;
												font-size: 20px;
												color: white;
											}
											</style>
											<form action="" method="POST" class="digit-group otp-box" data-group-name="digits" data-autosubmit="false" autocomplete="off">
												<p>Please enter your OTP to verify your account</p>
												<div --class="form-group">
													<input type="text" required id="digit-1" class="otp" name="digit_1" data-next="digit-2" maxlength="1"/>
													<input type="text" required id="digit-2" class="otp" name="digit_2" data-next="digit-3" maxlength="1" data-previous="digit-1" />
													<input type="text" required id="digit-3" class="otp" name="digit_3" data-next="digit-4" maxlength="1" data-previous="digit-2" />
													<input type="text" required id="digit-4" class="otp" name="digit_4" data-next="digit-5" maxlength="1" data-previous="digit-3" />
													<input type="text" required id="digit-5" class="otp" name="digit_5" data-next="digit-6" maxlength="1" data-previous="digit-4" />
													<input type="text" required id="digit-6" class="otp" name="digit_6" data-next="digit-7" maxlength="1" data-previous="digit-5" />
												</div>
												<button type="submit" class="mt-3 btn btn-block register-but">Verify OTP</button>
												<br>
												<a href="<?php echo base_url();?>cancel-verification.html" onclick="return confirm('Are you sure you want to terminate the verification?');">Cancel</a>
											</form>
										
										<script>

											$('#verify_otp_btn').prop('disabled', true);
											$('#verify_otp_btn').css('cursor','not-allowed');
											var container = document.getElementsByClassName("digit-group")[0];
											container.onkeyup = function(e) 
											{
												digit = $('#digit-6').val();

												if (digit != "") 
												{
													$('#verify_otp_btn').prop('disabled', false);
													$('#verify_otp_btn').css('cursor','pointer');
													// $('.digit-group').submit();
												}

												var target = e.srcElement || e.target;
												var maxLength = parseInt(target.attributes["maxlength"].value, 10);
												var myLength = target.value.length;
												if (myLength >= maxLength) {
													var next = target;
													while (next = next.nextElementSibling) 
													{
														if (next == null)
															break;
														if (next.tagName.toLowerCase() === "input") {
															next.focus();
															break;
														}
													}
												}
												// Move to previous field if empty (user pressed backspace)
												else if (myLength === 0) {
													var previous = target;
													while (previous = previous.previousElementSibling) {
														if (previous == null)
															break;
														if (previous.tagName.toLowerCase() === "input") {
															previous.focus();
															break;
														}
													}
												}
											}
										</script>
										<?php
									}
									else
									{ 
										?>
										<form action="" autocomplete="off" id="formValidation" method="post">
										<p>Please enter your Mobile Number to verify your account</p>
											<div class="login-top-mobilenum row">
												<div class="col-md-12">
													<div class="my-1"></div>
													<div class="form-group country-code mb-0">
														<div class="entry-fileds-error">
															<?php 
																$getCountry = $this->db->query("select country_id,country_name,country_code from country where country_status=1 order by default_country desc")->result_array();
															?>
															
															<input class="form-control mobile_vali mobile-number" autocomplete="off" maxlength="10" type="text" name="mobile_number_verify" id="mobile_number" required placeholder="Mobile Number">
															<p class="num-divide-line"></p><i class="icon_mobile"></i> 
															<button class="btn btn-default default_country_code" type="button" data-toggle="dropdown">
																<?php echo COUNTRY_CODE; ?> 
															</button>
															<div class="err_text text-danger"></div>
															<script>
																function getCountryCode(country_id,country_code)
																{
																	$("#country_code").val(country_code);
																	$("#country_id_model").val(country_id);
																	$(".default_country_code").html(country_code);
																}
															</script>
															
															<input type="hidden" value="<?php echo COUNTRY_CODE; ?>" name="country_code" id="country_code">
															<input type="hidden" name="country_id" id="country_id_model" >
															<div class="lists-showing">
																<ul class="dropdown-menu country-code-icons">
																	<?php 
																		foreach($getCountry as $row)
																		{
																			?>
																			<li>
																				<a href="javascript:void(0);" onclick="getCountryCode('<?php echo $row['country_id'];?>','<?php echo $row['country_code'];?>');">
																					<span class="login-country-name">
																						<?php
																							if(file_exists("uploads/country_icons/".$row['country_id'].'.png') )
																							{
																								$photo_url = base_url().'uploads/country_icons/'.$row['country_id'].'.png';
																								$BranchName = ucfirst($row['country_name']);
																								?>
																								<img src="<?php echo $photo_url;?>" style="border-radius:4px;height:22px; width:30px;" alt="">
																								<?php 
																							}
																							else
																							{
																								?>
																								<img src="<?php echo base_url();?>uploads/no-image.png" style="border:1px solid #ddd; border-radius:4px;height:23px; width:30px;" alt="...">
																								<?php
																							}
																						?>
																						
																					</span>
																					<?php echo ucfirst($row['country_code']);?>
																					<span class="mid-pipeline">|</span>
																					<span class="login-country-code">
																					<?php echo ucfirst($row['country_name']);?> 
																					</span>
																				</a>
																			</li>
																			<?php 
																		} 
																	?>
																</ul>
															</div>
														</div>
													</div>
												</div>
											</div>
											
											<button type="submit" id="send-otp"  disabled class="mt-3 btn btn-block register-but">Send OTP</button>
											
										</form>
										
										<script>
											$('#mobile_number').keyup(function () {
												
												len = $(this).val();
												if($(this).val().length < 7 || $(this).val().length > 10 ) 
												{
													$('.err_text').html("");
													$("#send-otp").prop('disabled',true);
												}
												else 
												{
													mobile_number = $('#mobile_number').val()
													$.ajax({
														url: '<?php echo base_url(); ?>web_payment/AjaxVerifyMobileNumber',
														type: "POST",
														data:{
															'<?php echo $this->security->get_csrf_token_name(); ?>' : '<?php echo $this->security->get_csrf_hash(); ?>',
															"mobile_number" : mobile_number
														},
														datatype: JSON,
														success: function(value)
														{
															if (value == 1) 
															{
																$('.err_text').html("");
																$("#send-otp").prop('disabled',false);
															}
															else
															{
																$('.err_text').html("The Number Already Taken");
																$("#send-otp").prop('disabled',true);
															}
															
														}
													});
												}
												
											})
										</script>
																			
										
										<?php 
									} 
								?>
							</div>		
						</div>
						<!--<div class="modal-body popup-title">
							<div class="col-md-12">
								<div class="row">
									<div class="col-md-4">
										<a href=""><img class="branches-img" src="<?php echo base_url();?>assets/frontend/img/slider_bg3.jpg" alt="img1" height="150" width="100%"></a>
										<span>Sharjah</span>
									</div>
									<div class="col-md-4">
										<a href=""><img class="branches-img" src="<?php echo base_url();?>assets/frontend/img/slider_bg2.jpg" alt="img1" height="150" width="100%"></a>
										<span>Dubai</span>
									</div>
									<div class="col-md-4">
										<a href=""><img class="branches-img" src="<?php echo base_url();?>assets/frontend/img/slider_bg1.jpg" alt="img1" height="150" width="100%"></a>
										<span>Abudhabi</span>
									</div>
								</div>
							</div>
						</div> -->
						
						
						<!--
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>-->
					</div>
					<!-- Modal content end-->
				</div>
			</div>
		</div>
		<!-- Modal end-->

		<?php
	}
?>