import base64
import sys
import win32print
import time
import json

arraystring = sys.argv[1].split(",")  # Getting args from Codeignator
orderData = json.loads(base64.b64decode(arraystring[0]))

BillText = """\n\n
"""+orderData['branch_address']+"""\n\n     Ph- """+orderData['phone_number']+"""\n\n     TAX INVOICE\n\n     TRN # - """+orderData['gst_number']+"""
--------------------------------
Ord.No      : """+orderData['order_number']+"""
Customer    : """+orderData['first_name']+"""
Time        : """+orderData['order_date']+"""
Date        : """+orderData['created_date']+"""
Mobile No   : """+orderData['mobile_number']+"""
--------------------------------
Item Name       Qty     Price   Total
--------------------------------\n"""

newGrandtotal = 0

for OrderItems in orderData['lineData']:
    
    newGrandtotal += float(OrderItems['linetotal'])
    if len(OrderItems['product_name']) > 6 :
        BillText +=	OrderItems['product_name'][:5]+"..       "+OrderItems['quantity']+"      "+OrderItems['price']+"   "+OrderItems['linetotal']+"\n"
    else:
        BillText +=	OrderItems['product_name']+"         "+OrderItems['quantity']+"      "+OrderItems['price']+"   "+OrderItems['linetotal']+"\n"

vatValue = float(newGrandtotal)/(float(orderData['tax_value'])*100)

BillText +="""--------------------------------\n
Sub Total   :   """+str(newGrandtotal)+"""\n
VAT 5 %     :   """+str(vatValue)+"""\n
--------------------------------\n
Grand Total	:   """+str(newGrandtotal+vatValue)+"""\n
--------------------------------
For Complaints Please contact : +971 52 949 4545 \n
    THANK YOU !!! VISIT AGAIN \n
        www.vasantabhavan.ae \n
"""

printer_name = win32print.GetDefaultPrinter()

if sys.version_info >= (3,):
    raw_data = bytes(BillText, "utf-8")
else:
    raw_data = BillText

hPrinter = win32print.OpenPrinter(printer_name)
try:
    hJob = win32print.StartDocPrinter(hPrinter, 1, ("Raw File", None, "RAW"))
    try:
        win32print.StartPagePrinter(hPrinter)
        win32print.WritePrinter(hPrinter, raw_data)
        win32print.EndPagePrinter(hPrinter)
    finally:
        win32print.EndDocPrinter(hPrinter)
        statusCode = 1
finally:
    win32print.ClosePrinter(hPrinter)
    final = "Printed Sucessfully"

jsonData = 
    {
        "printerStatus" : final,
        "statusCode"    : statusCode,
        "order_id"      : orderData['order_id']
    }
    
print(json.dumps(jsonData))