<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2019, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (https://ellislab.com/)
 * @copyright	Copyright (c) 2014 - 2019, British Columbia Institute of Technology (https://bcit.ca/)
 * @license	https://opensource.org/licenses/MIT	MIT License
 * @link	https://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Application Controller Class
 *
 * This class object is the super class that every library in
 * CodeIgniter will be assigned to.
 *
 * @package		CodeIgniter
 * @subpackage	Libraries
 * @category	Libraries
 * @author		EllisLab Dev Team
 * @link		https://codeigniter.com/user_guide/general/controllers.html
 */
class CI_Controller {
	/**
	 * Reference to the CI singleton
	 *
	 * @var	object
	 */
	private static $instance;
	/**
	 * Class constructor
	 *
	 * @return	void
	 */
	public function __construct()
	{
		self::$instance =& $this;
		
		#Assign all the class objects that were instantiated by the
		#bootstrap file (CodeIgniter.php) to local class variables
		#so that CI can run as one big super object.
		foreach (is_loaded() as $var => $class)
		{
			$this->$var =& load_class($class);
		}

		$this->load =& load_class('Loader', 'core');
		$this->load->initialize();
		log_message('info', 'Controller Class Initialized');
		$CI =&get_instance();
        $CI->load->database();
		
		$this->validation = 'onkeypress="return event.charCode >= 48 && event.charCode <= 57 || event.charCode >= 97 && event.charCode <= 122 || event.charCode >= 65 && event.charCode <= 90 || event.charCode == 32"';
		$backup_morning = $CI->db->query('select description from settings where type ="backup_morning"')->result_array();
		$backup_evening = $CI->db->query('select description from settings where type ="backup_evening"')->result_array();
		
		defined('BACKUP_MORNING') || define('BACKUP_MORNING', $backup_morning[0]['description']);
		defined('BACKUP_EVENING') || define('BACKUP_EVENING', $backup_evening[0]['description']);
		
		defined('HOST_NAME') || define('HOST_NAME', 'localhost');
		defined('USER_NAME') || define('USER_NAME', 'root');
		defined('DB_PASSWORD') || define('DB_PASSWORD', '');
		defined('DATABASE_NAME') || define('DATABASE_NAME', 'hms_v2');
		
		date_default_timezone_set("Asia/Dubai");
		$date = date('h:i A', time());
		#echo $date;
		/* if( (!empty(BACKUP_MORNING) && $date == BACKUP_MORNING) || ( !empty(BACKUP_EVENING) && $date == BACKUP_EVENING) )
		{
			date_default_timezone_set('GMT');
			#Load the file helper in codeigniter
			$this->load->helper('file');
			
			$con = mysqli_connect(HOST_NAME,USER_NAME,DB_PASSWORD,DATABASE_NAME);

			$tables = array();
			$query = mysqli_query($con, 'SHOW TABLES');
			while($row = mysqli_fetch_row($query))
			{
				 $tables[] = $row[0];
			}

			$result = 'SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";';
			$result .= 'SET time_zone = "+00:00";';
				
			foreach($tables as $table)
			{
				$query = mysqli_query($con, 'SELECT * FROM `'.$table.'`');
				$num_fields = mysqli_num_fields($query);

				$result .= 'DROP TABLE IF EXISTS '.$table.';';
				$row2 = mysqli_fetch_row(mysqli_query($con, 'SHOW CREATE TABLE `'.$table.'`'));
				$result .= "\n\n".$row2[1].";\n\n";
				
				for ($i = 0; $i < $num_fields; $i++) 
				{
					while($row = mysqli_fetch_row($query))
					{
						 $result .= 'INSERT INTO `'.$table.'` VALUES(';
						 for($j=0; $j<$num_fields; $j++)
						 {
							$row[$j] = addslashes($row[$j]);
							$row[$j] = str_replace("\n","\\n",$row[$j]);
							if(isset($row[$j]))
							{
							   $result .= '"'.$row[$j].'"' ; 
							}
							else
							{ 
								$result .= '""';
							}
							if($j<($num_fields-1))
							{ 
								$result .= ',';
							}
						}
						$result .= ");\n";
					}
				}
				$result .="\n\n";
			}

			#Create Folder
			$folder = 'database/';
			if (!is_dir($folder))
			mkdir($folder, 0777, true);
			chmod($folder, 0777);

			$date = "db_filename_".date('m-d-Y')."_".rand(); 
			$filename = $folder.$date; 
			$databaseName = $folder.$date.'.sql'; 

			$handle = fopen($filename.'.sql','w+');
			fwrite($handle,$result);
			fclose($handle);
			
			$data['database_name'] = $databaseName;
			$data['backup_date'] = strtotime(date('d-m-Y h:i:s a'));
			
			$this->db->insert('backup_databases', $data);
			$id = $this->db->insert_id();
		} */
		
		# Product Expiry start here
		$product_start_date = $this->db->get_where('settings' , array('type' =>'product_start_date'))->row()->description;
		$product_end_date = $this->db->get_where('settings' , array('type' =>'product_end_date'))->row()->description;
		$before_expire_days = $this->db->get_where('settings' , array('type' =>'before_expire_days'))->row()->description;
		
		define('PRODUCT_START_DATE', $product_start_date);
		define('PRODUCT_END_DATE', $product_end_date);
		define('BEFORE_EXPIRY_DAY', $before_expire_days);
		
		#$start_date = strtotime(date("d-m-Y",$product_start_date));
		$end_date = date("d-m-Y",$product_end_date);
		$start_date = time();
		
		#if( $start_date >= strtotime($end_date) ) 
		if( $start_date >= $product_end_date )
		{
			$segment = $this->uri->segment(2);
			if($segment == 'product_expiry')
			{
				
			}
			else
			{
				$html="<style>
							html{background: #d8d5d5;}
							h1.oops-class{text-align: center;font-size: 59px;margin: 83px 0px 0px 0px;}
							h4.four-not-class {
								text-align: center;
							}
					  </style> 
				<h1 class='oops-class'>OOPS!</h1>
				<h4 class='four-not-class'>404 - PAGE NOT FOUND!</h4><br>
				<p style='color: red;font-size: 28px;text-align: center;'>
					Your Product has been expired!...  
					Please Contact to Admin  <a href='https://www.jesperapps.com/contact-us.html' target='_blank' title='Contact Us'>Contact Us</a>
				</p>";
				echo $html;exit;
			}
		}
		# Product Expiry end here
		
		# Product Expiry start here
			/* $start_date = strtotime(date("d-m-Y"));
			$end_date = "07-11-2020";
			if( $start_date >= strtotime($end_date) ) 
			{
				$html="<style>
							html{background: #d8d5d5;}
							h1.oops-class{text-align: center;font-size: 59px;margin: 83px 0px 0px 0px;}
							h4.four-not-class {
								text-align: center;
							}
					  </style> 
				<h1 class='oops-class'>OOPS!</h1>
				<h4 class='four-not-class'>404 - PAGE NOT FOUND!</h4><br>
				<p style='color: red;font-size: 28px;text-align: center;'>
					Your Product has been expired!...  
					Please Contact to Admin  <a href='https://www.jespersoft.com/contact-us.html' target='_blank' title='Contact Us'>Contact Us</a>
				</p>";
				echo $html;exit;
			} */
		# Product Expiry end here
		
		# Suresh new changes start here 30-4-2019
		
		$this->template ="themes/template"; #Load Front template
		$this->adminTemplate ="backend/template"; #Load admin template
		
		$this->user_id = $this->session->userdata('user_id'); # Admin user id - 1
		$this->UserID = $this->session->userdata('UserID'); # Front end
		$this->admin_branch_id = $this->session->userdata('admin_branch_id'); # Front end
		
		define('THEME_NAME', 'default');
		define('NO_DATA_FOUND', 'No data Found.');
		$this->thems = array('1'=>'Default','2'=>'Green and Yellow');
		$this->items_per_page = array("10" => "10","25" => "25","50" => "50","100" => "100","500" => "500","1500" => "1500");
		$this->backupTime = array('12:00 AM'=>'12:00 AM','12:30 AM'=>'12:30 AM','01:00 AM'=>'01:00 AM','01:30 AM'=>'01:30 AM','02:00 AM'=>'02:00 AM','02:30 AM'=>'02:30 AM','03:00 AM'=>'03:00 AM','03:30 AM'=>'03:30 AM','04:00 AM'=>'04:00 AM','04:30 AM'=>'04:30 AM','05:00 AM'=>'05:00 AM','05:30 AM'=>'05:30 AM','06:00 AM'=>'06:00 AM','06:30 AM'=>'06:30 AM','07:00 AM'=>'07:00 AM','07:30 AM'=>'07:30 AM','08:00 AM'=>'08:00 AM','08:30 AM'=>'08:30 AM','09:00 AM'=>'09:00 AM','09:30 AM'=>'09:30 AM','10:00 AM'=>'10:00 AM','10:30 AM'=>'10:30 AM','11:00 AM'=>'11:00 AM','11:30 AM'=>'11:30 AM','12:00 PM'=>'12:00 PM','12:30 PM'=>'12:30 PM','01:00 PM'=>'01:00 PM','01:30 PM'=>'01:30 PM','02:00 PM'=>'02:00 PM','02:30 PM'=>'02:30 PM','03:00 PM'=>'03:00 PM','03:30 PM'=>'03:30 PM','04:00 PM'=>'04:00 PM','04:30 PM'=>'04:30 PM','05:00 PM'=>'05:00 PM','05:30 PM'=>'05:30 PM','06:00 PM'=>'06:00 PM','06:30 PM'=>'06:30 PM','07:00 PM'=>'07:00 PM','07:30 PM'=>'07:30 PM','08:00 PM'=>'08:00 PM','08:30 PM'=>'08:30 PM','09:00 PM'=>'09:00 PM','09:30 PM'=>'09:30 PM','10:00 PM'=>'10:00 PM','10:30 PM'=>'10:30 PM','11:00 PM'=>'11:00 PM','11:30 PM'=>'11:30 PM');
		
		$this->gender = array("1"=>"Male","2"=>"Female","3"=>"Transgender");
		$this->marital_status = array("1"=>"Married","2"=>"Unmarried");
		$this->read_only = array("1"=>"Yes","0"=>"No");
		$this->menu_enabled = array("1"=>"Yes","0"=>"No");
		$this->employeementType = array("1"=>"CONTRACTOR","2"=>"FULL TIME","3"=>"PART TIME");
		$this->product_branch_status = array("1"=>"Available","2"=>"Unavailable");
		$this->order_status = array("0"=>"Pending","1"=>"Preparing","3"=>"Delivered","4"=>"Canceled");
		$this->order_status_front = array("0"=>"Pending","1"=>"confirmed","2"=>"Preparing","3"=>"Delivered","4"=>"Canceled");
		$this->auto_refresh_seconds = array("1000"=>"1 Sec","2000"=>"2 Sec","3000"=>"3 Sec","4000"=>"4 Sec","5000"=>"5 Sec","6000"=>"6 Sec","7000"=>"7 Sec","8000"=>"8 Sec","9000"=>"9 Sec","10000"=>"10 Sec","15000"=>"15 Sec","20000"=>"20 Sec");
		$this->orders_filter = array("1"=>"Today","2"=>"This Week","3"=>"This Month","4"=>"This Year","5"=>"Total");
		$this->order_closed = array("0"=>"Unclosed","1"=>"Closed");
		
		$this->ItemsDays = array("All"=>"All Days","Mon"=>"Monday","Tue"=>"Tuesday","Wed"=>"Wednesday","Thu"=>"Thursday","Fri"=>"Friday","Sat"=>"Saturday","Sun"=>"Sunday");
		
		$this->deliveryTags = array("1"=>"Home","2"=>"Work");
		$this->cms_page	= array("1"=>"Terms & Conditions","2"=>"Privacy Policy");
		
		#Menu URL's
		define('dashboard', 'dashboard');
		define('orders', 'orders');
		define('items', 'items');
		define('items_offers', 'items-offers');
		define('customers', 'customers');
		define('branches', 'branches');
		define('settings', 'settings');
		define('users', 'users');
		define('categories', 'categories');
		define('payment_history', 'payment-history');
		
		
		#SMTP Settings start
		$smtp_result = $CI->db->query('select * from email_settings where settings_id =1')->result_array();
		
		if($smtp_result[0]['email_type'] == 1) #Sendgrid
		{
			defined('EMAIL_TYPE') || define('EMAIL_TYPE', $smtp_result[0]['email_type']);
			defined('SENDGRID_HOST') || define('SENDGRID_HOST', $smtp_result[0]['sendgrid_host']);
			defined('SENDGRID_USERNAME') || define('SENDGRID_USERNAME', $smtp_result[0]['sendgrid_username']);
			defined('SENDGRID_PASSWORD') || define('SENDGRID_PASSWORD', $smtp_result[0]['sendgrid_password']);
			defined('SENDGRID_PORT') || define('SENDGRID_PORT', $smtp_result[0]['sendgrid_port']);
		}
		else if($smtp_result[0]['email_type'] == 2) #SMTP
		{
			defined('EMAIL_TYPE') || define('EMAIL_TYPE', $smtp_result[0]['email_type']);
			defined('SMTP_HOST') || define('SMTP_HOST', $smtp_result[0]['smtp_host']);
			defined('SMTP_USERNAME') || define('SMTP_USERNAME', $smtp_result[0]['smtp_username']);
			defined('SMTP_PASSWORD') || define('SMTP_PASSWORD', $smtp_result[0]['smtp_password']);
			defined('SMTP_PORT') || define('SMTP_PORT', $smtp_result[0]['smtp_port']);
		}
		#SMTP Settings end
		
		#General Settings start
		$company_name = $CI->db->query('select description from settings where type ="company_name"')->result_array();
		$contact_name = $CI->db->query('select description from settings where type ="system_name"')->result_array();
		$welcome_content = $CI->db->query('select description from settings where type ="welcome_content"')->result_array();
		$gst_number = $CI->db->query('select description from settings where type ="gst_number"')->result_array();
		$pan_number = $CI->db->query('select description from settings where type ="pan_number"')->result_array();
		$company_account = $CI->db->query('select description from settings where type ="company_account"')->result_array();
		
		defined('COMPANY_NAME') || define('COMPANY_NAME', $company_name[0]['description']);
		defined('SITE_NAME') || define('SITE_NAME', $contact_name[0]['description']);
		defined('WELCOME_CONTENT') || define('WELCOME_CONTENT', $welcome_content[0]['description']);
		
		defined('CONTACT_NAME') || define('CONTACT_NAME', $contact_name[0]['description']);
		defined('GST_NUMBER') || define('GST_NUMBER', $gst_number[0]['description']);
		defined('PAN_NUMBER') || define('PAN_NUMBER', isset($pan_number[0]['description']) ? $pan_number[0]['description'] :"");
		defined('COMPANY_ACCOUNT') || define('COMPANY_ACCOUNT', $company_account[0]['description']);
		#General Settings end
		
		#E-Mail & Contact Settings start
		$contact_email = $CI->db->query('select description from settings where type ="contact_email"')->result_array();
		$address1 = $CI->db->query('select description from settings where type ="address"')->result_array();
		$address2 = $CI->db->query('select description from settings where type ="address2"')->result_array();
		$address3 = $CI->db->query('select description from settings where type ="address3"')->result_array();
		$address4 = $CI->db->query('select description from settings where type ="address4"')->result_array();
		$phone1 = $CI->db->query('select description from settings where type ="phone"')->result_array();
		$phone2 = $CI->db->query('select description from settings where type ="phone2"')->result_array();
		$webmasterEmail = $CI->db->query('select description from settings where type ="webmaster_email"')->result_array();
		$no_reply_email = $CI->db->query('select description from settings where type ="no_reply_email"')->result_array();
		
		
		#Get State Code start
		$gst_state_number = $CI->db->query('select description from settings where type ="gst_state_number"')->result_array();
		$stateID = isset($gst_state_number[0]['description']) ? $gst_state_number[0]['description'] :"";
		$getStateNumber = $this->db->query("select state_number from state where state_id='".$stateID."' ")->result_array();
		#defined('STATE_NUMBER') || define('STATE_NUMBER', $getStateNumber[0]['state_number']);
		#Get State Code End
		
		defined('CONTACT_EMAIL') || define('CONTACT_EMAIL', $contact_email[0]['description']);
		defined('WEBMASTER_EMAIL') || define('WEBMASTER_EMAIL', $webmasterEmail[0]['description']);
		defined('NOREPLY_EMAIL') || define('NOREPLY_EMAIL', $no_reply_email[0]['description']);
		defined('ADDRESS1') || define('ADDRESS1', $address1[0]['description']);
		defined('ADDRESS2') || define('ADDRESS2', $address2[0]['description']);
		defined('ADDRESS3') || define('ADDRESS3', $address3[0]['description']);
		defined('ADDRESS4') || define('ADDRESS4', $address4[0]['description']);
		defined('PHONE1') || define('PHONE1', $phone1[0]['description']);
		defined('PHONE2') || define('PHONE2', $phone2[0]['description']);
		#E-Mail & Contact Settings end
		
		#Thems Settings start
		$thems = $CI->db->query('select description from settings where type ="thems"')->result_array();
		define('THEME', $thems[0]['description']);
		#Thems Settings end
		
		#Country Data start
		$countryData = $CI->db->query('select country_id,currency_symbol,currency_code,country_code from country where country_status ="1" and default_country ="1"')->result_array();
		
		if( count($countryData) > 0 )
		{
			defined('COUNTRY_ID') || define('COUNTRY_ID', $countryData[0]['country_id']);  
			defined('CURRENCY_SYMBOL') || define('CURRENCY_SYMBOL', $countryData[0]['currency_symbol']);  
			defined('CURRENCY_CODE') || define('CURRENCY_CODE', $countryData[0]['currency_code']);
			defined('COUNTRY_CODE') || define('COUNTRY_CODE', $countryData[0]['country_code']);
		}
		else
		{
			defined('COUNTRY_ID') || define('COUNTRY_ID', '');  
			defined('CURRENCY_SYMBOL') || define('CURRENCY_SYMBOL', '');  
			defined('CURRENCY_CODE') || define('CURRENCY_CODE', '');
			defined('COUNTRY_CODE') || define('COUNTRY_CODE', '');
		}
		#Country end start
		
		#System Settings Start
		$getSystemSettings = $CI->db->query('select * from system_settings where system_setting_id ="1"')->result_array();
		
		if($getSystemSettings[0]['decimal_digit_value'] > 0 )
		{
			defined('DECIMAL_VALUE') || define('DECIMAL_VALUE', $getSystemSettings[0]['decimal_digit_value']);  
		}
		else
		{
			defined('DECIMAL_VALUE') || define('DECIMAL_VALUE', 2);  
		}
		
		defined('FB_APP_ID') || define('FB_APP_ID', $getSystemSettings[0]['fb_api_id']);
		defined('FB_APP_SECRET') || define('FB_APP_SECRET', $getSystemSettings[0]['fb_api_secret']);
		defined('FB_CLIENT_TOCKEN') || define('FB_CLIENT_TOCKEN', $getSystemSettings[0]['fb_api_token']);
		
		defined('GOOGLE_SECRET_KEY') || define('GOOGLE_SECRET_KEY', $getSystemSettings[0]['google_secret_key']);
		defined('GOOGLE_CLIENT_ID') || define('GOOGLE_CLIENT_ID',$getSystemSettings[0]['google_client_id']);
		defined('GOOGLE_MAP_API_KEY') || define('GOOGLE_MAP_API_KEY',$getSystemSettings[0]['google_map_api_key']);
		defined('DISTANCE') || define('DISTANCE',$getSystemSettings[0]['km_distance']);
		
		defined('N_GENIUS_PAYMENT_API_KEY') || define('N_GENIUS_PAYMENT_API_KEY',$getSystemSettings[0]['n_genius_payment_api']);
		defined('N_GENIUS_PAYMENT_OUTLET_ID') || define('N_GENIUS_PAYMENT_OUTLET_ID',$getSystemSettings[0]['n_genius_payment_outlet']);
		defined('AUTO_REFRESH_SECONDS') || define('AUTO_REFRESH_SECONDS',$getSystemSettings[0]['auto_refresh_seconds']);
		
		defined('SMS_API_KEY') || define('SMS_API_KEY',$getSystemSettings[0]['sms_api_key']);
		defined('SMS_API_SECRET') || define('SMS_API_SECRET',$getSystemSettings[0]['sms_api_secret']);
		
		
		#System Settings End
		
		#Social Links start
		$social = $this->frontend_model->get_frontend_general_settings('social_links');
		$links = json_decode($social);
		defined('FACEBOOK') || define('FACEBOOK', $links[0]->facebook);
		defined('TWITTER') || define('TWITTER', $links[0]->twitter);
		defined('GOOGLE_PLUS') || define('GOOGLE_PLUS', $links[0]->google);
		defined('LINKEDIN') || define('LINKEDIN', $links[0]->linkedin);
		defined('YOUTUBE') || define('YOUTUBE', $links[0]->youtube);
		defined('INSTAGRAM') || define('INSTAGRAM', $links[0]->instagram);
		#Social Links end
		
		# Suresh new changes end here 30-4-2019
	}

	public static function &get_instance()
	{
		return self::$instance;
	}
}
